/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.fus;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.collectors.fus.TerminalFusAwareHandler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.PathUtil;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.fus.BlockTerminalSwitchPlace;
import org.jetbrains.plugins.terminal.fus.TerminalCommandGenerationEvent;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackEvent;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalUsageCollectorKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020\nH\u0016J\u0012\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u001cH\u0003J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b1J0\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109J\u0016\u0010:\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010;\u001a\u00020\u0019J \u0010<\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u0013H\u0007J%\u0010>\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b@J+\u0010A\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001c0C2\u0006\u0010=\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010DJ%\u0010A\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\bKJ:\u0010L\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010M\u001a\u0004\u0018\u00010\u001c2\u0006\u0010N\u001a\u00020\u00132\u0006\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u0013H\u0007J\u0010\u0010S\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u0010T\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00130\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00130\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006V"}, d2={"Lorg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "BLOCK_TERMINAL_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "EXECUTION_TIME_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "EXIT_CODE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "OS_VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "RUN_ANYTHING_PROVIDER_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "SHELL_FIELD", "TERMINAL_COMMAND_HANDLER_FIELD", "blockTerminalSwitchedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "Lorg/jetbrains/plugins/terminal/fus/BlockTerminalSwitchPlace;", "commandFinishedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "commandGenerationEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lorg/jetbrains/plugins/terminal/fus/TerminalCommandGenerationEvent;", "commandStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "feedbackSurveyEvent", "Lorg/jetbrains/plugins/terminal/fus/TerminalFeedbackEvent;", "Lorg/jetbrains/plugins/terminal/fus/TerminalFeedbackMoment;", "localExecEvent", "promotionGotItClickedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "promotionShownEvent", "shellStartedEvent", "sshExecEvent", "terminalSmartCommandExecutedEvent", "terminalSmartCommandNotExecutedEvent", "getGroup", "getShellNameForStat", "shellName", "triggerBlockTerminalSwitched", "", "project", "Lcom/intellij/openapi/project/Project;", "enabled", "place", "triggerBlockTerminalSwitched$intellij_terminal", "triggerCommandFinished", "userCommandLine", "exitCode", "", "executionTime", "Lkotlin/time/Duration;", "triggerCommandFinished-Wn2Vu4Y", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;IJ)V", "triggerCommandGenerationEvent", "event", "triggerCommandStarted", "isBlockTerminal", "triggerFeedbackSurveyEvent", "moment", "triggerFeedbackSurveyEvent$intellij_terminal", "triggerLocalShellStarted", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Z)V", "shellInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalShellInfoStatistics$LoggableShellInfo;", "triggerLocalShellStarted$intellij_terminal", "triggerPromotionGotItClicked", "triggerPromotionGotItClicked$intellij_terminal", "triggerPromotionShown", "triggerPromotionShown$intellij_terminal", "triggerSmartCommand", "workingDirectory", "localSession", "command", "handler", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "executed", "triggerSshShellStarted", "trimKnownExt", "name", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUsageCollector.kt\norg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,264:1\n262#2,3:265\n262#2,3:268\n262#2,3:271\n262#2,3:274\n*S KotlinDebug\n*F\n+ 1 TerminalUsageCollector.kt\norg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector\n*L\n80#1:265,3\n82#1:268,3\n83#1:271,3\n86#1:274,3\n*E\n"})
public final class TerminalUsageTriggerCollector
extends CounterUsagesCollector {
    @NotNull
    public static final TerminalUsageTriggerCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final ClassEventField TERMINAL_COMMAND_HANDLER_FIELD;
    @NotNull
    private static final ClassEventField RUN_ANYTHING_PROVIDER_FIELD;
    @NotNull
    private static final StringEventField OS_VERSION_FIELD;
    @NotNull
    private static final StringEventField SHELL_FIELD;
    @NotNull
    private static final BooleanEventField BLOCK_TERMINAL_FIELD;
    @NotNull
    private static final IntEventField EXIT_CODE_FIELD;
    @NotNull
    private static final LongEventField EXECUTION_TIME_FIELD;
    @NotNull
    private static final EventId sshExecEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandExecutedEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandNotExecutedEvent;
    @NotNull
    private static final EventId3<String, String, Boolean> localExecEvent;
    @NotNull
    private static final VarargEventId shellStartedEvent;
    @NotNull
    private static final EventId3<String, String, Boolean> commandStartedEvent;
    @NotNull
    private static final VarargEventId commandFinishedEvent;
    @NotNull
    private static final EventId promotionShownEvent;
    @NotNull
    private static final EventId promotionGotItClickedEvent;
    @NotNull
    private static final EventId2<Boolean, BlockTerminalSwitchPlace> blockTerminalSwitchedEvent;
    @NotNull
    private static final EventId2<TerminalFeedbackEvent, TerminalFeedbackMoment> feedbackSurveyEvent;
    @NotNull
    private static final EventId1<TerminalCommandGenerationEvent> commandGenerationEvent;

    private TerminalUsageTriggerCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void triggerSshShellStarted(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        sshExecEvent.log(project);
    }

    @JvmStatic
    public static final void triggerCommandStarted(@NotNull Project project, @NotNull String userCommandLine, boolean isBlockTerminal) {
        TerminalCommandUsageStatistics.CommandData commandData;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        commandStartedEvent.log(project, (Object)(commandData2 != null ? commandData2.getCommand() : null), (Object)(commandData3 != null ? commandData3.getSubCommand() : null), (Object)isBlockTerminal);
    }

    public final void triggerCommandFinished-Wn2Vu4Y(@NotNull Project project, @NotNull String userCommandLine, int exitCode, long executionTime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        EventPair[] eventPairArray = new EventPair[4];
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData;
        eventPairArray[0] = TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal().with((Object)(commandData2 != null ? commandData2.getCommand() : null));
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        eventPairArray[1] = TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal().with((Object)(commandData3 != null ? commandData3.getSubCommand() : null));
        eventPairArray[2] = EXIT_CODE_FIELD.with((Object)exitCode);
        eventPairArray[3] = EXECUTION_TIME_FIELD.with((Object)Duration.getInWholeMilliseconds-impl((long)executionTime));
        commandFinishedEvent.log(project, eventPairArray);
    }

    @JvmStatic
    public static final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command2, @NotNull TerminalShellCommandHandler handler, boolean executed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Object[] objectArray = new EventPair[]{TERMINAL_COMMAND_HANDLER_FIELD.with(handler.getClass())};
        List data = CollectionsKt.mutableListOf((Object[])objectArray);
        if (handler instanceof TerminalFusAwareHandler) {
            ((TerminalFusAwareHandler)handler).fillData(project, workingDirectory, localSession, command2, data);
        }
        if (executed) {
            terminalSmartCommandExecutedEvent.log(project, data);
        } else {
            terminalSmartCommandNotExecutedEvent.log(project, data);
        }
    }

    @JvmStatic
    public static final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand, boolean isBlockTerminal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
        String string = version != null ? version.toCompactString() : null;
        if (string == null) {
            string = "unknown";
        }
        localExecEvent.log(project, (Object)string, (Object)TerminalUsageTriggerCollector.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand)), (Object)isBlockTerminal);
        if (isBlockTerminal) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            String string2 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCodeAndSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringWithoutProductCodeAndSnapshot(...)");
            String version2 = string2;
            propertiesComponent.setValue("BLOCK_TERMINAL_LAST_USED_VERSION", version2);
            propertiesComponent.setValue("BLOCK_TERMINAL_LAST_USED_DATE", (int)(System.currentTimeMillis() / (long)1000), 0);
        }
    }

    public final void triggerLocalShellStarted$intellij_terminal(@NotNull Project project, @NotNull String shellName, @NotNull TerminalShellInfoStatistics.LoggableShellInfo shellInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellName, (String)"shellName");
        Intrinsics.checkNotNullParameter((Object)shellInfo, (String)"shellInfo");
        Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
        String string = version != null ? version.toCompactString() : null;
        if (string == null) {
            string = "unknown";
        }
        String osVersion = string;
        EventPair[] eventPairArray = new EventPair[12];
        eventPairArray[0] = OS_VERSION_FIELD.with((Object)osVersion);
        String string2 = shellName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        eventPairArray[1] = SHELL_FIELD.with((Object)string2);
        eventPairArray[2] = TerminalShellInfoStatistics.INSTANCE.getShellVersionField().with((Object)shellInfo.getShellVersion());
        eventPairArray[3] = TerminalShellInfoStatistics.INSTANCE.getPromptThemeField().with((Object)shellInfo.getPromptTheme());
        eventPairArray[4] = TerminalShellInfoStatistics.INSTANCE.isOhMyZshField().with((Object)shellInfo.isOhMyZsh());
        eventPairArray[5] = TerminalShellInfoStatistics.INSTANCE.isOhMyPoshField().with((Object)shellInfo.isOhMyPosh());
        eventPairArray[6] = TerminalShellInfoStatistics.INSTANCE.isP10KField().with((Object)shellInfo.isP10K());
        eventPairArray[7] = TerminalShellInfoStatistics.INSTANCE.isStarshipField().with((Object)shellInfo.isStarship());
        eventPairArray[8] = TerminalShellInfoStatistics.INSTANCE.isSpaceshipField().with((Object)shellInfo.isSpaceship());
        eventPairArray[9] = TerminalShellInfoStatistics.INSTANCE.isPreztoField().with((Object)shellInfo.isPrezto());
        eventPairArray[10] = TerminalShellInfoStatistics.INSTANCE.isOhMyBashField().with((Object)shellInfo.isOhMyBash());
        eventPairArray[11] = TerminalShellInfoStatistics.INSTANCE.isBashItField().with((Object)shellInfo.isBashIt());
        shellStartedEvent.log(project, eventPairArray);
    }

    public final void triggerPromotionShown$intellij_terminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        promotionShownEvent.log(project);
    }

    public final void triggerPromotionGotItClicked$intellij_terminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        promotionGotItClickedEvent.log(project);
    }

    @JvmStatic
    public static final void triggerBlockTerminalSwitched$intellij_terminal(@NotNull Project project, boolean enabled, @NotNull BlockTerminalSwitchPlace place) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        blockTerminalSwitchedEvent.log(project, (Object)enabled, (Object)place);
    }

    public final void triggerFeedbackSurveyEvent$intellij_terminal(@NotNull Project project, @NotNull TerminalFeedbackEvent event, @NotNull TerminalFeedbackMoment moment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)moment), (String)"moment");
        feedbackSurveyEvent.log(project, (Object)event, (Object)moment);
    }

    public final void triggerCommandGenerationEvent(@NotNull Project project, @NotNull TerminalCommandGenerationEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        commandGenerationEvent.log(project, (Object)event);
    }

    @JvmStatic
    private static final String getShellNameForStat(String shellName) {
        String string;
        if (shellName == null) {
            return "unspecified";
        }
        String name = ((Object)StringsKt.trimStart((CharSequence)shellName)).toString();
        int ind = StringsKt.indexOf$default((CharSequence)name, (String)" ", (int)0, (boolean)false, (int)6, null);
        if (ind < 0) {
            string = name;
        } else {
            String string2 = name.substring(0, ind);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        name = string;
        if (SystemInfo.isFileSystemCaseSensitive) {
            String string3 = name;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            name = string4;
        }
        String string5 = PathUtil.getFileName((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileName(...)");
        name = string5;
        name = INSTANCE.trimKnownExt(name);
        return TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p().contains(name) ? name : "other";
    }

    private final String trimKnownExt(String name) {
        String string;
        String ext = PathUtil.getFileExtension((String)name);
        if (ext != null && TerminalUsageCollectorKt.access$getKNOWN_EXTENSIONS$p().contains(ext)) {
            String string2 = name.substring(0, name.length() - ext.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    static {
        EventFields $this$iv;
        INSTANCE = new TerminalUsageTriggerCollector();
        GROUP = new EventLogGroup("terminalShell", 22, null, 4, null);
        TERMINAL_COMMAND_HANDLER_FIELD = EventFields.Class((String)"terminalCommandHandler");
        RUN_ANYTHING_PROVIDER_FIELD = EventFields.Class((String)"runAnythingProvider");
        OS_VERSION_FIELD = EventFields.StringValidatedByRegexpReference$default((String)"os-version", (String)"version", null, (int)4, null);
        SHELL_FIELD = EventFields.String((String)"shell", (List)CollectionsKt.toList((Iterable)TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p()));
        BLOCK_TERMINAL_FIELD = EventFields.Boolean((String)"new_terminal");
        EXIT_CODE_FIELD = EventFields.Int((String)"exit_code");
        EXECUTION_TIME_FIELD = EventFields.Long((String)"execution_time", (String)"Time in milliseconds");
        sshExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"ssh.exec", null, (int)2, null);
        EventField[] eventFieldArray = new EventFields[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.executed", eventFieldArray);
        eventFieldArray = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandNotExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.not.executed", eventFieldArray);
        localExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"local.exec", (EventField)((EventField)OS_VERSION_FIELD), (EventField)((EventField)SHELL_FIELD), (EventField)((EventField)BLOCK_TERMINAL_FIELD), null, (int)16, null);
        eventFieldArray = new EventField[]{OS_VERSION_FIELD, SHELL_FIELD, TerminalShellInfoStatistics.INSTANCE.getShellVersionField(), TerminalShellInfoStatistics.INSTANCE.getPromptThemeField(), TerminalShellInfoStatistics.INSTANCE.isOhMyZshField(), TerminalShellInfoStatistics.INSTANCE.isOhMyPoshField(), TerminalShellInfoStatistics.INSTANCE.isP10KField(), TerminalShellInfoStatistics.INSTANCE.isStarshipField(), TerminalShellInfoStatistics.INSTANCE.isSpaceshipField(), TerminalShellInfoStatistics.INSTANCE.isPreztoField(), TerminalShellInfoStatistics.INSTANCE.isOhMyBashField(), TerminalShellInfoStatistics.INSTANCE.isBashItField()};
        shellStartedEvent = GROUP.registerVarargEvent("local.shell.started", eventFieldArray);
        commandStartedEvent = GROUP.registerEvent("terminal.command.executed", (EventField)TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), (EventField)TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), (EventField)BLOCK_TERMINAL_FIELD, "Fired each time when command is started");
        eventFieldArray = new EventField[]{TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), EXIT_CODE_FIELD, EXECUTION_TIME_FIELD};
        commandFinishedEvent = GROUP.registerVarargEvent("terminal.command.finished", "Fired each time when command is finished. New Terminal only.", eventFieldArray);
        promotionShownEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"promotion.shown", null, (int)2, null);
        promotionGotItClickedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"promotion.got.it.clicked", null, (int)2, null);
        eventFieldArray = EventFields.INSTANCE;
        String name$iv = "switch_place";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        blockTerminalSwitchedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"new.terminal.switched", (EventField)((EventField)EventFields.Boolean((String)"enabled")), (EventField)((EventField)new EnumEventField(name$iv, BlockTerminalSwitchPlace.class, null, transform$iv)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "event_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        EnumEventField enumEventField = new EnumEventField(name$iv, TerminalFeedbackEvent.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "moment";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        feedbackSurveyEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"feedback.event.happened", (EventField)((EventField)enumEventField), (EventField)((EventField)new EnumEventField(name$iv, TerminalFeedbackMoment.class, null, transform$iv)), null, (int)8, null);
        $this$iv = EventFields.INSTANCE;
        name$iv = "event_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        commandGenerationEvent = GROUP.registerEvent("command.generation.event.happened", (EventField)new EnumEventField(name$iv, TerminalCommandGenerationEvent.class, null, transform$iv), "Events related to generate command from natural language feature of New Terminal");
    }
}

