/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.compiler.charts.jps;

import com.intellij.java.compiler.charts.jps.CompilationChartsJpsBundle;
import com.intellij.java.compiler.charts.jps.CompilationStatusBuilderMessage;
import com.intellij.java.compiler.charts.jps.CompileStatisticBuilderMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class ChartsBuilderService
extends BuilderService {
    public static final String COMPILATION_STATISTIC_BUILDER_ID = "jps.compile.statistic";
    public static final String COMPILATION_STATUS_BUILDER_ID = "jps.compile.status";

    @NotNull
    public List<? extends ModuleLevelBuilder> createModuleLevelBuilders() {
        List<ChartsModuleLevelBuilder> list = List.of(new ChartsModuleLevelBuilder());
        if (list == null) {
            ChartsBuilderService.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/java/compiler/charts/jps/ChartsBuilderService", "createModuleLevelBuilders"));
    }

    private static class ChartsModuleLevelBuilder
    extends ModuleLevelBuilder {
        private static final Logger LOG = Logger.getInstance(ChartsModuleLevelBuilder.class);
        private ScheduledFuture<?> myStatisticsReporter = null;
        private Runnable myStatisticsRunnable = null;

        protected ChartsModuleLevelBuilder() {
            super(BuilderCategory.TRANSLATOR);
            LOG.debug(CompilationChartsJpsBundle.message("compilation.charts.jps.registered", new Object[0]));
        }

        public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(0);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(1);
            }
            if (dirtyFilesHolder == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(2);
            }
            if (outputConsumer == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(3);
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }

        @NotNull
        public List<String> getCompilableFileExtensions() {
            List<String> list = List.of();
            if (list == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getPresentableName() {
            String string = StringUtil.capitalize((String)ChartsModuleLevelBuilder.getBuilderName());
            if (string == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        public static String getBuilderName() {
            return "charts";
        }

        public void buildStarted(@NotNull CompileContext context) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(6);
            }
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            OperatingSystemMXBean os = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            context.processMessage((BuildMessage)new CompilationStatusBuilderMessage("START"));
            this.myStatisticsRunnable = () -> this.send(context, CompileStatisticBuilderMessage.create(memory, os));
            this.myStatisticsReporter = AppExecutorUtil.createBoundedScheduledExecutorService((String)"IncProjectBuilder metrics reporter", (int)1).scheduleWithFixedDelay(this.myStatisticsRunnable, 0L, 1L, TimeUnit.SECONDS);
        }

        private void send(@NotNull CompileContext context, @Nullable BuildMessage msg) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(7);
            }
            if (msg != null) {
                context.processMessage(msg);
            }
        }

        public void buildFinished(@NotNull CompileContext context) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(8);
            }
            context.processMessage((BuildMessage)new CompilationStatusBuilderMessage("FINISH"));
            if (this.myStatisticsRunnable != null) {
                this.myStatisticsRunnable.run();
                this.myStatisticsRunnable = null;
            }
            if (this.myStatisticsReporter != null) {
                this.myStatisticsReporter.cancel(true);
                this.myStatisticsReporter = null;
            }
        }

        public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(9);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(10);
            }
            context.processMessage((BuildMessage)CompileStatisticBuilderMessage.create(chunk.getTargets(), "STARTED"));
            if (this.myStatisticsRunnable != null) {
                this.myStatisticsRunnable.run();
            }
        }

        public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(11);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(12);
            }
            context.processMessage((BuildMessage)CompileStatisticBuilderMessage.create(chunk.getTargets(), "FINISHED"));
            if (this.myStatisticsRunnable != null) {
                this.myStatisticsRunnable.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirtyFilesHolder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputConsumer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/compiler/charts/jps/ChartsBuilderService$ChartsModuleLevelBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/compiler/charts/jps/ChartsBuilderService$ChartsModuleLevelBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilableFileExtensions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "buildStarted";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "send";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFinished";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "chunkBuildStarted";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "chunkBuildFinished";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

