/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AnnotateLocalFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateLocalFileAction.class);

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return false;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null || file.isDirectory() || file.getFileType().isBinary()) {
            return false;
        }
        VirtualFile vcsFile = VcsUtil.resolveSymlinkIfNeeded((Project)project, (VirtualFile)file);
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(vcsFile);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(vcsFile);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        return VcsAnnotateUtil.getBackgroundableLock(project, file).isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        VirtualFile file;
        Editor editor;
        if (e == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(2);
        }
        return (editor = VcsAnnotateUtil.getEditorFor(file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE), e.getDataContext())) != null && AnnotateToggleAction.hasVcsAnnotations(editor);
    }

    private static void perform(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile selectedFile = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        if (!selected) {
            Editor editor = Objects.requireNonNull(VcsAnnotateUtil.getEditorFor(selectedFile, e.getDataContext()));
            AnnotateToggleAction.closeVcsAnnotations(editor);
        } else {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null && !Objects.equals(editor.getVirtualFile(), selectedFile)) {
                editor = null;
            }
            if (editor == null && (editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, selectedFile), false)) == null) {
                Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"dialog.message.can.t.create.text.editor.for", (Object[])new Object[]{selectedFile.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                return;
            }
            AnnotateLocalFileAction.doAnnotate(editor, e, project);
        }
    }

    private static void doAnnotate(final @NotNull Editor editor, final AnActionEvent e, final @NotNull Project project) {
        if (editor == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AnnotateLocalFileAction.$$$reportNull$$$0(4);
        }
        final StructuredIdeActivity activity2 = VcsStatisticsCollector.ANNOTATE_ACTIVITY.started(project);
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null) {
            return;
        }
        final VirtualFile vcsFile = VcsUtil.resolveSymlinkIfNeeded((Project)project, (VirtualFile)file);
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(vcsFile);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionLock actionLock = VcsAnnotateUtil.getBackgroundableLock(project, file);
        actionLock.lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(vcsFile));
                }
                catch (VcsException e2) {
                    exceptionRef.set((Object)e2);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList((VcsException)((Object)exceptionRef.get())), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, (FileAnnotation)fileAnnotationRef.get(), vcs);
                }
                ArrayList<EventPair> eventData = new ArrayList<EventPair>();
                String place = e.getPlace();
                eventData.add(EventFields.ActionPlace.with((Object)place));
                eventData.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)ActionPlaces.isPopupPlace((String)place)));
                activity2.finished(() -> eventData);
            }

            public void onFinished() {
                actionLock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuspended";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotated";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doAnnotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateLocalFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateLocalFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateLocalFileAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                Provider.$$$reportNull$$$0(1);
            }
            AnnotateLocalFileAction.perform(e, selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateLocalFileAction$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuspended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

