/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;

public class AnnotationsWriteableFilesVfsListener
implements VirtualFileListener {
    private final Project myProject;
    private final VcsKey myVcsKey;

    public AnnotationsWriteableFilesVfsListener(@NotNull Project project, @NotNull VcsKey vcsKey) {
        if (project == null) {
            AnnotationsWriteableFilesVfsListener.$$$reportNull$$$0(0);
        }
        if (vcsKey == null) {
            AnnotationsWriteableFilesVfsListener.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myVcsKey = vcsKey;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            AnnotationsWriteableFilesVfsListener.$$$reportNull$$$0(2);
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if ("writable".equals(event.getPropertyName()) && ((Boolean)event.getOldValue()).booleanValue()) {
            this.closeAnnotations(event.getFile());
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            AnnotationsWriteableFilesVfsListener.$$$reportNull$$$0(3);
        }
        VirtualFile file = event.getFile();
        if (!event.isFromRefresh()) {
            return;
        }
        if (!file.isWritable()) {
            this.closeAnnotations(file);
        }
    }

    private void closeAnnotations(@NotNull VirtualFile file) {
        if (file == null) {
            AnnotationsWriteableFilesVfsListener.$$$reportNull$$$0(4);
        }
        VcsAnnotationLocalChangesListener annotationsListener = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAnnotationLocalChangesListener();
        annotationsListener.invalidateAnnotationsFor(file, this.myVcsKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/annotate/AnnotationsWriteableFilesVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "closeAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

