/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesViewManagerKt;
import com.intellij.openapi.vcs.changes.committed.ProjectCommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\u00020\t*\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/openapi/vcs/changes/committed/ProjectCommittedChangesPanel;", "createCommittedChangesPanel", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "runInEdtIfNotDisposed", "block", "Lkotlin/Function0;", "updateCommittedChangesProvider", "notifyBranchesChanged", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "DisplayNameSupplier", "MyCommittedChangesListener", "VisibilityPredicate", "intellij.platform.vcs.impl"})
public final class CommittedChangesViewManager
implements ChangesViewContentProvider {
    @NotNull
    private final Project project;
    @Nullable
    private ProjectCommittedChangesPanel panel;

    public CommittedChangesViewManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ProjectCommittedChangesPanel it = this.createCommittedChangesPanel();
        boolean bl = false;
        this.panel = it;
        content.setComponent((JComponent)((Object)it));
        content.setDisposer(() -> CommittedChangesViewManager.initTabContent$lambda$3$lambda$0(this));
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)it);
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        busConnection.subscribe(topic, () -> CommittedChangesViewManager.initTabContent$lambda$3$lambda$1(this));
        Topic<CommittedChangesListener> topic2 = CommittedChangesCache.COMMITTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"COMMITTED_TOPIC");
        busConnection.subscribe(topic2, (Object)new MyCommittedChangesListener());
        Topic<VcsConfigurationChangeListener.Notification> topic3 = VcsConfigurationChangeListener.BRANCHES_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"BRANCHES_CHANGED");
        busConnection.subscribe(topic3, (arg_0, arg_1) -> CommittedChangesViewManager.initTabContent$lambda$3$lambda$2(this, arg_0, arg_1));
        it.refreshChanges();
    }

    private final ProjectCommittedChangesPanel createCommittedChangesPanel() {
        CommittedChangesProvider committedChangesProvider = CommittedChangesViewManagerKt.access$getCommittedChangesProvider(this.project);
        Intrinsics.checkNotNull((Object)committedChangesProvider);
        return new ProjectCommittedChangesPanel(this.project, committedChangesProvider);
    }

    private final void updateCommittedChangesProvider() {
        block1: {
            CommittedChangesProvider committedChangesProvider = CommittedChangesViewManagerKt.access$getCommittedChangesProvider(this.project);
            if (committedChangesProvider == null) {
                return;
            }
            CommittedChangesProvider projectProvider = committedChangesProvider;
            ProjectCommittedChangesPanel projectCommittedChangesPanel = this.panel;
            if (projectCommittedChangesPanel == null) break block1;
            ProjectCommittedChangesPanel $this$updateCommittedChangesProvider_u24lambda_u244 = projectCommittedChangesPanel;
            boolean bl = false;
            $this$updateCommittedChangesProvider_u24lambda_u244.setProvider(projectProvider);
            this.notifyBranchesChanged($this$updateCommittedChangesProvider_u24lambda_u244, null);
        }
    }

    private final void notifyBranchesChanged(ProjectCommittedChangesPanel $this$notifyBranchesChanged, VirtualFile vcsRoot) {
        MessageBus messageBus = $this$notifyBranchesChanged.getProject().getMessageBus();
        Topic<VcsConfigurationChangeListener.DetailedNotification> topic = VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"BRANCHES_CHANGED_RESPONSE");
        Object object = messageBus.syncPublisher(topic);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        $this$notifyBranchesChanged.passCachedListsToListener((VcsConfigurationChangeListener.DetailedNotification)object, vcsRoot);
    }

    private final void runInEdtIfNotDisposed(Function0<Unit> block) {
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, block){
            final /* synthetic */ CommittedChangesViewManager this$0;
            final /* synthetic */ Function0<Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            public final void invoke() {
                if (CommittedChangesViewManager.access$getProject$p(this.this$0).isDisposed() || CommittedChangesViewManager.access$getPanel$p(this.this$0) == null) {
                    return;
                }
                this.$block.invoke();
            }
        }), (int)1, null);
    }

    private static final void initTabContent$lambda$3$lambda$0(CommittedChangesViewManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.panel = null;
    }

    private static final void initTabContent$lambda$3$lambda$1(CommittedChangesViewManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.runInEdtIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ CommittedChangesViewManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CommittedChangesViewManager.access$updateCommittedChangesProvider(this.this$0);
            }
        }));
    }

    private static final void initTabContent$lambda$3$lambda$2(CommittedChangesViewManager this$0, Project project, VirtualFile vcsRoot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        this$0.runInEdtIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this$0, vcsRoot){
            final /* synthetic */ CommittedChangesViewManager this$0;
            final /* synthetic */ VirtualFile $vcsRoot;
            {
                this.this$0 = $receiver;
                this.$vcsRoot = $vcsRoot;
                super(0);
            }

            public final void invoke() {
                ProjectCommittedChangesPanel projectCommittedChangesPanel = CommittedChangesViewManager.access$getPanel$p(this.this$0);
                if (projectCommittedChangesPanel != null) {
                    CommittedChangesViewManager.access$notifyBranchesChanged(this.this$0, projectCommittedChangesPanel, this.$vcsRoot);
                }
            }
        }));
    }

    public static final /* synthetic */ ProjectCommittedChangesPanel access$getPanel$p(CommittedChangesViewManager $this) {
        return $this.panel;
    }

    public static final /* synthetic */ void access$updateCommittedChangesProvider(CommittedChangesViewManager $this) {
        $this.updateCommittedChangesProvider();
    }

    public static final /* synthetic */ void access$notifyBranchesChanged(CommittedChangesViewManager $this, ProjectCommittedChangesPanel $receiver, VirtualFile vcsRoot) {
        $this.notifyBranchesChanged($receiver, vcsRoot);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "()V", "get", "intellij.platform.vcs.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string = VcsBundle.message((String)"committed.changes.tab", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$MyCommittedChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "(Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager;)V", "changesLoaded", "", "location", "Lcom/intellij/openapi/vcs/RepositoryLocation;", "changes", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "refreshErrorStatusChanged", "lastError", "Lcom/intellij/openapi/vcs/VcsException;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommittedChangesViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommittedChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$MyCommittedChangesListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    private final class MyCommittedChangesListener
    implements CommittedChangesListener {
        public void changesLoaded(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> changes) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            CommittedChangesViewManager.this.runInEdtIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(CommittedChangesViewManager.this){
                final /* synthetic */ CommittedChangesViewManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        ProjectCommittedChangesPanel projectCommittedChangesPanel = CommittedChangesViewManager.access$getPanel$p(this.this$0);
                        if (projectCommittedChangesPanel == null) break block0;
                        projectCommittedChangesPanel.refreshChanges();
                    }
                }
            }));
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            block0: {
                VcsException vcsException = lastError;
                if (vcsException == null) break block0;
                VcsException vcsException2 = vcsException;
                CommittedChangesViewManager committedChangesViewManager = CommittedChangesViewManager.this;
                VcsException it = vcsException2;
                boolean bl = false;
                VcsBalloonProblemNotifier.showOverChangesView(committedChangesViewManager.project, it.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$VisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "()V", "test", "", "project", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommittedChangesViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommittedChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$VisibilityPredicate\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n12474#2,2:98\n*S KotlinDebug\n*F\n+ 1 CommittedChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/committed/CommittedChangesViewManager$VisibilityPredicate\n*L\n85#1:98,2\n*E\n"})
    public static final class VisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
                Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
                Object[] $this$any$iv = abstractVcsArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    AbstractVcs it = (AbstractVcs)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!CommittedChangesViewManagerKt.isCommittedChangesAvailable(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }
    }
}

