/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.filename.UniqueNameBuilder;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ex.VcsActivationListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.impl.projectlevelman.VcsDefaultMappingUtils;
import com.intellij.openapi.vcs.impl.projectlevelman.VcsDirectoryMappingCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.util.paths.FilePathMapping;
import com.intellij.openapi.vcs.util.paths.VirtualFileMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class NewMappings
implements Disposable {
    private static final Comparator<MappedRoot> ROOT_COMPARATOR = Comparator.comparing(it -> it.root.getPath());
    private static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance(NewMappings.class);
    private final Object myUpdateLock;
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;
    private volatile List<VcsDirectoryMapping> myMappings;
    @NotNull
    private Disposable myFilePointerDisposable;
    private volatile List<MappedRoot> myMappedRoots;
    private volatile RootMapping myMappedRootsMapping;
    private volatile Map<VirtualFile, @NlsSafe String> myMappedRootShortNames;
    private volatile List<AbstractVcs> myActiveVcses;
    private volatile boolean myActivated;
    @NotNull
    private final MergingUpdateQueue myRootUpdateQueue;
    private final VirtualFilePointerListener myFilePointerListener;

    public NewMappings(@NotNull Project project, @NotNull ProjectLevelVcsManagerImpl vcsManager2) {
        if (project == null) {
            NewMappings.$$$reportNull$$$0(0);
        }
        if (vcsManager2 == null) {
            NewMappings.$$$reportNull$$$0(1);
        }
        this.myUpdateLock = new Object();
        this.myMappings = Collections.emptyList();
        this.myFilePointerDisposable = Disposer.newDisposable();
        this.myMappedRoots = Collections.emptyList();
        this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
        this.myMappedRootShortNames = Collections.emptyMap();
        this.myActiveVcses = Collections.emptyList();
        this.myActivated = false;
        this.myProject = project;
        this.myVcsManager = vcsManager2;
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this);
        this.myRootUpdateQueue = new MergingUpdateQueue("NewMappings", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).usePassThroughInUnitTestMode();
        this.myFilePointerListener = new VirtualFilePointerListener(){

            public void validityChanged(VirtualFilePointer @NotNull [] pointers) {
                if (pointers == null) {
                    1.$$$reportNull$$$0(0);
                }
                NewMappings.this.scheduleMappedRootsUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "validityChanged"));
            }
        };
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(() -> this.scheduleMappedRootsUpdate(), (Disposable)project);
    }

    @TestOnly
    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    public AbstractVcs @NotNull [] getActiveVcses() {
        AbstractVcs[] abstractVcsArray = this.myActiveVcses.toArray(new AbstractVcs[0]);
        if (abstractVcsArray == null) {
            NewMappings.$$$reportNull$$$0(2);
        }
        return abstractVcsArray;
    }

    public boolean hasActiveVcss() {
        return !this.myActiveVcses.isEmpty();
    }

    public boolean isActivated() {
        return this.myActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
            LOG.debug("activated");
        }
        this.updateActiveVcses(true);
        boolean fireMappingsChangedEvent = true;
        if (this.haveDefaultMapping() != null) {
            this.updateMappedRootsFast(fireMappingsChangedEvent);
            this.scheduleMappedRootsUpdateWithoutDelay();
        } else {
            this.updateMappedRoots(fireMappingsChangedEvent);
        }
    }

    private boolean updateActiveVcses(boolean forceFireEvent) {
        MyVcsActivator activator = (MyVcsActivator)ReadAction.compute(() -> {
            Object object = this.myUpdateLock;
            synchronized (object) {
                return this.myActivated ? this.createVcsActivator() : null;
            }
        });
        if (activator != null) {
            boolean wasChanged2 = activator.activate();
            if (forceFireEvent || wasChanged2) {
                ((VcsActivationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, ProjectLevelVcsManagerEx.VCS_ACTIVATED)).vcsesActivated(this.myActiveVcses);
            }
        }
        return activator != null;
    }

    public void setMapping(@NotNull String path2, @Nullable String activeVcsName) {
        if (path2 == null) {
            NewMappings.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setMapping path = '" + path2 + "' vcs = " + activeVcsName, new Throwable());
        }
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path2, activeVcsName);
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getDirectory(), newMapping.getDirectory()));
        newMappings.add(newMapping);
        this.updateVcsMappings(newMappings);
    }

    @TestOnly
    public void waitMappedRootsUpdate() {
        this.myRootUpdateQueue.flush();
    }

    @TestOnly
    public void freezeMappedRootsUpdate(@NotNull Disposable disposable) {
        if (disposable == null) {
            NewMappings.$$$reportNull$$$0(4);
        }
        this.myRootUpdateQueue.setPassThrough(false);
        this.myRootUpdateQueue.suspend();
        Disposer.register((Disposable)disposable, () -> {
            this.myRootUpdateQueue.setPassThrough(false);
            this.myRootUpdateQueue.resume();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMappedVcsesImmediately() {
        LOG.debug("updateMappingsImmediately");
        if (!this.updateActiveVcses(false)) {
            return;
        }
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = Disposer.newDisposable();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.myMappedRootShortNames = Collections.emptyMap();
            this.dumpMappedRootsToLog();
        }
        this.notifyMappingsChanged();
        this.scheduleMappedRootsUpdate();
    }

    public void scheduleMappedRootsUpdate() {
        this.myRootUpdateQueue.queue((Update)new DisposableUpdate(this, "update"){

            public void doRun() {
                NewMappings.this.updateMappedRoots(true);
            }
        });
    }

    private void scheduleMappedRootsUpdateWithoutDelay() {
        this.scheduleMappedRootsUpdate();
        this.myRootUpdateQueue.sendFlush();
    }

    private void updateVcsMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(5);
        }
        this.updateVcsMappings(mappings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVcsMappings(@NotNull List<VcsDirectoryMapping> mappings, boolean updateRootsImmediately) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(6);
        }
        this.myRootUpdateQueue.cancelAllUpdates();
        List newMappings = List.copyOf(ContainerUtil.sorted(NewMappings.removeDuplicates(mappings), MAPPINGS_COMPARATOR));
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappingsChanged;
            boolean bl = mappingsChanged = !this.myMappings.equals(newMappings);
            if (!mappingsChanged) {
                return;
            }
            this.myMappings = newMappings;
            this.dumpMappingsToLog();
        }
        boolean isActivated = this.updateActiveVcses(false);
        if (updateRootsImmediately) {
            boolean fireMappingsChangedEvent = false;
            if (ApplicationManager.getApplication().isDispatchThread() && ContainerUtil.exists(newMappings, it -> it.isDefaultMapping())) {
                this.updateMappedRootsFast(fireMappingsChangedEvent);
                this.scheduleMappedRootsUpdateWithoutDelay();
            } else {
                this.updateMappedRoots(fireMappingsChangedEvent);
            }
        } else {
            this.scheduleMappedRootsUpdateWithoutDelay();
        }
        if (updateRootsImmediately || isActivated) {
            this.notifyMappingsChanged();
        }
    }

    private void updateMappedRoots(boolean fireMappingsChangedEvent) {
        this.myRootUpdateQueue.cancelAllUpdates();
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRoots");
        List<VcsDirectoryMapping> mappings = this.myMappings;
        Mappings newMappedRoots = this.collectMappedRoots(mappings, null);
        this.setNewMappedRoots(mappings, newMappedRoots, fireMappingsChangedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappedRootsFast(boolean fireMappingsChangedEvent) {
        List<MappedRoot> mappedRoots;
        List<VcsDirectoryMapping> mappings;
        if (!this.myActivated) {
            return;
        }
        LOG.debug("updateMappedRootsFast");
        Object object = this.myUpdateLock;
        synchronized (object) {
            mappings = this.myMappings;
            mappedRoots = this.myMappedRoots;
        }
        if (mappedRoots.isEmpty()) {
            mappedRoots = this.getCachedMappedRootsIfNeeded(mappings);
        }
        Mappings newMappedRoots = this.collectMappedRoots(mappings, mappedRoots);
        this.setNewMappedRoots(mappings, newMappedRoots, fireMappingsChangedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewMappedRoots(@NotNull List<VcsDirectoryMapping> mappings, @NotNull Mappings newMappedRoots, boolean fireMappingsChangedEvent) {
        boolean mappedRootsChanged;
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(7);
        }
        if (newMappedRoots == null) {
            NewMappings.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, @NlsSafe String> newMappedRootNames = NewMappings.buildMappingShortNameMap(this.myProject, newMappedRoots.mappedRoots);
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myMappings != mappings) {
                Disposer.dispose((Disposable)newMappedRoots.filePointerDisposable);
                return;
            }
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myFilePointerDisposable = newMappedRoots.filePointerDisposable;
            boolean bl = mappedRootsChanged = !this.myMappedRoots.equals(newMappedRoots.mappedRoots);
            if (mappedRootsChanged) {
                this.myMappedRoots = newMappedRoots.mappedRoots;
                this.myMappedRootsMapping = new RootMapping(newMappedRoots.mappedRoots);
                this.myMappedRootShortNames = newMappedRootNames;
                this.dumpMappedRootsToLog();
            }
        }
        if (fireMappingsChangedEvent && mappedRootsChanged) {
            this.notifyMappingsChanged();
        }
    }

    private static @NotNull Map<VirtualFile, @NlsSafe String> buildMappingShortNameMap(@NotNull Project project, @NotNull List<MappedRoot> roots) {
        String basePath;
        if (project == null) {
            NewMappings.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            NewMappings.$$$reportNull$$$0(10);
        }
        String builderRoot = (basePath = project.getBasePath()) != null ? FileUtil.toSystemIndependentName((String)basePath) : "";
        MultiMap nameCollisionMap = new MultiMap();
        for (MappedRoot mappedRoot : roots) {
            VirtualFile root = mappedRoot.root;
            nameCollisionMap.putValue((Object)root.getName(), (Object)root);
        }
        HashMap<VirtualFile, @NlsSafe String> result2 = new HashMap<VirtualFile, String>();
        for (Map.Entry entry : nameCollisionMap.entrySet()) {
            Collection collisionRoots = (Collection)entry.getValue();
            if (collisionRoots.size() == 1) {
                for (VirtualFile root : collisionRoots) {
                    result2.put(root, root.getName());
                }
                continue;
            }
            UniqueNameBuilder builder2 = new UniqueNameBuilder(builderRoot, File.separator);
            for (VirtualFile root : collisionRoots) {
                builder2.addPath((Object)root, root.getPath());
            }
            for (VirtualFile root : collisionRoots) {
                result2.put(root, StringUtil.nullize((String)builder2.getShortPath((Object)root)));
            }
        }
        HashMap<VirtualFile, String> hashMap = result2;
        if (hashMap == null) {
            NewMappings.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private void refreshMainMenu() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ProjectFrameHelper frame = WindowManagerEx.getInstanceEx().getFrameHelper(this.myProject);
            if (frame != null) {
                if (ExperimentalUI.isNewUI()) {
                    frame.rootPane.updateMainMenuActions();
                } else {
                    frame.updateView();
                }
            }
        }, this.myProject.getDisposed());
    }

    @NotNull
    private static List<VcsDirectoryMapping> removeDuplicates(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(12);
        }
        ArrayList<VcsDirectoryMapping> newMapping = new ArrayList<VcsDirectoryMapping>();
        HashSet<String> paths = new HashSet<String>();
        for (VcsDirectoryMapping mapping : ContainerUtil.reverse(mappings)) {
            if (!paths.add(mapping.getDirectory())) continue;
            newMapping.add(mapping);
        }
        ArrayList<VcsDirectoryMapping> arrayList = newMapping;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private List<MappedRoot> getCachedMappedRootsIfNeeded(@NotNull List<VcsDirectoryMapping> mappings) {
        VcsDirectoryMapping defaultMapping;
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(14);
        }
        if ((defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(mappings, it -> it.isDefaultMapping())) == null) {
            List<MappedRoot> list = Collections.emptyList();
            if (list == null) {
                NewMappings.$$$reportNull$$$0(15);
            }
            return list;
        }
        AbstractVcs vcs = this.getMappingsVcs(defaultMapping);
        if (vcs == null) {
            List<MappedRoot> list = Collections.emptyList();
            if (list == null) {
                NewMappings.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<String> oldMappings = VcsDirectoryMappingCache.getInstance(this.myProject).getMappings(defaultMapping.getVcs());
        List list = ContainerUtil.mapNotNull(oldMappings, path2 -> {
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
            return root != null ? new MappedRoot(vcs, defaultMapping, root) : null;
        });
        if (list == null) {
            NewMappings.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private Mappings collectMappedRoots(@NotNull List<VcsDirectoryMapping> mappings, @Nullable List<MappedRoot> reuseMappedRoots) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(18);
        }
        HashMap<VirtualFile, MappedRoot> mappedRoots = new HashMap<VirtualFile, MappedRoot>();
        Disposable pointerDisposable = Disposer.newDisposable();
        if (!TrustedProjects.isTrusted((Project)this.myProject)) {
            return new Mappings(Collections.emptyList(), pointerDisposable);
        }
        try {
            for (VcsDirectoryMapping mapping : mappings) {
                if (mapping.isDefaultMapping()) continue;
                MappedRoot mappedRoot = this.findDirectMappingFor(mapping, pointerDisposable);
                if (mappedRoot != null) {
                    mappedRoots.putIfAbsent(mappedRoot.root, mappedRoot);
                    continue;
                }
                LOG.info("Invalid mapping: " + mapping);
            }
            for (VcsDirectoryMapping mapping : mappings) {
                List<MappedRoot> defaultMappings;
                if (!mapping.isDefaultMapping()) continue;
                if (reuseMappedRoots != null) {
                    defaultMappings = this.reuseDefaultMappingsFrom(mapping, reuseMappedRoots, pointerDisposable);
                } else {
                    Set directMappingDirs = ContainerUtil.map2Set(mappedRoots.values(), it -> it.root);
                    defaultMappings = this.findDefaultMappingsFor(mapping, directMappingDirs, pointerDisposable);
                    VcsDirectoryMappingCache.getInstance(this.myProject).setMappings(mapping.getVcs(), ContainerUtil.map(defaultMappings, it -> it.root.getPath()));
                }
                for (MappedRoot mappedRoot : defaultMappings) {
                    mappedRoots.putIfAbsent(mappedRoot.root, mappedRoot);
                }
            }
            List result2 = ContainerUtil.sorted(mappedRoots.values(), ROOT_COMPARATOR);
            for (MappedRoot root : result2) {
                if (!this.myVcsManager.isIgnored(VcsUtil.getFilePath((VirtualFile)root.root))) continue;
                LOG.warn("Root mapping is under ignored root: " + root.root);
            }
            return new Mappings(result2, pointerDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)pointerDisposable);
            ExceptionUtil.rethrow((Throwable)e);
            if (null == null) {
                NewMappings.$$$reportNull$$$0(19);
            }
            return null;
        }
    }

    @Nullable
    private MappedRoot findDirectMappingFor(@NotNull VcsDirectoryMapping mapping, @NotNull Disposable pointerDisposable) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(20);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(21);
        }
        AbstractVcs vcs = this.getMappingsVcs(mapping);
        String rootPath = mapping.getDirectory();
        return (MappedRoot)ReadAction.compute(() -> {
            VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)rootPath), pointerDisposable, this.myFilePointerListener);
            VirtualFile vcsRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
            if (vcsRoot == null || !vcsRoot.isDirectory()) {
                return null;
            }
            if (this.checkMappedRoot(vcs, vcsRoot)) {
                return new MappedRoot(vcs, mapping, vcsRoot);
            }
            return new MappedRoot(null, mapping, vcsRoot);
        });
    }

    @NotNull
    private List<MappedRoot> findDefaultMappingsFor(@NotNull VcsDirectoryMapping mapping, @NotNull Set<VirtualFile> directMappingDirs, @NotNull Disposable pointerDisposable) {
        AbstractVcs vcs;
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(22);
        }
        if (directMappingDirs == null) {
            NewMappings.$$$reportNull$$$0(23);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(24);
        }
        if ((vcs = this.getMappingsVcs(mapping)) == null) {
            List<MappedRoot> list = Collections.emptyList();
            if (list == null) {
                NewMappings.$$$reportNull$$$0(25);
            }
            return list;
        }
        Collection<VirtualFile> defaultRoots = this.detectDefaultRootsFor(vcs, DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(), directMappingDirs);
        ArrayList<MappedRoot> result2 = new ArrayList<MappedRoot>();
        ReadAction.run(() -> {
            for (VirtualFile vcsRoot : defaultRoots) {
                if (vcsRoot == null || !vcsRoot.isDirectory()) continue;
                VirtualFilePointerManager.getInstance().create(vcsRoot, pointerDisposable, this.myFilePointerListener);
                result2.add(new MappedRoot(vcs, mapping, vcsRoot));
            }
        });
        ArrayList<MappedRoot> arrayList = result2;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private List<MappedRoot> reuseDefaultMappingsFrom(@NotNull VcsDirectoryMapping mapping, @NotNull List<MappedRoot> oldMappedRoots, @NotNull Disposable pointerDisposable) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(27);
        }
        if (oldMappedRoots == null) {
            NewMappings.$$$reportNull$$$0(28);
        }
        if (pointerDisposable == null) {
            NewMappings.$$$reportNull$$$0(29);
        }
        ArrayList<MappedRoot> result2 = new ArrayList<MappedRoot>();
        ReadAction.run(() -> {
            List oldMappings = ContainerUtil.filter((Collection)oldMappedRoots, root -> root.mapping.getVcs().equals(mapping.getVcs()));
            for (MappedRoot root2 : oldMappings) {
                VirtualFilePointerManager.getInstance().create(root2.root, pointerDisposable, this.myFilePointerListener);
                result2.add(new MappedRoot(root2.vcs, mapping, root2.root));
            }
        });
        ArrayList<MappedRoot> arrayList = result2;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    private AbstractVcs getMappingsVcs(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(31);
        }
        return AllVcses.getInstance(this.myProject).getByName(mapping.getVcs());
    }

    private boolean checkMappedRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            NewMappings.$$$reportNull$$$0(32);
        }
        try {
            if (vcs == null) {
                return false;
            }
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            return rootChecker.validateRoot(vcsRoot);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    @NotNull
    private Collection<VirtualFile> detectDefaultRootsFor(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) {
        Set<VirtualFile> set;
        VcsRootChecker rootChecker;
        block13: {
            block12: {
                if (vcs == null) {
                    NewMappings.$$$reportNull$$$0(33);
                }
                if (projectRoots == null) {
                    NewMappings.$$$reportNull$$$0(34);
                }
                if (mappedDirs == null) {
                    NewMappings.$$$reportNull$$$0(35);
                }
                if (!vcs.needsLegacyDefaultMappings()) break block12;
                Collection<VirtualFile> collection = projectRoots;
                if (collection == null) {
                    NewMappings.$$$reportNull$$$0(36);
                }
                return collection;
            }
            rootChecker = this.myVcsManager.getRootChecker(vcs);
            Collection checkerFiles = rootChecker.detectProjectMappings(this.myProject, projectRoots, mappedDirs);
            if (checkerFiles == null) break block13;
            Collection collection = checkerFiles;
            if (collection == null) {
                NewMappings.$$$reportNull$$$0(37);
            }
            return collection;
        }
        try {
            set = VcsDefaultMappingUtils.detectProjectMappings(this.myProject, rootChecker, projectRoots, mappedDirs);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NewMappings.$$$reportNull$$$0(39);
            }
            return list;
        }
        if (set == null) {
            NewMappings.$$$reportNull$$$0(38);
        }
        return set;
    }

    public void notifyMappingsChanged() {
        ((VcsMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileWatchRequestsManager.ping();
    }

    private void dumpMappingsToLog() {
        for (VcsDirectoryMapping mapping : this.myMappings) {
            String path2 = mapping.isDefaultMapping() ? "<Project>" : mapping.getDirectory();
            String vcs = mapping.getVcs();
            LOG.info(String.format("VCS Root: [%s] - [%s]", vcs, path2));
        }
    }

    private void dumpMappedRootsToLog() {
        block3: {
            block2: {
                if (!LOG.isDebugEnabled()) break block2;
                for (MappedRoot root2 : this.myMappedRoots) {
                    LOG.debug(String.format("Mapped Root: [%s] - [%s]", root2.vcs, root2.root.getPath()));
                }
                break block3;
            }
            if (this.haveDefaultMapping() == null) break block3;
            LOG.info("Mapped Roots: " + this.myMappedRoots.size());
            List detectedRoots = ContainerUtil.filter(this.myMappedRoots, root -> root.mapping.isDefaultMapping());
            for (MappedRoot root3 : ContainerUtil.getFirstItems((List)detectedRoots, (int)10)) {
                LOG.info(String.format("Detected mapped Root: [%s] - [%s]", root3.vcs, root3.root.getPath()));
            }
        }
    }

    public void setDirectoryMappingsFromConfig(@NotNull List<VcsDirectoryMapping> items) {
        if (items == null) {
            NewMappings.$$$reportNull$$$0(40);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setDirectoryMappingsFromConfig, size: " + items.size(), new Throwable());
        }
        this.updateVcsMappings(items, false);
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items) {
        if (items == null) {
            NewMappings.$$$reportNull$$$0(41);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setDirectoryMappings, size: " + items.size(), new Throwable());
        }
        this.updateVcsMappings(items);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable FilePath file) {
        if (file == null || file.isNonLocal()) {
            return null;
        }
        if (this.myMappedRoots.isEmpty()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        return this.myMappedRootsMapping.getRootFor(file);
    }

    @NotNull
    public List<MappedRoot> getAllMappedRoots() {
        List<MappedRoot> list = this.myMappedRoots;
        if (list == null) {
            NewMappings.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Nullable
    @NlsSafe
    public String getShortNameFor(@Nullable VirtualFile file) {
        return this.myMappedRootShortNames.get(file);
    }

    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            NewMappings.$$$reportNull$$$0(43);
        }
        List list = ContainerUtil.mapNotNull(this.myMappedRoots, root -> vcs.equals((Object)root.vcs) ? root.root : null);
        if (list == null) {
            NewMappings.$$$reportNull$$$0(44);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MyVcsActivator activator;
        LOG.debug("disposed");
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappings = Collections.emptyList();
            this.myMappedRoots = Collections.emptyList();
            this.myMappedRootsMapping = new RootMapping(Collections.emptyList());
            this.myMappedRootShortNames = Collections.emptyMap();
            this.myFilePointerDisposable = Disposer.newDisposable();
            activator = this.createVcsActivator();
        }
        activator.activate();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        return ContainerUtil.filter(this.myMappings, mapping -> Objects.equals(mapping.getVcs(), vcsName));
    }

    @Nullable
    public String haveDefaultMapping() {
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(this.myMappings, mapping -> mapping.isDefaultMapping());
        return defaultMapping != null ? defaultMapping.getVcs() : null;
    }

    public boolean isEmpty() {
        return ContainerUtil.all(this.myMappings, mapping -> mapping.isNoneMapping());
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(45);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove mapping: " + mapping.getDirectory(), new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.remove(mapping);
        this.updateVcsMappings(newMappings);
    }

    public void cleanupMappings() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VcsDirectoryMapping> oldMappings = new ArrayList<VcsDirectoryMapping>(this.getDirectoryMappings());
        ArrayList<VcsDirectoryMapping> filteredMappings = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(oldMappings, it -> it.isDefaultMapping());
        if (defaultMapping != null) {
            oldMappings.remove(defaultMapping);
            filteredMappings.add(defaultMapping);
        }
        MultiMap groupedMappings = new MultiMap();
        for (VcsDirectoryMapping mapping : oldMappings) {
            groupedMappings.putValue((Object)mapping.getVcs(), (Object)mapping);
        }
        for (Map.Entry entry : groupedMappings.entrySet()) {
            String vcsName = (String)entry.getKey();
            Collection mappings = (Collection)entry.getValue();
            List objects = ContainerUtil.mapNotNull((Collection)mappings, dm -> {
                VirtualFile vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                return vf == null ? null : Pair.create((Object)vf, (Object)dm);
            });
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredMappings.addAll(ContainerUtil.map((Collection)objects, (Function)Functions.pairSecond()));
                continue;
            }
            AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
            if (vcs == null) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsBundle.message((String)"impl.notification.content.vcs.plugin.not.found.for.mapping.to", (Object[])new Object[]{vcsName}), MessageType.ERROR, new NamedRunnable[0]);
                filteredMappings.addAll(mappings);
                continue;
            }
            filteredMappings.addAll(ContainerUtil.map((Collection)vcs.filterUniqueRoots(objects, pair -> (VirtualFile)pair.getFirst()), (Function)Functions.pairSecond()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("NewMappings.cleanupMappings", new Object[]{this.getDirectoryMappings(), filteredMappings});
        }
        this.updateVcsMappings(filteredMappings);
    }

    @NotNull
    private MyVcsActivator createVcsActivator() {
        Set newVcses = !this.myProject.isDisposed() && TrustedProjects.isTrusted((Project)this.myProject) ? ContainerUtil.map2SetNotNull(this.myMappings, this::getMappingsVcs) : Collections.emptySet();
        List<AbstractVcs> oldVcses = this.myActiveVcses;
        this.myActiveVcses = List.copyOf(newVcses);
        this.refreshMainMenu();
        Collection toAdd = ContainerUtil.subtract(this.myActiveVcses, oldVcses);
        Collection toRemove = ContainerUtil.subtract(oldVcses, this.myActiveVcses);
        return new MyVcsActivator(toAdd, toRemove);
    }

    public boolean haveActiveVcs(String name) {
        return ContainerUtil.exists(this.myActiveVcses, vcs -> Objects.equals(vcs.getName(), name));
    }

    public void beingUnregistered(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beingUnregistered " + name, new Throwable());
        }
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Objects.equals(mapping.getVcs(), name));
        this.updateVcsMappings(newMappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11, 13, 15, 16, 17, 19, 25, 26, 30, 36, 37, 38, 39, 42, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMappedRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 20: 
            case 22: 
            case 27: 
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerDisposable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directMappingDirs";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMappedRoots";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoots";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedDirs";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveVcses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMappingShortNameMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMappedRootsIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMappedRoots";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefaultMappingsFor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseDefaultMappingsFrom";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "detectDefaultRootsFor";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMappedRoots";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsAsFilesUnderVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "freezeMappedRootsUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateVcsMappings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNewMappedRoots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildMappingShortNameMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMappedRootsIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectMappedRoots";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDirectMappingFor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultMappingsFor";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reuseDefaultMappingsFrom";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsVcs";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkMappedRoot";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "detectDefaultRootsFor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappingsFromConfig";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsAsFilesUnderVcs";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11, 13, 15, 16, 17, 19, 25, 26, 30, 36, 37, 38, 39, 42, 44 -> new IllegalStateException(string);
        };
    }

    private static final class RootMapping {
        private final VirtualFileMapping<MappedRoot> myVFMap;
        private final FilePathMapping<MappedRoot> myPathMapping;

        private RootMapping(@NotNull List<MappedRoot> mappedRoots) {
            if (mappedRoots == null) {
                RootMapping.$$$reportNull$$$0(0);
            }
            this.myVFMap = new VirtualFileMapping();
            this.myPathMapping = new FilePathMapping(SystemInfo.isFileSystemCaseSensitive);
            for (MappedRoot root : mappedRoots) {
                this.myVFMap.add(root.root, root);
                this.myPathMapping.add(root.root.getPath(), root);
            }
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull VirtualFile file) {
            if (file == null) {
                RootMapping.$$$reportNull$$$0(1);
            }
            return this.myVFMap.getMappingFor(file);
        }

        @Nullable
        public MappedRoot getRootFor(@NotNull FilePath filePath) {
            if (filePath == null) {
                RootMapping.$$$reportNull$$$0(2);
            }
            return this.myPathMapping.getMappingFor(filePath.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$RootMapping";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRootFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyVcsActivator {
        @NotNull
        private final Collection<? extends AbstractVcs> myAddVcses;
        @NotNull
        private final Collection<? extends AbstractVcs> myRemoveVcses;

        private MyVcsActivator(@NotNull Collection<? extends AbstractVcs> addVcses, @NotNull Collection<? extends AbstractVcs> removeVcses) {
            if (addVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(0);
            }
            if (removeVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(1);
            }
            this.myAddVcses = addVcses;
            this.myRemoveVcses = removeVcses;
        }

        public boolean activate() {
            return (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                for (AbstractVcs abstractVcs : this.myAddVcses) {
                    try {
                        abstractVcs.doActivate();
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                }
                for (AbstractVcs abstractVcs : this.myRemoveVcses) {
                    try {
                        abstractVcs.doDeactivate();
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return !this.myAddVcses.isEmpty() || !this.myRemoveVcses.isEmpty();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addVcses";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removeVcses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MyVcsActivator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Mappings {
        @NotNull
        public final List<MappedRoot> mappedRoots;
        @NotNull
        public final Disposable filePointerDisposable;

        private Mappings(@NotNull List<MappedRoot> mappedRoots, @NotNull Disposable filePointerDisposable) {
            if (mappedRoots == null) {
                Mappings.$$$reportNull$$$0(0);
            }
            if (filePointerDisposable == null) {
                Mappings.$$$reportNull$$$0(1);
            }
            this.mappedRoots = mappedRoots;
            this.filePointerDisposable = filePointerDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointerDisposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$Mappings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MappedRoot {
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsDirectoryMapping mapping;
        @NotNull
        public final VirtualFile root;

        private MappedRoot(@Nullable AbstractVcs vcs, @NotNull VcsDirectoryMapping mapping, @NotNull VirtualFile root) {
            if (mapping == null) {
                MappedRoot.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MappedRoot.$$$reportNull$$$0(1);
            }
            this.vcs = vcs;
            this.mapping = mapping;
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappedRoot other = (MappedRoot)o;
            return Objects.equals(this.vcs, other.vcs) && this.mapping.equals((Object)other.mapping) && this.root.equals(other.root);
        }

        public int hashCode() {
            return Objects.hash(this.vcs, this.mapping, this.root);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MappedRoot";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

