/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.FilesCollector;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronouslyKt;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.Wrapper;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J*\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010H\u0002J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007J\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0007J\u0015\u0010\u0018\u001a\u00020\u000b2\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020 0\u000eH\u0007J\u0016\u0010!\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/vcs/update/RefreshVFsSynchronously;", "", "()V", "TRACE_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findValidParent", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "refresh", "", "T", "changes", "", "wrapper", "Lcom/intellij/openapi/vcs/update/Wrapper;", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "isRollback", "", "refreshDeletedFiles", "files", "refreshFiles", "refreshVirtualFiles", "trace", "message", "", "Lorg/jetbrains/annotations/NonNls;", "updateAllChanged", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "updateChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "updateChangesForRollback", "", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRefreshVFsSynchronously.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,145:1\n1611#2:146\n1855#2:147\n1856#2:149\n1612#2:150\n1611#2:155\n1855#2:156\n1856#2:158\n1612#2:159\n1855#2,2:164\n1#3:148\n1#3:157\n37#4,2:151\n37#4,2:153\n37#4,2:160\n179#5,2:162\n*S KotlinDebug\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n*L\n47#1:146\n47#1:147\n47#1:149\n47#1:150\n65#1:155\n65#1:156\n65#1:158\n65#1:159\n86#1:164,2\n47#1:148\n65#1:157\n48#1:151,2\n57#1:153,2\n66#1:160,2\n72#1:162,2\n*E\n"})
public final class RefreshVFsSynchronously {
    @NotNull
    public static final RefreshVFsSynchronously INSTANCE = new RefreshVFsSynchronously();
    @NotNull
    private static final Logger TRACE_LOG;

    private RefreshVFsSynchronously() {
    }

    @JvmStatic
    public static final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously: " + message);
        }
    }

    @JvmStatic
    public static final void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"updatedFiles");
        FilesCollector collector = new FilesCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, collector);
        INSTANCE.refreshDeletedFiles((Collection<? extends File>)collector.getDeletedFiles());
        RefreshVFsSynchronously.refreshFiles((Collection<? extends File>)collector.getFiles());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void refreshFiles(@NotNull Collection<? extends File> files2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (files2.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshFiles: " + files2, new Throwable());
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])files2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        Collection $this$toTypedArray$iv = toRefresh;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (files2.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFiles: " + files2, new Throwable());
        }
        Collection<? extends VirtualFile> $this$toTypedArray$iv = files2;
        boolean $i$f$toTypedArray = false;
        Collection<? extends VirtualFile> thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDeletedFiles(Collection<? extends File> files2) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        if (files2.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshDeletedFiles: " + files2, new Throwable());
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])files2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it.getParentFile()) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        Collection $this$toTypedArray$iv = toRefresh;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    private final VirtualFile findValidParent(File file) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, (Function1)findValidParent.1.INSTANCE), (Function1)findValidParent.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final void updateChangesForRollback(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh((Collection)changes, RefreshVFsSynchronouslyKt.access$getREVERSED_CHANGE_WRAPPER$p());
    }

    @JvmStatic
    public static final void updateChanges(@NotNull Collection<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh(changes, RefreshVFsSynchronouslyKt.access$getCHANGE_WRAPPER$p());
    }

    public final void refresh(@NotNull Collection<? extends FilePathChange> changes, boolean isRollback) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.refresh(changes, isRollback ? RefreshVFsSynchronouslyKt.access$getREVERSED_FILE_PATH_CHANGE_WRAPPER$p() : RefreshVFsSynchronouslyKt.access$getFILE_PATH_CHANGE_WRAPPER$p());
    }

    public static /* synthetic */ void refresh$default(RefreshVFsSynchronously refreshVFsSynchronously, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        refreshVFsSynchronously.refresh(collection, bl);
    }

    private final <T> void refresh(Collection<? extends T> changes, Wrapper<T> wrapper) {
        Set files2 = new LinkedHashSet();
        Set deletedFiles = new LinkedHashSet();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            FilePath it;
            Object element$iv;
            Object change = element$iv = iterator.next();
            boolean bl = false;
            FilePath beforePath = wrapper.getBeforePath(change);
            FilePath afterPath = wrapper.getAfterPath(change);
            if (beforePath != null) {
                boolean bl2 = false;
                ((Collection)(wrapper.isBeforePathDeleted(change) ? deletedFiles : files2)).add(it.getIOFile());
            }
            if (afterPath == null) continue;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)beforePath)) continue;
            ((Collection)files2).add(it.getIOFile());
        }
        RefreshVFsSynchronously.refreshFiles(files2);
        this.refreshDeletedFiles(deletedFiles);
    }

    static {
        Logger logger = Logger.getInstance((String)"#trace.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TRACE_LOG = logger;
    }
}

