/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchBuilder;
import com.jetbrains.rd.ide.requests.PatchEngine;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Stack;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002./B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001f\u001a\u00020\u0007H\u0097@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0016J&\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010&\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0014\u0010)\u001a\u00020\u00072\n\u0010*\u001a\u00060\u0010R\u00020\u0000H\u0002J\u0014\u0010+\u001a\u00020\u00072\n\u0010*\u001a\u00060\u0010R\u00020\u0000H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0006H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "clientSession", "Lcom/intellij/openapi/client/ClientAppSession;", "sender", "Lkotlin/Function1;", "Lcom/jetbrains/rd/ide/model/RdPatch;", "", "(Lcom/intellij/openapi/client/ClientAppSession;Lkotlin/jvm/functions/Function1;)V", "getClientSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "currentChangeScope", "Lcom/jetbrains/rd/ide/requests/ChangeScope;", "getCurrentChangeScope", "()Lcom/jetbrains/rd/ide/requests/ChangeScope;", "currentSession", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;", "getCurrentSession", "()Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;", "hasActivePatch", "", "getHasActivePatch", "()Z", "hasActivePatchFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "()V", "sessionStack", "Ljava/util/ArrayDeque;", "awaitNoPatches", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeCurrentSession", "description", "", "openAccumulatingSession", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSessionToken;", "sendOnClose", "changeOriginator", "Lcom/intellij/openapi/client/ClientSession;", "popSession", "accumulatingSession", "pushSession", "sendPatch", "patch", "ChangeAccumulatingSession", "ChangeAccumulatingSessionToken", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nRdPatchEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdPatchEngine.kt\ncom/jetbrains/rd/ide/requests/RdPatchEngine\n+ 2 clientLogger.kt\ncom/jetbrains/rd/platform/util/ClientLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n10#2:147\n7#2:148\n65#3,4:149\n65#3,4:153\n*S KotlinDebug\n*F\n+ 1 RdPatchEngine.kt\ncom/jetbrains/rd/ide/requests/RdPatchEngine\n*L\n16#1:147\n16#1:148\n27#1:149,4\n33#1:153,4\n*E\n"})
public final class RdPatchEngine
implements PatchEngine {
    @NotNull
    private final ClientAppSession clientSession;
    @NotNull
    private final Function1<RdPatch, Unit> sender;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayDeque<ChangeAccumulatingSession> sessionStack;
    @NotNull
    private final MutableStateFlow<Boolean> hasActivePatchFlow;

    public RdPatchEngine(@NotNull ClientAppSession clientSession, @NotNull Function1<? super RdPatch, Unit> sender) {
        Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        this.clientSession = clientSession;
        this.sender = sender;
        RdPatchEngine rdPatchEngine = this;
        ClientSession session$iv = (ClientSession)this.clientSession;
        boolean $i$f$thisLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance((String)(RdPatchEngine.class.getName() + "#" + session$iv.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.sessionStack = new ArrayDeque();
        this.hasActivePatchFlow = StateFlowKt.MutableStateFlow((Object)(this.getCurrentSession() != null ? 1 : 0));
    }

    @NotNull
    public final ClientAppSession getClientSession() {
        return this.clientSession;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    @Nullable
    public final ChangeAccumulatingSession getCurrentSession() {
        return this.sessionStack.peek();
    }

    @Override
    @NotNull
    public ChangeScope getCurrentChangeScope() {
        Object object = this.getCurrentSession();
        if (object == null || (object = ((ChangeAccumulatingSession)object).getChangeScope()) == null) {
            throw new IllegalStateException("No active accumulating session. You can open it using openAccumulatingSession, or better to use usingAccumulatingSession or recordChanges".toString());
        }
        return object;
    }

    private final void pushSession(ChangeAccumulatingSession accumulatingSession) {
        this.sessionStack.addFirst(accumulatingSession);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Pushed accumulating session " + accumulatingSession + ". Session count is " + this.sessionStack.size());
        }
        this.hasActivePatchFlow.tryEmit((Object)(!((Collection)this.sessionStack).isEmpty() ? 1 : 0));
    }

    private final void popSession(ChangeAccumulatingSession accumulatingSession) {
        ChangeAccumulatingSession removed = this.sessionStack.removeFirst();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Popped accumulating session " + accumulatingSession + ". Session count is " + this.sessionStack.size());
        }
        if (!Intrinsics.areEqual((Object)removed, (Object)accumulatingSession)) {
            this.logger.error("Removed session doesn't match");
        }
        this.hasActivePatchFlow.tryEmit((Object)(!((Collection)this.sessionStack).isEmpty() ? 1 : 0));
    }

    @Override
    public boolean getHasActivePatch() {
        return (Boolean)this.hasActivePatchFlow.getValue();
    }

    @Override
    @Deprecated(message="Avoid of using this method. To preserve event ordering consider migration of your feature to the request-response model.")
    @Nullable
    public Object awaitNoPatches(@NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.first((Flow)((Flow)this.hasActivePatchFlow), (Function2)((Function2)new Function2<Boolean, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ boolean Z$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean it = this.Z$0;
                        return Boxing.boxBoolean((!it ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.Z$0 = (Boolean)value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(boolean p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void sendPatch(RdPatch patch) {
        this.sender.invoke((Object)patch);
    }

    @Override
    @NotNull
    public ChangeAccumulatingSessionToken openAccumulatingSession(boolean sendOnClose, @NotNull String description2, @Nullable ClientSession changeOriginator) {
        ChangeAccumulatingSession session;
        ClientSession originator;
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        ClientSession clientSession = changeOriginator;
        if (clientSession == null) {
            clientSession = originator = (ClientSession)this.clientSession;
        }
        if ((session = this.getCurrentSession()) != null) {
            if (!sendOnClose) {
                this.logger.error("RecordChanges is executed under another accumulation session. This leads to capturing and sending the same patch multiple times.");
            }
            return new ChangeAccumulatingSessionToken(session, description2, true, originator);
        }
        return new ChangeAccumulatingSessionToken(new ChangeAccumulatingSession(originator), description2, sendOnClose, originator);
    }

    @Override
    public void closeCurrentSession(@NotNull String description2) {
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        ChangeAccumulatingSession session = this.getCurrentSession();
        if (session == null) {
            this.logger.error("Attempt to close nonexistent session: " + description2);
            return;
        }
        ChangeAccumulatingSessionToken token = session.peekToken$intellij_rd_platform();
        if (token == null) {
            this.logger.error("No token for accumulating session");
            return;
        }
        token.finish();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\b\u0018\u00010\u0014R\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0018\u00010\u0014R\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001cJ\u0019\u0010\u001d\u001a\u00020\r2\n\u0010\u001b\u001a\u00060\u0014R\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;", "", "originator", "Lcom/intellij/openapi/client/ClientSession;", "(Lcom/jetbrains/rd/ide/requests/RdPatchEngine;Lcom/intellij/openapi/client/ClientSession;)V", "builder", "Lcom/jetbrains/rd/ide/requests/PatchBuilder;", "changeScope", "Lcom/jetbrains/rd/ide/requests/ChangeScope;", "getChangeScope", "()Lcom/jetbrains/rd/ide/requests/ChangeScope;", "completed", "Lkotlinx/coroutines/CompletableDeferred;", "", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "getPatch", "()Lcom/jetbrains/rd/ide/model/RdPatch;", "tokens", "Ljava/util/Stack;", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSessionToken;", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "awaitCompleted", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "peekToken", "peekToken$intellij_rd_platform", "popToken", "token", "popToken$intellij_rd_platform", "pushToken", "pushToken$intellij_rd_platform", "send", "toString", "", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nRdPatchEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdPatchEngine.kt\ncom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n65#2,4:147\n65#2,4:151\n65#2,4:155\n*S KotlinDebug\n*F\n+ 1 RdPatchEngine.kt\ncom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession\n*L\n113#1:147,4\n122#1:151,4\n127#1:155,4\n*E\n"})
    public final class ChangeAccumulatingSession {
        @NotNull
        private final ClientSession originator;
        @NotNull
        private final PatchBuilder builder;
        @NotNull
        private final Stack<ChangeAccumulatingSessionToken> tokens;
        @NotNull
        private final CompletableDeferred<Unit> completed;
        @NotNull
        private final ChangeScope changeScope;

        public ChangeAccumulatingSession(ClientSession originator) {
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            this.originator = originator;
            this.builder = new PatchBuilder();
            this.tokens = new Stack();
            this.completed = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.changeScope = this.builder;
        }

        @NotNull
        public final ChangeScope getChangeScope() {
            return this.changeScope;
        }

        @Nullable
        public final RdPatch getPatch() {
            return this.builder.build();
        }

        private final void send() {
            RdPatch rdPatch = this.getPatch();
            if (rdPatch == null) {
                return;
            }
            RdPatch patchToSend = rdPatch;
            RdPatchEngine.this.sendPatch(patchToSend);
        }

        public final void pushToken$intellij_rd_platform(@NotNull ChangeAccumulatingSessionToken token) {
            Intrinsics.checkNotNullParameter((Object)((Object)token), (String)"token");
            if (this.tokens.isEmpty()) {
                RdPatchEngine.this.pushSession(this);
            }
            this.tokens.push(token);
            Logger $this$trace$iv = RdPatchEngine.this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Pushed token " + token + " into accumulating session of " + this.originator.getName() + ". Tokens count now is " + this.tokens.size());
            }
        }

        public final void popToken$intellij_rd_platform(@Nullable ChangeAccumulatingSessionToken token) {
            Logger logger;
            ChangeAccumulatingSessionToken pop = this.tokens.pop();
            if (token != null && !Intrinsics.areEqual((Object)((Object)pop), (Object)((Object)token))) {
                RdPatchEngine.this.logger.error("Inconsistent token disposal order: on stack token " + pop + ", disposing token " + token + ". Whole session originator is " + this.originator.getName());
            }
            Logger $this$trace$iv = RdPatchEngine.this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Popped token " + pop + " from accumulating session of " + this.originator.getName() + ". Tokens count now is " + this.tokens.size());
            }
            if (this.tokens.isEmpty()) {
                RdPatchEngine.this.popSession(this);
                if (pop.getSendOnClose$intellij_rd_platform()) {
                    $this$trace$iv = RdPatchEngine.this.logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Token of " + pop + " acquired to send patch on close. Sending the patch due to empty stack.");
                    }
                    this.send();
                }
                this.completed.complete((Object)Unit.INSTANCE);
            }
        }

        @Nullable
        public final ChangeAccumulatingSessionToken peekToken$intellij_rd_platform() {
            return this.tokens.isEmpty() ? null : this.tokens.peek();
        }

        @Nullable
        public final Object awaitCompleted(@NotNull Continuation<? super Unit> $completion) {
            Object object = this.completed.await($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @NotNull
        public String toString() {
            return this.originator.getName();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSessionToken;", "Lcom/intellij/openapi/application/AccessToken;", "session", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "description", "", "sendOnClose", "", "originator", "Lcom/intellij/openapi/client/ClientSession;", "(Lcom/jetbrains/rd/ide/requests/RdPatchEngine;Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;Ljava/lang/String;ZLcom/intellij/openapi/client/ClientSession;)V", "getDescription$intellij_rd_platform", "()Ljava/lang/String;", "getSendOnClose$intellij_rd_platform", "()Z", "getSession", "()Lcom/jetbrains/rd/ide/requests/RdPatchEngine$ChangeAccumulatingSession;", "finish", "", "toString", "intellij.rd.platform"})
    public final class ChangeAccumulatingSessionToken
    extends AccessToken {
        @NotNull
        private final ChangeAccumulatingSession session;
        @NotNull
        private final String description;
        private final boolean sendOnClose;
        @NotNull
        private final ClientSession originator;

        public ChangeAccumulatingSessionToken(@NotNull ChangeAccumulatingSession session, String description2, @NotNull boolean sendOnClose, ClientSession originator) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
            this.session = session;
            this.description = description2;
            this.sendOnClose = sendOnClose;
            this.originator = originator;
            this.session.pushToken$intellij_rd_platform(this);
        }

        @NotNull
        public final ChangeAccumulatingSession getSession() {
            return this.session;
        }

        @NotNull
        public final String getDescription$intellij_rd_platform() {
            return this.description;
        }

        public final boolean getSendOnClose$intellij_rd_platform() {
            return this.sendOnClose;
        }

        public void finish() {
            this.session.popToken$intellij_rd_platform(this);
        }

        @NotNull
        public String toString() {
            return "[" + this.originator.getName() + ":" + this.description + "]";
        }
    }
}

