/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.colors;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.IdeaColorKey;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorKeysStorage;", "", "()V", "keysCache", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/jetbrains/rd/ide/model/ColorKeyModel;", "Lcom/intellij/openapi/editor/colors/ColorKey;", "preloadedPlatformKeys", "", "getColorKey", "modelKey", "getModel", "key", "preloadPlatformKeys", "", "printKeysSausage", "", "registerKeysSausage", "model", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nColorKeysStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorKeysStorage.kt\ncom/jetbrains/rd/platform/colors/ColorKeysStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n1#2:79\n13#3:80\n*S KotlinDebug\n*F\n+ 1 ColorKeysStorage.kt\ncom/jetbrains/rd/platform/colors/ColorKeysStorage\n*L\n13#1:80\n*E\n"})
public final class ColorKeysStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BidirectionalMap<ColorKeyModel, ColorKey> keysCache = new BidirectionalMap();
    private boolean preloadedPlatformKeys;
    @NotNull
    private static final Logger logger;

    @NotNull
    public final ColorKey getColorKey(@NotNull ColorKeyModel modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        if (!this.preloadedPlatformKeys) {
            this.preloadPlatformKeys();
            this.preloadedPlatformKeys = true;
        }
        return this.registerKeysSausage(modelKey);
    }

    @NotNull
    public final ColorKeyModel getModel(@NotNull ColorKey key) {
        ColorKeyModel colorKeyModel;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.keysCache.getKeysByValue((Object)key);
        if (object != null && (object = (ColorKeyModel)CollectionsKt.firstOrNull((List)object)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        ColorKey colorKey = key.getFallbackColorKey();
        if (colorKey != null) {
            ColorKey it = colorKey;
            boolean bl = false;
            colorKeyModel = this.getModel(it);
        } else {
            colorKeyModel = null;
        }
        ColorKeyModel fallback = colorKeyModel;
        String string = key.getExternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
        Color color = key.getDefaultColor();
        IdeaColorKey model2 = new IdeaColorKey(fallback, string, color != null ? ColorHostKt.toModel(color) : null);
        ((Map)this.keysCache).put(model2, key);
        return model2;
    }

    private final void preloadPlatformKeys() {
        for (ColorSettingsPage colorSettingsPage : (ColorSettingsPage[])ColorSettingsPage.EP_NAME.getExtensions()) {
            List list2 = ColorSettingsUtil.getAllColorDescriptors((ColorAndFontDescriptorsProvider)((ColorAndFontDescriptorsProvider)colorSettingsPage));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllColorDescriptors(...)");
            CollectionsKt.toList((Iterable)list2);
        }
    }

    private final ColorKey registerKeysSausage(ColorKeyModel model2) {
        ColorKey colorKey;
        ColorKey fallbackKey;
        ColorKeyModel fallbackKeyModel;
        ColorKey colorKey2 = (ColorKey)this.keysCache.get((Object)model2);
        if (colorKey2 != null) {
            ColorKey it = colorKey2;
            boolean bl = false;
            return it;
        }
        IdeaColorKey ideaColorKey = model2 instanceof IdeaColorKey ? (IdeaColorKey)model2 : null;
        ColorKeyModel colorKeyModel = fallbackKeyModel = ideaColorKey != null ? ideaColorKey.getFallback() : null;
        ColorKey colorKey3 = fallbackKey = colorKeyModel != null ? this.registerKeysSausage(colorKeyModel) : null;
        if (fallbackKey == null) {
            AbstractColor abstractColor = model2.getDefaultColor();
            colorKey = ColorKey.createColorKey((String)model2.getExternalName(), (Color)(abstractColor != null ? ColorHostKt.toColor(abstractColor) : null));
        } else {
            ColorKey colorKey4 = ColorKey.createColorKey((String)model2.getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)colorKey4, (String)"createColorKey(...)");
            ColorKey probablyExistingKey = colorKey4;
            if (probablyExistingKey.getFallbackColorKey() != null) {
                colorKey = probablyExistingKey;
            } else {
                ColorKey colorKey5 = ColorKey.createColorKeyWithFallback((String)model2.getExternalName(), (ColorKey)fallbackKey);
                Intrinsics.checkNotNull((Object)colorKey5);
                colorKey = colorKey5;
            }
        }
        ColorKey colorKey6 = colorKey;
        Intrinsics.checkNotNull((Object)colorKey6);
        ColorKey resultColorKey = colorKey6;
        if (!Intrinsics.areEqual((Object)resultColorKey.getFallbackColorKey(), (Object)fallbackKey)) {
            logger.warn("Fallback keys sausage was not registered properly for ColorKey " + resultColorKey + ": keys sausage for actual registered key = " + this.printKeysSausage(resultColorKey) + ", keys sausage for model fallback key = " + this.printKeysSausage(fallbackKey));
        }
        ((Map)this.keysCache).put(model2, resultColorKey);
        return resultColorKey;
    }

    private final String printKeysSausage(ColorKey key) {
        ColorKey colorKey = key;
        return colorKey == null ? "null" : colorKey + "-->" + this.printKeysSausage(key.getFallbackColorKey());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ColorKeysStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ColorKeysStorage.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorKeysStorage$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

