/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.KotlinCodeStylePanel;
import org.jetbrains.kotlin.idea.formatter.KotlinCodeStylePropertyAccessor;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider;
import org.jetbrains.kotlin.idea.formatter.KotlinPackageEntryTableAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "()V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getAccessor", "Lcom/intellij/application/options/codeStyle/properties/CodeStyleFieldAccessor;", "codeStyleObject", "", "field", "Ljava/lang/reflect/Field;", "getAdditionalAccessors", "", "Lcom/intellij/application/options/codeStyle/properties/CodeStylePropertyAccessor;", "getCodeSample", "", "getConfigurableDisplayName", "getDefaultCommonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "getLanguage", "Lcom/intellij/lang/Language;", "usesCommonKeepLineBreaks", "", "kotlin.formatter.minimal"})
public final class KotlinLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"INSTANCE");
        return (Language)kotlinLanguage;
    }

    @NotNull
    public String getConfigurableDisplayName() {
        return KotlinBundle.message("codestyle.name.kotlin", new Object[0]);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        String string = KotlinLanguage.INSTANCE.getDisplayName();
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(settings, modelSettings, string){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCurrentSettings(...)");
                return (CodeStyleAbstractPanel)new KotlinCodeStylePanel(codeStyleSettings, settings);
            }

            @NotNull
            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.kotlin";
            }
        };
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        KotlinCommonCodeStyleSettings kotlinCommonCodeStyleSettings;
        KotlinCommonCodeStyleSettings $this$getDefaultCommonSettings_u24lambda_u240 = kotlinCommonCodeStyleSettings = new KotlinCommonCodeStyleSettings();
        boolean bl = false;
        $this$getDefaultCommonSettings_u24lambda_u240.initIndentOptions();
        return kotlinCommonCodeStyleSettings;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new KotlinCodeStyleSettings(settings);
    }

    @Nullable
    public CodeStyleFieldAccessor<?, ?> getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)codeStyleObject, (String)"codeStyleObject");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (codeStyleObject instanceof KotlinCodeStyleSettings && KotlinPackageEntryTable.class.isAssignableFrom(field.getType())) {
            return (CodeStyleFieldAccessor)new KotlinPackageEntryTableAccessor((KotlinCodeStyleSettings)((Object)codeStyleObject), field);
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @NotNull
    public List<CodeStylePropertyAccessor<?>> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        Intrinsics.checkNotNullParameter((Object)codeStyleObject, (String)"codeStyleObject");
        if (codeStyleObject instanceof KotlinCodeStyleSettings) {
            return CollectionsKt.listOf((Object)((Object)new KotlinCodeStylePropertyAccessor((KotlinCodeStyleSettings)((Object)codeStyleObject))));
        }
        List list = super.getAdditionalAccessors(codeStyleObject);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdditionalAccessors(...)");
        return list;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        CodeStyleSettingsCustomizableOptions codeStyleSettingsCustomizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsCustomizableOptions, (String)"getInstance(...)");
        CodeStyleSettingsCustomizableOptions codeStyleSettingsCustomizableOptions2 = codeStyleSettingsCustomizableOptions;
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES"};
                consumer.showStandardOptions(stringArray);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.1.INSTANCE, KotlinBundle.message("formatter.title.range.operator", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_AROUND_OPERATORS, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.2.INSTANCE, KotlinBundle.message("formatter.title.before.colon.after.declaration.name", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.3.INSTANCE, KotlinBundle.message("formatter.title.after.colon.before.declaration.type", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.4.INSTANCE, KotlinBundle.message("formatter.title.before.colon.in.new.type.definition", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.5.INSTANCE, KotlinBundle.message("formatter.title.after.colon.in.new.type.definition", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.6.INSTANCE, KotlinBundle.message("formatter.title.in.simple.one.line.methods", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.7.INSTANCE, KotlinBundle.message("formatter.title.around.arrow.in.function.types", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.8.INSTANCE, KotlinBundle.message("formatter.title.around.arrow.in", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.9.INSTANCE, KotlinBundle.message("formatter.title.before.lambda.arrow", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_OTHER, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.10.INSTANCE, KotlinBundle.message("formatter.title.when.parentheses", new Object[0]), codeStyleSettingsCustomizableOptions2.SPACES_BEFORE_PARENTHESES, new Object[0]);
                break;
            }
            case 2: {
                Object[] objectArray = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_LINE_BREAKS", "ALIGN_MULTILINE_EXTENDS_LIST", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_METHOD_BRACKETS", "ALIGN_MULTILINE_BINARY_OPERATION", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "CALL_PARAMETERS_WRAP", "METHOD_PARAMETERS_WRAP", "EXTENDS_LIST_WRAP", "METHOD_ANNOTATION_WRAP", "CLASS_ANNOTATION_WRAP", "PARAMETER_ANNOTATION_WRAP", "VARIABLE_ANNOTATION_WRAP", "FIELD_ANNOTATION_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ENUM_CONSTANTS_WRAP", "METHOD_CALL_CHAIN_WRAP", "WRAP_FIRST_METHOD_IN_CALL_CHAIN", "ASSIGNMENT_WRAP"};
                consumer.showStandardOptions((String[])objectArray);
                consumer.renameStandardOption(codeStyleSettingsCustomizableOptions2.WRAPPING_SWITCH_STATEMENT, KotlinBundle.message("formatter.title.when.statements", new Object[0]));
                consumer.renameStandardOption("FIELD_ANNOTATION_WRAP", KotlinBundle.message("formatter.title.property.annotations", new Object[0]));
                consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", KotlinBundle.message("formatter.title.function.declaration.parameters", new Object[0]));
                consumer.renameStandardOption("CALL_PARAMETERS_WRAP", KotlinBundle.message("formatter.title.function.call.arguments", new Object[0]));
                consumer.renameStandardOption("METHOD_CALL_CHAIN_WRAP", KotlinBundle.message("formatter.title.chained.function.calls", new Object[0]));
                consumer.renameStandardOption("METHOD_ANNOTATION_WRAP", KotlinBundle.message("formatter.title.function.annotations", new Object[0]));
                consumer.renameStandardOption(codeStyleSettingsCustomizableOptions2.WRAPPING_METHOD_PARENTHESES, KotlinBundle.message("formatter.title.function.parentheses", new Object[0]));
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.11.INSTANCE, KotlinBundle.message("formatter.title.align.when.branches.in.columns", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_SWITCH_STATEMENT, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.12.INSTANCE, KotlinBundle.message("formatter.title.line.break.after.multiline.when.entry", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_SWITCH_STATEMENT, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.13.INSTANCE, KotlinBundle.message("formatter.title.indent.before.arrow.on.new.line", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_SWITCH_STATEMENT, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.14.INSTANCE, KotlinBundle.message("formatter.title.put.left.brace.on.new.line", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_BRACES, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.15.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_METHOD_PARAMETERS, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.16.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.17.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_CALL_CHAIN, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.18.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_EXTENDS_LIST, new Object[0]);
                objectArray = new Object[]{codeStyleSettingsCustomizableOptions2.WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON};
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption$default(consumer, (KProperty)customizeSettings.19.INSTANCE, KotlinBundle.message("formatter.title.expression.body.functions", new Object[0]), null, objectArray, 8, null);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.20.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), KotlinBundle.message("formatter.title.expression.body.functions", new Object[0]), new Object[0]);
                objectArray = new Object[]{codeStyleSettingsCustomizableOptions2.WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON};
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption$default(consumer, (KProperty)customizeSettings.21.INSTANCE, KotlinBundle.message("formatter.title.elvis.expressions", new Object[0]), null, objectArray, 8, null);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.22.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent", new Object[0]), KotlinBundle.message("formatter.title.elvis.expressions", new Object[0]), new Object[0]);
                KProperty kProperty = (KProperty)customizeSettings.23.INSTANCE;
                String string = ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, kProperty, string, codeStyleSettingsCustomizableOptions2.WRAPPING_IF_STATEMENT, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.24.INSTANCE, KotlinBundle.message("formatter.title.use.continuation.indent.in.conditions", new Object[0]), codeStyleSettingsCustomizableOptions2.WRAPPING_IF_STATEMENT, new Object[0]);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_AFTER_CLASS_HEADER"};
                consumer.showStandardOptions(stringArray);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.25.INSTANCE, KotlinBundle.message("formatter.title.around.when.branches.with", new Object[0]), codeStyleSettingsCustomizableOptions2.BLANK_LINES, new Object[0]);
                KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(consumer, (KProperty)customizeSettings.26.INSTANCE, KotlinBundle.message("formatter.title.before.declaration.with.comment.or.annotation", new Object[0]), codeStyleSettingsCustomizableOptions2.BLANK_LINES, new Object[0]);
                break;
            }
            case 4: {
                consumer.showAllStandardOptions();
                break;
            }
            default: {
                consumer.showStandardOptions(new String[0]);
            }
        }
    }

    public boolean usesCommonKeepLineBreaks() {
        return true;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 2 -> "@Deprecated(\"Foo\") public class ThisIsASampleClass : Comparable<*>, Appendable {\n    val test =\n        12\n\n    @Deprecated(\"Foo\") fun foo1(i1: Int, i2: Int, i3: Int, a: Any) : Int {\n        when (i1) {\n            is Number -> 0\n            else -> 1\n        }\n        when (a) {\n            is Int,\n            is String \n            -> 0\n            else -> 1\n        }\n        if (i2 > 0 &&\n                i3 < 0) {\n            return 2\n        }\n        return 0\n    }\n    private fun foo2():Int {\n// todo: something\n        try {            return foo1(12, 13, 14)\n        }        catch (e: Exception) {            return 0        }        finally {           if (true) {               return 1           }           else {               return 2           }        }    }\n    private val f = {a: Int->a*2}\n\n    fun longMethod(@Named(\"param1\") param1: Int,\n     param2: String) {\n        @Deprecated val foo = 1\n    }\n\n    fun multilineMethod(\n            foo: String,\n            bar: String?,\n            x: Int?\n        ) {\n        foo.toUpperCase().trim()\n            .length\n        val barLen = bar?.length() ?: x ?: -1\n        if (foo.length > 0 &&\n            barLen > 0) {\n            println(\"> 0\")\n        }\n    }\n}\n\n@Deprecated val bar = 1\n\nenum class Enumeration {\n    A, B\n}\n\nfun veryLongExpressionBodyMethod() = \"abc\"";
            case 3 -> " class Foo {\n    private var field1: Int = 1\n    private val field2: String? = null\n\n\n    init {\n        field1 = 2;\n    }\n\n    fun foo1() {\n        run {\n\n\n\n            field1\n        }\n\n        when(field1) {\n            1 -> println(\"1\")\n            2 -> println(\"2\")\n            3 ->\n                 println(\"3\" +\n                      \"4\")\n        }\n\n        when(field2) {\n            1 -> {\n                println(\"1\")\n            }\n\n            2 -> {\n                println(\"2\")\n            }\n        }\n    }\n\n\n    class InnerClass {\n    }\n}\n\n\n\nclass AnotherClass {\n}\n\ninterface TestInterface {\n}\nfun run(f: () -> Unit) {\n    f()\n}\n\nclass Bar {\n    @Annotation\n    val a = 42\n    @Annotation\n    val b = 43\n    fun c() {\n        a + b\n    }\n    fun d() = Unit\n    // smth\n    fun e() {\n        d()\n    }\n    fun f() = d()\n}";
            default -> "open class Some {\n                       private val f: (Int)->Int = { a: Int -> a * 2 }\n                       fun foo(): Int {\n                           val test: Int = 12\n                           for (i in 10..<42) {\n                               println (when {\n                                   i < test -> -1\n                                   i > test -> 1\n                                   else -> 0\n                               })\n                           }\n                           if (true) { }\n                           while (true) { break }\n                           try {\n                               when (test) {\n                                   12 -> println(\"foo\")\n                                   in 10..42 -> println(\"baz\")\n                                   else -> println(\"bar\")\n                               }\n                           } catch (e: Exception) {\n                           } finally {\n                           }\n                           return test\n                       }\n                       private fun <T>foo2(): Int where T : List<T> {\n                           return 0\n                       }\n\n                       fun multilineMethod(\n                           foo: String,\n                           bar: String\n                       ) {\n                           foo\n                               .length\n                       }\n\n                       fun expressionBodyMethod() =\n                               \"abc\"\n                   }\n                   class AnotherClass<T : Any> : Some()";
        };
    }

    private static final void customizeSettings$showCustomOption(CodeStyleSettingsCustomizable $consumer, KProperty<?> field, @NlsContexts.Label @Nls String title, @NlsContexts.Label @Nls String groupName, Object ... options) {
        $consumer.showCustomOption(KotlinCodeStyleSettings.class, field.getName(), title, groupName, Arrays.copyOf(options, options.length));
    }

    static /* synthetic */ void customizeSettings$showCustomOption$default(CodeStyleSettingsCustomizable codeStyleSettingsCustomizable, KProperty kProperty, String string, String string2, Object[] objectArray, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        KotlinLanguageCodeStyleSettingsProvider.customizeSettings$showCustomOption(codeStyleSettingsCustomizable, kProperty, string, string2, objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

