/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.ui.NotebookEditorUiUtilKt;
import org.jetbrains.plugins.notebooks.visualization.InlaysChangedListener;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellSelectionModel;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerFactory;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointersEvent;
import org.jetbrains.plugins.notebooks.visualization.NotebookVisualizationUiUtilKt;
import org.jetbrains.plugins.notebooks.visualization.ui.DecoratedEditorKt;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCell;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellEventListener;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u000f\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0001\\B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0007H\u0002J\u0016\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0001J\b\u0010+\u001a\u00020\"H\u0002J\b\u0010,\u001a\u00020\"H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\"H\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u00102\u001a\u000203H\u0002J\u001e\u00104\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u000f2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020;H\u0002J\u0006\u0010<\u001a\u00020\"J\u000e\u0010=\u001a\u00020\b2\u0006\u0010#\u001a\u00020$J\u000e\u0010>\u001a\u00020\b2\u0006\u0010.\u001a\u000206J\b\u0010?\u001a\u00020\"H\u0002J\b\u0010@\u001a\u00020\"H\u0002J\b\u0010A\u001a\u00020\"H\u0002J\u0006\u0010B\u001a\u00020\"J\u0014\u0010C\u001a\u00020\"2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\"0EJ\u0010\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020HH\u0016J\u001e\u0010I\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0007H\u0002J\b\u0010J\u001a\u00020\"H\u0002J\b\u0010K\u001a\u00020\"H\u0002J\u0014\u0010L\u001a\u00020\"2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020/0NJ\u000e\u0010L\u001a\u00020\"2\u0006\u0010O\u001a\u00020/J\u000e\u0010L\u001a\u00020\"2\u0006\u0010P\u001a\u00020\bJ\b\u0010Q\u001a\u00020\"H\u0002J\u0006\u0010R\u001a\u00020\"J\u0016\u0010S\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\u001a\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u0002082\b\b\u0002\u0010V\u001a\u00020\u001bH\u0002J\u001e\u0010W\u001a\u00020\"2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002060\u000f2\u0006\u00107\u001a\u000208H\u0007J\b\u0010Y\u001a\u00020\"H\u0002J\u0006\u0010Z\u001a\u00020\"J\u001a\u0010[\u001a\b\u0012\u0004\u0012\u0002060\u000f*\u00020\u001f2\u0006\u00107\u001a\u000208H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "_cells", "", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;", "cellEventListeners", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cells", "", "getCells", "()Ljava/util/List;", "changedListener", "Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;", "getChangedListener", "()Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;", "setChangedListener", "(Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "initialized", "", "invalidationListeners", "Ljava/lang/Runnable;", "notebookCellLines", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;", "valid", "addCell", "", "index", "", "editorCell", "events", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellEventListener$EditorCellEvent;", "addCellEventsListener", "editorCellEventListener", "disposable", "addViewportChangeListener", "checkInlayOffsets", "createCell", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "dispose", "editorCells", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "ensureInlaysAndHighlightersExist", "matchingCellsBeforeChange", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "logicalLines", "Lkotlin/ranges/IntRange;", "fixInlaysOffsetsAfterNewCellInsert", "change", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent$OnInserted;", "forceUpdateAll", "getCell", "getCellForInterval", "handleRefreshedDocument", "initialize", "inlaysChanged", "invalidateCells", "onInvalidate", "function", "Lkotlin/Function0;", "onUpdated", "event", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent;", "removeCell", "setupFoldingListener", "setupSelectionUI", "update", "pointers", "", "pointer", "cell", "updateAll", "updateAllOutputs", "updateCellsFolding", "updateConsequentInlays", "interestingRange", "force", "updateControllers", "matchingCells", "updateSelection", "validateCells", "getMatchingCells", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1855#2,2:404\n1549#2:406\n1620#2,3:407\n766#2:410\n857#2,2:411\n1855#2,2:413\n1855#2,2:415\n1549#2:417\n1620#2,3:418\n1549#2:422\n1620#2,3:423\n766#2:426\n857#2,2:427\n1855#2,2:429\n1855#2,2:431\n800#2,11:433\n1855#2,2:444\n766#2:446\n857#2,2:447\n1855#2,2:449\n1855#2,2:451\n1855#2,2:453\n1549#2:455\n1620#2,3:456\n1549#2:459\n1620#2,3:460\n1855#2,2:463\n1855#2,2:465\n1#3:421\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager\n*L\n60#1:404,2\n142#1:406\n142#1:407,3\n186#1:410\n186#1:411,2\n194#1:413,2\n206#1:415,2\n212#1:417\n212#1:418,3\n223#1:422\n223#1:423,3\n255#1:426\n255#1:427,2\n307#1:429,2\n313#1:431,2\n329#1:433,11\n329#1:444,2\n346#1:446\n346#1:447,2\n384#1:449,2\n390#1:451,2\n97#1:453,2\n201#1:455\n201#1:456,3\n239#1:459\n239#1:460,3\n242#1:463,2\n260#1:465,2\n*E\n"})
public final class NotebookCellInlayManager
implements Disposable,
NotebookIntervalPointerFactory.ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final NotebookCellLines notebookCellLines;
    private boolean initialized;
    @NotNull
    private List<EditorCell> _cells;
    @Nullable
    private InlaysChangedListener changedListener;
    @NotNull
    private final EventDispatcher<EditorCellEventListener> cellEventListeners;
    @NotNull
    private final List<Runnable> invalidationListeners;
    private boolean valid;
    @NotNull
    private static final Key<Boolean> FOLDING_MARKER_KEY = new Key("jupyter.folding.paragraph");
    @NotNull
    private static final Key<NotebookCellInlayManager> key;

    private NotebookCellInlayManager(EditorImpl editor) {
        this.editor = editor;
        this.notebookCellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        this._cells = new ArrayList();
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorCellEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.cellEventListeners = eventDispatcher;
        this.invalidationListeners = new ArrayList();
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final List<EditorCell> getCells() {
        return CollectionsKt.toList((Iterable)this._cells);
    }

    @Nullable
    public final InlaysChangedListener getChangedListener() {
        return this.changedListener;
    }

    public final void setChangedListener(@Nullable InlaysChangedListener inlaysChangedListener) {
        this.changedListener = inlaysChangedListener;
    }

    public void dispose() {
    }

    @NotNull
    public final EditorCell getCellForInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this._cells.get(interval.getOrdinal());
    }

    public final void updateAllOutputs() {
        Iterable $this$forEach$iv = this._cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv;
            boolean bl = false;
            EditorCellView editorCellView = it.getView();
            if (editorCellView == null) continue;
            editorCellView.updateOutputs$intellij_notebooks_visualization();
        }
    }

    private final void updateAll() {
        if (this.initialized) {
            this.updateConsequentInlays(new IntRange(0, this.editor.getDocument().getLineCount()), false);
        }
    }

    public final void forceUpdateAll() {
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (NotebookCellInlayManager.access$getInitialized$p(this.this$0)) {
                    NotebookCellInlayManager.access$updateConsequentInlays(this.this$0, new IntRange(0, this.this$0.getEditor().getDocument().getLineCount()), true);
                }
            }
        }), (int)1, null);
    }

    public final void update(@NotNull Collection<? extends NotebookIntervalPointer> pointers) {
        Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(pointers, this){
            final /* synthetic */ Collection<NotebookIntervalPointer> $pointers;
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.$pointers = $pointers;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                List linesList;
                void $this$mapNotNullTo$iv;
                Iterable iterable = this.$pointers;
                Collection destination$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    IntRange it$iv;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv;
                    boolean bl2 = false;
                    NotebookCellLines.Interval interval = it.get();
                    if ((interval != null ? interval.getLines() : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl3 = false;
                    destination$iv.add(it$iv);
                }
                List $this$sortBy$iv = linesList = (List)destination$iv;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            IntRange it = (IntRange)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getFirst());
                            it = (IntRange)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
                        }
                    });
                }
                NotebookVisualizationUiUtilKt.mergeAndJoinIntersections(linesList, CollectionsKt.emptyList());
                for (IntRange lines : linesList) {
                    NotebookCellInlayManager.access$updateConsequentInlays(this.this$0, lines, false);
                }
            }
        }), (int)1, null);
    }

    public final void update(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, cell){
            final /* synthetic */ NotebookCellInlayManager this$0;
            final /* synthetic */ EditorCell $cell;
            {
                this.this$0 = $receiver;
                this.$cell = $cell;
                super(0);
            }

            public final void invoke() {
                this.this$0.update(this.$cell.getIntervalPointer$intellij_notebooks_visualization());
            }
        }), (int)1, null);
    }

    public final void update(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, pointer){
            final /* synthetic */ NotebookCellInlayManager this$0;
            final /* synthetic */ NotebookIntervalPointer $pointer;
            {
                this.this$0 = $receiver;
                this.$pointer = $pointer;
                super(0);
            }

            public final void invoke() {
                this.this$0.update((Collection)new SmartList((Object)this.$pointer));
            }
        }), (int)1, null);
    }

    private final void addViewportChangeListener() {
        this.editor.getScrollPane().getViewport().addChangeListener(arg_0 -> NotebookCellInlayManager.addViewportChangeListener$lambda$2(this, arg_0));
    }

    private final void initialize() {
        this.editor.putUserData(key, (Object)this);
        this.handleRefreshedDocument();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = this.editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> NotebookCellInlayManager.initialize$lambda$3(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> NotebookCellInlayManager.initialize$lambda$4(this, arg_0));
        this.addViewportChangeListener();
        this.editor.getFoldingModel().addListener(new FoldingListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFoldProcessingEnd() {
                this.this$0.invalidateCells();
            }
        }, this.editor.getDisposable());
        this.initialized = true;
        this.setupFoldingListener();
        this.setupSelectionUI();
    }

    private final void setupSelectionUI() {
        this.editor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NotebookCellInlayManager.access$updateSelection(this.this$0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelection() {
        void $this$mapTo$iv$iv;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)this.editor);
        if (notebookCellSelectionModel == null) {
            throw new IllegalStateException("The selection model is supposed to be installed".toString());
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        Iterable $this$map$iv = selectionModel.getSelectedCells();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOrdinal());
        }
        List selectedCells = (List)destination$iv$iv;
        for (EditorCell cell : this.getCells()) {
            NotebookCellLines.Interval interval = cell.getIntervalPointer$intellij_notebooks_visualization().get();
            cell.setSelected(CollectionsKt.contains((Iterable)selectedCells, (Object)(interval != null ? Integer.valueOf(interval.getOrdinal()) : null)));
        }
    }

    private final void setupFoldingListener() {
        FoldingModelImpl foldingModelImpl = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
        FoldingModelImpl foldingModel = foldingModelImpl;
        foldingModel.addListener(new FoldingListener(this){
            @NotNull
            private final LinkedList<FoldRegion> changedRegions;
            @NotNull
            private final LinkedList<FoldRegion> removedRegions;
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                this.changedRegions = new LinkedList<E>();
                this.removedRegions = new LinkedList<E>();
            }

            @NotNull
            public final LinkedList<FoldRegion> getChangedRegions() {
                return this.changedRegions;
            }

            @NotNull
            public final LinkedList<FoldRegion> getRemovedRegions() {
                return this.removedRegions;
            }

            public void beforeFoldRegionDisposed(@NotNull FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
            }

            public void beforeFoldRegionRemoved(@NotNull FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
            }

            public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.changedRegions.add(region);
            }

            /*
             * WARNING - void declaration
             */
            public void onFoldProcessingEnd() {
                EditorCell it;
                boolean $i$f$forEach;
                FoldRegion region;
                Iterable $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.changedRegions;
                boolean $i$f$filter22 = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    FoldRegion it2 = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getUserData(NotebookCellInlayManager.Companion.getFOLDING_MARKER_KEY()), (Object)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changedRegions = (List)destination$iv$iv;
                this.changedRegions.clear();
                List removedRegions = CollectionsKt.toList((Iterable)this.removedRegions);
                this.removedRegions.clear();
                Iterable $i$f$filter22 = changedRegions;
                object = this.this$0;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = NotebookCellInlayManager.access$editorCells((NotebookCellInlayManager)object, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        it = (EditorCell)element$iv2;
                        boolean bl2 = false;
                        it.setVisible(region.isExpanded());
                    }
                }
                $this$forEach$iv = removedRegions;
                object = this.this$0;
                $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv3 = NotebookCellInlayManager.access$editorCells((NotebookCellInlayManager)object, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv3) {
                        it = (EditorCell)element$iv2;
                        boolean bl3 = false;
                        it.setVisible(true);
                    }
                }
            }
        }, this.editor.getDisposable());
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorCell> editorCells(FoldRegion region) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this._cells;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell cell = (EditorCell)element$iv$iv;
            boolean bl = false;
            DocumentEx documentEx = this.editor.getDocument();
            NotebookCellLines.Interval interval = cell.getIntervalPointer$intellij_notebooks_visualization().get();
            Intrinsics.checkNotNull((Object)interval);
            int startOffset = documentEx.getLineStartOffset(interval.getLines().getFirst());
            DocumentEx documentEx2 = this.editor.getDocument();
            NotebookCellLines.Interval interval2 = cell.getIntervalPointer$intellij_notebooks_visualization().get();
            Intrinsics.checkNotNull((Object)interval2);
            int endOffset = documentEx2.getLineEndOffset(interval2.getLines().getLast());
            if (!(startOffset >= region.getStartOffset() && endOffset <= region.getEndOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRefreshedDocument() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        ThreadingAssertions.softAssertReadAccess();
        Iterable $this$forEach$iv = this._cells;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        NotebookIntervalPointerFactory pointerFactory = NotebookIntervalPointerFactory.Companion.get((Editor)this.editor);
        this.editor.getInlayModel().execute(true, () -> NotebookCellInlayManager.handleRefreshedDocument$lambda$9(this, pointerFactory));
        Iterable $this$forEach$iv2 = this._cells;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            EditorCell it = (EditorCell)element$iv3;
            boolean bl = false;
            EditorCellView editorCellView = it.getView();
            if (editorCellView == null) continue;
            editorCellView.postInitInlays();
        }
        this.updateCellsFolding(this._cells);
        $this$forEach$iv2 = this._cells;
        EditorCellEventListener editorCellEventListener = (EditorCellEventListener)this.cellEventListeners.getMulticaster();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EditorCell editorCell = (EditorCell)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EditorCellEventListener.CellCreated((EditorCell)it));
        }
        editorCellEventListener.onEditorCellEvents((List)destination$iv$iv);
        this.inlaysChanged();
    }

    private final EditorCell createCell(NotebookIntervalPointer interval) {
        EditorCell editorCell;
        EditorCell it = editorCell = new EditorCell((EditorEx)this.editor, interval, (Function1<? super EditorCell, EditorCellView>)((Function1)new Function1<EditorCell, EditorCellView>(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final EditorCellView invoke(@NotNull EditorCell cell) {
                EditorCellView editorCellView;
                Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
                EditorCellView it = editorCellView = new EditorCellView(this.this$0.getEditor(), NotebookCellInlayManager.access$getNotebookCellLines$p(this.this$0), cell, this.this$0);
                boolean bl = false;
                Disposer.register((Disposable)cell, (Disposable)it);
                return editorCellView;
            }
        }));
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)it);
        return editorCell;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureInlaysAndHighlightersExist(List<NotebookCellLines.Interval> matchingCellsBeforeChange, IntRange logicalLines) {
        IntRange intRange;
        Iterable iterable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable2 = matchingCellsBeforeChange;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLines());
        }
        Iterable it = iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable3 = iterable = !((Collection)it).isEmpty() ? iterable2 : null;
        if (iterable != null) {
            Iterable it2 = iterable;
            boolean bl2 = false;
            intRange = new IntRange(Math.min(logicalLines.getFirst(), ((IntRange)CollectionsKt.first((List)it2)).getFirst()), Math.max(((IntRange)CollectionsKt.last((List)it2)).getLast(), logicalLines.getLast()));
        } else {
            intRange = logicalLines;
        }
        IntRange interestingRange = intRange;
        NotebookCellInlayManager.updateConsequentInlays$default(this, interestingRange, false, 2, null);
    }

    private final void inlaysChanged() {
        block0: {
            InlaysChangedListener inlaysChangedListener = this.changedListener;
            if (inlaysChangedListener == null) break block0;
            inlaysChangedListener.inlaysChanged();
        }
    }

    private final void updateConsequentInlays(IntRange interestingRange, boolean force) {
        ThreadingAssertions.softAssertReadAccess();
        DecoratedEditorKt.keepScrollingPositionWhile((Editor)this.editor, () -> NotebookCellInlayManager.updateConsequentInlays$lambda$18(this, interestingRange, force));
    }

    static /* synthetic */ void updateConsequentInlays$default(NotebookCellInlayManager notebookCellInlayManager, IntRange intRange, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        notebookCellInlayManager.updateConsequentInlays(intRange, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCellsFolding(List<EditorCell> editorCells) {
        void $this$filterTo$iv$iv;
        FoldingModelImpl foldingModelImpl = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
        FoldingModelImpl foldingModel = foldingModelImpl;
        Iterable $this$filter$iv = editorCells;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell it = (EditorCell)element$iv$iv;
            boolean bl = false;
            EditorCellView editorCellView = it.getView();
            boolean bl2 = editorCellView != null ? editorCellView.getShouldUpdateFolding() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cellsForFoldingUpdate = (List)destination$iv$iv;
        if (cellsForFoldingUpdate.isEmpty()) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> NotebookCellInlayManager.updateCellsFolding$lambda$21(cellsForFoldingUpdate), true, false);
    }

    private final List<NotebookCellLines.Interval> getMatchingCells(NotebookCellLines $this$getMatchingCells, IntRange logicalLines) {
        List list;
        List result = list = (List)new ArrayList();
        boolean bl = false;
        ListIterator<NotebookCellLines.Interval> iterator = $this$getMatchingCells.intervalsIterator(logicalLines.getFirst());
        if (iterator.hasPrevious()) {
            iterator.previous();
        }
        ListIterator<NotebookCellLines.Interval> listIterator = iterator;
        while (listIterator.hasNext()) {
            NotebookCellLines.Interval interval = listIterator.next();
            result.add(interval);
            if (interval.getLines().getFirst() <= logicalLines.getLast()) continue;
            break;
        }
        return list;
    }

    @TestOnly
    public final void updateControllers(@NotNull List<NotebookCellLines.Interval> matchingCells, @NotNull IntRange logicalLines) {
        Intrinsics.checkNotNullParameter(matchingCells, (String)"matchingCells");
        Intrinsics.checkNotNullParameter((Object)logicalLines, (String)"logicalLines");
        this.ensureInlaysAndHighlightersExist(matchingCells, logicalLines);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List events = new ArrayList();
        for (NotebookIntervalPointersEvent.Change change : event.getChanges()) {
            NotebookIntervalPointersEvent.PointerSnapshot it;
            Iterable $this$forEach$iv;
            object = change;
            if (object instanceof NotebookIntervalPointersEvent.OnEdited) {
                EditorCell cell = this._cells.get(((NotebookIntervalPointersEvent.OnEdited)change).getIntervalAfter().getOrdinal());
                cell.updateInput();
                events.add(new EditorCellEventListener.CellUpdated(cell));
                continue;
            }
            if (object instanceof NotebookIntervalPointersEvent.OnInserted) {
                $this$forEach$iv = ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv;
                    boolean bl = false;
                    EditorCell editorCell = this.createCell(it.getPointer());
                    this.addCell(it.getInterval().getOrdinal(), editorCell, events);
                }
                continue;
            }
            if (object instanceof NotebookIntervalPointersEvent.OnRemoved) {
                $this$forEach$iv = CollectionsKt.reversed((Iterable)((NotebookIntervalPointersEvent.OnRemoved)change).getSubsequentPointers());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv;
                    boolean bl = false;
                    int index = it.getInterval().getOrdinal();
                    this.removeCell(index, events);
                }
                continue;
            }
            if (!(object instanceof NotebookIntervalPointersEvent.OnSwapped)) continue;
            EditorCell firstCell = this._cells.get(((NotebookIntervalPointersEvent.OnSwapped)change).getFirstOrdinal());
            NotebookIntervalPointer first = firstCell.getIntervalPointer$intellij_notebooks_visualization();
            EditorCell secondCell = this._cells.get(((NotebookIntervalPointersEvent.OnSwapped)change).getSecondOrdinal());
            firstCell.setIntervalPointer$intellij_notebooks_visualization(secondCell.getIntervalPointer$intellij_notebooks_visualization());
            secondCell.setIntervalPointer$intellij_notebooks_visualization(first);
            firstCell.update(false);
            secondCell.update(false);
        }
        Iterable $this$filterIsInstance$iv = event.getChanges();
        boolean $i$f$filterIsInstance = false;
        object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NotebookIntervalPointersEvent.OnInserted)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookIntervalPointersEvent.OnInserted change = (NotebookIntervalPointersEvent.OnInserted)element$iv;
            boolean bl = false;
            this.fixInlaysOffsetsAfterNewCellInsert(change);
        }
        ((EditorCellEventListener)this.cellEventListeners.getMulticaster()).onEditorCellEvents(events);
        this.inlaysChanged();
        this.checkInlayOffsets();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInlayOffsets() {
        void $this$filterTo$iv$iv;
        Set set;
        Set $this$checkInlayOffsets_u24lambda_u2426 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (EditorCell cell : this._cells) {
            $this$checkInlayOffsets_u24lambda_u2426.add(this.editor.getDocument().getLineStartOffset(cell.getInterval().getLines().getFirst()));
            $this$checkInlayOffsets_u24lambda_u2426.add(this.editor.getDocument().getLineEndOffset(cell.getInterval().getLines().getLast()));
        }
        Set inlaysOffsets = SetsKt.build((Set)set);
        List list = this.editor.getInlayModel().getBlockElementsInRange(0, this.editor.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Inlay it = (Inlay)element$iv$iv;
            boolean bl2 = false;
            if (!(!inlaysOffsets.contains(it.getOffset()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List wronglyPlacedInlays = (List)destination$iv$iv;
        if (!((Collection)wronglyPlacedInlays).isEmpty()) {
            throw new IllegalStateException(("Expected offsets: " + inlaysOffsets + ". Wrongly placed inlays: " + wronglyPlacedInlays).toString());
        }
    }

    private final void fixInlaysOffsetsAfterNewCellInsert(NotebookIntervalPointersEvent.OnInserted change) {
        int prevCellIndex = ((NotebookIntervalPointersEvent.PointerSnapshot)CollectionsKt.first(change.getSubsequentPointers())).getInterval().getOrdinal() - 1;
        if (prevCellIndex >= 0) {
            EditorCell prevCell = this.getCell(prevCellIndex);
            EditorCell.update$default(prevCell, false, 1, null);
        }
    }

    private final void addCell(int index, EditorCell editorCell, List<EditorCellEventListener.EditorCellEvent> events) {
        this._cells.add(index, editorCell);
        events.add(new EditorCellEventListener.CellCreated(editorCell));
        this.invalidateCells();
    }

    private final void removeCell(int index, List<EditorCellEventListener.EditorCellEvent> events) {
        EditorCell removed = this._cells.remove(index);
        Disposer.dispose((Disposable)removed);
        events.add(new EditorCellEventListener.CellRemoved(removed));
        this.invalidateCells();
    }

    public final void addCellEventsListener(@NotNull EditorCellEventListener editorCellEventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorCellEventListener, (String)"editorCellEventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.cellEventListeners.addListener((EventListener)editorCellEventListener, disposable);
    }

    @NotNull
    public final EditorCell getCell(int index) {
        return this.getCells().get(index);
    }

    public final void invalidateCells() {
        if (this.valid) {
            this.valid = false;
            Iterable $this$forEach$iv = this.invalidationListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                it.run();
            }
        }
    }

    public final void validateCells() {
        if (!this.valid) {
            Iterable $this$forEach$iv = this._cells;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellView editorCellView;
                EditorCell it = (EditorCell)element$iv;
                boolean bl = false;
                if (it.getView() == null) continue;
                EditorCellView view = editorCellView;
                boolean bl2 = false;
                view.setBounds(view.calculateBounds());
                view.validate();
            }
            this.valid = true;
        }
    }

    public final void onInvalidate(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.invalidationListeners.add(() -> NotebookCellInlayManager.onInvalidate$lambda$31(function));
    }

    private static final void addViewportChangeListener$lambda$2(NotebookCellInlayManager this$0, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0._cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it2 = (EditorCell)element$iv;
            boolean bl = false;
            it2.onViewportChange();
        }
    }

    private static final void initialize$lambda$3(NotebookCellInlayManager this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateAll();
    }

    private static final void initialize$lambda$4(NotebookCellInlayManager this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateAll();
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleRefreshedDocument$lambda$9(NotebookCellInlayManager this$0, NotebookIntervalPointerFactory $pointerFactory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pointerFactory, (String)"$pointerFactory");
        Iterable iterable = this$0.notebookCellLines.getIntervals();
        NotebookCellInlayManager notebookCellInlayManager = this$0;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void interval;
            NotebookCellLines.Interval interval2 = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.createCell($pointerFactory.create((NotebookCellLines.Interval)interval)));
        }
        notebookCellInlayManager._cells = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateConsequentInlays$lambda$18(NotebookCellInlayManager this$0, IntRange $interestingRange, boolean $force) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$interestingRange, (String)"$interestingRange");
        List<NotebookCellLines.Interval> matchingIntervals = this$0.getMatchingCells(this$0.notebookCellLines, $interestingRange);
        Iterable $this$map$iv = matchingIntervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0._cells.get(it.getOrdinal()));
        }
        List matchingCells = (List)destination$iv$iv;
        Iterable $this$forEach$iv = matchingCells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv;
            boolean bl = false;
            it.update($force);
        }
        this$0.updateCellsFolding(matchingCells);
        this$0.inlaysChanged();
    }

    private static final void updateCellsFolding$lambda$21(List $cellsForFoldingUpdate) {
        Intrinsics.checkNotNullParameter((Object)$cellsForFoldingUpdate, (String)"$cellsForFoldingUpdate");
        Iterable $this$forEach$iv = $cellsForFoldingUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell cell = (EditorCell)element$iv;
            boolean bl = false;
            EditorCellView editorCellView = cell.getView();
            if (editorCellView == null) continue;
            editorCellView.updateCellFolding();
        }
    }

    private static final void onInvalidate$lambda$31(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    @JvmStatic
    public static final void install(@NotNull EditorImpl editor) {
        Companion.install(editor);
    }

    @JvmStatic
    @Nullable
    public static final NotebookCellInlayManager get(@NotNull Editor editor) {
        return Companion.get(editor);
    }

    public static final /* synthetic */ boolean access$getInitialized$p(NotebookCellInlayManager $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ void access$updateConsequentInlays(NotebookCellInlayManager $this, IntRange interestingRange, boolean force) {
        $this.updateConsequentInlays(interestingRange, force);
    }

    public static final /* synthetic */ void access$updateSelection(NotebookCellInlayManager $this) {
        $this.updateSelection();
    }

    public static final /* synthetic */ List access$editorCells(NotebookCellInlayManager $this, FoldRegion region) {
        return $this.editorCells(region);
    }

    public static final /* synthetic */ NotebookCellLines access$getNotebookCellLines$p(NotebookCellInlayManager $this) {
        return $this.notebookCellLines;
    }

    public /* synthetic */ NotebookCellInlayManager(EditorImpl editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Key key = Key.create((String)NotebookCellInlayManager.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NotebookCellInlayManager.key = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0004\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager$Companion;", "", "()V", "FOLDING_MARKER_KEY", "Lcom/intellij/openapi/util/Key;", "", "getFOLDING_MARKER_KEY", "()Lcom/intellij/openapi/util/Key;", "key", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "get", "editor", "Lcom/intellij/openapi/editor/Editor;", "install", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1#2:404\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void install(@NotNull EditorImpl editor) {
            NotebookCellInlayManager notebookCellInlayManager;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookCellInlayManager it = notebookCellInlayManager = new NotebookCellInlayManager(editor, null);
            boolean bl = false;
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)it);
            NotebookCellInlayManager notebookCellInlayManager2 = notebookCellInlayManager;
            editor.putUserData(NotebookEditorUiUtilKt.isFoldingEnabledKey(), (Object)Registry.is((String)"jupyter.editor.folding.cells"));
            NotebookIntervalPointerFactory.Companion.get((Editor)editor).getChangeListeners().addListener((EventListener)notebookCellInlayManager2, editor.getDisposable());
            notebookCellInlayManager2.initialize();
        }

        @JvmStatic
        @Nullable
        public final NotebookCellInlayManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookCellInlayManager)key.get((UserDataHolder)editor);
        }

        @NotNull
        public final Key<Boolean> getFOLDING_MARKER_KEY() {
            return FOLDING_MARKER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

