/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ClearOutputAction;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutputUtil;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.SaveOutputAction;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ToolbarPane;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.progress.InlayProgressStatus;
import org.jetbrains.plugins.notebooks.visualization.r.ui.ToolbarUtil;
import org.jetbrains.plugins.notebooks.visualization.r.ui.UiCustomizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u000202H&J\u0018\u00103\u001a\u00020\b2\u0006\u00104\u001a\u0002022\u0006\u00101\u001a\u000202H&J\b\u00105\u001a\u00020\bH\u0016J\b\u00106\u001a\u00020\bH&J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u00108\u001a\u00020\fH\u0002J\b\u00109\u001a\u00020\fH\u0002J\b\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u000202H&J\u0006\u0010=\u001a\u00020)J\b\u0010>\u001a\u00020\u001bH\u0002J\u0010\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u0017H\u0016J\b\u0010A\u001a\u00020\bH&JK\u0010B\u001a\u00020\b2\b\b\u0001\u0010C\u001a\u0002022\b\b\u0001\u0010D\u001a\u0002022\f\u0010E\u001a\b\u0012\u0004\u0012\u0002020F2\u0006\u0010G\u001a\u0002022\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\b0\u001aH\u0004\u00a2\u0006\u0002\u0010JJ\b\u0010K\u001a\u00020\bH&J\u0016\u0010L\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010M\u001a\u00020NR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R^\u0010\u001f\u001a\u001f\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\b\u0018\u00010\u001a2#\u0010\u0019\u001a\u001f\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\b\u0018\u00010\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u0017X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0018\u00a8\u0006O"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput;", "", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getActions", "()Ljava/util/List;", "actions$delegate", "Lkotlin/Lazy;", "disposable", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "extraActions", "getExtraActions", "isFullWidth", "", "()Z", "value", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "height", "onHeightCalculated", "getOnHeightCalculated", "()Lkotlin/jvm/functions/Function1;", "setOnHeightCalculated", "(Lkotlin/jvm/functions/Function1;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "toolbarPane", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/ToolbarPane;", "getToolbarPane$annotations", "()V", "getToolbarPane", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/ToolbarPane;", "useDefaultSaveAction", "getUseDefaultSaveAction", "acceptType", "type", "", "addData", "data", "addToolbar", "clear", "createActions", "createClearAction", "createSaveAsAction", "createToolbar", "Ljavax/swing/JComponent;", "getCollapsedDescription", "getComponent", "getProgressStatusHeight", "onViewportChange", "isInViewport", "saveAs", "saveWithFileChooser", "title", "description", "extension", "", "defaultName", "onChoose", "Ljava/io/File;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "scrollToTop", "updateProgressStatus", "progressStatus", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/progress/InlayProgressStatus;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayOutput.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput\n+ 2 ToolbarUtil.kt\norg/jetbrains/plugins/notebooks/visualization/r/ui/ToolbarUtil\n*L\n1#1,475:1\n61#2:476\n61#2:477\n*S KotlinDebug\n*F\n+ 1 InlayOutput.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput\n*L\n147#1:476\n151#1:477\n*E\n"})
public abstract class InlayOutput {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<Unit> clearAction;
    @NotNull
    private final ToolbarPane toolbarPane;
    @NotNull
    private final Project project;
    private final boolean useDefaultSaveAction;
    @NotNull
    private final List<AnAction> extraActions;
    private final boolean isFullWidth;
    @NotNull
    private final Lazy actions$delegate;
    @Nullable
    private Function1<? super Integer, Unit> onHeightCalculated;
    @NotNull
    private final Disposable disposable;

    public InlayOutput(@NotNull Disposable parent, @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        this.editor = editor;
        this.clearAction = clearAction2;
        this.toolbarPane = new ToolbarPane(this);
        Project project = this.editor.getProject();
        if (project == null) {
            throw new IllegalStateException("Editor should have a project".toString());
        }
        this.project = project;
        this.useDefaultSaveAction = true;
        this.extraActions = CollectionsKt.emptyList();
        this.isFullWidth = true;
        this.actions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends AnAction>>(this){
            final /* synthetic */ InlayOutput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<AnAction> invoke() {
                return InlayOutput.access$createActions(this.this$0);
            }
        }));
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        Disposer.register((Disposable)parent, (Disposable)this.disposable);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    protected final ToolbarPane getToolbarPane() {
        return this.toolbarPane;
    }

    protected static /* synthetic */ void getToolbarPane$annotations() {
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    protected boolean getUseDefaultSaveAction() {
        return this.useDefaultSaveAction;
    }

    @NotNull
    protected List<AnAction> getExtraActions() {
        return this.extraActions;
    }

    public boolean isFullWidth() {
        return this.isFullWidth;
    }

    @NotNull
    public final List<AnAction> getActions() {
        Lazy lazy = this.actions$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final ToolbarPane getComponent() {
        return this.toolbarPane;
    }

    public abstract void clear();

    public abstract void addData(@NotNull String var1, @NotNull String var2);

    public abstract void scrollToTop();

    @NotNull
    public abstract String getCollapsedDescription();

    public abstract void saveAs();

    public abstract boolean acceptType(@NotNull String var1);

    public final void updateProgressStatus(@NotNull Editor editor, @NotNull InlayProgressStatus progressStatus) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)progressStatus, (String)"progressStatus");
        this.toolbarPane.setProgressComponent(UiCustomizer.Companion.getInstance().buildInlayProgressStatusComponent(progressStatus, editor));
    }

    private final int getProgressStatusHeight() {
        JComponent jComponent = this.toolbarPane.getProgressComponent();
        return jComponent != null ? jComponent.getHeight() : 0;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnHeightCalculated() {
        return this.onHeightCalculated;
    }

    public final void setOnHeightCalculated(@Nullable Function1<? super Integer, Unit> value) {
        this.onHeightCalculated = (Function1)new Function1<Integer, Unit>(value, this){
            final /* synthetic */ Function1<Integer, Unit> $value;
            final /* synthetic */ InlayOutput this$0;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int height) {
                block0: {
                    Function1<Integer, Unit> function1 = this.$value;
                    if (function1 == null) break block0;
                    function1.invoke((Object)(height + InlayOutput.access$getProgressStatusHeight(this.this$0)));
                }
            }
        };
    }

    public void onViewportChange(boolean isInViewport) {
    }

    public void addToolbar() {
        this.toolbarPane.setToolbarComponent(this.createToolbar());
    }

    private final JComponent createToolbar() {
        ActionToolbar toolbar = ToolbarUtil.INSTANCE.createEllipsisToolbar("NotebooksInlayOutput", CollectionsKt.plus((Collection)this.getActions(), (Object)this.createClearAction()));
        toolbar.setTargetComponent((JComponent)this.toolbarPane);
        toolbar.getComponent().setOpaque(true);
        toolbar.getComponent().setBackground(UiCustomizer.Companion.getInstance().getTextOutputBackground(this.editor));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    protected final void saveWithFileChooser(@Nls @NotNull String title, @Nls @NotNull String description, @NotNull String[] extension, @NotNull String defaultName, @NotNull Function1<? super File, Unit> onChoose) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        Intrinsics.checkNotNullParameter(onChoose, (String)"onChoose");
        InlayOutputUtil.INSTANCE.saveWithFileChooser(this.project, title, description, extension, defaultName, true, onChoose);
    }

    private final List<AnAction> createActions() {
        List list;
        List $this$createActions_u24lambda_u240 = list = CollectionsKt.toMutableList((Collection)this.getExtraActions());
        boolean bl = false;
        if (this.getUseDefaultSaveAction()) {
            $this$createActions_u24lambda_u240.add(this.createSaveAsAction());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final AnAction createClearAction() {
        void this_$iv;
        ToolbarUtil toolbarUtil = ToolbarUtil.INSTANCE;
        Function0 onClick$iv = (Function0)new Function0<Unit>(this.clearAction){

            public final void invoke() {
                ((Function0)this.receiver).invoke();
            }
        };
        boolean $i$f$createAnActionButton = false;
        String string = Reflection.getOrCreateKotlinClass(ClearOutputAction.class).getQualifiedName();
        if (string == null) {
            string = this_$iv.getEMPTY_STRING();
        }
        return this_$iv.createAnActionButton(string, (Function0<Unit>)onClick$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final AnAction createSaveAsAction() {
        void this_$iv;
        ToolbarUtil toolbarUtil = ToolbarUtil.INSTANCE;
        Function0 onClick$iv = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((InlayOutput)this.receiver).saveAs();
            }
        };
        boolean $i$f$createAnActionButton = false;
        String string = Reflection.getOrCreateKotlinClass(SaveOutputAction.class).getQualifiedName();
        if (string == null) {
            string = this_$iv.getEMPTY_STRING();
        }
        return this_$iv.createAnActionButton(string, (Function0<Unit>)onClick$iv);
    }

    public static final /* synthetic */ int access$getProgressStatusHeight(InlayOutput $this) {
        return $this.getProgressStatusHeight();
    }

    public static final /* synthetic */ List access$createActions(InlayOutput $this) {
        return $this.createActions();
    }
}

