/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/MySeparator;", "Ljavax/swing/JComponent;", "myText", "", "(Ljava/lang/String;)V", "myOrientation", "", "getMaxButtonHeight", "getMaxButtonWidth", "getPreferredSize", "Ljava/awt/Dimension;", "getTextWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "text", "graphics", "Ljava/awt/Graphics;", "paintComponent", "", "g", "intellij.notebooks.visualization"})
public final class MySeparator
extends JComponent {
    @Nullable
    private final String myText;
    private int myOrientation;

    public MySeparator(@Nullable String myText) {
        this.myText = myText;
        this.setFont((Font)JBUI.Fonts.toolbarSmallComboBoxFont());
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension;
        int gap = JBUI.scale((int)2);
        int center = JBUI.scale((int)3);
        int width = gap * 2 + center;
        int height = JBUI.scale((int)24);
        if (this.myOrientation != 0) {
            return (Dimension)new JBDimension(height, width, true);
        }
        if (this.myText != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Intrinsics.checkNotNull((Object)fontMetrics);
            int textWidth = this.getTextWidth(fontMetrics, this.myText, this.getGraphics());
            dimension = (Dimension)new JBDimension(width + gap * 2 + textWidth, Math.max(fontMetrics.getHeight(), height), true);
        } else {
            dimension = (Dimension)new JBDimension(width, height, true);
        }
        return dimension;
    }

    private final int getMaxButtonHeight() {
        return ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE.height;
    }

    private final int getMaxButtonWidth() {
        return ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE.width;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.getParent() == null) {
            return;
        }
        int gap = JBUI.scale((int)2);
        int center = JBUI.scale((int)3);
        int offset = this.myOrientation == 0 ? this.getParent().getHeight() - this.getMaxButtonHeight() - 1 : this.getParent().getWidth() - this.getMaxButtonWidth() - 1;
        g.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        if (this.myOrientation == 0) {
            int y2 = this.getParent().getHeight() - gap * 2 - offset;
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)center, (double)gap, (double)center, (double)y2);
            if (this.myText != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int top = (this.getHeight() - fontMetrics.getHeight()) / 2;
                UISettings.Companion.setupAntialiasing(g);
                g.setColor(JBColor.foreground());
                g.drawString(this.myText, gap * 2 + center + gap, top + fontMetrics.getAscent());
            }
        } else {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)gap, (double)center, (double)(this.getParent().getWidth() - gap * 2 - offset), (double)center);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getTextWidth(FontMetrics fontMetrics, String text, Graphics graphics) {
        if (graphics == null) {
            return fontMetrics.stringWidth(text);
        }
        Graphics g = graphics.create();
        try {
            Intrinsics.checkNotNull((Object)g);
            UISettings.Companion.setupAntialiasing(g);
            int n = fontMetrics.getStringBounds((String)text, (Graphics)g).getBounds().width;
            return n;
        }
        finally {
            g.dispose();
        }
    }
}

