/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IFilter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AutoChoices;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.ChoicesHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.CustomChoice;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.FiltersHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.FilterEditor;

class NonAdaptiveChoicesHandler
extends ChoicesHandler {
    private boolean interrupted = true;

    NonAdaptiveChoicesHandler(FiltersHandler handler) {
        super(handler);
    }

    @Override
    public RowFilter getRowFilter() {
        return this.handler;
    }

    @Override
    public boolean setInterrupted(boolean interrupted) {
        if (this.interrupted != interrupted) {
            this.interrupted = interrupted;
            this.setEnableTableModelEvents(!interrupted);
            if (!interrupted) {
                for (FilterEditor editor : this.handler.getEditors()) {
                    this.editorUpdated(editor);
                }
            }
        }
        return !interrupted;
    }

    @Override
    public void editorUpdated(FilterEditor editor) {
        if (editor.isEnabled()) {
            this.initEditorChoices(editor);
        }
    }

    @Override
    public boolean filterUpdated(IFilter iFilter, boolean retInfoRequired) {
        return true;
    }

    @Override
    public void filterOperation(boolean start) {
        this.handler.enableNotifications(!start);
    }

    @Override
    public void filterEnabled(IFilter filter) {
        for (FilterEditor editor : this.handler.getEditors()) {
            if (editor.getFilter() != filter) continue;
            this.initEditorChoices(editor);
            break;
        }
        if (!this.interrupted) {
            this.setEnableTableModelEvents(true);
        }
    }

    @Override
    public void allFiltersDisabled() {
        this.setEnableTableModelEvents(false);
    }

    @Override
    public void consolidateFilterChanges(int modelIndex) {
    }

    @Override
    public void tableUpdated(TableModel model, int eventType, int firstRow, int lastRow, int column) {
        if (column != -1) {
            FilterEditor editor = this.handler.getEditor(column);
            if (editor.isEnabled()) {
                NonAdaptiveChoicesHandler.setChoicesFromModel(editor);
            }
        } else {
            for (FilterEditor editor : this.handler.getEditors()) {
                if (!editor.isEnabled() || AutoChoices.ENABLED != editor.getAutoChoices()) continue;
                if (eventType == 1) {
                    editor.addChoices(new HashSet());
                    continue;
                }
                NonAdaptiveChoicesHandler.setChoicesFromModel(editor);
            }
        }
    }

    private void initEditorChoices(FilterEditor editor) {
        AutoChoices autoChoices = editor.getAutoChoices();
        if (autoChoices == AutoChoices.DISABLED) {
            editor.setChoices(editor.getCustomChoices());
        } else {
            boolean asEnum;
            TableModel model = this.handler.getTable().getModel();
            Class<?> c = model.getColumnClass(editor.getModelIndex());
            boolean bl = asEnum = c.equals(Boolean.class) || c.isEnum();
            if (asEnum && autoChoices != AutoChoices.ENUMS) {
                editor.setAutoChoices(AutoChoices.ENUMS);
            } else if (!asEnum && autoChoices == AutoChoices.ENUMS) {
                editor.setAutoChoices(AutoChoices.DISABLED);
            } else if (asEnum) {
                Set<CustomChoice> choices = editor.getCustomChoices();
                if (c.equals(Boolean.class)) {
                    choices.add((CustomChoice)((Object)Boolean.valueOf(true)));
                    choices.add((CustomChoice)((Object)Boolean.valueOf(false)));
                } else {
                    Collections.addAll(choices, c.getEnumConstants());
                }
                editor.setChoices(choices);
            } else {
                NonAdaptiveChoicesHandler.setChoicesFromModel(editor);
            }
        }
    }

    private static void setChoicesFromModel(FilterEditor editor) {
        editor.setChoices(editor.getCustomChoices());
    }
}

