/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui;

import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.table.AdditionalTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IFilter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IFilterObserver;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AbstractFiltersHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AutoChoices;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.FilterSettings;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.FiltersHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterEditor;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterHeaderObserver;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IParserModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.FilterEditor;

public class TableFilterHeader
extends AdditionalTableHeader {
    private static final boolean instantFilteringEnabled = FilterSettings.instantFiltering;
    private static final boolean autoCompletionEnabled = FilterSettings.autoCompletion;
    private static final int maxHistory = FilterSettings.maxPopupHistory;
    private static final int filterRowHeightDelta = FilterSettings.filterRowHeightDelta;
    private final AbstractFiltersHandler filtersHandler;
    private final Set<IFilterHeaderObserver> observers = new HashSet<IFilterHeaderObserver>();

    public TableFilterHeader() {
        this(null, null, null);
    }

    public TableFilterHeader(AbstractFiltersHandler filtersHandler) {
        this(null, filtersHandler);
    }

    public TableFilterHeader(JTable table, AbstractFiltersHandler filtersHandler) {
        this.setOpaque(false);
        this.setBackground(Gray.TRANSPARENT);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBackground(Gray.TRANSPARENT);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.add(panel, "Center");
        this.filtersHandler = filtersHandler;
        this.setPosition(FilterSettings.headerPosition);
        this.installTable(table);
    }

    public TableFilterHeader(JTable table, IParserModel parserModel, AutoChoices mode) {
        this(table, new FiltersHandler(mode == null ? FilterSettings.autoChoices : mode, parserModel == null ? FilterSettings.newParserModel() : parserModel));
    }

    public IFilterEditor getFilterEditor(int modelColumn) {
        return this.getColumnsController() == null ? null : ((FilterColumnsControllerPanel)this.getColumnsController()).getFilterEditor(this.getTable().convertColumnIndexToView(modelColumn));
    }

    @Nullable
    public JTable getTable() {
        return this.filtersHandler == null ? null : this.filtersHandler.getTable();
    }

    protected void setTable(@Nullable JTable table) {
        this.filtersHandler.setTable(table);
    }

    public void installTable(@Nullable JTable table) {
        this.filtersHandler.enableNotifications(false);
        super.installTable(table);
        this.filtersHandler.enableNotifications(true);
    }

    public void setAdaptiveChoices(boolean enable) {
        this.filtersHandler.setAdaptiveChoices(enable);
    }

    public void detachController() {
        this.getColumnsController().detach();
    }

    @NotNull
    public AdditionalTableHeader.ColumnsControllerPanel createColumnsController() {
        JTable currentTable = Objects.requireNonNull(this.getTable());
        return new FilterColumnsControllerPanel(currentTable, this.getFont(), this.getForeground());
    }

    class FilterColumnsControllerPanel
    extends AdditionalTableHeader.ColumnsControllerPanel {
        private Boolean handlerEnabled;

        FilterColumnsControllerPanel(JTable table, Font font, Color foreground) {
            if (table == null) {
                FilterColumnsControllerPanel.$$$reportNull$$$0(0);
            }
            super(table);
            super.setFont(font);
            super.setForeground(foreground);
            this.setOpaque(false);
            this.setBackground(Gray.TRANSPARENT);
            int count = this.getTableColumnModel().getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.createColumn(i);
            }
            this.setMyPreferredSize(this.computeMyPreferredSize());
            this.placeComponents();
            this.getTableColumnModel().addColumnModelListener((TableColumnModelListener)((Object)this));
        }

        @NotNull
        public FilterColumnPanel createColumn(int columnView) {
            boolean enabled = TableFilterHeader.this.filtersHandler.isEnabled();
            int columnModel = this.getTable().convertColumnIndexToModel(columnView);
            FilterEditor editor = this.createEditor(columnModel, enabled);
            FilterColumnPanel column = new FilterColumnPanel(this.getTableColumnModel().getColumn(columnView), editor);
            column.updateHeight();
            this.getColumns().add(column);
            this.add((Component)((Object)column));
            FilterColumnPanel filterColumnPanel = column;
            if (filterColumnPanel == null) {
                FilterColumnsControllerPanel.$$$reportNull$$$0(1);
            }
            return filterColumnPanel;
        }

        private FilterEditor createEditor(int modelColumn, boolean enableIt) {
            FilterEditor ret = new FilterEditor(TableFilterHeader.this.filtersHandler, modelColumn, this.getTable().getModel().getColumnClass(modelColumn));
            ret.setMaxHistory(maxHistory);
            ret.setInstantFiltering(instantFilteringEnabled);
            ret.setAutoCompletion(autoCompletionEnabled);
            ret.getFilter().setEnabled(enableIt);
            TableFilterHeader.this.filtersHandler.addFilterEditor(ret);
            return ret;
        }

        public FilterEditor getFilterEditor(int viewColumn) {
            return this.getColumns().size() > viewColumn ? ((FilterColumnPanel)this.getColumns().get((int)viewColumn)).editor : null;
        }

        public void updateColumns() {
            if (--this.autoRun == 0) {
                this.getTable();
                this.handlerEnabled = null;
                this.updateHeight();
            }
            TableFilterHeader.this.filtersHandler.enableNotifications(true);
        }

        public void updateHeight() {
            int h = 0;
            for (AdditionalTableHeader.ColumnsControllerPanel.AdditionalPanel c : this.getColumns()) {
                h = Math.max(h, c.getMyHeight());
            }
            this.myPreferredSize.height = h + filterRowHeightDelta;
            this.placeComponents();
            this.repaint();
        }

        public void columnAdded(@NotNull TableColumnModelEvent e) {
            if (e == null) {
                FilterColumnsControllerPanel.$$$reportNull$$$0(2);
            }
            if (this.isCorrectModel()) {
                TableFilterHeader.this.filtersHandler.enableNotifications(false);
                if (this.handlerEnabled == null) {
                    this.handlerEnabled = TableFilterHeader.this.filtersHandler.isEnabled();
                }
            }
            super.columnAdded(e);
        }

        public void columnRemoved(@NotNull TableColumnModelEvent e) {
            if (e == null) {
                FilterColumnsControllerPanel.$$$reportNull$$$0(3);
            }
            if (this.isCorrectModel()) {
                TableFilterHeader.this.filtersHandler.enableNotifications(false);
                if (this.handlerEnabled == null) {
                    this.handlerEnabled = TableFilterHeader.this.filtersHandler.isEnabled();
                }
            }
            super.columnRemoved(e);
        }

        @NotNull
        public Dimension computeMyPreferredSize() {
            int count = this.getTableColumnModel().getColumnCount();
            return new Dimension(0, count == 0 ? 0 : ((AdditionalTableHeader.ColumnsControllerPanel.AdditionalPanel)this.getColumns().get(0)).getMyHeight() + filterRowHeightDelta);
        }

        public Dimension getPreferredSize() {
            JTable table = this.getTable();
            this.myPreferredSize.width = table.getWidth();
            return this.myPreferredSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/notebooks/visualization/r/inlays/table/filters/gui/TableFilterHeader$FilterColumnsControllerPanel";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/notebooks/visualization/r/inlays/table/filters/gui/TableFilterHeader$FilterColumnsControllerPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "columnAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "columnRemoved";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        class FilterColumnPanel
        extends AdditionalTableHeader.ColumnsControllerPanel.AdditionalPanel
        implements IFilterObserver {
            public FilterEditor editor;

            FilterColumnPanel(TableColumn tc, FilterEditor editor) {
                super((AdditionalTableHeader.ColumnsControllerPanel)FilterColumnsControllerPanel.this, tc);
                this.setOpaque(false);
                this.setBackground(Gray.TRANSPARENT);
                this.setMyWidth(tc.getWidth());
                this.setMyHeight(this.getPreferredSize().height);
                this.add(editor, "Center");
                editor.getFilter().addFilterObserver(this);
                for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                    observer.tableFilterEditorCreated(TableFilterHeader.this, editor, tc);
                }
                this.editor = editor;
                tc.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }

            public void detach() {
                if (this.editor != null) {
                    TableFilterHeader.this.filtersHandler.removeFilterEditor(this.editor);
                    this.remove(this.editor);
                    this.editor.getFilter().removeFilterObserver(this);
                    for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                        observer.tableFilterEditorExcluded(TableFilterHeader.this, this.editor, this.getTableColumn());
                    }
                }
                this.getTableColumn().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }

            public void updateHeight() {
                this.setMyHeight(this.getPreferredSize().height);
                this.revalidate();
            }

            @Override
            public void filterUpdated(IFilter obs) {
                if (this.editor != null) {
                    for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                        observer.tableFilterUpdated(TableFilterHeader.this, this.editor, this.getTableColumn());
                    }
                }
            }
        }
    }
}

