/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.ChoiceRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterEditor;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.ChoiceMatch;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.ChoicesListModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.FilterListCellRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.HistoryListModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.IChoicesParser;

abstract class PopupComponent
implements PopupMenuListener {
    private FilterListCellRenderer listRenderer;
    private JScrollPane choicesScrollPane;
    private JScrollPane historyScrollPane;
    private JSeparator separator;
    private EditorBoundsWatcher editorBoundsWatcher = new EditorBoundsWatcher();
    private ChoicesListModel choicesModel;
    private HistoryListModel historyModel = new HistoryListModel();
    JPopupMenu popup;
    private Object cancelReason;
    private int maxVisibleRows;
    JList focusedList;
    JList choicesList;
    JList historyList;

    public PopupComponent(IFilterEditor editor, Format format, Comparator choicesComparator, Comparator stringComparator) {
        this.choicesModel = new ChoicesListModel(format, choicesComparator, stringComparator);
        this.createGui(editor);
    }

    protected abstract void choiceSelected(Object var1);

    public Object getSelection() {
        return this.focusedList.getSelectedValue();
    }

    public int getChoicesSize() {
        return this.choicesModel.getSize();
    }

    public void addChoices(Collection<?> choices, IChoicesParser parser) {
        if (this.choicesModel.addContent(choices, parser)) {
            this.hide();
        }
    }

    public void addHistory(Object st) {
        if (this.historyModel.add(st)) {
            this.hide();
        }
    }

    public void clearChoices() {
        this.choicesModel.clearContent();
        this.hide();
    }

    public void clearHistory() {
        this.historyModel.clear();
        this.hide();
    }

    public boolean isVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    public boolean display(Component editor) {
        if (this.isVisible()) {
            return false;
        }
        this.prepareGui();
        this.setPopupFocused(false);
        this.editorBoundsWatcher.displayPopup(editor);
        this.focusedList = this.historyList;
        return true;
    }

    public boolean hide() {
        return this.editorBoundsWatcher.displayPopup(null);
    }

    public FilterListCellRenderer getFilterRenderer() {
        return this.listRenderer;
    }

    public boolean setRenderedContent(ChoiceRenderer renderer, Comparator choicesComparator, Comparator stringComparator) {
        this.hide();
        this.listRenderer.setUserRenderer(renderer);
        boolean ret = this.choicesModel.setRenderedContent(choicesComparator, stringComparator);
        if (ret) {
            this.historyModel.setStringContent(null);
        }
        return ret;
    }

    public boolean setStringContent(Format format, Comparator choicesComparator, Comparator<String> stringComparator) {
        this.hide();
        this.listRenderer.setUserRenderer(null);
        boolean ret = this.choicesModel.setStringContent(format, choicesComparator, stringComparator);
        if (ret) {
            this.historyModel.setStringContent(stringComparator);
        }
        return ret;
    }

    public Comparator<String> getStringComparator() {
        return this.choicesModel.getStringComparator();
    }

    public ChoiceMatch selectBestMatch(Object hint) {
        ChoiceMatch hMatch = this.historyModel.getClosestMatch(hint);
        if (this.choicesModel.getSize() > 0) {
            ChoiceMatch match = this.choicesModel.getBestMatch(hint);
            if (this.isVisible() && match.index >= 0) {
                this.choicesList.ensureIndexIsVisible(match.index);
            }
            if (match.exact || !hMatch.exact && match.len >= hMatch.len) {
                if (match.index >= 0 && this.isVisible()) {
                    this.focusChoices();
                    this.select(match.index);
                }
                return match;
            }
        }
        if (hMatch.index != -1 && this.isVisible()) {
            this.focusHistory();
            this.select(hMatch.index);
        }
        return hMatch;
    }

    public String getCompletion(String s) {
        return this.choicesModel.getCompletion(s, this.historyModel.getList());
    }

    public void setPopupFocused(boolean set) {
        if (set != this.listRenderer.isFocusOnList()) {
            this.listRenderer.setFocusOnList(set);
            if (this.focusedList != null) {
                this.focusedList.repaint();
            }
        }
    }

    public boolean isPopupFocused() {
        return this.isVisible() && this.listRenderer.isFocusOnList();
    }

    public void setMaxHistory(int size) {
        this.historyModel.setMaxHistory(Math.max(0, Math.min(size, this.maxVisibleRows)));
        this.hide();
    }

    public int getMaxHistory() {
        return this.historyModel.getMaxHistory();
    }

    public void setHistory(List<Object> history) {
        this.historyModel.initialize(history);
    }

    public List<Object> getHistory() {
        return this.historyModel.getShownHistory();
    }

    public boolean selectFirst(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToHistory() && (forceJump || this.choicesList.getSelectedIndex() == 0);
        if (ret) {
            this.focusHistory();
        }
        return this.select(0) || ret;
    }

    public boolean selectLast(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToChoices() && (forceJump || this.historyList.getSelectedIndex() == this.historyModel.getSize() - 1);
        if (ret) {
            this.focusChoices();
        }
        return this.select(this.focusedList.getModel().getSize() - 1) || ret;
    }

    public boolean selectUp(boolean jumpRequired) {
        if (jumpRequired || !this.select(this.focusedList.getSelectedIndex() - 1)) {
            if (!this.canSwitchToHistory()) {
                return false;
            }
            this.focusHistory();
            this.select(this.historyModel.getSize() - 1);
        }
        return true;
    }

    public void selectDown(boolean jumpRequired) {
        if ((jumpRequired || !this.select(this.focusedList.getSelectedIndex() + 1)) && this.canSwitchToChoices()) {
            this.focusChoices();
            this.select(this.choicesList.getFirstVisibleIndex());
        }
    }

    public void selectDownPage() {
        if (this.isFocusInHistory()) {
            if (this.canSwitchToChoices()) {
                this.focusChoices();
            }
            this.select(this.focusedList.getLastVisibleIndex());
        } else {
            int lst = this.choicesList.getLastVisibleIndex();
            if (lst == this.choicesList.getSelectedIndex()) {
                lst = Math.min(lst + lst - this.choicesList.getFirstVisibleIndex(), this.choicesModel.getSize() - 1);
            }
            this.select(lst);
        }
    }

    public void selectUpPage() {
        int r = 0;
        if (!this.isFocusInHistory()) {
            int selected = this.choicesList.getSelectedIndex();
            if (this.canSwitchToHistory() && selected == 0) {
                this.focusHistory();
            } else {
                r = this.choicesList.getFirstVisibleIndex();
                if (r == selected) {
                    r = Math.max(0, r + r - this.choicesList.getLastVisibleIndex());
                }
            }
        }
        this.select(r);
    }

    private boolean select(int n) {
        int current = this.focusedList.getSelectedIndex();
        this.setPopupFocused(true);
        if (n >= 0) {
            this.focusedList.setSelectedIndex(n);
            this.focusedList.ensureIndexIsVisible(n);
        }
        return current != this.focusedList.getSelectedIndex();
    }

    private boolean canSwitchToHistory() {
        return this.focusedList == this.choicesList && this.historyScrollPane.isVisible();
    }

    private boolean canSwitchToChoices() {
        return this.focusedList == this.historyList && this.choicesScrollPane.isVisible();
    }

    private void focusHistory() {
        this.choicesList.clearSelection();
        this.focusedList = this.historyList;
    }

    private void focusChoices() {
        this.historyList.clearSelection();
        this.focusedList = this.choicesList;
    }

    private boolean isFocusInHistory() {
        return this.focusedList == this.historyList;
    }

    void showPopup(Component editor) {
        int width = editor.getParent().getWidth() - 1;
        PopupComponent.configurePaneSize(this.choicesScrollPane, width);
        PopupComponent.configurePaneSize(this.historyScrollPane, width);
        this.popup.show(editor, -editor.getLocation().x - 1, editor.getHeight());
    }

    private static void configurePaneSize(JComponent pane, int width) {
        Dimension size = pane.getPreferredSize();
        size.width = width;
        pane.setPreferredSize(size);
    }

    private void ensureListRowsHeight() {
        String prototype;
        prototype = this.listRenderer != null && this.listRenderer.getUserRenderer() == null ? ("X".equals(prototype = (String)this.choicesList.getPrototypeCellValue()) ? "Z" : "X") : null;
        this.choicesList.setPrototypeCellValue(prototype);
        this.historyList.setPrototypeCellValue(prototype);
    }

    private void createGui(IFilterEditor editor) {
        MouseHandler mouseHandler = new MouseHandler();
        this.choicesList = new JList(this.choicesModel);
        this.choicesList.addMouseMotionListener(mouseHandler);
        this.choicesList.addMouseListener(mouseHandler);
        this.choicesScrollPane = PopupComponent.createScrollPane(this.choicesList);
        this.historyList = new JList(this.historyModel);
        this.historyList.addMouseMotionListener(mouseHandler);
        this.historyList.addMouseListener(mouseHandler);
        this.choicesList.setBorder(null);
        this.choicesList.setFocusable(false);
        this.choicesList.setSelectionMode(0);
        this.historyList.setBorder(null);
        this.historyList.setFocusable(false);
        this.historyList.setSelectionMode(0);
        this.ensureListRowsHeight();
        this.separator = new JSeparator();
        this.popup = new JPopupMenu();
        this.popup.setLayout(new BorderLayout());
        this.popup.setBorderPainted(true);
        this.popup.setOpaque(false);
        this.popup.addPopupMenuListener(this);
        this.historyScrollPane = PopupComponent.createScrollPane(this.historyList);
        this.popup.add((Component)this.historyScrollPane, "North");
        this.popup.add((Component)this.separator, "Center");
        this.popup.add((Component)this.choicesScrollPane, "South");
        this.popup.setDoubleBuffered(true);
        this.popup.setFocusable(false);
        this.listRenderer = new FilterListCellRenderer(editor, this.choicesList);
        this.choicesList.setCellRenderer(this.listRenderer);
        this.historyList.setCellRenderer(this.listRenderer);
    }

    private void prepareGui() {
        int historySize = this.historyModel.clearRestrictions();
        int choicesSize = this.choicesModel.getSize();
        int maxChoices = Math.min(choicesSize, this.maxVisibleRows - historySize);
        if (historySize > 0 && choicesSize <= maxChoices) {
            for (int i = 0; i < choicesSize; ++i) {
                if (!this.historyModel.restrict(this.choicesModel.getElementAt(i))) continue;
                --historySize;
            }
            maxChoices = choicesSize;
        }
        boolean showHistory = historySize > 0;
        boolean showChoices = maxChoices > 0;
        this.choicesScrollPane.setVisible(showChoices);
        this.historyScrollPane.setVisible(showHistory);
        if (showHistory) {
            this.historyList.setVisibleRowCount(historySize);
            this.historyScrollPane.setPreferredSize(null);
        }
        if (showChoices) {
            this.choicesList.setVisibleRowCount(maxChoices);
            this.choicesScrollPane.setPreferredSize(null);
        }
        this.separator.setVisible(showHistory && showChoices);
    }

    private static JScrollPane createScrollPane(JList list) {
        JScrollPane ret = new JScrollPane(list, 20, 31);
        ret.setHorizontalScrollBar(null);
        ret.setFocusable(false);
        ret.getVerticalScrollBar().setFocusable(false);
        ret.setBorder(null);
        return ret;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.cancelReason = null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        AWTEvent ev = EventQueue.getCurrentEvent();
        if (ev instanceof MouseEvent) {
            this.cancelReason = ev.getSource();
        }
    }

    public boolean isMenuCanceledForMouseEvent(Object source) {
        boolean ret = !this.popup.isVisible() && this.cancelReason == source;
        this.cancelReason = null;
        return ret;
    }

    final class EditorBoundsWatcher
    extends ComponentAdapter {
        private Component editor;

        EditorBoundsWatcher() {
        }

        public boolean displayPopup(Component editor) {
            if (editor != this.editor) {
                if (this.editor != null) {
                    this.editor.removeComponentListener(this);
                }
                if (editor != null) {
                    editor.addComponentListener(this);
                }
            }
            this.editor = editor;
            if (editor != null) {
                PopupComponent.this.showPopup(editor);
            } else if (PopupComponent.this.popup.isVisible()) {
                PopupComponent.this.popup.setVisible(false);
                return true;
            }
            return false;
        }

        private void handleChange() {
            if (PopupComponent.this.popup.isVisible()) {
                PopupComponent.this.showPopup(this.editor);
            } else {
                this.displayPopup(null);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleChange();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleChange();
        }
    }

    final class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            this.listSelection(PopupComponent.this.focusedList.getSelectedValue());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            JList focus = (JList)e.getSource();
            JList other = focus == PopupComponent.this.choicesList ? PopupComponent.this.historyList : PopupComponent.this.choicesList;
            focus.setSelectedIndex(focus.locationToIndex(e.getPoint()));
            if (other.getModel().getSize() > 0) {
                other.setSelectedIndex(0);
                other.clearSelection();
            }
            PopupComponent.this.focusedList = focus;
        }

        private void listSelection(Object object) {
            PopupComponent.this.choiceSelected(object);
            PopupComponent.this.hide();
        }
    }
}

