/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayManager;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCell;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellView;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorComponentWrapper;
import org.jetbrains.plugins.notebooks.visualization.ui.NestedScrollingSupport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\r\b\u0001\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0096\u0001J\u0018\u0010\u0010\u001a\u00020\u00112\r\b\u0001\u0010\r\u001a\u00070\u0012\u00a2\u0006\u0002\b\u000fH\u0096\u0001J\u001e\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\b0\b0\u00072\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u000e\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u000fH\u0097\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001f\u0010\u001c\u001a\u00180\u001d\u00a2\u0006\u000e\b\u001e\u0012\n\b\u001f\u0012\u0006\b\n0 8!\u00a2\u0006\u0002\b\u000fH\u0097\u0001J\u0010\u0010\"\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b#H\u0097\u0001J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016JD\u0010*\u001a\t\u0018\u0001H+\u00a2\u0006\u0002\b#\"\u0010\b\u0000\u0010+*\n \u0014*\u0004\u0018\u00010,0,2\u001b\b\u0001\u0010\r\u001a\u0015\u0012\f\u0012\n \u0014*\u0004\u0018\u0001H+H+0-\u00a2\u0006\u0002\b\u000fH\u0097\u0001\u00a2\u0006\u0002\u0010.J\t\u0010/\u001a\u00020\u0011H\u0096\u0001J\t\u00100\u001a\u00020\u0011H\u0096\u0001J\u0018\u00101\u001a\u00020\f2\r\b\u0001\u0010\r\u001a\u00070\u0012\u00a2\u0006\u0002\b\u000fH\u0096\u0001JN\u00102\u001a\u00020\f\"\u0010\b\u0000\u0010+*\n \u0014*\u0004\u0018\u00010,0,2\u001b\b\u0001\u0010\r\u001a\u0015\u0012\f\u0012\n \u0014*\u0004\u0018\u0001H+H+0-\u00a2\u0006\u0002\b\u000f2\u000f\b\u0001\u00103\u001a\t\u0018\u0001H+\u00a2\u0006\u0002\b#H\u0096\u0001\u00a2\u0006\u0002\u00104J\u0018\u00105\u001a\u00020\f2\r\b\u0001\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0096\u0001J\u0018\u00106\u001a\u00020\f2\r\b\u0001\u0010\r\u001a\u00070%\u00a2\u0006\u0002\b\u000fH\u0096\u0001J\b\u00107\u001a\u00020\fH\u0002J\b\u00108\u001a\u00020\fH\u0002J\u0018\u00109\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010:\u001a\u00020;H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/DecoratedEditor;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "original", "manager", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;)V", "component", "Ljavax/swing/JLayer;", "Ljavax/swing/JComponent;", "mouseOverCell", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView;", "addPropertyChangeListener", "", "p0", "Ljava/beans/PropertyChangeListener;", "Lorg/jetbrains/annotations/NotNull;", "canNavigateTo", "", "Lcom/intellij/pom/Navigatable;", "createLayer", "kotlin.jvm.PlatformType", "view", "dispose", "getComponent", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPreferredFocusedComponent", "Lorg/jetbrains/annotations/Nullable;", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "getUserData", "T", "", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isModified", "isValid", "navigateTo", "putUserData", "p1", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "removePropertyChangeListener", "setState", "setupScrollPaneListener", "setupScrollingPositionKeeper", "updateMouseOverCell", "point", "Ljava/awt/Point;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nDecoratedEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoratedEditor.kt\norg/jetbrains/plugins/notebooks/visualization/ui/DecoratedEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n766#2:176\n857#2,2:177\n1603#2,9:179\n1855#2:188\n1856#2:190\n1612#2:191\n288#2,2:192\n1#3:189\n*S KotlinDebug\n*F\n+ 1 DecoratedEditor.kt\norg/jetbrains/plugins/notebooks/visualization/ui/DecoratedEditor\n*L\n118#1:176\n118#1:177,2\n118#1:179,9\n118#1:188\n118#1:190\n118#1:191\n118#1:192,2\n118#1:189\n*E\n"})
final class DecoratedEditor
implements TextEditor {
    @NotNull
    private final TextEditor original;
    @NotNull
    private final NotebookCellInlayManager manager;
    @Nullable
    private EditorCellView mouseOverCell;
    @NotNull
    private final JLayer<JComponent> component;

    public DecoratedEditor(@NotNull TextEditor original, @NotNull NotebookCellInlayManager manager) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.original = original;
        this.manager = manager;
        JComponent jComponent = this.original.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.component = NestedScrollingSupport.INSTANCE.addNestedScrollingSupport(this.createLayer(jComponent));
        if (!GraphicsEnvironment.isHeadless()) {
            this.setupScrollPaneListener();
        }
        this.setupScrollingPositionKeeper();
        this.manager.onInvalidate((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                component.revalidate();
            }
        }));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.original.addPropertyChangeListener(p0);
    }

    public boolean canNavigateTo(@NotNull Navigatable p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.original.canNavigateTo(p0);
    }

    @NotNull
    public Editor getEditor() {
        return this.original.getEditor();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getName() {
        return this.original.getName();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.original.getPreferredFocusedComponent();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        return (T)this.original.getUserData(p0);
    }

    public boolean isModified() {
        return this.original.isModified();
    }

    public boolean isValid() {
        return this.original.isValid();
    }

    public void navigateTo(@NotNull Navigatable p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.original.navigateTo(p0);
    }

    public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.original.putUserData(p0, p1);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.original.removePropertyChangeListener(p0);
    }

    public void setState(@NotNull FileEditorState p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.original.setState(p0);
    }

    private final void setupScrollPaneListener() {
        Editor editor = this.original.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editorEx = (EditorEx)editor;
        JScrollPane jScrollPane = editorEx.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.getViewport().addChangeListener(arg_0 -> DecoratedEditor.setupScrollPaneListener$lambda$2(editorEx, this, arg_0));
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.original.getStructureViewBuilder();
    }

    private final void setupScrollingPositionKeeper() {
        Editor editor = this.original.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editorEx = (EditorEx)editor;
        JScrollPane jScrollPane = editorEx.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        Component view = scrollPane.getViewport().getView();
        JViewport jViewport = scrollPane.getViewport();
        Editor editor2 = (Editor)editorEx;
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorComponentImpl");
        jViewport.setView(new EditorComponentWrapper(editor2, (EditorComponentImpl)view, this.manager));
    }

    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.original.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        FileEditorState fileEditorState = this.original.getState(level);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
        return fileEditorState;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.original));
    }

    private final JLayer<JComponent> createLayer(JComponent view) {
        return new JLayer<Component>(view, (LayerUI)new LayerUI<JComponent>(this){
            final /* synthetic */ DecoratedEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void installUI(@NotNull JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.installUI(c);
                ((JLayer)c).setLayerEventMask(32L);
            }

            public void uninstallUI(@NotNull JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.uninstallUI(c);
                ((JLayer)c).setLayerEventMask(0L);
            }

            public void eventDispatched(@NotNull AWTEvent e, @Nullable JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e instanceof MouseEvent) {
                    JComponent component;
                    Editor editor = DecoratedEditor.access$getOriginal$p(this.this$0).getEditor();
                    Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                    EditorEx editorEx = (EditorEx)editor;
                    JComponent jComponent = SwingUtilities.isDescendingFrom(((MouseEvent)e).getComponent(), editorEx.getContentComponent()) ? editorEx.getContentComponent() : (component = SwingUtilities.isDescendingFrom(((MouseEvent)e).getComponent(), (Component)editorEx.getGutterComponentEx()) ? (JComponent)editorEx.getGutterComponentEx() : null);
                    if (component != null) {
                        Point point = SwingUtilities.convertPoint(((MouseEvent)e).getComponent(), ((MouseEvent)e).getPoint(), component);
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"convertPoint(...)");
                        DecoratedEditor.access$updateMouseOverCell(this.this$0, component, point);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMouseOverCell(JComponent component, Point point) {
        block6: {
            Object v0;
            block5: {
                void $this$firstOrNull$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Object it;
                void $this$filterTo$iv$iv;
                List<EditorCell> cells = this.manager.getCells();
                Iterable $this$filter$iv = cells;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (EditorCell)element$iv$iv;
                    boolean bl = false;
                    if (!((EditorCell)it).getVisible()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    EditorCellView it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    EditorCell it2 = (EditorCell)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getView() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EditorCellView it3 = (EditorCellView)element$iv;
                    boolean bl = false;
                    int viewLeft = 0;
                    int viewTop = it3.getBounds().y;
                    int viewRight = component.getSize().width;
                    int viewBottom = viewTop + it3.getBounds().height;
                    if (!(viewLeft <= point.x && viewTop <= point.y && viewRight >= point.x && viewBottom >= point.y)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            EditorCellView currentOverCell = v0;
            if (Intrinsics.areEqual((Object)this.mouseOverCell, (Object)currentOverCell)) break block6;
            EditorCellView editorCellView = this.mouseOverCell;
            if (editorCellView != null) {
                editorCellView.mouseExited();
            }
            EditorCellView editorCellView2 = this.mouseOverCell = currentOverCell;
            if (editorCellView2 != null) {
                editorCellView2.mouseEntered();
            }
        }
    }

    private static final void setupScrollPaneListener$lambda$2(EditorEx $editorEx, DecoratedEditor this$0, ChangeEvent it) {
        block1: {
            Point it2;
            Intrinsics.checkNotNullParameter((Object)$editorEx, (String)"$editorEx");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Point point = $editorEx.getContentComponent().getMousePosition();
            if (point != null) {
                it2 = point;
                boolean bl = false;
                JComponent jComponent = $editorEx.getContentComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
                this$0.updateMouseOverCell(jComponent, it2);
            }
            Point point2 = $editorEx.getGutterComponentEx().getMousePosition();
            if (point2 == null) break block1;
            it2 = point2;
            boolean bl = false;
            EditorGutterComponentEx editorGutterComponentEx = $editorEx.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            this$0.updateMouseOverCell((JComponent)editorGutterComponentEx, it2);
        }
    }

    public static final /* synthetic */ TextEditor access$getOriginal$p(DecoratedEditor $this) {
        return $this.original;
    }

    public static final /* synthetic */ void access$updateMouseOverCell(DecoratedEditor $this, JComponent component, Point point) {
        $this.updateMouseOverCell(component, point);
    }
}

