/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.ui.ControllerEditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCell;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellFoldingBar;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellInput;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellRunButton;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellView;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.HasGutterIcon;
import org.jetbrains.plugins.notebooks.visualization.ui.TextEditorCellViewComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#H\u0002J\u0006\u0010%\u001a\u00020 J\u000e\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020 J\"\u0010)\u001a\u00020 2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0005H\u0002J\b\u0010+\u001a\u00020 H\u0002J\u0010\u0010,\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020 H\u0002J\u0010\u00100\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020.J\u000e\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellInput;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "componentFactory", "Lkotlin/Function2;", "cell", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;)V", "value", "component", "getComponent", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "setComponent", "(Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;)V", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "folding", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellFoldingBar;", "getFolding", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellFoldingBar;", "gutterAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "runCellButton", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellRunButton;", "calculateBounds", "Ljava/awt/Rectangle;", "doDispose", "", "doLayout", "getFoldingBounds", "Lkotlin/Pair;", "", "hideRunButton", "setGutterAction", "action", "showRunButton", "toggleFolding", "inputComponentFactory", "toggleTextFolding", "update", "force", "", "updateGutterIcons", "updateInput", "updatePresentation", "view", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellInput.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellInput\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1284#2,3:152\n288#3,2:155\n*S KotlinDebug\n*F\n+ 1 EditorCellInput.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellInput\n*L\n132#1:152,3\n73#1:155,2\n*E\n"})
public final class EditorCellInput
extends EditorCellViewComponent {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Function2<EditorCellInput, EditorCellViewComponent, EditorCellViewComponent> componentFactory;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private FoldRegion foldRegion;
    @Nullable
    private final EditorCellRunButton runCellButton;
    @NotNull
    private EditorCellViewComponent component;
    @NotNull
    private final EditorCellFoldingBar folding;
    @Nullable
    private AnAction gutterAction;

    public EditorCellInput(@NotNull EditorEx editor, @NotNull Function2<? super EditorCellInput, ? super EditorCellViewComponent, ? extends EditorCellViewComponent> componentFactory, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.componentFactory = componentFactory;
        this.cell = cell;
        this.runCellButton = NotebookUtilKt.getNotebookAppearance((Editor)((Editor)this.editor)).shouldShowRunButtonInGutter() ? new EditorCellRunButton(this.editor) : null;
        this.component = (EditorCellViewComponent)this.componentFactory.invoke((Object)this, null);
        this.folding = new EditorCellFoldingBar(this.editor, (Function0<Pair<Integer, Integer>>)((Function0)new Function0<Pair<? extends Integer, ? extends Integer>>((Object)this){

            @NotNull
            public final Pair<Integer, Integer> invoke() {
                return EditorCellInput.access$getFoldingBounds((EditorCellInput)this.receiver);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorCellInput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorCellInput.access$toggleFolding(this.this$0, EditorCellInput.access$getComponentFactory$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final NotebookCellLines.Interval getInterval() {
        NotebookCellLines.Interval interval = this.cell.getIntervalPointer$intellij_notebooks_visualization().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        return interval;
    }

    @NotNull
    public final EditorCellViewComponent getComponent() {
        return this.component;
    }

    private final void setComponent(EditorCellViewComponent value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.component)) {
            this.component.dispose();
            this.remove(this.component);
            this.component = value;
            this.add(value);
        }
    }

    @NotNull
    public final EditorCellFoldingBar getFolding() {
        return this.folding;
    }

    private final Pair<Integer, Integer> getFoldingBounds() {
        int delimiterPanelSize = this.getInterval().getOrdinal() == 0 ? NotebookUtilKt.getNotebookAppearance((Editor)((Editor)this.editor)).getAboveFirstCellDelimiterHeight() : NotebookUtilKt.getNotebookAppearance((Editor)((Editor)this.editor)).getCellBorderHeight() / 2;
        return TuplesKt.to((Object)(this.getBounds().y + delimiterPanelSize), (Object)(this.getBounds().height - delimiterPanelSize));
    }

    private final void toggleFolding(Function2<? super EditorCellInput, ? super EditorCellViewComponent, ? extends EditorCellViewComponent> inputComponentFactory) {
        EditorCellViewComponent editorCellViewComponent;
        if (this.component instanceof ControllerEditorCellViewComponent) {
            this.toggleTextFolding();
            editorCellViewComponent = new TextEditorCellViewComponent(this.editor, this.cell);
        } else {
            this.toggleTextFolding();
            editorCellViewComponent = (EditorCellViewComponent)inputComponentFactory.invoke((Object)this, (Object)this.component);
        }
        this.setComponent(editorCellViewComponent);
        this.invalidate();
    }

    private final void toggleTextFolding() {
        block4: {
            FoldRegion currentFoldingRegion;
            FoldingModelEx foldingModel;
            block3: {
                NotebookCellLines.Interval interval = this.getInterval();
                int startOffset = this.editor.getDocument().getLineStartOffset(interval.getLines().getFirst() + 1);
                int endOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast());
                FoldingModelEx foldingModelEx = this.editor.getFoldingModel();
                Intrinsics.checkNotNullExpressionValue((Object)foldingModelEx, (String)"getFoldingModel(...)");
                foldingModel = foldingModelEx;
                currentFoldingRegion = this.foldRegion;
                if (currentFoldingRegion != null) break block3;
                if (this.cell.getType() == NotebookCellLines.CellType.MARKDOWN) {
                    EditorCellView editorCellView = this.cell.getView();
                    if (editorCellView != null) {
                        editorCellView.disableMarkdownRenderingIfEnabled();
                    }
                }
                foldingModel.runBatchFoldingOperation(() -> EditorCellInput.toggleTextFolding$lambda$1(this, startOffset, endOffset, foldingModel));
                break block4;
            }
            foldingModel.runBatchFoldingOperation(() -> EditorCellInput.toggleTextFolding$lambda$2(foldingModel, currentFoldingRegion, this));
            if (this.cell.getType() != NotebookCellLines.CellType.MARKDOWN) break block4;
            EditorCellView editorCellView = this.cell.getView();
            if (editorCellView != null) {
                editorCellView.enableMarkdownRenderingIfNeeded();
            }
        }
    }

    @Override
    public void doDispose() {
        this.folding.dispose();
        EditorCellRunButton editorCellRunButton = this.runCellButton;
        if (editorCellRunButton != null) {
            editorCellRunButton.dispose();
        }
        this.component.dispose();
    }

    public final void update(boolean force) {
        this.updateInput(force);
        this.updateGutterIcons();
    }

    public static /* synthetic */ void update$default(EditorCellInput editorCellInput, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        editorCellInput.update(bl);
    }

    private final void updateGutterIcons() {
        block0: {
            EditorCellViewComponent editorCellViewComponent = this.component;
            HasGutterIcon hasGutterIcon = editorCellViewComponent instanceof HasGutterIcon ? (HasGutterIcon)((Object)editorCellViewComponent) : null;
            if (hasGutterIcon == null) break block0;
            hasGutterIcon.updateGutterIcons(this.gutterAction);
        }
    }

    public final void setGutterAction(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.gutterAction = action2;
        this.updateGutterIcons();
    }

    public final void showRunButton() {
        try {
            EditorCellRunButton editorCellRunButton = this.runCellButton;
            if (editorCellRunButton != null) {
                editorCellRunButton.showRunButton(this.getInterval());
            }
        }
        catch (IllegalStateException e) {
            return;
        }
    }

    public final void hideRunButton() {
        block0: {
            EditorCellRunButton editorCellRunButton = this.runCellButton;
            if (editorCellRunButton == null) break block0;
            editorCellRunButton.hideRunButton();
        }
    }

    public final void updatePresentation(@NotNull EditorCellViewComponent view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.setComponent(view);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Rectangle calculateBounds() {
        void $this$fold$iv;
        IntRange linesRange = this.getInterval().getLines();
        int startOffset = this.editor.getDocument().getLineStartOffset(linesRange.getFirst());
        int endOffset = this.editor.getDocument().getLineEndOffset(linesRange.getLast());
        List list = this.editor.getInlayModel().getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)new Function1<Inlay<?>, Boolean>(this){
            final /* synthetic */ EditorCellInput this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Inlay<?> it) {
                return it.getProperties().getPriority() > NotebookUtilKt.getNotebookAppearance((Editor)((Editor)EditorCellInput.access$getEditor$p(this.this$0))).getNOTEBOOK_OUTPUT_INLAY_PRIORITY();
            }
        }), (Function1)calculateBounds.bounds.2.INSTANCE);
        Rectangle initial$iv = this.component.calculateBounds();
        boolean $i$f$fold = false;
        Rectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void i;
            Rectangle rectangle = (Rectangle)element$iv;
            Rectangle b = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)b.union((Rectangle)i), (String)"union(...)");
        }
        Rectangle bounds2 = accumulator$iv;
        return bounds2;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.folding.updateBounds();
    }

    public final void updateInput(boolean force) {
        EditorCellViewComponent oldComponent = force ? null : this.component;
        this.setComponent((EditorCellViewComponent)this.componentFactory.invoke((Object)this, (Object)oldComponent));
        if (!Intrinsics.areEqual((Object)this.getBounds(), (Object)this.calculateBounds())) {
            this.invalidate();
        }
    }

    public static /* synthetic */ void updateInput$default(EditorCellInput editorCellInput, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        editorCellInput.updateInput(bl);
    }

    private static final void toggleTextFolding$lambda$1(EditorCellInput this$0, int $startOffset, int $endOffset, FoldingModelEx $foldingModel) {
        String firstNotEmptyString;
        String string;
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
            String string2 = this$0.editor.getDocument().getText(new TextRange($startOffset, $endOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String text = string2;
            Iterable $this$firstOrNull$iv = StringsKt.lines((CharSequence)text);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        if ((string = (firstNotEmptyString = (String)v2)) == null) {
            string = "\u2026";
        }
        String string3 = StringUtil.shortenTextWithEllipsis((String)string, (int)20, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
        String placeholder = string3;
        this$0.foldRegion = $foldingModel.createFoldRegion($startOffset, $endOffset, placeholder, null, true);
    }

    private static final void toggleTextFolding$lambda$2(FoldingModelEx $foldingModel, FoldRegion $currentFoldingRegion, EditorCellInput this$0) {
        Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $foldingModel.removeFoldRegion($currentFoldingRegion);
        this$0.foldRegion = null;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(EditorCellInput $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Pair access$getFoldingBounds(EditorCellInput $this) {
        return $this.getFoldingBounds();
    }

    public static final /* synthetic */ void access$toggleFolding(EditorCellInput $this, Function2 inputComponentFactory) {
        $this.toggleFolding((Function2<? super EditorCellInput, ? super EditorCellViewComponent, ? extends EditorCellViewComponent>)inputComponentFactory);
    }

    public static final /* synthetic */ Function2 access$getComponentFactory$p(EditorCellInput $this) {
        return $this.componentFactory;
    }
}

