/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellFoldingBar;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutputKt;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.NotebookEditorUiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J&\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutput;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "component", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent;", "toDispose", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent;Lcom/intellij/openapi/Disposable;)V", "value", "", "collapsed", "getCollapsed", "()Z", "setCollapsed", "(Z)V", "folding", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellFoldingBar;", "getFolding", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellFoldingBar;", "calculateBounds", "Ljava/awt/Rectangle;", "doDispose", "", "doViewportChange", "getFoldingBounds", "Lkotlin/Pair;", "", "getOutputComponent", "Ljavax/swing/JComponent;", "paintGutter", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "yOffset", "g", "Ljava/awt/Graphics;", "r", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellOutput.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class EditorCellOutput
extends EditorCellViewComponent {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final CollapsingComponent component;
    @Nullable
    private final Disposable toDispose;
    @NotNull
    private final EditorCellFoldingBar folding;

    public EditorCellOutput(@NotNull EditorEx editor, @NotNull CollapsingComponent component, @Nullable Disposable toDispose) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.editor = editor;
        this.component = component;
        this.toDispose = toDispose;
        this.folding = new EditorCellFoldingBar(this.editor, (Function0<Pair<Integer, Integer>>)((Function0)new Function0<Pair<? extends Integer, ? extends Integer>>((Object)this){

            @NotNull
            public final Pair<Integer, Integer> invoke() {
                return EditorCellOutput.access$getFoldingBounds((EditorCellOutput)this.receiver);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditorCellOutput this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EditorCellOutput.access$getComponent$p(this.this$0).setSeen(!EditorCellOutput.access$getComponent$p(this.this$0).isSeen());
            }
        }));
        if (DataManager.getDataProvider((JComponent)this.component) == null) {
            DataManager.registerDataProvider((JComponent)this.component, arg_0 -> EditorCellOutput._init_$lambda$0(this, arg_0));
        }
    }

    public final boolean getCollapsed() {
        return !this.component.isSeen();
    }

    public final void setCollapsed(boolean value) {
        this.component.setSeen(!value);
    }

    @NotNull
    public final EditorCellFoldingBar getFolding() {
        return this.folding;
    }

    @TestOnly
    @NotNull
    public final JComponent getOutputComponent() {
        return this.component.getMainComponent();
    }

    private final Pair<Integer, Integer> getFoldingBounds() {
        Point inlayComponentLocation = SwingUtilities.convertPoint(this.component, new Point(0, 0), (Component)this.editor.getGutterComponentEx());
        return TuplesKt.to((Object)inlayComponentLocation.y, (Object)this.component.getHeight());
    }

    @Override
    public void doDispose() {
        block0: {
            this.folding.dispose();
            Disposable disposable = this.toDispose;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    @Override
    public void doViewportChange() {
        JComponent jComponent = this.component.getMainComponent();
        NotebookOutputInlayShowable notebookOutputInlayShowable = jComponent instanceof NotebookOutputInlayShowable ? (NotebookOutputInlayShowable)((Object)jComponent) : null;
        if (notebookOutputInlayShowable == null) {
            return;
        }
        NotebookOutputInlayShowable component = notebookOutputInlayShowable;
        if (!(component instanceof JComponent)) {
            return;
        }
        NotebookEditorUiUtilKt.validateComponent((Container)((Object)component));
        Rectangle componentRect = SwingUtilities.convertRectangle((Component)((Object)component), ((JComponent)((Object)component)).getBounds(), this.editor.getScrollPane().getViewport().getView());
        component.setShown(this.editor.getScrollPane().getViewport().getViewRect().intersects(componentRect));
    }

    public final void paintGutter(@NotNull EditorImpl editor, int yOffset, @NotNull Graphics g, @NotNull Rectangle r) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            if (!Intrinsics.areEqual((Object)editor.getUserData(org.jetbrains.plugins.notebooks.ui.NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true)) {
                this.component.paintGutter((EditorEx)editor, yOffset, g);
            }
            JComponent mainComponent = this.component.getMainComponent();
            NotebookOutputComponentFactory.GutterPainter gutterPainter = NotebookOutputComponentFactory.Companion.getGutterPainter(mainComponent);
            if (gutterPainter == null) break block2;
            NotebookOutputComponentFactory.GutterPainter painter = gutterPainter;
            boolean bl = false;
            Integer n = NotebookEditorUiUtilKt.yOffsetFromEditor(mainComponent, (Editor)editor);
            if (n != null) {
                int yOffset2 = ((Number)n).intValue();
                boolean bl2 = false;
                Rectangle bounds2 = new Rectangle(r.x, yOffset2, r.width, mainComponent.getHeight());
                painter.paintGutter(editor, g, bounds2);
            }
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        Point location = SwingUtilities.convertPoint(this.component.getParent(), this.component.getLocation(), this.editor.getContentComponent());
        return new Rectangle(location, this.component.getSize());
    }

    private static final Object _init_$lambda$0(EditorCellOutput this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)key, (Object)EditorCellOutputKt.getNOTEBOOK_CELL_OUTPUT_DATA_KEY().getName()) ? this$0 : null;
    }

    public static final /* synthetic */ Pair access$getFoldingBounds(EditorCellOutput $this) {
        return $this.getFoldingBounds();
    }

    public static final /* synthetic */ CollapsingComponent access$getComponent$p(EditorCellOutput $this) {
        return $this.component;
    }
}

