/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactoryGetter;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKey;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayControllerKt;
import org.jetbrains.plugins.notebooks.visualization.outputs.OutputListener;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.InnerComponent;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.SurroundingComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutput;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutputsKt;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellView;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.NotebookEditorUiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010#\u001a\u00020\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\b\b\u0002\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J7\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010%\"\b\b\u0000\u00101*\u0002022\u0010\u00103\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H1042\u0006\u00105\u001a\u0002H1H\u0002\u00a2\u0006\u0002\u00106J%\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u00010%\"\b\b\u0000\u00101*\u0002022\u0006\u00105\u001a\u0002H1H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020\nH\u0016J\"\u0010:\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003040;0\rH\u0002J\u001e\u0010=\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020)J\b\u0010A\u001a\u00020\nH\u0002J\u0010\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020'H\u0002J\u0006\u0010D\u001a\u00020\nJ\u0016\u0010E\u001a\u00020\u00102\f\u0010F\u001a\b\u0012\u0004\u0012\u0002020 H\u0002J<\u0010G\u001a\u00020H\"\b\b\u0000\u0010I*\u00020<\"\b\b\u0001\u00101*\u000202*\u000e\u0012\u0004\u0012\u0002HI\u0012\u0004\u0012\u0002H1042\u0006\u0010J\u001a\u00020<2\u0006\u00105\u001a\u000202H\u0002J>\u0010K\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HM\u0012\u0004\u0012\u0002HN0;0L\"\u0004\b\u0000\u0010M\"\u0004\b\u0001\u0010N*\b\u0012\u0004\u0012\u0002HM0L2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002HN0LH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006P"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutputs;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "interval", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "onInlayDisposed", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "_outputs", "", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutput;", "value", "", "foldingsSelected", "getFoldingsSelected", "()Z", "setFoldingsSelected", "(Z)V", "foldingsVisible", "getFoldingsVisible", "setFoldingsVisible", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "innerComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/InnerComponent;", "outerComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/SurroundingComponent;", "outputs", "", "getOutputs", "()Ljava/util/List;", "addIntoInnerComponent", "newComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "pos", "", "calculateBounds", "Ljava/awt/Rectangle;", "computeInlayOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lines", "Lkotlin/ranges/IntRange;", "createInlay", "createOutput", "K", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;", "factory", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "outputDataKey", "(Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory;Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;)Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "createOutputGuessingFactory", "(Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;)Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "doDispose", "getComponentsWithFactories", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "paintGutter", "g", "Ljava/awt/Graphics;", "r", "recreateInlayIfNecessary", "removeOutput", "idx", "update", "updateData", "newDataKeys", "matchWithTypes", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "C", "component", "zip", "", "A", "B", "other", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellOutputs.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutputs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 NotebookVisualizationUiUtil.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,292:1\n1855#2,2:293\n1855#2,2:295\n1855#2,2:297\n1855#2,2:305\n1#3:299\n14#4:300\n14#4:302\n23#5:301\n22#6,2:303\n26#6,2:307\n*S KotlinDebug\n*F\n+ 1 EditorCellOutputs.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutputs\n*L\n40#1:293,2\n48#1:295,2\n75#1:297,2\n285#1:305,2\n137#1:300\n230#1:302\n187#1:301\n282#1:303,2\n282#1:307,2\n*E\n"})
public final class EditorCellOutputs
extends EditorCellViewComponent
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Function0<NotebookCellLines.Interval> interval;
    @NotNull
    private final Function1<EditorCellOutputs, Unit> onInlayDisposed;
    private boolean foldingsVisible;
    private boolean foldingsSelected;
    @NotNull
    private final List<EditorCellOutput> _outputs;
    @NotNull
    private final InnerComponent innerComponent;
    @NotNull
    private final SurroundingComponent outerComponent;
    @Nullable
    private Inlay<?> inlay;

    public EditorCellOutputs(@NotNull EditorImpl editor, @NotNull Function0<NotebookCellLines.Interval> interval, @NotNull Function1<? super EditorCellOutputs, Unit> onInlayDisposed) {
        JPanel it;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter(onInlayDisposed, (String)"onInlayDisposed");
        this.editor = editor;
        this.interval = interval;
        this.onInlayDisposed = onInlayDisposed;
        this._outputs = new ArrayList();
        InnerComponent innerComponent = jPanel = new InnerComponent();
        EditorCellOutputs editorCellOutputs = this;
        boolean bl = false;
        it.setMaxHeight(!ApplicationManager.getApplication().isUnitTestMode() ? (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.3) : 200);
        editorCellOutputs.innerComponent = jPanel;
        it = jPanel = SurroundingComponent.Companion.create(this.editor, this.innerComponent);
        editorCellOutputs = this;
        boolean bl2 = false;
        DataManager.registerDataProvider((JComponent)it, (DataProvider)new EditorCellView.NotebookCellDataProvider((Editor)this.editor, it, this.interval));
        editorCellOutputs.outerComponent = jPanel;
        this.update();
    }

    public /* synthetic */ EditorCellOutputs(EditorImpl editorImpl, Function0 function0, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(editorImpl, (Function0<NotebookCellLines.Interval>)function0, (Function1<? super EditorCellOutputs, Unit>)function1);
    }

    public final boolean getFoldingsVisible() {
        return this.foldingsVisible;
    }

    public final void setFoldingsVisible(boolean value) {
        if (this.foldingsVisible != value) {
            this.foldingsVisible = value;
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutput it = (EditorCellOutput)element$iv;
                boolean bl = false;
                it.getFolding().setVisible(value);
            }
        }
    }

    public final boolean getFoldingsSelected() {
        return this.foldingsSelected;
    }

    public final void setFoldingsSelected(boolean value) {
        if (this.foldingsSelected != value) {
            this.foldingsSelected = value;
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutput it = (EditorCellOutput)element$iv;
                boolean bl = false;
                it.getFolding().setSelected(value);
            }
        }
    }

    @NotNull
    public final List<EditorCellOutput> getOutputs() {
        return this._outputs;
    }

    @Override
    public void doDispose() {
        block1: {
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutput it = (EditorCellOutput)element$iv;
                boolean bl = false;
                it.dispose();
            }
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block1;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        Inlay<?> inlay = this.inlay;
        Rectangle rectangle = inlay != null ? inlay.getBounds() : null;
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        return rectangle;
    }

    /*
     * Unable to fully structure code
     */
    public final void update() {
        var2_1 = (List<E>)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)NotebookOutputDataKeyExtractor.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<NotebookOutputDataKeyExtractor, List<? extends NotebookOutputDataKey>>(this){
            final /* synthetic */ EditorCellOutputs this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final List<NotebookOutputDataKey> invoke(@NotNull NotebookOutputDataKeyExtractor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.extract(EditorCellOutputs.access$getEditor$p(this.this$0), (NotebookCellLines.Interval)EditorCellOutputs.access$getInterval$p(this.this$0).invoke());
            }
        })));
        if (var2_1 == null) ** GOTO lbl-1000
        it = var4_2 = var2_1;
        $i$a$-takeIf-EditorCellOutputs$update$outputDataKeys$2 = false;
        v0 = var3_5 = !((Collection)it).isEmpty() != false ? var4_2 : null;
        if (var3_5 != null) {
            v1 = var3_5;
        } else lbl-1000:
        // 2 sources

        {
            v1 = CollectionsKt.emptyList();
        }
        outputDataKeys = v1;
        this.updateData(outputDataKeys);
        this.recreateInlayIfNecessary();
        this.onViewportChange();
    }

    private final void recreateInlayIfNecessary() {
        if (!((Collection)this.getOutputs()).isEmpty()) {
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            int expectedOffset = this.computeInlayOffset((Document)documentEx, ((NotebookCellLines.Interval)this.interval.invoke()).getLines());
            Inlay<?> currentInlay = this.inlay;
            if (currentInlay != null) {
                if (currentInlay.getOffset() != expectedOffset) {
                    Disposer.dispose((Disposable)((Disposable)currentInlay));
                    this.inlay = this.createInlay();
                }
            } else {
                this.inlay = this.createInlay();
            }
        } else {
            Inlay<?> inlay = this.inlay;
            if (inlay != null) {
                Inlay<?> it = inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            this.inlay = null;
        }
    }

    private final boolean updateData(List<? extends NotebookOutputDataKey> newDataKeys) {
        int idx;
        Iterator<? extends NotebookOutputDataKey> newDataKeyIterator = newDataKeys.iterator();
        Iterator<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> oldComponentsWithFactories = this.getComponentsWithFactories().iterator();
        boolean isFilled = false;
        Iterator<Object> iterator = CollectionsKt.withIndex(this.zip(newDataKeyIterator, oldComponentsWithFactories));
        while (iterator.hasNext()) {
            IndexedValue indexedValue = (IndexedValue)iterator.next();
            idx = indexedValue.component1();
            Pair pair1 = (Pair)indexedValue.component2();
            NotebookOutputDataKey newDataKey = (NotebookOutputDataKey)pair1.component1();
            Pair pair2 = (Pair)pair1.component2();
            JComponent oldComponent = (JComponent)pair2.component1();
            NotebookOutputComponentFactory oldFactory = (NotebookOutputComponentFactory)pair2.component2();
            isFilled = (switch (WhenMappings.$EnumSwitchMapping$0[this.matchWithTypes(oldFactory, oldComponent, newDataKey).ordinal()]) {
                case 1 -> {
                    this.removeOutput(idx);
                    NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(newDataKey);
                    if (newComponent != null) {
                        this.addIntoInnerComponent(newComponent, idx);
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    Intrinsics.checkNotNull((Object)oldFactory, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactory<javax.swing.JComponent, org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKey>");
                    oldFactory.updateComponent(this.editor, oldComponent, newDataKey);
                    Container $this$asSafely$iv = oldComponent.getParent();
                    boolean $i$f$asSafely = false;
                    Container v1 = $this$asSafely$iv;
                    if (!(v1 instanceof CollapsingComponent)) {
                        v1 = null;
                    }
                    CollapsingComponent v2 = (CollapsingComponent)v1;
                    if (v2 != null) {
                        v2.updateStubIfCollapsed();
                    }
                    yield true;
                }
                case 3 -> true;
                default -> throw new NoWhenBranchMatchedException();
            }) || isFilled;
        }
        iterator = oldComponentsWithFactories;
        while (iterator.hasNext()) {
            Pair<JComponent, NotebookOutputComponentFactory<?, ?>> ignored = iterator.next();
            idx = this.innerComponent.getComponentCount() - 1;
            this.removeOutput(idx);
        }
        iterator = newDataKeyIterator;
        while (iterator.hasNext()) {
            NotebookOutputDataKey outputDataKey = (NotebookOutputDataKey)iterator.next();
            NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(outputDataKey);
            if (newComponent == null) continue;
            isFilled = true;
            EditorCellOutputs.addIntoInnerComponent$default(this, newComponent, 0, 2, null);
        }
        return isFilled;
    }

    private final void removeOutput(int idx) {
        this.innerComponent.remove(idx);
        EditorCellOutput outputComponent = this._outputs.remove(idx);
        outputComponent.dispose();
        this.remove(outputComponent);
    }

    private final <K extends NotebookOutputDataKey> NotebookOutputComponentFactory.CreatedComponent<?> createOutputGuessingFactory(K outputDataKey) {
        return (NotebookOutputComponentFactory.CreatedComponent)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)NotebookOutputComponentFactoryGetter.Companion.getInstance().getList()), (Function1)new Function1<NotebookOutputComponentFactory<?, ?>, Boolean>(outputDataKey){
            final /* synthetic */ K $outputDataKey;
            {
                this.$outputDataKey = $outputDataKey;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NotebookOutputComponentFactory<?, ?> factory) {
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                return factory.getOutputDataKeyClass().isAssignableFrom(this.$outputDataKey.getClass());
            }
        }), (Function1)new Function1<NotebookOutputComponentFactory<?, ?>, NotebookOutputComponentFactory.CreatedComponent<?>>(this, outputDataKey){
            final /* synthetic */ EditorCellOutputs this$0;
            final /* synthetic */ K $outputDataKey;
            {
                this.this$0 = $receiver;
                this.$outputDataKey = $outputDataKey;
                super(1);
            }

            @Nullable
            public final NotebookOutputComponentFactory.CreatedComponent<?> invoke(@NotNull NotebookOutputComponentFactory<?, ?> factory) {
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                return EditorCellOutputs.access$createOutput(this.this$0, factory, this.$outputDataKey);
            }
        }));
    }

    private final <K extends NotebookOutputDataKey> NotebookOutputComponentFactory.CreatedComponent<?> createOutput(NotebookOutputComponentFactory<?, K> factory, K outputDataKey) {
        NotebookOutputComponentFactory.CreatedComponent<?> result;
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent;
        IntRange lines = ((NotebookCellLines.Interval)this.interval.invoke()).getLines();
        ((OutputListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookOutputInlayControllerKt.getOUTPUT_LISTENER())).beforeOutputCreated((Editor)this.editor, lines.getLast());
        try {
            createdComponent = factory.createComponent(this.editor, outputDataKey);
        }
        catch (Throwable t) {
            EditorCellOutputs $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditorCellOutputs.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at .createComponent()", t);
            createdComponent = null;
        }
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent2 = result = createdComponent;
        if (createdComponent2 != null) {
            NotebookOutputComponentFactory.CreatedComponent<?> it = createdComponent = createdComponent2;
            boolean bl = false;
            Object component = it.getComponent();
            EditorCellOutputsKt.access$setOutputComponentFactory(component, factory);
            NotebookOutputComponentFactory.Companion.setGutterPainter$intellij_notebooks_visualization((JComponent)component, it.getGutterPainter());
            Disposable disposable = it.getDisposable();
            if (disposable != null) {
                Disposer.register((Disposable)this.editor.getDisposable(), (Disposable)disposable);
            }
        }
        ((OutputListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookOutputInlayControllerKt.getOUTPUT_LISTENER())).outputCreated((Editor)this.editor, lines.getLast());
        return result;
    }

    private final List<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> getComponentsWithFactories() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        for (JComponent component : this.innerComponent.getMainComponents()) {
            NotebookOutputComponentFactory factory = EditorCellOutputsKt.access$getOutputComponentFactory(component);
            if (factory == null) continue;
            ((Collection)it).add(TuplesKt.to((Object)component, (Object)factory));
        }
        return list;
    }

    private final <C extends JComponent, K extends NotebookOutputDataKey> NotebookOutputComponentFactory.Match matchWithTypes(NotebookOutputComponentFactory<C, K> $this$matchWithTypes, JComponent component, NotebookOutputDataKey outputDataKey) {
        NotebookOutputComponentFactory.Match match;
        if (!$this$matchWithTypes.getComponentClass().isAssignableFrom(component.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else if (!$this$matchWithTypes.getOutputDataKeyClass().isAssignableFrom(outputDataKey.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else {
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type C of org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutputs.matchWithTypes");
            Intrinsics.checkNotNull((Object)outputDataKey, (String)"null cannot be cast to non-null type K of org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutputs.matchWithTypes");
            match = $this$matchWithTypes.match(component, outputDataKey);
        }
        return match;
    }

    private final Inlay<?> createInlay() {
        Inlay inlay;
        EditorEx editorEx = (EditorEx)this.editor;
        JComponent jComponent = this.outerComponent;
        int n = NotebookUtilKt.getNotebookAppearance((Editor)((Editor)this.editor)).getNOTEBOOK_OUTPUT_INLAY_PRIORITY();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        Inlay inlay2 = inlay = NotebookEditorUiUtilKt.addComponentInlay$default(editorEx, jComponent, true, false, false, n, this.computeInlayOffset((Document)documentEx, ((NotebookCellLines.Interval)this.interval.invoke()).getLines()), null, 72, null);
        boolean bl = false;
        EditorCustomElementRenderer $this$asSafely$iv = inlay2.getRenderer();
        boolean $i$f$asSafely = false;
        EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
        if (!(editorCustomElementRenderer instanceof JComponent)) {
            editorCustomElementRenderer = null;
        }
        JComponent jComponent2 = (JComponent)editorCustomElementRenderer;
        if (jComponent2 != null) {
            jComponent2.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ EditorCellOutputs this$0;
                {
                    this.this$0 = $receiver;
                }

                private final void update() {
                    this.this$0.invalidate();
                    Iterable $this$forEach$iv = this.this$0.getOutputs();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        EditorCellOutput it = (EditorCellOutput)element$iv;
                        boolean bl = false;
                        it.getFolding().updateBounds();
                    }
                }

                public void componentResized(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.update();
                }

                public void componentMoved(@Nullable ComponentEvent e) {
                    this.update();
                }
            });
        }
        Disposer.register((Disposable)((Disposable)inlay2), () -> EditorCellOutputs.createInlay$lambda$11$lambda$10(this));
        return inlay;
    }

    private final int computeInlayOffset(Document document, IntRange lines) {
        return document.getLineEndOffset(lines.getLast());
    }

    private final void addIntoInnerComponent(NotebookOutputComponentFactory.CreatedComponent<?> newComponent, int pos) {
        EditorCellOutput editorCellOutput;
        CollapsingComponent collapsingComponent = new CollapsingComponent(this.editor, (JComponent)newComponent.getComponent(), newComponent.getResizable(), newComponent.getCollapsedTextSupplier());
        this.innerComponent.add(collapsingComponent, new InnerComponent.Constraint(newComponent.getWidthStretching(), newComponent.getLimitHeight()), pos);
        EditorCellOutput $this$addIntoInnerComponent_u24lambda_u2412 = editorCellOutput = new EditorCellOutput((EditorEx)this.editor, collapsingComponent, newComponent.getDisposable());
        boolean bl = false;
        $this$addIntoInnerComponent_u24lambda_u2412.getFolding().setVisible(this.foldingsVisible);
        $this$addIntoInnerComponent_u24lambda_u2412.getFolding().setSelected(this.foldingsSelected);
        EditorCellOutput outputComponent = editorCellOutput;
        this._outputs.add(pos == -1 ? this._outputs.size() : pos, outputComponent);
        this.add(outputComponent);
        ((JComponent)newComponent.getComponent()).revalidate();
    }

    static /* synthetic */ void addIntoInnerComponent$default(EditorCellOutputs editorCellOutputs, NotebookOutputComponentFactory.CreatedComponent createdComponent, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        editorCellOutputs.addIntoInnerComponent(createdComponent, n);
    }

    private final <A, B> Iterator<Pair<A, B>> zip(Iterator<? extends A> $this$zip, Iterator<? extends B> other) {
        return new Iterator<Pair<? extends A, ? extends B>>($this$zip, other){
            final /* synthetic */ Iterator<A> $this_zip;
            final /* synthetic */ Iterator<B> $other;
            {
                this.$this_zip = $receiver;
                this.$other = $other;
            }

            public boolean hasNext() {
                return this.$this_zip.hasNext() && this.$other.hasNext();
            }

            @NotNull
            public Pair<A, B> next() {
                return TuplesKt.to(this.$this_zip.next(), this.$other.next());
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Integer n = NotebookEditorUiUtilKt.yOffsetFromEditor(this.innerComponent, (Editor)editor);
        if (n == null) {
            return;
        }
        int yOffset = n;
        Rectangle oldClip = g.getClipBounds();
        Graphics $this$use$iv = g.create();
        boolean $i$f$use = false;
        try {
            Graphics g2 = $this$use$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D cfr_ignored_0 = (Graphics2D)g2;
            ((Graphics2D)g2).clip(new Rectangle(oldClip.x, yOffset, oldClip.width, this.innerComponent.getHeight()).intersection(oldClip));
            Iterable $this$forEach$iv = this.getOutputs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCellOutput it = (EditorCellOutput)element$iv;
                boolean bl2 = false;
                it.paintGutter(editor, yOffset, g2, r);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$use$iv.dispose();
        }
    }

    private static final void createInlay$lambda$11$lambda$10(EditorCellOutputs this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onInlayDisposed.invoke((Object)this$0);
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(EditorCellOutputs $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Function0 access$getInterval$p(EditorCellOutputs $this) {
        return $this.interval;
    }

    public static final /* synthetic */ NotebookOutputComponentFactory.CreatedComponent access$createOutput(EditorCellOutputs $this, NotebookOutputComponentFactory factory, NotebookOutputDataKey outputDataKey) {
        return $this.createOutput(factory, outputDataKey);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookOutputComponentFactory.Match.values().length];
            try {
                nArray[NotebookOutputComponentFactory.Match.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.COMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

