/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorRunCellGutterIconRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellRunButton;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "cellRangeHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "dispose", "", "hideRunButton", "showRunButton", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "intellij.notebooks.visualization"})
public final class EditorCellRunButton {
    @NotNull
    private final EditorEx editor;
    @Nullable
    private RangeHighlighter cellRangeHighlighter;

    public EditorCellRunButton(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    public final void showRunButton(@NotNull NotebookCellLines.Interval interval) {
        int sourceEndOffset;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        if (this.editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        this.hideRunButton();
        if (interval.getType() != NotebookCellLines.CellType.CODE) {
            return;
        }
        IntRange linesRange = interval.getLines();
        int sourceStartOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getFirst());
        if (sourceStartOffset + 1 == (sourceEndOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast()))) {
            return;
        }
        RangeHighlighter rangeHighlighter = this.cellRangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(sourceStartOffset, sourceEndOffset, 5001, null, HighlighterTargetArea.LINES_IN_RANGE);
        if (rangeHighlighter != null) {
            rangeHighlighter.setGutterIconRenderer((GutterIconRenderer)new EditorRunCellGutterIconRenderer(linesRange));
        }
    }

    public final void hideRunButton() {
        block0: {
            RangeHighlighter rangeHighlighter = this.cellRangeHighlighter;
            if (rangeHighlighter == null) break block0;
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
            this.cellRangeHighlighter = null;
        }
    }

    public final void dispose() {
        this.hideRunButton();
    }
}

