/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.MarkdownInlayRenderingController;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayManager;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.ui.ControllerEditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCell;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellInput;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellOutputs;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellView;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.NotebookCellHighlighterRenderer;
import org.jetbrains.plugins.notebooks.visualization.ui.TextEditorCellViewComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0003hijB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001509J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u001aH\u0002J\u0006\u0010=\u001a\u000207J\u0010\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020\u000eH\u0002J\b\u0010@\u001a\u000207H\u0016J\b\u0010A\u001a\u000207H\u0016J\u0006\u0010B\u001a\u000207J6\u0010C\u001a\u0004\u0018\u00010\u000e2\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0003\u001a\u00020F2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001e0IH\u0002J\u001c\u0010J\u001a\u0004\u0018\u0001HK\"\n\b\u0000\u0010K\u0018\u0001*\u00020LH\u0086\b\u00a2\u0006\u0002\u0010MJ%\u0010J\u001a\u0004\u0018\u0001HK\"\b\b\u0000\u0010K*\u00020L2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002HK0O\u00a2\u0006\u0002\u0010PJ\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020E0RH\u0002J\b\u0010S\u001a\u00020(H\u0002J\u0006\u0010T\u001a\u000207J\u0006\u0010U\u001a\u000207J\u0006\u0010V\u001a\u000207J\u0006\u0010W\u001a\u000207J\b\u0010X\u001a\u000207H\u0002J\b\u0010Y\u001a\u000207H\u0002J\u000e\u0010Z\u001a\u0002072\u0006\u0010[\u001a\u00020\\J\u0010\u0010]\u001a\u0002072\b\b\u0002\u0010^\u001a\u00020(J\u0006\u0010_\u001a\u000207J\b\u0010`\u001a\u000207H\u0002J\u0012\u0010a\u001a\u0002072\b\b\u0002\u0010^\u001a\u00020(H\u0002J\b\u0010b\u001a\u000207H\u0002J\u0006\u0010c\u001a\u000207J\r\u0010d\u001a\u000207H\u0000\u00a2\u0006\u0002\beJ\b\u0010f\u001a\u000207H\u0002J\u000e\u0010g\u001a\u0002072\u0006\u0010.\u001a\u00020(R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010+\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R$\u0010/\u001a\u00020(2\u0006\u0010.\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u00104\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b5\u00101\u00a8\u0006k"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intervals", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;", "cell", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;", "cellInlayManager", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;)V", "_controllers", "", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController;", "getCell$intellij_notebooks_visualization", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;", "setCell$intellij_notebooks_visualization", "(Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;)V", "cellHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "controllers", "getControllers", "()Ljava/util/List;", "input", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellInput;", "getInput", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellInput;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "intervalPointer", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "getIntervalPointer", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "lastHighLightersOffsets", "Lkotlin/ranges/IntRange;", "mouseOver", "", "<set-?>", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutputs;", "outputs", "getOutputs", "()Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellOutputs;", "value", "selected", "getSelected", "()Z", "setSelected", "(Z)V", "shouldUpdateFolding", "getShouldUpdateFolding", "addCellHighlighter", "", "provider", "Lkotlin/Function0;", "calculateBounds", "Ljava/awt/Rectangle;", "createEditorCellInput", "disableMarkdownRenderingIfEnabled", "disposeController", "controller", "doDispose", "doInvalidate", "enableMarkdownRenderingIfNeeded", "failSafeCompute", "factory", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;", "Lcom/intellij/openapi/editor/Editor;", "", "intervalIterator", "", "getExtension", "T", "", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "getInputFactories", "Lkotlin/sequences/Sequence;", "hasOutputs", "mouseEntered", "mouseExited", "onViewportChanges", "postInitInlays", "recreateControllers", "removeCellHighlight", "setGutterAction", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "update", "force", "updateCellFolding", "updateCellHighlight", "updateControllers", "updateFolding", "updateInput", "updateOutputs", "updateOutputs$intellij_notebooks_visualization", "updateRunButton", "updateSelection", "Companion", "NotebookCellDataProvider", "NotebookGutterLineMarkerRenderer", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellView.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,499:1\n1#2:500\n1#2:521\n1855#3,2:501\n1855#3,2:503\n766#3:508\n857#3,2:509\n1603#3,9:511\n1855#3:520\n1856#3:522\n1612#3:523\n1855#3,2:524\n288#3,2:527\n1855#3,2:529\n800#3,11:531\n1747#3,3:542\n1855#3,2:545\n14#4:505\n14#4:506\n23#5:507\n23#5:526\n*S KotlinDebug\n*F\n+ 1 EditorCellView.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView\n*L\n160#1:521\n110#1:501,2\n117#1:503,2\n157#1:508\n157#1:509,2\n160#1:511,9\n160#1:520\n160#1:522\n160#1:523\n166#1:524,2\n248#1:527,2\n257#1:529,2\n346#1:531,11\n418#1:542,3\n421#1:545,2\n127#1:505\n140#1:506\n143#1:507\n216#1:526\n*E\n"})
public final class EditorCellView
extends EditorCellViewComponent
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final NotebookCellLines intervals;
    @NotNull
    private EditorCell cell;
    @NotNull
    private final NotebookCellInlayManager cellInlayManager;
    @NotNull
    private List<? extends NotebookCellInlayController> _controllers;
    @NotNull
    private final List<RangeHighlighter> cellHighlighters;
    @NotNull
    private final EditorCellInput input;
    @Nullable
    private EditorCellOutputs outputs;
    private boolean selected;
    private boolean mouseOver;
    @Nullable
    private IntRange lastHighLightersOffsets;
    @NotNull
    private static final Key<Boolean> WAS_FOLDED_IN_RENDERED_STATE_KEY = new Key("jupyter.markdown.folding.was.rendered");

    public EditorCellView(@NotNull EditorImpl editor, @NotNull NotebookCellLines intervals, @NotNull EditorCell cell, @NotNull NotebookCellInlayManager cellInlayManager) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)intervals, (String)"intervals");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellInlayManager, (String)"cellInlayManager");
        this.editor = editor;
        this.intervals = intervals;
        this.cell = cell;
        this.cellInlayManager = cellInlayManager;
        this._controllers = CollectionsKt.emptyList();
        this.cellHighlighters = new ArrayList();
        this.input = this.createEditorCellInput();
        this.recreateControllers();
        this.updateSelection(false);
    }

    @NotNull
    public final EditorCell getCell$intellij_notebooks_visualization() {
        return this.cell;
    }

    public final void setCell$intellij_notebooks_visualization(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"<set-?>");
        this.cell = editorCell;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<NotebookCellInlayController> getControllers() {
        Iterable iterable;
        Collection collection = this._controllers;
        EditorCellViewComponent editorCellViewComponent = this.input.getComponent();
        Object object = editorCellViewComponent instanceof ControllerEditorCellViewComponent ? (ControllerEditorCellViewComponent)editorCellViewComponent : null;
        if (object != null && (object = ((ControllerEditorCellViewComponent)object).getController$intellij_notebooks_visualization()) != null) {
            void it;
            Object object2 = object;
            Collection collection2 = collection;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)it);
            collection = collection2;
            object = list;
            if (list != null) {
                iterable = (Iterable)object;
                return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
            }
        }
        iterable = CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
    }

    private final NotebookIntervalPointer getIntervalPointer() {
        return this.cell.getIntervalPointer$intellij_notebooks_visualization();
    }

    private final NotebookCellLines.Interval getInterval() {
        NotebookCellLines.Interval interval = this.getIntervalPointer().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        return interval;
    }

    @NotNull
    public final EditorCellInput getInput() {
        return this.input;
    }

    @Nullable
    public final EditorCellOutputs getOutputs() {
        return this.outputs;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selected = value;
        this.updateFolding();
        this.updateRunButton();
        this.updateCellHighlight();
    }

    private final EditorCellInput createEditorCellInput() {
        EditorCellInput editorCellInput;
        EditorCellInput it = editorCellInput = new EditorCellInput((EditorEx)this.editor, (Function2<? super EditorCellInput, ? super EditorCellViewComponent, ? extends EditorCellViewComponent>)((Function2)new Function2<EditorCellInput, EditorCellViewComponent, EditorCellViewComponent>(this){
            final /* synthetic */ EditorCellView this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final EditorCellViewComponent invoke(@NotNull EditorCellInput parent, @Nullable EditorCellViewComponent currentComponent) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    v0 = currentComponent instanceof ControllerEditorCellViewComponent != false ? (ControllerEditorCellViewComponent)currentComponent : null;
                    currentController = v0 != null ? v0.getController$intellij_notebooks_visualization() : null;
                    var5_4 = EditorCellView.access$getInputFactories(this.this$0);
                    var6_5 = this.this$0;
                    for (NotebookCellInlayController.Factory factory : var5_4) {
                        $i$a$-firstNotNullOfOrNull-EditorCellView$createEditorCellInput$1$controller$1 = false;
                        v1 = var6_5;
                        v2 = factory;
                        v3 = (Editor)EditorCellView.access$getEditor$p(var6_5);
                        v4 = currentController;
                        if (v4 == null) ** GOTO lbl-1000
                        var10_9 = v4;
                        var11_10 = v3;
                        var12_11 = v2;
                        var13_12 = v1;
                        $i$a$-let-EditorCellView$createEditorCellInput$1$controller$1$1 = false;
                        var15_14 = CollectionsKt.listOf((Object)it);
                        v1 = var13_12;
                        v2 = var12_11;
                        v3 = var11_10;
                        v5 = var15_14;
                        v4 = v5;
                        if (v5 != null) {
                            v6 = (Collection)v4;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = CollectionsKt.emptyList();
                        }
                        if ((var8_7 = EditorCellView.access$failSafeCompute(v1, v2, v3, v6, EditorCellView.access$getIntervals$p(var6_5).getIntervals().listIterator(EditorCellView.access$getInterval(var6_5).getOrdinal()))) == null) continue;
                        v7 = var8_7;
                        break block3;
                    }
                    v7 = controller = null;
                }
                return controller != null ? (EditorCellViewComponent)(Intrinsics.areEqual(controller, (Object)currentController) != false ? (ControllerEditorCellViewComponent)currentComponent : new ControllerEditorCellViewComponent(controller, parent)) : (EditorCellViewComponent)(currentComponent instanceof TextEditorCellViewComponent != false ? (TextEditorCellViewComponent)currentComponent : new TextEditorCellViewComponent((EditorEx)EditorCellView.access$getEditor$p(this.this$0), this.this$0.getCell$intellij_notebooks_visualization()));
            }
        }), this.cell);
        boolean bl = false;
        this.add(it);
        return editorCellInput;
    }

    public final void postInitInlays() {
        Iterable $this$forEach$iv = this._controllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            EditorCustomElementRenderer editorCustomElementRenderer = it.getInlay().getRenderer();
            JPanel jPanel = editorCustomElementRenderer instanceof JPanel ? (JPanel)editorCustomElementRenderer : null;
            if (jPanel == null) continue;
            jPanel.validate();
        }
        EditorCellView.updateControllers$default(this, false, 1, null);
    }

    @Override
    public void doDispose() {
        Iterable $this$forEach$iv = this._controllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController controller = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            this.disposeController(controller);
        }
        this.input.dispose();
        EditorCellOutputs editorCellOutputs = this.outputs;
        if (editorCellOutputs != null) {
            EditorCellOutputs it = editorCellOutputs;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.removeCellHighlight();
    }

    private final void disposeController(NotebookCellInlayController controller) {
        Inlay<?> inlay = controller.getInlay();
        EditorCustomElementRenderer $this$asSafely$iv = inlay.getRenderer();
        boolean $i$f$asSafely = false;
        EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
        if (!(editorCustomElementRenderer instanceof JComponent)) {
            editorCustomElementRenderer = null;
        }
        JComponent jComponent = (JComponent)editorCustomElementRenderer;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            DataManager.removeDataProvider((JComponent)it);
        }
        Disposer.dispose((Disposable)((Disposable)inlay));
    }

    public final void update(boolean force) {
        this.recreateControllers();
        this.updateControllers(force);
    }

    public static /* synthetic */ void update$default(EditorCellView editorCellView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        editorCellView.update(bl);
    }

    private final void updateControllers(boolean force) {
        for (NotebookCellInlayController controller : this.getControllers()) {
            JComponent component;
            Inlay<?> inlay = controller.getInlay();
            EditorCustomElementRenderer $this$asSafely$iv = inlay.getRenderer();
            boolean $i$f$asSafely = false;
            EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
            if (!(editorCustomElementRenderer instanceof JComponent)) {
                editorCustomElementRenderer = null;
            }
            if ((JComponent)editorCustomElementRenderer == null) continue;
            boolean bl = false;
            DataProvider oldProvider = DataManager.getDataProvider((JComponent)component);
            if (oldProvider != null && !(oldProvider instanceof NotebookCellDataProvider)) {
                EditorCellView $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(EditorCellView.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Overwriting an existing CLIENT_PROPERTY_DATA_PROVIDER. Old provider: " + oldProvider);
            }
            DataManager.removeDataProvider((JComponent)component);
            DataManager.registerDataProvider((JComponent)component, (DataProvider)new NotebookCellDataProvider((Editor)this.editor, component, (Function0<NotebookCellLines.Interval>)((Function0)new Function0<NotebookCellLines.Interval>(this){
                final /* synthetic */ EditorCellView this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final NotebookCellLines.Interval invoke() {
                    return EditorCellView.access$getInterval(this.this$0);
                }
            })));
        }
        this.input.update(force);
        this.updateOutputs$intellij_notebooks_visualization();
        this.updateCellHighlight();
        this.invalidate();
    }

    static /* synthetic */ void updateControllers$default(EditorCellView editorCellView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        editorCellView.updateControllers(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void recreateControllers() {
        List list;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotebookCellInlayController.Factory it = (NotebookCellInlayController.Factory)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof NotebookCellInlayController.InputFactory))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherFactories = (List)destination$iv$iv;
        Set controllersToDispose = CollectionsKt.toMutableSet((Iterable)this._controllers);
        EditorCellView editorCellView = this;
        if (!this.editor.isDisposed()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $i$f$filter2 = otherFactories;
            EditorCellView editorCellView2 = editorCellView;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NotebookCellInlayController it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                NotebookCellInlayController.Factory factory = (NotebookCellInlayController.Factory)element$iv$iv;
                boolean bl2 = false;
                if (this.failSafeCompute(factory, (Editor)this.editor, (Collection<? extends NotebookCellInlayController>)this._controllers, this.intervals.getIntervals().listIterator(this.getInterval().getOrdinal())) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
            editorCellView = editorCellView2;
        } else {
            list = CollectionsKt.emptyList();
        }
        editorCellView._controllers = list;
        controllersToDispose.removeAll(CollectionsKt.toSet((Iterable)this._controllers));
        Iterable $this$forEach$iv = controllersToDispose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            this.disposeController(it);
        }
    }

    public final void updateInput() {
        this.updateCellHighlight();
        EditorCellInput.updateInput$default(this.input, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateOutputs$intellij_notebooks_visualization() {
        if (this.hasOutputs()) {
            if (this.outputs == null) {
                void it;
                EditorCellOutputs editorCellOutputs;
                EditorCellOutputs editorCellOutputs2 = editorCellOutputs = new EditorCellOutputs(this.editor, (Function0)new Function0<NotebookCellLines.Interval>(this){
                    final /* synthetic */ EditorCellView this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final NotebookCellLines.Interval invoke() {
                        return EditorCellView.access$getInterval(this.this$0);
                    }
                }, null, 4, null);
                EditorCellView editorCellView = this;
                boolean bl = false;
                Disposer.register((Disposable)this, (Disposable)((Disposable)it));
                this.add((EditorCellViewComponent)it);
                editorCellView.outputs = editorCellOutputs;
                this.updateCellHighlight();
                this.updateFolding();
            } else {
                EditorCellOutputs editorCellOutputs = this.outputs;
                if (editorCellOutputs != null) {
                    editorCellOutputs.update();
                }
            }
        } else {
            EditorCellOutputs editorCellOutputs = this.outputs;
            if (editorCellOutputs != null) {
                EditorCellOutputs it = editorCellOutputs;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
                this.remove(it);
            }
            this.outputs = null;
        }
    }

    private final boolean hasOutputs() {
        return this.getInterval().getType() == NotebookCellLines.CellType.CODE && (this.editor.getEditorKind() != EditorKind.DIFF || Registry.is((String)"jupyter.diff.viewer.output"));
    }

    private final Sequence<NotebookCellInlayController.Factory> getInputFactories() {
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)NotebookCellInlayController.Factory.EP_NAME.getExtensionList()), (Function1)getInputFactories.1.INSTANCE);
    }

    private final NotebookCellInlayController failSafeCompute(NotebookCellInlayController.Factory factory, Editor editor, Collection<? extends NotebookCellInlayController> controllers, ListIterator<NotebookCellLines.Interval> intervalIterator) {
        try {
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            return factory.compute((EditorImpl)editor, controllers, intervalIterator);
        }
        catch (Throwable t) {
            EditorCellView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EditorCellView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at NotebookCellInlayController.Factory.compute(...)", t);
            return null;
        }
    }

    public final void onViewportChanges() {
        block0: {
            this.input.onViewportChange();
            EditorCellOutputs editorCellOutputs = this.outputs;
            if (editorCellOutputs == null) break block0;
            editorCellOutputs.onViewportChange();
        }
    }

    public final void setGutterAction(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.input.setGutterAction(action2);
    }

    public final void mouseExited() {
        this.mouseOver = false;
        this.updateFolding();
        this.updateRunButton();
    }

    public final void mouseEntered() {
        this.mouseOver = true;
        this.updateFolding();
        this.updateRunButton();
    }

    public final /* synthetic */ <T> T getExtension() {
        boolean $i$f$getExtension = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getExtension(Reflection.getOrCreateKotlinClass(Object.class));
    }

    @Nullable
    public final <T> T getExtension(@NotNull KClass<T> type) {
        Object v1;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Iterable $this$firstOrNull$iv = this.getControllers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
                boolean bl = false;
                if (!type.isInstance((Object)it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = v1 = null;
        }
        if (v0 == null) {
            v1 = null;
        }
        return v1;
    }

    public final void addCellHighlighter(@NotNull Function0<? extends RangeHighlighter> provider2) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        RangeHighlighter highlighter = (RangeHighlighter)provider2.invoke();
        this.cellHighlighters.add(highlighter);
    }

    private final void removeCellHighlight() {
        Iterable $this$forEach$iv = this.cellHighlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.cellHighlighters.clear();
    }

    private final void updateCellHighlight() {
        NotebookCellLines.Interval interval = this.getIntervalPointer().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        NotebookCellLines.Interval interval2 = interval;
        int startOffset = this.editor.getDocument().getLineStartOffset(interval2.getLines().getFirst());
        int endOffset = this.editor.getDocument().getLineEndOffset(interval2.getLines().getLast());
        IntRange range = new IntRange(startOffset, endOffset);
        if (Intrinsics.areEqual((Object)interval2.getLines(), (Object)this.lastHighLightersOffsets)) {
            return;
        }
        this.lastHighLightersOffsets = range;
        this.removeCellHighlight();
        this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)new Function0<RangeHighlighter>(this, startOffset, endOffset, interval2){
            final /* synthetic */ EditorCellView this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ NotebookCellLines.Interval $interval;
            {
                this.this$0 = $receiver;
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
                this.$interval = $interval;
                super(0);
            }

            @NotNull
            public final RangeHighlighter invoke() {
                RangeHighlighter rangeHighlighter = EditorCellView.access$getEditor$p(this.this$0).getMarkupModel().addRangeHighlighter(null, this.$startOffset, this.$endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE);
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                RangeHighlighter rangeHighlighter2 = rangeHighlighter;
                EditorCellView editorCellView = this.this$0;
                NotebookCellLines.Interval interval = this.$interval;
                RangeHighlighter $this$invoke_u24lambda_u240 = rangeHighlighter2;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setLineMarkerRenderer((LineMarkerRenderer)editorCellView.new NotebookGutterLineMarkerRenderer(interval));
                return rangeHighlighter2;
            }
        }));
        if (interval2.getType() == NotebookCellLines.CellType.CODE) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)new Function0<RangeHighlighter>(this, startOffset, endOffset){
                final /* synthetic */ EditorCellView this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final RangeHighlighter invoke() {
                    RangeHighlighter rangeHighlighter;
                    void $this$invoke_u24lambda_u240;
                    TextAttributes textAttributes = new TextAttributes();
                    EditorCellView editorCellView = this.this$0;
                    TextAttributes textAttributes2 = textAttributes;
                    int n = 900;
                    int n2 = this.$endOffset;
                    int n3 = this.$startOffset;
                    MarkupModelEx markupModelEx = EditorCellView.access$getEditor$p(this.this$0).getMarkupModel();
                    boolean bl = false;
                    NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance((Editor)((Editor)EditorCellView.access$getEditor$p(editorCellView)));
                    EditorColorsScheme editorColorsScheme = EditorCellView.access$getEditor$p(editorCellView).getColorsScheme();
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                    $this$invoke_u24lambda_u240.setBackgroundColor(notebookEditorAppearance.getCodeCellBackground(editorColorsScheme));
                    Unit unit = Unit.INSTANCE;
                    RangeHighlighter rangeHighlighter2 = markupModelEx.addRangeHighlighter(n3, n2, n, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
                    RangeHighlighter $this$invoke_u24lambda_u241 = rangeHighlighter = rangeHighlighter2;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241.setCustomRenderer((CustomHighlighterRenderer)NotebookCellHighlighterRenderer.INSTANCE);
                    return rangeHighlighter;
                }
            }));
        }
        if (interval2.getType() == NotebookCellLines.CellType.CODE && NotebookUtilKt.getNotebookAppearance((Editor)((Editor)this.editor)).shouldShowCellLineNumbers() && this.editor.getEditorKind() != EditorKind.DIFF) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)new Function0<RangeHighlighter>(this, startOffset, endOffset){
                final /* synthetic */ EditorCellView this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    super(0);
                }

                @NotNull
                public final RangeHighlighter invoke() {
                    RangeHighlighter rangeHighlighter = EditorCellView.access$getEditor$p(this.this$0).getMarkupModel().addRangeHighlighter(null, this.$startOffset, this.$endOffset, 901, HighlighterTargetArea.LINES_IN_RANGE);
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    return rangeHighlighter;
                }
            }));
        }
        if (interval2.getType() == NotebookCellLines.CellType.CODE) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)new Function0<RangeHighlighter>(this, startOffset, endOffset){
                final /* synthetic */ EditorCellView this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    super(0);
                }

                @NotNull
                public final RangeHighlighter invoke() {
                    RangeHighlighterEx rangeHighlighterEx = EditorCellView.access$getEditor$p(this.this$0).getMarkupModel().addRangeHighlighterAndChangeAttributes(null, this.$startOffset, this.$endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> updateCellHighlight.4.invoke$lambda$0(updateCellHighlight.1.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
                    return (RangeHighlighter)rangeHighlighterEx;
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }));
        } else if (this.editor.getEditorKind() != EditorKind.DIFF) {
            this.addCellHighlighter((Function0<? extends RangeHighlighter>)((Function0)new Function0<RangeHighlighter>(this, startOffset, endOffset){
                final /* synthetic */ EditorCellView this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    super(0);
                }

                @NotNull
                public final RangeHighlighter invoke() {
                    RangeHighlighterEx rangeHighlighterEx = EditorCellView.access$getEditor$p(this.this$0).getMarkupModel().addRangeHighlighterAndChangeAttributes(null, this.$startOffset, this.$endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> updateCellHighlight.5.invoke$lambda$0(updateCellHighlight.1.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
                    return (RangeHighlighter)rangeHighlighterEx;
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }));
        }
        for (NotebookCellInlayController controller : this.getControllers()) {
            controller.createGutterRendererLineMarker((EditorEx)this.editor, interval2, this);
        }
    }

    public final void updateSelection(boolean value) {
        this.setSelected(value);
        this.updateFolding();
        this.updateRunButton();
        this.updateCellHighlight();
    }

    /*
     * WARNING - void declaration
     */
    public final void disableMarkdownRenderingIfEnabled() {
        block2: {
            FoldRegion foldRegion;
            MarkdownInlayRenderingController markdownController;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getControllers();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MarkdownInlayRenderingController)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MarkdownInlayRenderingController markdownInlayRenderingController = markdownController = (MarkdownInlayRenderingController)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (markdownInlayRenderingController == null) break block2;
            MarkdownInlayRenderingController it = markdownInlayRenderingController;
            boolean bl = false;
            it.stopRendering();
            NotebookEditorModeKt.setMode((Editor)((Editor)this.editor), (NotebookEditorMode)NotebookEditorMode.EDIT);
            int startOffset = this.editor.getDocument().getLineStartOffset(this.getInterval().getLines().getFirst() + 1);
            int endOffset = this.editor.getDocument().getLineEndOffset(this.getInterval().getLines().getLast());
            FoldingModelImpl foldingModelImpl = this.editor.getFoldingModel();
            Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
            FoldingModelImpl foldingModel = foldingModelImpl;
            FoldRegion foldRegion2 = foldRegion = foldingModel.getFoldRegion(startOffset, endOffset);
            if (foldRegion2 != null) {
                FoldRegion it2 = foldRegion2;
                boolean bl2 = false;
                foldingModel.runBatchFoldingOperation(() -> EditorCellView.disableMarkdownRenderingIfEnabled$lambda$16$lambda$15$lambda$14(foldingModel, it2));
            }
            this.update(true);
            this.cell.putUserData(WAS_FOLDED_IN_RENDERED_STATE_KEY, true);
        }
    }

    public final void enableMarkdownRenderingIfNeeded() {
        if (this.cell.getUserData(WAS_FOLDED_IN_RENDERED_STATE_KEY) == null) {
            return;
        }
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        CaretModelImpl caretModelImpl = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"getCaretModel(...)");
        CaretModelImpl caretModel = caretModelImpl;
        int oldPosition = caretModel.getOffset();
        int startLine = this.cell.getInterval().getLines().getFirst();
        int startOffset = document.getLineEndOffset(startLine);
        caretModel.moveToOffset(startOffset);
        caretModel.moveToOffset(oldPosition);
        RemoveUserDataKt.removeUserData((UserDataHolder)this.cell, WAS_FOLDED_IN_RENDERED_STATE_KEY);
    }

    private final void updateFolding() {
        this.input.getFolding().setVisible(this.mouseOver || this.selected);
        this.input.getFolding().setSelected(this.selected);
        EditorCellOutputs editorCellOutputs = this.outputs;
        if (editorCellOutputs != null) {
            editorCellOutputs.setFoldingsVisible(this.mouseOver || this.selected);
        }
        EditorCellOutputs editorCellOutputs2 = this.outputs;
        if (editorCellOutputs2 != null) {
            editorCellOutputs2.setFoldingsSelected(this.selected);
        }
    }

    private final void updateRunButton() {
        if (this.mouseOver || this.selected) {
            this.input.showRunButton();
        } else {
            this.input.hideRunButton();
        }
    }

    @Override
    public void doInvalidate() {
        this.cellInlayManager.invalidateCells();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Rectangle calculateBounds() {
        inputBounds = this.input.calculateBounds();
        currentOutputs = this.outputs;
        v0 = 0;
        v1 = inputBounds.y;
        v2 = this.editor.getContentSize().width;
        if (currentOutputs == null || (var3_3 = currentOutputs.calculateBounds()) == null) ** GOTO lbl-1000
        var6_5 = var5_4 = var3_3;
        var11_6 = v2;
        var10_7 = v1;
        var9_8 = v0;
        $i$a$-takeIf-EditorCellView$calculateBounds$1 = false;
        var12_11 = it.isEmpty() == false ? 1 : 0;
        v0 = var9_8;
        v1 = var10_7;
        v2 = var11_6;
        v3 = var4_12 = var12_11 != 0 ? var5_4 : null;
        if (var4_12 != null) {
            $i$a$-takeIf-EditorCellView$calculateBounds$1 = var4_12;
            var11_6 = v2;
            var10_7 = v1;
            var9_8 = v0;
            $i$a$-let-EditorCellView$calculateBounds$2 = false;
            var12_11 = it.height + it.y - inputBounds.y;
            v0 = var9_8;
            v1 = var10_7;
            v2 = var11_6;
            v4 = var12_11;
        } else lbl-1000:
        // 2 sources

        {
            v4 = inputBounds.height;
        }
        var13_14 = v4;
        var14_15 = v2;
        var15_16 = v1;
        var16_17 = v0;
        return new Rectangle(var16_17, var15_16, var14_15, var13_14);
    }

    public final boolean getShouldUpdateFolding() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getControllers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
                    boolean bl2 = false;
                    if (!it.getShouldUpdateInlay()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void updateCellFolding() {
        Iterable $this$forEach$iv = this.getControllers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellInlayController it = (NotebookCellInlayController)element$iv;
            boolean bl = false;
            it.updateCellFolding();
        }
    }

    private static final void disableMarkdownRenderingIfEnabled$lambda$16$lambda$15$lambda$14(FoldingModelImpl $foldingModel, FoldRegion $it) {
        Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $foldingModel.removeFoldRegion($it);
    }

    public static final /* synthetic */ Sequence access$getInputFactories(EditorCellView $this) {
        return $this.getInputFactories();
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(EditorCellView $this) {
        return $this.editor;
    }

    public static final /* synthetic */ NotebookCellInlayController access$failSafeCompute(EditorCellView $this, NotebookCellInlayController.Factory factory, Editor editor, Collection controllers, ListIterator intervalIterator) {
        return $this.failSafeCompute(factory, editor, controllers, intervalIterator);
    }

    public static final /* synthetic */ NotebookCellLines access$getIntervals$p(EditorCellView $this) {
        return $this.intervals;
    }

    public static final /* synthetic */ NotebookCellLines.Interval access$getInterval(EditorCellView $this) {
        return $this.getInterval();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView$Companion;", "", "()V", "WAS_FOLDED_IN_RENDERED_STATE_KEY", "Lcom/intellij/openapi/util/Key;", "", "getWAS_FOLDED_IN_RENDERED_STATE_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getWAS_FOLDED_IN_RENDERED_STATE_KEY() {
            return WAS_FOLDED_IN_RENDERED_STATE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView$NotebookCellDataProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "editor", "Lcom/intellij/openapi/editor/Editor;", "component", "Ljavax/swing/JComponent;", "intervalProvider", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "(Lcom/intellij/openapi/editor/Editor;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "getComponent", "()Ljavax/swing/JComponent;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getIntervalProvider", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getData", "key", "", "hashCode", "", "toString", "intellij.notebooks.visualization"})
    public static final class NotebookCellDataProvider
    implements DataProvider {
        @NotNull
        private final Editor editor;
        @NotNull
        private final JComponent component;
        @NotNull
        private final Function0<NotebookCellLines.Interval> intervalProvider;

        public NotebookCellDataProvider(@NotNull Editor editor, @NotNull JComponent component, @NotNull Function0<NotebookCellLines.Interval> intervalProvider) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(intervalProvider, (String)"intervalProvider");
            this.editor = editor;
            this.component = component;
            this.intervalProvider = intervalProvider;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final Function0<NotebookCellLines.Interval> getIntervalProvider() {
            return this.intervalProvider;
        }

        @Nullable
        public Object getData(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = key;
            return Intrinsics.areEqual((Object)string, (Object)NotebookCellLinesKt.getNOTEBOOK_CELL_LINES_INTERVAL_DATA_KEY().getName()) ? this.intervalProvider.invoke() : (Intrinsics.areEqual((Object)string, (Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()) ? this.component : (Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.EDITOR.getName()) ? this.editor : null));
        }

        @NotNull
        public final Editor component1() {
            return this.editor;
        }

        @NotNull
        public final JComponent component2() {
            return this.component;
        }

        @NotNull
        public final Function0<NotebookCellLines.Interval> component3() {
            return this.intervalProvider;
        }

        @NotNull
        public final NotebookCellDataProvider copy(@NotNull Editor editor, @NotNull JComponent component, @NotNull Function0<NotebookCellLines.Interval> intervalProvider) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(intervalProvider, (String)"intervalProvider");
            return new NotebookCellDataProvider(editor, component, intervalProvider);
        }

        public static /* synthetic */ NotebookCellDataProvider copy$default(NotebookCellDataProvider notebookCellDataProvider, Editor editor, JComponent jComponent, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                editor = notebookCellDataProvider.editor;
            }
            if ((n & 2) != 0) {
                jComponent = notebookCellDataProvider.component;
            }
            if ((n & 4) != 0) {
                function0 = notebookCellDataProvider.intervalProvider;
            }
            return notebookCellDataProvider.copy(editor, jComponent, function0);
        }

        @NotNull
        public String toString() {
            return "NotebookCellDataProvider(editor=" + this.editor + ", component=" + this.component + ", intervalProvider=" + this.intervalProvider + ")";
        }

        public int hashCode() {
            int result = this.editor.hashCode();
            result = result * 31 + this.component.hashCode();
            result = result * 31 + this.intervalProvider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotebookCellDataProvider)) {
                return false;
            }
            NotebookCellDataProvider notebookCellDataProvider = (NotebookCellDataProvider)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)notebookCellDataProvider.editor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.component, (Object)notebookCellDataProvider.component)) {
                return false;
            }
            return Intrinsics.areEqual(this.intervalProvider, notebookCellDataProvider.intervalProvider);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView$NotebookGutterLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "(Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "paintBackground", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nEditorCellView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellView.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView$NotebookGutterLineMarkerRenderer\n+ 2 NotebookVisualizationUiUtil.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookVisualizationUiUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n22#2,2:500\n26#2,2:503\n1#3:502\n*S KotlinDebug\n*F\n+ 1 EditorCellView.kt\norg/jetbrains/plugins/notebooks/visualization/ui/EditorCellView$NotebookGutterLineMarkerRenderer\n*L\n428#1:500,2\n428#1:503,2\n*E\n"})
    public final class NotebookGutterLineMarkerRenderer
    extends NotebookLineMarkerRenderer {
        @NotNull
        private final NotebookCellLines.Interval interval;

        public NotebookGutterLineMarkerRenderer(NotebookCellLines.Interval interval) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            super(null, 1, null);
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            EditorImpl cfr_ignored_0 = (EditorImpl)editor;
            Graphics $this$use$iv = g.create();
            boolean $i$f$use = false;
            try {
                void $this$paint_u24lambda_u241_u24lambda_u240;
                Graphics g2 = $this$use$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D cfr_ignored_1 = (Graphics2D)g2;
                int visualLineStart = editor.xyToVisualPosition((Point)new Point((int)0, (int)((Graphics2D)g2).getClip().getBounds().y)).line;
                Rectangle rectangle = ((Graphics2D)g2).getClip().getBounds();
                int n = 0;
                Editor editor2 = editor;
                boolean bl2 = false;
                int n2 = $this$paint_u24lambda_u241_u24lambda_u240.y + $this$paint_u24lambda_u241_u24lambda_u240.height;
                int n3 = n2;
                int n4 = n;
                int visualLineEnd = editor2.xyToVisualPosition((Point)new Point((int)n4, (int)n3)).line;
                int logicalLineStart = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineStart, (int)0)).line;
                int logicalLineEnd = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineEnd, (int)0)).line;
                if (this.interval.getLines().getFirst() > logicalLineEnd || this.interval.getLines().getLast() < logicalLineStart) {
                    return;
                }
                this.paintBackground((EditorImpl)editor, g2, r, this.interval);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.dispose();
            }
        }

        private final void paintBackground(EditorImpl editor, Graphics g, Rectangle r, NotebookCellLines.Interval interval) {
            block1: {
                for (NotebookCellInlayController controller : EditorCellView.this.getControllers()) {
                    controller.paintGutter(editor, g, r, interval);
                }
                EditorCellOutputs editorCellOutputs = EditorCellView.this.getOutputs();
                if (editorCellOutputs == null) break block1;
                editorCellOutputs.paintGutter(editor, g, r);
            }
        }
    }
}

