/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/NestedScrollingSupport;", "", "()V", "asyncComponents", "", "Lkotlin/reflect/KClass;", "addNestedScrollingSupport", "Ljavax/swing/JLayer;", "Ljavax/swing/JComponent;", "view", "registerAsyncComponent", "", "type", "intellij.notebooks.visualization"})
public final class NestedScrollingSupport {
    @NotNull
    public static final NestedScrollingSupport INSTANCE = new NestedScrollingSupport();
    @NotNull
    private static final Set<KClass<?>> asyncComponents = new LinkedHashSet();

    private NestedScrollingSupport() {
    }

    public final void registerAsyncComponent(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        asyncComponents.add(type);
    }

    @NotNull
    public final JLayer<JComponent> addNestedScrollingSupport(@NotNull JComponent view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return new JLayer<Component>(view, (LayerUI)new LayerUI<JComponent>(){
            @Nullable
            private Component _currentMouseWheelOwner;
            private long timestamp;
            @Nullable
            private MouseEvent dispatchingEvent;

            private final Component getCurrentMouseWheelOwner() {
                return this.resetOwnerIfTimeoutExceeded();
            }

            private final void setCurrentMouseWheelOwner(Component value) {
                this._currentMouseWheelOwner = value;
            }

            public void installUI(@NotNull JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.installUI(c);
                ((JLayer)c).setLayerEventMask(131120L);
            }

            public void uninstallUI(@NotNull JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.uninstallUI(c);
                ((JLayer)c).setLayerEventMask(0L);
            }

            protected void processMouseWheelEvent(@NotNull MouseWheelEvent e, @NotNull JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(l, (String)"l");
                Component component = e.getComponent();
                if (this.isDispatchingInProgress()) {
                    if (!this.isNewEventCreated(e)) {
                        return;
                    }
                    if (this._currentMouseWheelOwner != null) {
                        e.consume();
                        return;
                    }
                }
                this.resetOwnerIfTimeoutExceeded();
                Component owner = this.resetOwnerIfEventIsOutside(e);
                if (owner != null) {
                    if (!Intrinsics.areEqual((Object)component, (Object)owner)) {
                        MouseEvent mouseEvent = SwingUtilities.convertMouseEvent(component, e, owner);
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"convertMouseEvent(...)");
                        this.redispatchEvent(mouseEvent);
                        e.consume();
                    } else {
                        this.dispatchEvent(e);
                    }
                }
            }

            private final boolean isNewEventCreated(MouseWheelEvent e) {
                return !Intrinsics.areEqual((Object)this.dispatchingEvent, (Object)e);
            }

            private final boolean isDispatchingInProgress() {
                return this.dispatchingEvent != null;
            }

            private final boolean isAsync(Component owner) {
                return NestedScrollingSupport.access$getAsyncComponents$p().contains(Reflection.getOrCreateKotlinClass(owner.getClass()));
            }

            private final void dispatchEvent(MouseEvent event) {
                Component owner = event.getComponent();
                Intrinsics.checkNotNull((Object)owner);
                if (!this.isAsync(owner)) {
                    this.dispatchEventSync(event, owner);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean dispatchEventSync(MouseEvent event, Component owner) {
                MouseEvent oldDispatchingEvent = this.dispatchingEvent;
                this.dispatchingEvent = event;
                try {
                    owner.dispatchEvent(event);
                    if (event.isConsumed() && this._currentMouseWheelOwner == null) {
                        this.updateOwner(owner);
                    } else {
                        this.updateOwner(this._currentMouseWheelOwner);
                    }
                    boolean bl = event.isConsumed();
                    return bl;
                }
                finally {
                    this.dispatchingEvent = oldDispatchingEvent;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean redispatchEvent(MouseEvent event) {
                MouseEvent oldDispatchingEvent = this.dispatchingEvent;
                this.dispatchingEvent = null;
                try {
                    Component owner = event.getComponent();
                    owner.dispatchEvent(event);
                    boolean bl = event.isConsumed();
                    return bl;
                }
                finally {
                    this.dispatchingEvent = oldDispatchingEvent;
                }
            }

            private final Component resetOwnerIfTimeoutExceeded() {
                Component component;
                Component currentOwner = this._currentMouseWheelOwner;
                if (currentOwner == null) {
                    return null;
                }
                long scrollOwnerTimeout = DurationKt.toDuration((int)Registry.intValue((String)"jupyter.editor.scroll.mousewheel.timeout", (int)250), (DurationUnit)DurationUnit.MILLISECONDS);
                if (this.isTimeoutExceeded(scrollOwnerTimeout)) {
                    this.resetOwner();
                    component = null;
                } else {
                    component = currentOwner;
                }
                return component;
            }

            private final Component resetOwnerIfEventIsOutside(MouseWheelEvent e) {
                Component component;
                Component currentOwner = this._currentMouseWheelOwner;
                if (currentOwner != null && this.isEventInsideOwner(currentOwner, e)) {
                    component = currentOwner;
                } else {
                    this.resetOwner();
                    component = e.getComponent();
                }
                return component;
            }

            private final boolean isEventInsideOwner(Component owner, MouseEvent e) {
                Component component = e.getComponent();
                if (component != null) {
                    Point p = SwingUtilities.convertPoint(component, e.getPoint(), owner);
                    return owner.contains(p);
                }
                return false;
            }

            private final boolean isTimeoutExceeded(long timeout) {
                return this.timestamp + (long)Duration.toInt-impl((long)timeout, (DurationUnit)DurationUnit.NANOSECONDS) < System.nanoTime();
            }

            private final void updateOwner(Component component) {
                if (component != null) {
                    this.replaceOwner(component);
                } else {
                    this.resetOwner();
                }
            }

            private final void replaceOwner(Component component) {
                this.setCurrentMouseWheelOwner(component);
                this.timestamp = System.nanoTime();
            }

            private final void resetOwner() {
                this.timestamp = 0L;
                this.setCurrentMouseWheelOwner(null);
            }

            protected void processMouseEvent(@NotNull MouseEvent e, @NotNull JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(l, (String)"l");
                if (e.getID() == 500 || e.getID() == 502 || e.getID() == 501) {
                    JScrollPane scrollPane = (JScrollPane)ComponentUtil.getParentOfType(JScrollPane.class, (Component)l.findComponentAt(e.getPoint()));
                    this.updateOwner(scrollPane);
                }
            }

            protected void processMouseMotionEvent(@NotNull MouseEvent e, @NotNull JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(l, (String)"l");
                Component owner = this.getCurrentMouseWheelOwner();
                if (owner != null) {
                    if (this.isTimeoutExceeded(DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)) && !this.isEventInsideOwner(owner, e)) {
                        this.resetOwner();
                    }
                }
            }
        });
    }

    public static final /* synthetic */ Set access$getAsyncComponents$p() {
        return asyncComponents;
    }
}

