/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.ui.ActionToGutterRendererAdapter;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCell;
import org.jetbrains.plugins.notebooks.visualization.ui.EditorCellViewComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.HasGutterIcon;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/ui/TextEditorCellViewComponent;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCellViewComponent;", "Lorg/jetbrains/plugins/notebooks/visualization/ui/HasGutterIcon;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "cell", "Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/notebooks/visualization/ui/EditorCell;)V", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "calculateBounds", "Ljava/awt/Rectangle;", "disposeExistingHighlighter", "", "doDispose", "updateGutterIcons", "gutterAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nTextEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorCellViewComponent.kt\norg/jetbrains/plugins/notebooks/visualization/ui/TextEditorCellViewComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1855#2,2:67\n*S KotlinDebug\n*F\n+ 1 TextEditorCellViewComponent.kt\norg/jetbrains/plugins/notebooks/visualization/ui/TextEditorCellViewComponent\n*L\n48#1:67,2\n*E\n"})
public final class TextEditorCellViewComponent
extends EditorCellViewComponent
implements HasGutterIcon {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private List<? extends RangeHighlighter> highlighters;

    public TextEditorCellViewComponent(@NotNull EditorEx editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.cell = cell;
    }

    private final NotebookCellLines.Interval getInterval() {
        NotebookCellLines.Interval interval = this.cell.getIntervalPointer$intellij_notebooks_visualization().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        return interval;
    }

    @Override
    public void updateGutterIcons(@Nullable AnAction gutterAction) {
        this.disposeExistingHighlighter();
        if (gutterAction != null) {
            MarkupModelEx markupModelEx = this.editor.getMarkupModel();
            Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
            MarkupModelEx markupModel = markupModelEx;
            NotebookCellLines.Interval interval = this.getInterval();
            int startOffset = this.editor.getDocument().getLineStartOffset(interval.getLines().getFirst());
            int endOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast());
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 900, new TextAttributes(), HighlighterTargetArea.LINES_IN_RANGE);
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
            RangeHighlighter highlighter = rangeHighlighter;
            highlighter.setGutterIconRenderer((GutterIconRenderer)new ActionToGutterRendererAdapter(gutterAction));
            this.highlighters = CollectionsKt.listOf((Object)highlighter);
        }
    }

    @Override
    public void doDispose() {
        this.disposeExistingHighlighter();
    }

    private final void disposeExistingHighlighter() {
        if (this.highlighters != null) {
            List<? extends RangeHighlighter> list = this.highlighters;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            this.highlighters = null;
        }
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        NotebookCellLines.Interval interval = this.getInterval();
        int startOffset = this.editor.getDocument().getLineStartOffset(interval.getLines().getFirst());
        Point point = this.editor.offsetToXY(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startLocation = point;
        int endOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast());
        Point point2 = this.editor.offsetToXY(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point endLocation = point2;
        int height = endLocation.y + this.editor.getLineHeight() - startLocation.y;
        int width = endLocation.x - startLocation.x;
        Dimension dimension = new Dimension(width, height);
        return new Rectangle(startLocation, dimension);
    }
}

