/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Objects;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;

interface ListModule {

    public static interface SplitAt {
        public static <T> Tuple2<List<T>, List<T>> splitByPredicateReversed(List<T> source, Predicate<? super T> predicate2) {
            Objects.requireNonNull(predicate2, "predicate is null");
            LinearSeq init2 = List.Nil.instance();
            LinearSeq<T> tail = source;
            while (!tail.isEmpty() && !predicate2.test(tail.head())) {
                init2 = init2.prepend(tail.head());
                tail = tail.tail();
            }
            return Tuple.of(init2, tail);
        }
    }

    public static interface Combinations {
        public static <T> List<List<T>> apply(List<T> elements2, int k) {
            if (k == 0) {
                return List.of(List.empty());
            }
            return elements2.zipWithIndex().flatMap(t -> Combinations.apply(elements2.drop((Long)t._2 + 1L), k - 1).map(c -> c.prepend(t._1)));
        }
    }
}

