/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.FirCallableSignatureKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BA\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010J\u0013\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature;", "", "receiverType", "", "contextReceiverTypes", "", "parameters", "typeParametersCount", "", "returnType", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILjava/lang/String;)V", "hasTheSameSignature", "", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "equals", "other", "hashCode", "Companion", "analysis-api-fir"})
public final class FirCallableSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String receiverType;
    @NotNull
    private final List<String> contextReceiverTypes;
    @Nullable
    private final List<String> parameters;
    private final int typeParametersCount;
    @NotNull
    private final String returnType;

    private FirCallableSignature(String receiverType2, List<String> contextReceiverTypes, List<String> parameters2, int typeParametersCount, String returnType2) {
        this.receiverType = receiverType2;
        this.contextReceiverTypes = contextReceiverTypes;
        this.parameters = parameters2;
        this.typeParametersCount = typeParametersCount;
        this.returnType = returnType2;
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableSymbol<?> declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        return this.hasTheSameSignature((FirCallableDeclaration)declaration2.getFir());
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableDeclaration declaration2) {
        Object parameter;
        int index;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (this.receiverType == null != (declaration2.getReceiverParameter() == null)) {
            return false;
        }
        if (this.contextReceiverTypes.size() != declaration2.getContextReceivers().size()) {
            return false;
        }
        if (this.typeParametersCount != declaration2.getTypeParameters().size()) {
            return false;
        }
        List<String> list2 = this.parameters;
        if (!Intrinsics.areEqual((Object)(list2 != null ? Integer.valueOf(list2.size()) : null), (object = declaration2 instanceof FirFunction ? (FirFunction)declaration2 : null) != null && (object = ((FirFunction)object).getValueParameters()) != null ? Integer.valueOf(object.size()) : null)) {
            return false;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(declaration2, FirResolvePhase.TYPES);
        FirPureAbstractElement firPureAbstractElement = declaration2.getReceiverParameter();
        if (!Intrinsics.areEqual((Object)this.receiverType, firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null)) {
            return false;
        }
        List<FirContextReceiver> receivers = declaration2.getContextReceivers();
        Iterator iterator2 = ((Iterable)this.contextReceiverTypes).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            index = n++;
            parameter = (String)iterator2.next();
            if (Intrinsics.areEqual((Object)FirCallableSignatureKt.renderType$default(receivers.get(index).getTypeRef(), null, 1, null), (Object)parameter)) continue;
            return false;
        }
        if (declaration2 instanceof FirFunction) {
            if (this.parameters == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            iterator2 = ((Iterable)((FirFunction)declaration2).getValueParameters()).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                index = n++;
                parameter = (FirValueParameter)iterator2.next();
                if (Intrinsics.areEqual((Object)this.parameters.get(index), (Object)FirCallableSignatureKt.renderType$default(((FirValueParameter)parameter).getReturnTypeRef(), null, 1, null))) continue;
                return false;
            }
        }
        return Intrinsics.areEqual((Object)this.returnType, (Object)FirCallableSignatureKt.renderType$default(declaration2.getSymbol().getResolvedReturnTypeRef(), null, 1, null));
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof FirCallableSignature)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiverType, (Object)((FirCallableSignature)other2).receiverType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contextReceiverTypes, ((FirCallableSignature)other2).contextReceiverTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parameters, ((FirCallableSignature)other2).parameters)) {
            return false;
        }
        if (this.typeParametersCount != ((FirCallableSignature)other2).typeParametersCount) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.returnType, (Object)((FirCallableSignature)other2).returnType);
    }

    public int hashCode() {
        String string = this.receiverType;
        int result2 = string != null ? string.hashCode() : 0;
        result2 = 31 * result2 + ((Object)this.contextReceiverTypes).hashCode();
        List<String> list2 = this.parameters;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        result2 = 31 * result2 + Integer.hashCode(this.typeParametersCount);
        result2 = 31 * result2 + this.returnType.hashCode();
        return result2;
    }

    public /* synthetic */ FirCallableSignature(String receiverType2, List contextReceiverTypes, List parameters2, int typeParametersCount, String returnType2, DefaultConstructorMarker $constructor_marker) {
        this(receiverType2, contextReceiverTypes, parameters2, typeParametersCount, returnType2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion;", "", "<init>", "()V", "createSignature", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature;", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nFirCallableSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallableSignature.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1557#2:124\n1628#2,3:125\n1557#2:128\n1628#2,3:129\n*S KotlinDebug\n*F\n+ 1 FirCallableSignature.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/FirCallableSignature$Companion\n*L\n86#1:124\n86#1:125,3\n88#1:128\n88#1:129,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableSymbol<?> callableSymbol) {
            Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
            return this.createSignature((FirCallableDeclaration)callableSymbol.getFir());
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableDeclaration callableDeclaration) {
            List list2;
            FirValueParameter it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)callableDeclaration, (String)"callableDeclaration");
            FirLazyDeclarationResolverKt.lazyResolveToPhase(callableDeclaration, FirResolvePhase.TYPES);
            Iterable iterable = callableDeclaration.getContextReceivers();
            FirPureAbstractElement firPureAbstractElement = callableDeclaration.getReceiverParameter();
            String string = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirContextReceiver firContextReceiver = (FirContextReceiver)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirCallableSignatureKt.renderType$default(((FirContextReceiver)((Object)it)).getTypeRef(), null, 1, null));
            }
            Collection collection2 = (List)destination$iv$iv;
            String string2 = string;
            if (callableDeclaration instanceof FirFunction) {
                Collection<String> collection3;
                $this$map$iv = ((FirFunction)callableDeclaration).getValueParameters();
                collection = collection2;
                string = string2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (FirValueParameter)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(FirCallableSignatureKt.renderType$default(it.getReturnTypeRef(), null, 1, null));
                }
                collection3 = (List)destination$iv$iv;
                string2 = string;
                collection2 = collection;
                list2 = collection3;
            } else {
                list2 = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string3 = FirCallableSignatureKt.renderType$default(callableDeclaration.getSymbol().getResolvedReturnTypeRef(), null, 1, null);
            int n = callableDeclaration.getTypeParameters().size();
            List list3 = list2;
            List list4 = collection2;
            String string4 = string2;
            return new FirCallableSignature(string4, list4, list3, n, string3, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

