/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirEnumEntrySymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol;", "ownerPointer", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;Lorg/jetbrains/kotlin/name/Name;)V", "restoreSymbol", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "enumEntryByName", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirEnumEntrySymbolPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirEnumEntrySymbolPointer.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirEnumEntrySymbolPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n295#2,2:49\n*S KotlinDebug\n*F\n+ 1 KaFirEnumEntrySymbolPointer.kt\norg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirEnumEntrySymbolPointer\n*L\n39#1:49,2\n*E\n"})
public final class KaFirEnumEntrySymbolPointer
extends KaSymbolPointer<KaEnumEntrySymbol> {
    @NotNull
    private final KaSymbolPointer<KaClassSymbol> ownerPointer;
    @NotNull
    private final Name name;

    public KaFirEnumEntrySymbolPointer(@NotNull KaSymbolPointer<? extends KaClassSymbol> ownerPointer, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(ownerPointer, (String)"ownerPointer");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.ownerPointer = ownerPointer;
        this.name = name2;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    public KaEnumEntrySymbol restoreSymbol(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KaFirSession $this$restoreSymbol_u24lambda_u240 = (KaFirSession)analysisSession;
        boolean bl = false;
        KaClassSymbol owner = $this$restoreSymbol_u24lambda_u240.restoreSymbol(this.ownerPointer);
        Object object = owner;
        FirClass firClass = object != null && (object = KtSymbolUtilsKt.getFirSymbol((KaClassSymbol)object)) != null ? (FirClass)((FirBasedSymbol)object).getFir() : null;
        FirRegularClass firRegularClass = firClass instanceof FirRegularClass ? (FirRegularClass)firClass : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass enumClass = firRegularClass;
        if (enumClass.getClassKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        FirEnumEntry firEnumEntry = this.enumEntryByName(enumClass, this.name);
        if (firEnumEntry == null) {
            return null;
        }
        FirEnumEntry enumEntry = firEnumEntry;
        return ((KaFirSession)analysisSession).getFirSymbolBuilder$analysis_api_fir().buildEnumEntrySymbol(enumEntry.getSymbol());
    }

    private final FirEnumEntry enumEntryByName(FirRegularClass $this$enumEntryByName, Name name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$enumEntryByName.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration member = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(member instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)member).getName(), (Object)name2))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other2) {
        Intrinsics.checkNotNullParameter(other2, (String)"other");
        return other2 == this || other2 instanceof KaFirEnumEntrySymbolPointer && Intrinsics.areEqual((Object)((KaFirEnumEntrySymbolPointer)other2).name, (Object)this.name) && ((KaFirEnumEntrySymbolPointer)other2).ownerPointer.pointsToTheSameSymbolAs(this.ownerPointer);
    }
}

