/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.console.CommandExecutor;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.ConsoleCompilerHelper;
import org.jetbrains.kotlin.console.ConsoleScriptDefinitionContributor;
import org.jetbrains.kotlin.console.HistoryKeyListener;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplColors;
import org.jetbrains.kotlin.console.ReplOutputHandler;
import org.jetbrains.kotlin.console.actions.BuildAndRestartConsoleAction;
import org.jetbrains.kotlin.console.actions.KtExecuteCommandAction;
import org.jetbrains.kotlin.console.gutter.ConsoleGutterContentProvider;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.repl.ReplState;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001*\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020IH\u0002J\u0010\u0010M\u001a\u00020K2\u0006\u0010N\u001a\u00020&H\u0002J\u0010\u0010O\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0014J\b\u0010T\u001a\u00020\u0002H\u0014J\b\u0010U\u001a\u00020SH\u0014J\b\u0010V\u001a\u00020WH\u0014J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020WH\u0014J\b\u0010[\u001a\u00020KH\u0007J\u0010\u0010\\\u001a\u00020K2\u0006\u0010]\u001a\u00020\u0002H\u0002J&\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020.H\u0014J\b\u0010f\u001a\u00020KH\u0014J\u0010\u0010g\u001a\u00020K2\u0006\u0010]\u001a\u00020\u0002H\u0002J\u0010\u0010h\u001a\u00020K2\u0006\u0010F\u001a\u00020GH\u0002J\u000e\u0010i\u001a\u00020K2\u0006\u0010j\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR+\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u001e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u001d\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010/\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020.8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b4\u0010\u001d\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00105\u001a\u000206X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R$\u0010<\u001a\u00020\n2\u0006\u0010;\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010=R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lcom/intellij/execution/console/LanguageConsoleView;", "module", "Lcom/intellij/openapi/module/Module;", "environmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "cmdLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "previousCompilationFailed", "", "myProject", "Lcom/intellij/openapi/project/Project;", "title", "", "path", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/execution/target/TargetEnvironmentRequest;Lcom/intellij/execution/target/TargetedCommandLine;ZLcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "commandHistory", "Lorg/jetbrains/kotlin/console/CommandHistory;", "getCommandHistory", "()Lorg/jetbrains/kotlin/console/CommandHistory;", "<set-?>", "Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", "compilerHelper", "getCompilerHelper", "()Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", "setCompilerHelper", "(Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;)V", "compilerHelper$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "consoleEditorHighlighter", "getConsoleEditorHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setConsoleEditorHighlighter", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "consoleEditorHighlighter$delegate", "consoleFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getConsoleFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "consoleScriptDefinition", "org/jetbrains/kotlin/console/KotlinConsoleRunner$consoleScriptDefinition$1", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner$consoleScriptDefinition$1;", "consoleTerminated", "Ljava/util/concurrent/CountDownLatch;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "disposableDescriptor", "getDisposableDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "setDisposableDescriptor", "(Lcom/intellij/execution/ui/RunContentDescriptor;)V", "disposableDescriptor$delegate", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "executor", "Lorg/jetbrains/kotlin/console/CommandExecutor;", "getExecutor", "()Lorg/jetbrains/kotlin/console/CommandExecutor;", "value", "isReadLineMode", "()Z", "setReadLineMode", "(Z)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPreviousCompilationFailed$kotlin_repl", "replState", "Lorg/jetbrains/kotlin/resolve/repl/ReplState;", "addGutterIndicator", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "iconWithTooltip", "Lorg/jetbrains/kotlin/console/gutter/IconWithTooltip;", "changeConsoleEditorIndicator", "", "newIconWithTooltip", "configureFileDependencies", "psiFile", "constructConsoleTitle", "createConsoleExecAction", "Lcom/intellij/execution/console/ConsoleExecuteAction;", "consoleExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "createConsoleView", "createExecuteActionHandler", "createProcess", "Ljava/lang/Process;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "dispose", "enableCompletion", "consoleView", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "contentDescriptor", "finishConsole", "setupGutters", "setupPlaceholder", "successfulLine", "text", "kotlin.repl"})
@SourceDebugExtension(value={"SMAP\nKotlinConsoleRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConsoleRunner.kt\norg/jetbrains/kotlin/console/KotlinConsoleRunner\n+ 2 ScriptDefinitionContributor.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n28#2:341\n28#2:354\n800#3,11:342\n800#3,11:355\n73#4:353\n1#5:366\n*S KotlinDebug\n*F\n+ 1 KotlinConsoleRunner.kt\norg/jetbrains/kotlin/console/KotlinConsoleRunner\n*L\n97#1:341\n166#1:354\n97#1:342,11\n166#1:355,11\n101#1:353\n*E\n"})
public final class KotlinConsoleRunner
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Module module;
    @NotNull
    private final TargetEnvironmentRequest environmentRequest;
    @NotNull
    private final TargetedCommandLine cmdLine;
    private final boolean previousCompilationFailed;
    @NotNull
    private final ReplState replState;
    @NotNull
    private final CountDownLatch consoleTerminated;
    private TargetEnvironment environment;
    @NotNull
    private final CommandHistory commandHistory;
    private boolean isReadLineMode;
    @NotNull
    private final ReadWriteProperty consoleEditorHighlighter$delegate;
    @NotNull
    private final ReadWriteProperty disposableDescriptor$delegate;
    @NotNull
    private final CommandExecutor executor;
    @NotNull
    private final ReadWriteProperty compilerHelper$delegate;
    @NotNull
    private final consoleScriptDefinition.1 consoleScriptDefinition;

    public KotlinConsoleRunner(@NotNull Module module2, @NotNull TargetEnvironmentRequest environmentRequest, @NotNull TargetedCommandLine cmdLine, boolean previousCompilationFailed, @NotNull Project myProject, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String path2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)environmentRequest, (String)"environmentRequest");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(myProject, title, path2);
        this.module = module2;
        this.environmentRequest = environmentRequest;
        this.cmdLine = cmdLine;
        this.previousCompilationFailed = previousCompilationFailed;
        this.replState = new ReplState();
        this.consoleTerminated = new CountDownLatch(1);
        this.commandHistory = new CommandHistory();
        this.consoleEditorHighlighter$delegate = Delegates.INSTANCE.notNull();
        this.disposableDescriptor$delegate = Delegates.INSTANCE.notNull();
        this.executor = new CommandExecutor(this);
        this.compilerHelper$delegate = Delegates.INSTANCE.notNull();
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        this.consoleScriptDefinition = new KotlinScriptDefinition(this, (KClass<Object>)kClass){
            final /* synthetic */ KotlinConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            public String getName() {
                return KotlinIdeaReplBundle.message("name.kotlin.repl", new Object[0]);
            }

            public boolean isScript(@NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                String string = this.this$0.getConsoleView().getVirtualFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return StringsKt.startsWith$default((String)fileName, (String)string, (boolean)false, (int)2, null);
            }

            @NotNull
            public Name getScriptName(@NotNull KtScript script) {
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                Name name2 = Name.identifier((String)"REPL");
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                return name2;
            }
        };
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public final boolean getPreviousCompilationFailed$kotlin_repl() {
        return this.previousCompilationFailed;
    }

    /*
     * WARNING - void declaration
     */
    protected void finishConsole() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinConsoleKeeper kotlinConsoleKeeper = KotlinConsoleKeeper.Companion.getInstance(project2);
        VirtualFile virtualFile2 = this.getConsoleView().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        kotlinConsoleKeeper.removeConsole(virtualFile2);
        ScriptDefinitionContributor.Companion companion = ScriptDefinitionContributor.Companion;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Project project$iv = project3;
        boolean $i$f$find = false;
        List list2 = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
        Iterable $this$filterIsInstance$iv$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ConsoleScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Object object = CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        Intrinsics.checkNotNull((Object)object);
        ConsoleScriptDefinitionContributor consoleContributor = (ConsoleScriptDefinitionContributor)object;
        consoleContributor.unregisterDefinition(this.consoleScriptDefinition);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        ScriptDefinitionsManager.Companion.getInstance(project4).reloadDefinitionsBy(consoleContributor);
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.consoleTerminated.countDown();
            return;
        }
        super.finishConsole();
    }

    @NotNull
    public final CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    public final boolean isReadLineMode() {
        return this.isReadLineMode;
    }

    public final void setReadLineMode(boolean value2) {
        if (value2) {
            this.changeConsoleEditorIndicator(ReplIcons.INSTANCE.getEDITOR_READLINE_INDICATOR());
        } else {
            this.changeConsoleEditorIndicator(ReplIcons.INSTANCE.getEDITOR_INDICATOR());
        }
        this.isReadLineMode = value2;
    }

    private final void changeConsoleEditorIndicator(IconWithTooltip newIconWithTooltip) {
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> KotlinConsoleRunner.changeConsoleEditorIndicator$lambda$0(this, newIconWithTooltip));
    }

    private final RangeHighlighter getConsoleEditorHighlighter() {
        return (RangeHighlighter)this.consoleEditorHighlighter$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setConsoleEditorHighlighter(RangeHighlighter rangeHighlighter) {
        this.consoleEditorHighlighter$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)rangeHighlighter);
    }

    private final RunContentDescriptor getDisposableDescriptor() {
        return (RunContentDescriptor)this.disposableDescriptor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setDisposableDescriptor(RunContentDescriptor runContentDescriptor) {
        this.disposableDescriptor$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)runContentDescriptor);
    }

    @NotNull
    public final CommandExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ConsoleCompilerHelper getCompilerHelper() {
        return (ConsoleCompilerHelper)this.compilerHelper$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setCompilerHelper(@NotNull ConsoleCompilerHelper consoleCompilerHelper) {
        Intrinsics.checkNotNullParameter((Object)consoleCompilerHelper, (String)"<set-?>");
        this.compilerHelper$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)consoleCompilerHelper);
    }

    @NotNull
    protected Process createProcess() {
        ProgressIndicator progressIndicator;
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
        this.environment = this.environmentRequest.prepareEnvironment(targetProgressIndicator);
        TargetEnvironment targetEnvironment = this.environment;
        if (targetEnvironment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            targetEnvironment = null;
        }
        if ((progressIndicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        return targetEnvironment.createProcess(this.cmdLine, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected LanguageConsoleView createConsoleView() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        LanguageConsoleBuilder builder2 = new LanguageConsoleBuilder();
        LanguageConsoleView languageConsoleView = builder2.gutterContentProvider((GutterContentProvider)new ConsoleGutterContentProvider()).build(this.getProject(), (Language)KotlinLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"build(...)");
        LanguageConsoleView consoleView2 = languageConsoleView;
        consoleView2.getVirtualFile().rename((Object)this, consoleView2.getVirtualFile().getName() + KotlinParserDefinition.STD_SCRIPT_EXT);
        consoleView2.getVirtualFile().putUserData(KotlinCodeBlockModificationListenerKt.getKOTLIN_CONSOLE_KEY(), (Object)true);
        consoleView2.setPrompt(null);
        EditorEx editorEx = consoleView2.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getConsoleEditor(...)");
        EditorEx consoleEditor = editorEx;
        this.setupPlaceholder(consoleEditor);
        Project project2 = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        HistoryKeyListener historyKeyListener = new HistoryKeyListener(project2, consoleEditor, this.commandHistory);
        consoleEditor.getContentComponent().addKeyListener(historyKeyListener);
        this.commandHistory.getListeners().add(historyKeyListener);
        VirtualFile virtualFile2 = consoleView2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        KtExecuteCommandAction executeAction = new KtExecuteCommandAction(virtualFile2);
        executeAction.registerCustomShortcutSet(CommonShortcuts.getCtrlEnter(), consoleView2.getConsoleEditor().getComponent());
        ScriptDefinitionContributor.Companion companion = ScriptDefinitionContributor.Companion;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Project project$iv = project3;
        boolean $i$f$find = false;
        List list2 = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
        Iterable $this$filterIsInstance$iv$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ConsoleScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Object object = CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        Intrinsics.checkNotNull((Object)object);
        ConsoleScriptDefinitionContributor consoleContributor = (ConsoleScriptDefinitionContributor)object;
        consoleContributor.registerDefinition(this.consoleScriptDefinition);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        ScriptDefinitionsManager.Companion.getInstance(project4).reloadDefinitionsBy(consoleContributor);
        this.enableCompletion(consoleView2);
        this.setupGutters(consoleView2);
        return consoleView2;
    }

    private final void enableCompletion(LanguageConsoleView consoleView2) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.getProject()).findFile(consoleView2.getVirtualFile());
        KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile consoleKtFile = ktFile2;
        this.configureFileDependencies(consoleKtFile);
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        TargetEnvironment targetEnvironment = this.environment;
        if (targetEnvironment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            targetEnvironment = null;
        }
        ReplOutputHandler processHandler = new ReplOutputHandler(this, process2, this.cmdLine.getCommandPresentation(targetEnvironment));
        VirtualFile virtualFile2 = this.getConsoleView().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        VirtualFile consoleFile = virtualFile2;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinConsoleKeeper keeper = KotlinConsoleKeeper.Companion.getInstance(project2);
        keeper.putVirtualFileToConsole(consoleFile, this);
        return processHandler;
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessHandler processHandler = this.getProcessHandler();
        return new ProcessBackedConsoleExecuteActionHandler(this, processHandler){
            final /* synthetic */ KotlinConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false);
            }

            public void runExecuteAction(@NotNull LanguageConsoleView consoleView2) {
                Intrinsics.checkNotNullParameter((Object)consoleView2, (String)"consoleView");
                this.this$0.getExecutor().executeCommand();
            }
        };
    }

    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setDisposableDescriptor(contentDescriptor);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.setCompilerHelper(new ConsoleCompilerHelper(project2, this.module, defaultExecutor, contentDescriptor));
        Object[] objectArray = new AnAction[3];
        objectArray[0] = new BuildAndRestartConsoleAction(this);
        ProcessBackedConsoleExecuteActionHandler processBackedConsoleExecuteActionHandler = this.getConsoleExecuteActionHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processBackedConsoleExecuteActionHandler, (String)"getConsoleExecuteActionHandler(...)");
        objectArray[1] = this.createConsoleExecAction(processBackedConsoleExecuteActionHandler);
        Intrinsics.checkNotNullExpressionValue((Object)this.createCloseAction(defaultExecutor, contentDescriptor), (String)"createCloseAction(...)");
        ArrayList actionList = CollectionsKt.arrayListOf((Object[])objectArray);
        toolbarActions.addAll((Collection)actionList);
        return actionList;
    }

    @NotNull
    protected ConsoleExecuteAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        Intrinsics.checkNotNullParameter((Object)consoleExecuteActionHandler, (String)"consoleExecuteActionHandler");
        return new ConsoleExecuteAction(this.getConsoleView(), (ConsoleExecuteAction.ConsoleExecuteActionHandler)consoleExecuteActionHandler, "KotlinShellExecute", (Condition)consoleExecuteActionHandler);
    }

    @NotNull
    protected String constructConsoleTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Object[] objectArray = new Object[2];
        objectArray[0] = title;
        Intrinsics.checkNotNullExpressionValue((Object)this.module.getName(), (String)"getName(...)");
        return KotlinIdeaReplBundle.message("constructor.title.0.in.module.1", objectArray);
    }

    private final void setupPlaceholder(EditorEx editor2) {
        AnAction executeCommandAction = ActionManager.getInstance().getAction("KotlinShellExecute");
        String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)executeCommandAction);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String executeCommandActionShortcutText = string;
        Object[] objectArray = new Object[]{executeCommandActionShortcutText};
        editor2.setPlaceholder((CharSequence)KotlinIdeaReplBundle.message("command.0.to.execute", objectArray));
        editor2.setShowPlaceholderWhenFocused(true);
        TextAttributes placeholderAttrs = new TextAttributes();
        placeholderAttrs.setForegroundColor((Color)ReplColors.INSTANCE.getPLACEHOLDER_COLOR());
        placeholderAttrs.setFontType(2);
        editor2.setPlaceholderAttributes(placeholderAttrs);
    }

    private final void setupGutters(LanguageConsoleView consoleView2) {
        EditorEx editorEx = consoleView2.getHistoryViewer();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getHistoryViewer(...)");
        EditorEx historyEditor = editorEx;
        EditorEx editorEx2 = consoleView2.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getConsoleEditor(...)");
        EditorEx consoleEditor = editorEx2;
        KotlinConsoleRunner.setupGutters$configureEditorGutter(this, historyEditor, (Color)ReplColors.INSTANCE.getHISTORY_GUTTER_COLOR(), ReplIcons.INSTANCE.getHISTORY_INDICATOR());
        this.setConsoleEditorHighlighter(KotlinConsoleRunner.setupGutters$configureEditorGutter(this, consoleEditor, (Color)ReplColors.INSTANCE.getEDITOR_GUTTER_COLOR(), ReplIcons.INSTANCE.getEDITOR_INDICATOR()));
        historyEditor.getSettings().setUseSoftWraps(true);
        historyEditor.getSettings().setAdditionalLinesCount(0);
        consoleEditor.getSettings().setCaretRowShown(true);
        consoleEditor.getSettings().setAdditionalLinesCount(2);
    }

    @NotNull
    public final RangeHighlighter addGutterIndicator(@NotNull EditorEx editor2, @NotNull IconWithTooltip iconWithTooltip) {
        RangeHighlighter indicatorHighlighter;
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)iconWithTooltip, (String)"iconWithTooltip");
        ConsoleIndicatorRenderer indicator = new ConsoleIndicatorRenderer(iconWithTooltip);
        MarkupModelEx markupModelEx = editor2.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx editorMarkup = markupModelEx;
        RangeHighlighter rangeHighlighter2 = editorMarkup.addRangeHighlighter(0, editor2.getDocument().getTextLength(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter $this$addGutterIndicator_u24lambda_u241 = rangeHighlighter = (indicatorHighlighter = rangeHighlighter2);
        boolean bl = false;
        $this$addGutterIndicator_u24lambda_u241.setGutterIconRenderer((GutterIconRenderer)indicator);
        return rangeHighlighter;
    }

    @TestOnly
    public final void dispose() {
        this.getProcessHandler().destroyProcess();
        this.consoleTerminated.await(1L, TimeUnit.SECONDS);
        Disposer.dispose((Disposable)((Disposable)this.getDisposableDescriptor()));
    }

    public final void successfulLine(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        DumbModeUtils.runReadActionInSmartMode(project2, (Function0)new Function0<Unit>(this, text2){
            final /* synthetic */ KotlinConsoleRunner this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                super(0);
            }

            public final void invoke() {
                LightVirtualFile lightVirtualFile;
                int lineNumber = KotlinConsoleRunner.access$getReplState$p(this.this$0).getSuccessfulLinesCount() + 1;
                LightVirtualFile $this$invoke_u24lambda_u240 = lightVirtualFile = new LightVirtualFile(this.this$0.getConsoleView().getVirtualFile().getName() + lineNumber + KotlinParserDefinition.STD_SCRIPT_EXT, (Language)KotlinLanguage.INSTANCE, (CharSequence)this.$text);
                boolean bl = false;
                $this$invoke_u24lambda_u240.setCharset(CharsetToolkit.UTF8_CHARSET);
                $this$invoke_u24lambda_u240.setWritable(false);
                LightVirtualFile virtualFile2 = lightVirtualFile;
                PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.this$0.getProject());
                Intrinsics.checkNotNull((Object)psiFileFactory, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
                KtFile ktFile2 = (KtFile)((PsiFileFactoryImpl)psiFileFactory).trySetupPsiForFile(virtualFile2, (Language)KotlinLanguage.INSTANCE, true, false);
                if (ktFile2 == null) {
                    throw new IllegalStateException(("Failed to setup PSI for file:\n" + this.$text).toString());
                }
                KtFile psiFile2 = ktFile2;
                ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(psiFile2){
                    final /* synthetic */ KtFile $psiFile;
                    {
                        this.$psiFile = $psiFile;
                        super(0);
                    }

                    public final void invoke() {
                        ScriptConfigurationManager.Companion.updateScriptDependenciesSynchronously((PsiFile)this.$psiFile);
                    }
                }), (int)1, null);
                KotlinConsoleRunner.access$getReplState$p(this.this$0).submitLine(psiFile2);
                KotlinConsoleRunner.access$configureFileDependencies(this.this$0, psiFile2);
                KtScript ktScript = psiFile2.getScript();
                Intrinsics.checkNotNull((Object)ktScript);
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)ktScript, null, 1, null);
                ScriptDescriptor scriptDescriptor = declarationDescriptor instanceof ScriptDescriptor ? (ScriptDescriptor)declarationDescriptor : null;
                if (scriptDescriptor == null) {
                    throw new IllegalStateException(("Failed to analyze line:\n" + this.$text).toString());
                }
                ScriptDescriptor scriptDescriptor2 = scriptDescriptor;
                ForceResolveUtil.forceResolveAllContents((Object)scriptDescriptor2);
                KotlinConsoleRunner.access$getReplState$p(this.this$0).lineSuccess(psiFile2, scriptDescriptor2);
                KotlinConsoleRunner.access$getReplState$p(this.this$0).submitLine(this.this$0.getConsoleFile());
            }
        });
    }

    @NotNull
    public final KtFile getConsoleFile() {
        VirtualFile virtualFile2 = this.getConsoleView().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        VirtualFile consoleFile = virtualFile2;
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.getProject()).findFile(consoleFile);
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return (KtFile)psiFile2;
    }

    private final void configureFileDependencies(KtFile psiFile2) {
        ModuleInfo moduleInfo;
        PsiFile psiFile3 = (PsiFile)psiFile2;
        ModuleTestSourceInfo moduleTestSourceInfo = KotlinProjectStructureUtils.getTestSourceInfo(this.module);
        if (moduleTestSourceInfo != null) {
            moduleInfo = moduleTestSourceInfo;
        } else {
            ModuleProductionSourceInfo moduleProductionSourceInfo = KotlinProjectStructureUtils.getProductionSourceInfo(this.module);
            if (moduleProductionSourceInfo != null) {
                moduleInfo = moduleProductionSourceInfo;
            } else {
                Project project2 = psiFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                moduleInfo = new NotUnderContentRootModuleInfo(project2, psiFile2);
            }
        }
        KotlinProjectStructureUtils.setForcedModuleInfo(psiFile3, moduleInfo);
    }

    private static final void changeConsoleEditorIndicator$lambda$0(KotlinConsoleRunner this$0, IconWithTooltip $newIconWithTooltip) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newIconWithTooltip, (String)"$newIconWithTooltip");
        this$0.getConsoleEditorHighlighter().setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer($newIconWithTooltip));
    }

    private static final RangeHighlighter setupGutters$configureEditorGutter(KotlinConsoleRunner this$0, EditorEx editor2, Color color, IconWithTooltip iconWithTooltip) {
        editor2.getSettings().setLineMarkerAreaShown(true);
        editor2.getSettings().setFoldingOutlineShown(true);
        editor2.getGutterComponentEx().setPaintBackground(true);
        EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme editorColorScheme = editorColorsScheme;
        editorColorScheme.setColor(EditorColors.GUTTER_BACKGROUND, color);
        editor2.setColorsScheme(editorColorScheme);
        return this$0.addGutterIndicator(editor2, iconWithTooltip);
    }

    public static final /* synthetic */ ReplState access$getReplState$p(KotlinConsoleRunner $this) {
        return $this.replState;
    }

    public static final /* synthetic */ void access$configureFileDependencies(KotlinConsoleRunner $this, KtFile psiFile2) {
        $this.configureFileDependencies(psiFile2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "consoleEditorHighlighter", "getConsoleEditorHighlighter()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "disposableDescriptor", "getDisposableDescriptor()Lcom/intellij/execution/ui/RunContentDescriptor;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "compilerHelper", "getCompilerHelper()Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

