/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumClassSimpleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n60#2:40\n37#3:41\n1#4:42\n*S KotlinDebug\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n*L\n23#1:40\n23#1:41\n*E\n"})
public final class FirEnumClassSimpleChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumClassSimpleChecker INSTANCE = new FirEnumClassSimpleChecker();

    private FirEnumClassSimpleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        FirTypeRef firTypeRef = FirHelpersKt.findNonInterfaceSupertype(declaration2, context2);
        if (firTypeRef != null) {
            FirTypeRef firTypeRef2;
            FirTypeRef firTypeRef3;
            FirTypeRef it = firTypeRef3 = firTypeRef;
            boolean bl = false;
            FirTypeRef firTypeRef4 = firTypeRef2 = !Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(it), context2.getSession(), null, 2, null)), (Object)StandardClassIds.INSTANCE.getEnum()) ? firTypeRef3 : null;
            if (firTypeRef2 != null) {
                it = firTypeRef2;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
        if (!((Collection)declaration2.getTypeParameters()).isEmpty()) {
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration2.getTypeParameters());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firTypeParameterRef != null ? firTypeParameterRef.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }
}

