/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Identifier;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRenderOptions;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\u00020\u000f*\u00020\n2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\f0\u0019H\u0002J$\u0010\u001f\u001a\u00020\u000f*\u00020\n2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u0014\u0010 \u001a\u00020\u000f*\u00020\n2\u0006\u0010!\u001a\u00020\u0011H\u0002J\f\u0010\"\u001a\u00020\u000f*\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u001aH\u0002J\f\u0010$\u001a\u00020\u0011*\u00020%H\u0002J\f\u0010*\u001a\u00020\u0011*\u00020\u0001H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u0011*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010&\u001a\u0004\u0018\u00010'*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "options", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderOptions;", "<init>", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderOptions;)V", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "nodeCounter", "", "clusterCounter", "renderCompleteGraph", "", "graphName", "", "printNodesAndEdges", "Lkotlin/Function0;", "renderPartialGraph", "controlFlowGraph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "renderNodes", "nodes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "style", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "getStyle", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;)Ljava/lang/String;", "renderEdges", "enterCluster", "color", "exitCluster", "renderFlowHtmlLike", "renderHtmlLike", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getCallableId", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;)Lorg/jetbrains/kotlin/name/CallableId;", "toHtmlLikeString", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nControlFlowGraphRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,276:1\n1293#2,4:277\n1485#2:289\n1510#2,3:290\n1513#2,3:300\n1053#2:303\n1557#2:304\n1628#2,3:305\n1611#2,9:308\n1863#2:317\n1864#2:319\n1620#2:320\n1557#2:327\n1628#2,3:328\n1557#2:337\n1628#2,3:338\n487#3,7:281\n381#3,7:293\n1#4:288\n1#4:318\n77#5:321\n97#5,5:322\n77#5:331\n97#5,5:332\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer\n*L\n58#1:277,4\n133#1:289\n133#1:290,3\n133#1:300,3\n133#1:303\n134#1:304\n134#1:305,3\n143#1:308,9\n143#1:317\n143#1:319\n143#1:320\n166#1:327\n166#1:328,3\n167#1:337\n167#1:338,3\n59#1:281,7\n133#1:293,7\n143#1:318\n166#1:321\n166#1:322,5\n167#1:331\n167#1:332,5\n*E\n"})
final class ControlFlowGraphRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlFlowGraphRenderOptions options;
    @NotNull
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    @NotNull
    private static final String EDGE = " -> ";
    @NotNull
    private static final String RED = "red";
    @NotNull
    private static final String BLUE = "blue";
    @NotNull
    private static final Regex DIGIT_REGEX = new Regex("\\d");

    public ControlFlowGraphRenderer(@NotNull StringBuilder builder2, @NotNull ControlFlowGraphRenderOptions options2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.options = options2;
        this.printer = new Printer((Appendable)builder2, 0, null, 6, null);
    }

    public final void renderCompleteGraph(@NotNull String graphName, @NotNull Function0<Unit> printNodesAndEdges) {
        Intrinsics.checkNotNullParameter((Object)graphName, (String)"graphName");
        Intrinsics.checkNotNullParameter(printNodesAndEdges, (String)"printNodesAndEdges");
        String sanitizedName = StringsKt.replace$default((String)graphName, (String)".", (String)"_", (boolean)false, (int)4, null);
        if (((CharSequence)sanitizedName).length() > 0 && DIGIT_REGEX.matches((CharSequence)String.valueOf(StringsKt.first((CharSequence)sanitizedName)))) {
            sanitizedName = '_' + sanitizedName;
        }
        Object[] objectArray = new Object[]{"digraph " + sanitizedName + " {"};
        Printer printer = this.printer.println(objectArray).pushIndent();
        objectArray = new Object[]{"graph [nodesep=3]"};
        Printer printer2 = printer.println(objectArray);
        objectArray = new Object[]{"node [shape=box penwidth=2]"};
        Printer printer3 = printer2.println(objectArray);
        objectArray = new Object[]{"edge [penwidth=2]"};
        printer3.println(objectArray).println(new Object[0]);
        printNodesAndEdges.invoke();
        objectArray = new Object[]{"}"};
        this.printer.popIndent().println(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void renderPartialGraph(@NotNull ControlFlowGraph controlFlowGraph) {
        void $this$filterKeys$iv;
        Object object;
        boolean bl;
        ControlFlowGraphRenderer controlFlowGraphRenderer;
        void destination$iv;
        Object object2;
        Map $this$associateWithTo$iv;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
        List list2 = DFS.topologicalOrder((Iterable)CollectionsKt.listOf(controlFlowGraph.getEnterNode()), ControlFlowGraphRenderer::renderPartialGraph$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"topologicalOrder(...)");
        Iterable iterable = list2;
        Map map2 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        Iterator<Object> iterator2 = $this$associateWithTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            CFGNode cFGNode = (CFGNode)t;
            object2 = t;
            controlFlowGraphRenderer = destination$iv;
            bl = false;
            int n = this.nodeCounter;
            this.nodeCounter = n + 1;
            object = n;
            controlFlowGraphRenderer.put(object2, object);
        }
        LinkedHashMap nodes = (LinkedHashMap)destination$iv;
        $this$associateWithTo$iv = nodes;
        object2 = this.printer;
        controlFlowGraphRenderer = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            CFGNode it = (CFGNode)entry.getKey();
            bl = false;
            if (!(it.getLevel() >= controlFlowGraph.getEnterNode().getLevel())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        object = result$iv;
        controlFlowGraphRenderer.renderNodes((Printer)object2, (Map<CFGNode<?>, Integer>)object);
        this.renderEdges(this.printer, nodes);
        this.printer.println(new Object[0]);
    }

    private final void renderNodes(Printer $this$renderNodes, Map<CFGNode<?>, Integer> nodes) {
        String color = RED;
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            Object[] objectArray;
            String label2;
            StringBuilder stringBuilder;
            CFGNode<?> node2 = entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            if (node2 instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = BLUE;
            }
            List attributes = new ArrayList();
            if (this.options.getRenderFlow()) {
                StringBuilder $this$renderNodes_u24lambda_u243 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$renderNodes_u24lambda_u243.append("<TABLE BORDER=\"0\">");
                $this$renderNodes_u24lambda_u243.append("<TR><TD><B>");
                $this$renderNodes_u24lambda_u243.append(this.toHtmlLikeString(CFGNodeRendererKt.render(node2)));
                if (this.options.getRenderLevels()) {
                    $this$renderNodes_u24lambda_u243.append(" [" + node2.getLevel() + ']');
                }
                $this$renderNodes_u24lambda_u243.append("</B></TD></TR>");
                if (node2.getFlowInitialized()) {
                    $this$renderNodes_u24lambda_u243.append("<TR><TD ALIGN=\"LEFT\" BALIGN=\"LEFT\">");
                    $this$renderNodes_u24lambda_u243.append(this.renderFlowHtmlLike(node2));
                    $this$renderNodes_u24lambda_u243.append("</TD></TR>");
                }
                $this$renderNodes_u24lambda_u243.append("</TABLE>");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
                ((Collection)attributes).add("label=< " + label2 + " >");
            } else {
                StringBuilder $this$renderNodes_u24lambda_u244 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$renderNodes_u24lambda_u244.append(StringsKt.replace$default((String)CFGNodeRendererKt.render(node2), (String)"\"", (String)"", (boolean)false, (int)4, null));
                if (this.options.getRenderLevels()) {
                    $this$renderNodes_u24lambda_u244.append(" [" + node2.getLevel() + ']');
                }
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
                ((Collection)attributes).add("label=\"" + label2 + '\"');
            }
            Object object = node2.isDead() ? "gray" : (Intrinsics.areEqual(node2, node2.getOwner().getEnterNode()) || Intrinsics.areEqual(node2, node2.getOwner().getExitNode()) ? RED : (objectArray = node2.isUnion() ? "yellow" : null));
            if (objectArray != null) {
                Object[] it = objectArray;
                boolean bl = false;
                ((Collection)attributes).add("style=\"filled\"");
                ((Collection)attributes).add("fillcolor=" + (String)it);
            }
            objectArray = new Object[]{index, CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", (CharSequence)" [", (CharSequence)"];", (int)0, null, null, (int)56, null)};
            $this$renderNodes.println(objectArray);
            if (!(node2 instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStyle(Edge $this$style) {
        Object object;
        String string;
        Object object2 = new String[3];
        object2[0] = !$this$style.getKind().getUsedInDfa() && !$this$style.getKind().getUsedInDeadDfa() ? "color=green" : (!$this$style.getKind().getUsedInCfa() ? "color=red" : null);
        object2[1] = $this$style.getKind().isDead() ? "style=dotted" : ($this$style.getKind().isBack() ? "style=dashed" : null);
        Object[] objectArray = object2;
        int n = 2;
        String string2 = $this$style.getLabel().getLabel();
        if (string2 != null) {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string4 = "label=\"" + (String)it + '\"';
            objectArray = objectArray2;
            n = n2;
            string = string4;
        } else {
            string = null;
        }
        objectArray[n] = string;
        object2 = CollectionsKt.listOfNotNull((Object[])object2);
        if (object2.isEmpty()) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        List list2 = (List)object;
        return list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderEdges(Printer $this$renderEdges, Map<CFGNode<?>, Integer> nodes) {
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            Object[] objectArray;
            Iterable group;
            void $this$groupByTo$iv$iv;
            CFGNode<?> node2 = entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            Iterable $this$groupBy$iv = node2.getFollowingNodes();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CFGNode it = (CFGNode)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = this.getStyle(node2.edgeTo(it));
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$sortedBy$iv2 = destination$iv$iv.entrySet();
            boolean $i$f$sortedBy = false;
            for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            })) {
                void $this$mapTo$iv$iv;
                String style = (String)$this$sortedBy$iv2.getKey();
                group = (List)$this$sortedBy$iv2.getValue();
                Object[] $this$map$iv = (Object[])group;
                boolean $i$f$map = false;
                Object[] element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CFGNode $i$f$getOrPut = (CFGNode)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Number)MapsKt.getValue(nodes, (Object)it)).intValue());
                }
                List mappedGroup = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                $this$map$iv = new Object[]{index, EDGE, CollectionsKt.joinToString$default((Iterable)mappedGroup, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
                $this$renderEdges.print($this$map$iv);
                if (style != null) {
                    String it;
                    boolean bl = false;
                    objectArray = new Object[]{' ' + it};
                    $this$renderEdges.printWithNoIndent(objectArray);
                }
                $this$map$iv = new Object[]{";"};
                $this$renderEdges.printlnWithNoIndent($this$map$iv);
            }
            if (!(node2 instanceof CFGNodeWithSubgraphs)) continue;
            Iterable $this$mapNotNull$iv = ((CFGNodeWithSubgraphs)node2).getSubGraphs();
            boolean $i$f$mapNotNull = false;
            group = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            objectArray = $this$forEach$iv$iv$iv.iterator();
            while (objectArray.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = objectArray.next();
                boolean bl = false;
                ControlFlowGraph it = (ControlFlowGraph)element$iv$iv;
                boolean bl3 = false;
                if (nodes.get(it.getEnterNode()) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List subNodes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (!(!((Collection)subNodes).isEmpty())) continue;
            Object[] objectArray2 = new Object[]{index, EDGE, CollectionsKt.joinToString$default((Iterable)subNodes, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
            $this$renderEdges.print(objectArray2);
            objectArray2 = new Object[]{" [style=dashed];"};
            $this$renderEdges.printlnWithNoIndent(objectArray2);
        }
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        int n = this.clusterCounter;
        this.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        objectArray = new Object[]{"color=" + color};
        $this$enterCluster.println(objectArray);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        Object[] objectArray = new Object[]{"}"};
        $this$exitCluster.println(objectArray);
    }

    private final String renderFlowHtmlLike(CFGNode<?> $this$renderFlowHtmlLike) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Map $this$map$iv;
        Object list$iv$iv;
        Map.Entry it;
        Map.Entry element$iv$iv;
        Map $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        PersistentFlow flow = $this$renderFlowHtmlLike.getFlow();
        Map map2 = (Map)flow.getImplications();
        Set set = SetsKt.plus(flow.getKnownVariables(), (Iterable)flow.getImplications().keySet());
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Implication)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Implication)((Object)it)).getCondition().getVariable());
        }
        $this$map$iv = (Map)flow.getImplications();
        set = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Implication)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Implication)((Object)it)).getEffect().getVariable());
        }
        Set variables2 = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)variables2), (CharSequence)"<BR/><BR/>", null, null, (int)0, null, arg_0 -> ControlFlowGraphRenderer.renderFlowHtmlLike$lambda$21(this, flow, arg_0), (int)30, null);
    }

    private final String renderHtmlLike(DataFlowVariable $this$renderHtmlLike) {
        StringBuilder stringBuilder;
        DataFlowVariable variable2 = $this$renderHtmlLike;
        StringBuilder $this$renderHtmlLike_u24lambda_u2422 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderHtmlLike_u24lambda_u2422.append("<B>");
        $this$renderHtmlLike_u24lambda_u2422.append(variable2);
        $this$renderHtmlLike_u24lambda_u2422.append("</B>");
        CallableId callableId = this.getCallableId(variable2);
        if (variable2 instanceof RealVariable && callableId != null) {
            DataFlowVariable dataFlowVariable;
            $this$renderHtmlLike_u24lambda_u2422.append(" = ");
            DataFlowVariable dataFlowVariable2 = ((RealVariable)variable2).getIdentifier().getDispatchReceiver();
            Object[] objectArray = new String[]{dataFlowVariable2 != null && (dataFlowVariable2 = this.getCallableId(dataFlowVariable2)) != null ? this.toHtmlLikeString(dataFlowVariable2) : null, (dataFlowVariable = ((RealVariable)variable2).getIdentifier().getExtensionReceiver()) != null && (dataFlowVariable = this.getCallableId(dataFlowVariable)) != null ? this.toHtmlLikeString(dataFlowVariable) : null};
            List receivers = CollectionsKt.listOfNotNull((Object[])objectArray);
            switch (receivers.size()) {
                case 2: {
                    $this$renderHtmlLike_u24lambda_u2422.append(CollectionsKt.joinToString$default((Iterable)receivers, null, (CharSequence)"(", (CharSequence)").", (int)0, null, null, (int)57, null));
                    break;
                }
                case 1: {
                    $this$renderHtmlLike_u24lambda_u2422.append(CollectionsKt.joinToString$default((Iterable)receivers, null, null, (CharSequence)".", (int)0, null, null, (int)59, null));
                }
            }
            $this$renderHtmlLike_u24lambda_u2422.append(this.toHtmlLikeString(callableId));
        }
        if (variable2 instanceof SyntheticVariable) {
            $this$renderHtmlLike_u24lambda_u2422.append(" = '");
            $this$renderHtmlLike_u24lambda_u2422.append(this.toHtmlLikeString(UtilsKt.render(((SyntheticVariable)variable2).getFir())));
            $this$renderHtmlLike_u24lambda_u2422.append("'");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final CallableId getCallableId(DataFlowVariable $this$callableId) {
        Object object = $this$callableId instanceof RealVariable ? (RealVariable)$this$callableId : null;
        FirBasedSymbol<?> firBasedSymbol = object != null && (object = ((RealVariable)object).getIdentifier()) != null ? ((Identifier)object).getSymbol() : null;
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        return firCallableSymbol != null ? firCallableSymbol.getCallableId() : null;
    }

    private final String toHtmlLikeString(Object $this$toHtmlLikeString) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$toHtmlLikeString.toString(), (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null);
    }

    private static final Iterable renderPartialGraph$lambda$0(CFGNode it) {
        return it.getFollowingNodes();
    }

    private static final CharSequence renderFlowHtmlLike$lambda$21(ControlFlowGraphRenderer this$0, PersistentFlow $flow, DataFlowVariable variable2) {
        Implication implication;
        Iterator iterator2;
        TypeStatement it;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        StringBuilder $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append(this$0.renderHtmlLike(variable2));
        if (variable2 instanceof RealVariable) {
            TypeStatement typeStatement = $flow.getTypeStatement((RealVariable)variable2);
            if (typeStatement != null) {
                it = typeStatement;
                boolean bl2 = false;
                $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append("<BR/><B>types</B> ");
                $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append(this$0.toHtmlLikeString(it.getExactType()));
            }
            PersistentList persistentList = (PersistentList)$flow.getImplications().get((Object)$flow.unwrapVariable((RealVariable)variable2));
            if (persistentList != null) {
                it = persistentList;
                boolean bl3 = false;
                iterator2 = it.iterator();
                while (iterator2.hasNext()) {
                    implication = (Implication)iterator2.next();
                    $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append("<BR/><B>implication</B> ");
                    $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append(this$0.toHtmlLikeString(implication));
                }
            }
        }
        PersistentList persistentList = (PersistentList)$flow.getImplications().get((Object)variable2);
        if (persistentList != null) {
            it = persistentList;
            boolean bl4 = false;
            iterator2 = it.iterator();
            while (iterator2.hasNext()) {
                implication = (Implication)iterator2.next();
                $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append("<BR/><B>implication</B> ");
                $this$renderFlowHtmlLike_u24lambda_u2421_u24lambda_u2420.append(this$0.toHtmlLikeString(implication));
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer$Companion;", "", "<init>", "()V", "EDGE", "", "RED", "BLUE", "DIGIT_REGEX", "Lkotlin/text/Regex;", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

