/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinActionKt;
import org.jetbrains.kotlin.idea.base.codeInsight.JavaToKotlinConversionUtils;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSelectedWritableJavaFiles", "", "Lcom/intellij/psi/PsiJavaFile;", "isEnabled", "", "shouldSkipConversionOfErroneousCode", "javaFiles", "project", "Lcom/intellij/openapi/project/Project;", "showNothingToConvertErrorMessage", "update", "Handler", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,330:1\n1774#2,4:331\n12474#3,2:335\n12474#3,2:337\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n*L\n271#1:331,4\n314#1:335,2\n322#1:337,2\n*E\n"})
public final class JavaToKotlinAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        List<PsiJavaFile> javaFiles = this.getSelectedWritableJavaFiles(e);
        if (javaFiles.isEmpty()) {
            this.showNothingToConvertErrorMessage(project3);
            return;
        }
        J2kConverterExtension.Kind j2kKind = JavaToKotlinActionKt.getJ2kKind$default(false, 1, null);
        J2kConverterExtension j2kConverterExtension = J2kConverterExtension.Companion.extension(j2kKind);
        if (this.shouldSkipConversionOfErroneousCode(javaFiles, project3)) {
            return;
        }
        if (j2kConverterExtension.doCheckBeforeConversion(project3, module3)) {
            Handler.convertFiles$default(Handler.INSTANCE, javaFiles, project3, module3, false, false, false, 56, null);
        } else {
            j2kConverterExtension.setUpAndConvert(project3, module3, javaFiles, (Function3<? super List<? extends PsiJavaFile>, ? super Project, ? super Module, Unit>)((Function3)new Function3<List<? extends PsiJavaFile>, Project, Module, Unit>((Object)Handler.INSTANCE){

                public final void invoke(@NotNull List<? extends PsiJavaFile> p0, @NotNull Project p1, @NotNull Module p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Handler.convertFiles$default((Handler)this.receiver, p0, p1, p2, false, false, false, 56, null);
                }
            }));
        }
    }

    private final List<PsiJavaFile> getSelectedWritableJavaFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] virtualFilesAndDirectories = virtualFileArray;
        Project project2 = e.getProject();
        if (project2 == null) {
            return CollectionsKt.emptyList();
        }
        Project project3 = project2;
        PsiManager psiManager = PsiManager.getInstance((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileUtils.getAllFilesRecursively(virtualFilesAndDirectories)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(psiManager2){
            final /* synthetic */ PsiManager $psiManager;
            {
                this.$psiManager = $psiManager;
                super(1);
            }

            @Nullable
            public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiFile psiFile2 = this.$psiManager.findFile(it);
                return psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
            }
        })), (Function1)getSelectedWritableJavaFiles.2.INSTANCE), (Function1)getSelectedWritableJavaFiles.3.INSTANCE));
    }

    private final void showNothingToConvertErrorMessage(Project project2) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinBundle.message((String)"action.j2k.error.nothing.to.convert", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().showInCenterOf(statusBar.getComponent());
    }

    private final boolean shouldSkipConversionOfErroneousCode(List<? extends PsiJavaFile> javaFiles, Project project2) {
        String string;
        int n;
        PsiErrorElement psiErrorElement = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles), (Function1)shouldSkipConversionOfErroneousCode.firstSyntaxError.1.INSTANCE));
        if (psiErrorElement == null) {
            return false;
        }
        PsiErrorElement firstSyntaxError2 = psiErrorElement;
        Iterable $this$count$iv = javaFiles;
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv;
                boolean bl = false;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        boolean bl = $this$count$iv = count > 0;
        if (_Assertions.ENABLED && !$this$count$iv) {
            String $i$f$count2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$count2);
        }
        String string2 = firstSyntaxError2.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String firstFileName = string2;
        if (count == 1) {
            var8_12 = new Object[]{firstFileName};
            string = KotlinBundle.message((String)"action.j2k.correction.errors.single", (Object[])var8_12);
        } else {
            var8_12 = new Object[]{firstFileName, count - 1};
            string = KotlinBundle.message((String)"action.j2k.correction.errors.multiple", (Object[])var8_12);
        }
        String question = string;
        String okText = KotlinBundle.message((String)"action.j2k.correction.investigate", (Object[])new Object[0]);
        String cancelText = KotlinBundle.message((String)"action.j2k.correction.proceed", (Object[])new Object[0]);
        if (Messages.showOkCancelDialog((Project)project2, (String)question, (String)Handler.INSTANCE.getTitle(), (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
            PsiElement psiElement2 = firstSyntaxError2.getNavigationElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNavigationElement(...)");
            NavigationUtil.activateFileWithPsiElement$default((PsiElement)psiElement2, (boolean)false, (int)2, null);
            return true;
        }
        return false;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        boolean bl;
        block11: {
            VirtualFile p0;
            VirtualFile element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            VirtualFile[] $this$any$iv;
            if (KotlinPluginModeProvider.Companion.isK2Mode() && !ExperimentalFeatures.INSTANCE.getK2J2K().isEnabled()) {
                return false;
            }
            if (KotlinPlatformUtils.isCidr()) {
                return false;
            }
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files2 = virtualFileArray;
            Project project2 = e.getProject();
            if (project2 == null) {
                return false;
            }
            Project project3 = project2;
            if (project3.isDisposed()) {
                return false;
            }
            if (e.getData(PlatformCoreDataKeys.MODULE) == null) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
                boolean bl2;
                block10: {
                    $this$any$iv = files2;
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        p0 = element$iv = $this$any$iv[n];
                        boolean bl3 = false;
                        if (!JavaToKotlinAction.isEnabled$isWritablePackageDirectory(project3, p0)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
            }
            $this$any$iv = files2;
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                p0 = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!JavaToKotlinAction.isEnabled$isWritableJavaFile(project3, p0)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isEnabled$isWritableJavaFile(Project project2, VirtualFile file2) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return Intrinsics.areEqual((Object)file2.getExtension(), (Object)"java") && psiManager2.findFile(file2) instanceof PsiJavaFile && file2.isWritable();
    }

    private static final boolean isEnabled$isWritablePackageDirectory(Project project2, VirtualFile file2) {
        PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(file2, project2);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory directory = psiDirectory;
        return PsiDirectoryFactory.getInstance((Project)project2).isPackage(directory) && file2.isWritable();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011JR\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0015J2\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J%\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$*\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0\u0017H\u0002\u00a2\u0006\u0002\u0010&R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "forceUsingOldJ2k", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "prepareExternalCodeUpdate", "Lkotlin/Function0;", "", "processing", "Lorg/jetbrains/kotlin/j2k/ExternalCodeProcessing;", "isEnabled", "shouldAsk", "runSynchronousProcess", "process", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaFiles", "convertedTexts", "runUndoTransparentGlobalWriteAction", "T", "command", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,330:1\n766#2:331\n857#2,2:332\n1#3:334\n17#4,6:335\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n*L\n72#1:331\n72#1:332,2\n81#1:335,6\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final String title = KotlinBundle.message((String)"action.j2k.name", (Object[])new Object[0]);

        private Handler() {
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project2, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k, @NotNull ConverterSettings settings2) {
            List list2;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!it.getVirtualFile().isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            if ($this$filter$iv.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            List javaFiles = (List)$this$filter$iv;
            Ref.ObjectRef converterResult = new Ref.ObjectRef();
            if (!this.runSynchronousProcess(project2, (Function0<Unit>)((Function0)new Function0<Unit>(forceUsingOldJ2k, project2, module2, settings2, (List<? extends PsiJavaFile>)javaFiles, (Ref.ObjectRef<FilesResult>)converterResult){
                final /* synthetic */ boolean $forceUsingOldJ2k;
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;
                final /* synthetic */ ConverterSettings $settings;
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                final /* synthetic */ Ref.ObjectRef<FilesResult> $converterResult;
                {
                    this.$forceUsingOldJ2k = $forceUsingOldJ2k;
                    this.$project = $project;
                    this.$module = $module;
                    this.$settings = $settings;
                    this.$javaFiles = $javaFiles;
                    this.$converterResult = $converterResult;
                    super(0, Intrinsics.Kotlin.class, "convertWithStatistics", "convertFiles$convertWithStatistics(ZLcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/j2k/ConverterSettings;Ljava/util/List;Lkotlin/jvm/internal/Ref$ObjectRef;)V", 0);
                }

                public final void invoke() {
                    Handler.access$convertFiles$convertWithStatistics(this.$forceUsingOldJ2k, this.$project, this.$module, this.$settings, this.$javaFiles, this.$converterResult);
                }
            }))) {
                return CollectionsKt.emptyList();
            }
            FilesResult filesResult = (FilesResult)converterResult.element;
            if (filesResult == null) {
                return CollectionsKt.emptyList();
            }
            FilesResult result2 = filesResult;
            ExternalCodeProcessing externalCodeProcessing2 = result2.getExternalCodeProcessing();
            Function0<Unit> externalCodeUpdate = this.prepareExternalCodeUpdate(project2, externalCodeProcessing2, enableExternalCodeProcessing, askExternalCodeProcessing);
            Ref.ObjectRef newFiles = new Ref.ObjectRef();
            ApplicationUtilsKt.executeCommand$default(project2, KotlinBundle.message((String)"action.j2k.task.name", (Object[])new Object[0]), null, (Function0)new Function0<Unit>((Ref.ObjectRef<List<KtFile>>)newFiles, project2, (List<? extends PsiJavaFile>)javaFiles, result2, externalCodeProcessing2, externalCodeUpdate){
                final /* synthetic */ Ref.ObjectRef<List<KtFile>> $newFiles;
                final /* synthetic */ Project $project;
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                final /* synthetic */ FilesResult $result;
                final /* synthetic */ ExternalCodeProcessing $externalCodeProcessing;
                final /* synthetic */ Function0<Unit> $externalCodeUpdate;
                {
                    this.$newFiles = $newFiles;
                    this.$project = $project;
                    this.$javaFiles = $javaFiles;
                    this.$result = $result;
                    this.$externalCodeProcessing = $externalCodeProcessing;
                    this.$externalCodeUpdate = $externalCodeUpdate;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    List list2;
                    this.$newFiles.element = Handler.access$runUndoTransparentGlobalWriteAction(Handler.INSTANCE, this.$project, (Function0)new Function0<List<? extends KtFile>>(this.$javaFiles, this.$result, this.$project){
                        final /* synthetic */ List<PsiJavaFile> $javaFiles;
                        final /* synthetic */ FilesResult $result;
                        final /* synthetic */ Project $project;
                        {
                            this.$javaFiles = $javaFiles;
                            this.$result = $result;
                            this.$project = $project;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final List<KtFile> invoke() {
                            Iterable iterable;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable2 = Handler.access$saveResults(Handler.INSTANCE, this.$javaFiles, this.$result.getResults());
                            Project project2 = this.$project;
                            boolean $i$f$map = false;
                            void var4_6 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, project2);
                                Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                                collection.add((KtFile)psiFile2);
                            }
                            Iterable $this$onEach$iv = (List)destination$iv$iv;
                            boolean $i$f$onEach = false;
                            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
                            boolean bl = false;
                            for (T element$iv : $this$onEach_u24lambda_u2416$iv) {
                                KtFile it = (KtFile)element$iv;
                                boolean bl2 = false;
                                DocumentUtilsKt.commitAndUnblockDocument((PsiFile)it);
                            }
                            return (List)iterable;
                        }
                    });
                    if (this.$newFiles.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"newFiles");
                        list2 = null;
                    } else {
                        list2 = (List)this.$newFiles.element;
                    }
                    KtFile ktFile2 = (KtFile)CollectionsKt.firstOrNull((List)list2);
                    if (ktFile2 == null) {
                        return;
                    }
                    KtFile contextElement = ktFile2;
                    ExternalCodeProcessing externalCodeProcessing2 = this.$externalCodeProcessing;
                    Ref.ObjectRef<List<KtFile>> objectRef = this.$newFiles;
                    boolean $i$f$allowAnalysisOnEdt = false;
                    KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
                        void this_$iv$iv;
                        boolean bl = false;
                        boolean $i$f$analyze = false;
                        Project project2 = ((KtElement)contextElement).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)contextElement);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)contextElement);
                        try {
                            Unit unit;
                            KaSession $this$invoke_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            ExternalCodeProcessing externalCodeProcessing3 = externalCodeProcessing2;
                            if (externalCodeProcessing3 != null) {
                                List list3;
                                if (objectRef.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"newFiles");
                                    list3 = null;
                                } else {
                                    list3 = (List)objectRef.element;
                                }
                                externalCodeProcessing3.bindJavaDeclarationsToConvertedKotlinOnes($this$invoke_u24lambda_u241_u24lambda_u240, list3);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit2 = unit;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)contextElement);
                        }
                    }
                    permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
                    try {
                        Unit unit;
                        boolean bl = false;
                        boolean $i$f$analyze = false;
                        Project project3 = ((KtElement)contextElement).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project3);
                        boolean $i$f$analyze3 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)contextElement);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)contextElement);
                        try {
                            Unit unit3;
                            KaSession $this$invoke_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl3 = false;
                            ExternalCodeProcessing externalCodeProcessing4 = externalCodeProcessing2;
                            if (externalCodeProcessing4 != null) {
                                List list4;
                                if (objectRef.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"newFiles");
                                    list4 = null;
                                } else {
                                    list4 = (List)objectRef.element;
                                }
                                externalCodeProcessing4.bindJavaDeclarationsToConvertedKotlinOnes($this$invoke_u24lambda_u241_u24lambda_u240, list4);
                                unit3 = Unit.INSTANCE;
                            } else {
                                unit3 = null;
                            }
                            unit = unit3;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)contextElement);
                        }
                        Unit unit4 = unit;
                    }
                    finally {
                        permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
                    }
                    Handler.access$runUndoTransparentGlobalWriteAction(Handler.INSTANCE, this.$project, (Function0)new Function0<FileEditor[]>(this.$externalCodeUpdate, this.$project, this.$newFiles){
                        final /* synthetic */ Function0<Unit> $externalCodeUpdate;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Ref.ObjectRef<List<KtFile>> $newFiles;
                        {
                            this.$externalCodeUpdate = $externalCodeUpdate;
                            this.$project = $project;
                            this.$newFiles = $newFiles;
                            super(0);
                        }

                        @Nullable
                        public final FileEditor[] invoke() {
                            FileEditor[] fileEditorArray;
                            List list2;
                            Function0<Unit> function0 = this.$externalCodeUpdate;
                            if (function0 != null) {
                                function0.invoke();
                            }
                            PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                            if (this.$newFiles.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"newFiles");
                                list2 = null;
                            } else {
                                list2 = (List)this.$newFiles.element;
                            }
                            KtFile ktFile2 = (KtFile)CollectionsKt.singleOrNull((List)list2);
                            if (ktFile2 != null) {
                                KtFile ktFile3 = ktFile2;
                                Project project2 = this.$project;
                                KtFile it = ktFile3;
                                boolean bl = false;
                                fileEditorArray = FileEditorManager.getInstance((Project)project2).openFile(it.getVirtualFile(), true);
                            } else {
                                fileEditorArray = null;
                            }
                            return fileEditorArray;
                        }
                    });
                }
            }, 2, null);
            if (newFiles.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"newFiles");
                list2 = null;
            } else {
                list2 = (List)newFiles.element;
            }
            return list2;
        }

        public static /* synthetic */ List convertFiles$default(Handler handler2, List list2, Project project2, Module module2, boolean bl, boolean bl2, boolean bl3, ConverterSettings converterSettings, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                converterSettings = ConverterSettings.Companion.getDefaultSettings();
            }
            return handler2.convertFiles(list2, project2, module2, bl, bl2, bl3, converterSettings);
        }

        private final Function0<Unit> prepareExternalCodeUpdate(Project project2, ExternalCodeProcessing processing, boolean isEnabled, boolean shouldAsk) {
            if (!isEnabled || processing == null) {
                return null;
            }
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            String question = KotlinBundle.message((String)"action.j2k.correction.required", (Object[])new Object[0]);
            if (!shouldAsk || Messages.showYesNoDialog((Project)project2, (String)question, (String)title, (Icon)Messages.getQuestionIcon()) == 0) {
                this.runSynchronousProcess(project2, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<Function0<Unit>>)result2, processing){
                    final /* synthetic */ Ref.ObjectRef<Function0<Unit>> $result;
                    final /* synthetic */ ExternalCodeProcessing $processing;
                    {
                        this.$result = $result;
                        this.$processing = $processing;
                        super(0);
                    }

                    public final void invoke() {
                        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this.$result, this.$processing){
                            final /* synthetic */ Ref.ObjectRef<Function0<Unit>> $result;
                            final /* synthetic */ ExternalCodeProcessing $processing;
                            {
                                this.$result = $result;
                                this.$processing = $processing;
                                super(0);
                            }

                            public final void invoke() {
                                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                                Intrinsics.checkNotNull((Object)progressIndicator);
                                this.$result.element = this.$processing.prepareWriteOperation(progressIndicator);
                            }
                        }));
                    }
                }));
            }
            return (Function0)result2.element;
        }

        private final boolean runSynchronousProcess(Project project2, Function0<Unit> process2) {
            return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Handler.runSynchronousProcess$lambda$3(process2), title, true, project2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T runUndoTransparentGlobalWriteAction(Project $this$runUndoTransparentGlobalWriteAction, Function0<? extends T> command2) {
            Object object;
            AutoCloseable autoCloseable = CommandProcessor.getInstance().withUndoTransparentAction();
            Throwable throwable = null;
            try {
                AutoCloseable it = autoCloseable;
                boolean bl = false;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal($this$runUndoTransparentGlobalWriteAction);
                object = ActionsKt.runWriteAction((Function0)new Function0<T>(command2){
                    final /* synthetic */ Function0<T> $command;
                    {
                        this.$command = $command;
                        super(0);
                    }

                    public final T invoke() {
                        return (T)this.$command.invoke();
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)javaFiles, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile2 = (PsiJavaFile)pair.component1();
                String text2 = (String)pair.component2();
                try {
                    String errorMessage;
                    Document document = PsiDocumentManager.getInstance((Project)psiFile2.getProject()).getDocument((PsiFile)psiFile2);
                    if (document == null) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message((String)"action.j2k.error.cant.find.document", (Object[])var10_11);
                    } else if (!document.isWritable()) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message((String)"action.j2k.error.read.only", (Object[])var10_11);
                    } else {
                        v0 = errorMessage = null;
                    }
                    if (errorMessage != null) {
                        Object[] objectArray = new Object[]{errorMessage};
                        String message2 = KotlinBundle.message((String)"action.j2k.error.cant.save.result", (Object[])objectArray);
                        MessagesEx.error((Project)psiFile2.getProject(), (String)message2).showLater();
                        continue;
                    }
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)document2);
                    document2.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile2)) {
                        PerFileMappings mapping;
                        Intrinsics.checkNotNullExpressionValue((Object)ScratchFileService.getInstance().getScratchesMapping(), (String)"getScratchesMapping(...)");
                        mapping.setMapping(virtualFile2, (Object)KotlinFileType.INSTANCE.getLanguage());
                    } else {
                        Intrinsics.checkNotNull((Object)virtualFile2);
                        String fileName = Handler.saveResults$uniqueKotlinFileName(virtualFile2);
                        virtualFile2.putUserData(JavaToKotlinConversionUtils.getPathBeforeJavaToKotlinConversion(), (Object)virtualFile2.getPath());
                        virtualFile2.rename((Object)this, fileName);
                    }
                    ((Collection)result2).add(virtualFile2);
                }
                catch (IOException e) {
                    Project project2 = psiFile2.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project2, (String)string).showLater();
                }
            }
            return result2;
        }

        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project2, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return this.convertFiles(files2, project2, module2, enableExternalCodeProcessing, askExternalCodeProcessing, forceUsingOldJ2k, ConverterSettings.Companion.getDefaultSettings());
        }

        public static /* synthetic */ List convertFiles$default(Handler handler2, List list2, Project project2, Module module2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return handler2.convertFiles(list2, project2, module2, bl, bl2, bl3);
        }

        private static final void convertFiles$convertWithStatistics(boolean $forceUsingOldJ2k, Project $project, Module $module, ConverterSettings $settings, List<? extends PsiJavaFile> javaFiles, Ref.ObjectRef<FilesResult> converterResult) {
            J2kConverterExtension.Kind j2kKind = JavaToKotlinActionKt.access$getJ2kKind($forceUsingOldJ2k);
            JavaToKotlinConverter converter = J2kConverterExtension.createJavaToKotlinConverter$default(J2kConverterExtension.Companion.extension(j2kKind), $project, $module, $settings, null, 8, null);
            PostProcessor postProcessor = J2kConverterExtension.createPostProcessor$default(J2kConverterExtension.Companion.extension(j2kKind), false, 1, null);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            ProgressIndicator progressIndicator2 = progressIndicator;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            converterResult.element = converter.filesToKotlin(javaFiles, postProcessor, progressIndicator2);
            long conversionTime = System.currentTimeMillis() - start$iv;
            int linesCount2 = ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(javaFiles){
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                {
                    this.$javaFiles = $javaFiles;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Integer invoke() {
                    Iterable iterable = this.$javaFiles;
                    int n = 0;
                    for (T t : iterable) {
                        void it;
                        PsiJavaFile psiJavaFile = (PsiJavaFile)t;
                        int n2 = n;
                        boolean bl = false;
                        int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
                        n = n2 + n3;
                    }
                    return n;
                }
            }))).intValue();
            J2KFusCollector.INSTANCE.log(ConversionType.FILES, j2kKind == J2kConverterExtension.Kind.K1_NEW, conversionTime, linesCount2, javaFiles.size());
        }

        private static final void runSynchronousProcess$lambda$3(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }

        private static final String saveResults$uniqueKotlinFileName(VirtualFile javaFile2) {
            Path nioFile = javaFile2.getFileSystem().getNioPath(javaFile2);
            int i2 = 0;
            while (true) {
                block4: {
                    String fileName;
                    block3: {
                        Path path2;
                        fileName = javaFile2.getNameWithoutExtension() + (i2 > 0 ? Integer.valueOf(i2) : "") + ".kt";
                        if (nioFile == null) break block3;
                        Intrinsics.checkNotNullExpressionValue((Object)nioFile.resolveSibling(fileName), (String)"resolveSibling(...)");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
                    }
                    return fileName;
                }
                ++i2;
            }
        }

        public static final /* synthetic */ void access$convertFiles$convertWithStatistics(boolean $forceUsingOldJ2k, Project $project, Module $module, ConverterSettings $settings, List javaFiles, Ref.ObjectRef converterResult) {
            Handler.convertFiles$convertWithStatistics($forceUsingOldJ2k, $project, $module, $settings, javaFiles, (Ref.ObjectRef<FilesResult>)converterResult);
        }

        public static final /* synthetic */ Object access$runUndoTransparentGlobalWriteAction(Handler $this, Project $receiver, Function0 command2) {
            return $this.runUndoTransparentGlobalWriteAction($receiver, command2);
        }

        public static final /* synthetic */ List access$saveResults(Handler $this, List javaFiles, List convertedTexts) {
            return $this.saveResults(javaFiles, convertedTexts);
        }
    }
}

