/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCache;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCacheImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndex;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0007\u001d\u001e\u001f !\"#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0013*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleStdlibDependencyCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "stdlibCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "stdlibDependencyCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "dispose", "", "findStdlibInModuleDependencies", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "module", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "isFatJar", "", "libraryInfo", "isKotlinJavaRuntime", "isStdlib", "isStdlibDependency", "libraryScopeContainsIndexedFilesForName", "name", "Lorg/jetbrains/kotlin/name/FqName;", "isStdlibWithFile", "fileName", "BaseStdLibCache", "Companion", "LibraryScope", "ModuleStdlibDependencyCache", "StdLibCache", "StdlibDependency", "StdlibDependencyCache", "kotlin.base.project-structure"})
public final class KotlinStdlibCacheImpl
implements KotlinStdlibCache,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StdLibCache stdlibCache;
    @NotNull
    private final StdlibDependencyCache stdlibDependencyCache;
    @NotNull
    private final ModuleStdlibDependencyCache moduleStdlibDependencyCache;
    @NotNull
    private static final String KOTLIN_JAVA_RUNTIME_NAME = "KotlinJavaRuntime";
    @NotNull
    private static final LibraryInfo noStdlibDependency = StdlibDependency.constructor-impl(null);

    public KotlinStdlibCacheImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.stdlibCache = new StdLibCache();
        this.stdlibDependencyCache = new StdlibDependencyCache();
        this.moduleStdlibDependencyCache = new ModuleStdlibDependencyCache();
        Disposer.register((Disposable)this, (Disposable)this.stdlibCache);
        Disposer.register((Disposable)this, (Disposable)this.stdlibDependencyCache);
        Disposer.register((Disposable)this, (Disposable)this.moduleStdlibDependencyCache);
    }

    private final boolean libraryScopeContainsIndexedFilesForName(LibraryInfo libraryInfo, FqName name2) {
        VirtualFile[] virtualFileArray = libraryInfo.getLibrary().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        LibraryScope libraryScope = new LibraryScope(this.project, ArraysKt.toSet((Object[])virtualFileArray));
        Object object = DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> KotlinStdlibCacheImpl.libraryScopeContainsIndexedFilesForName$lambda$0(name2, libraryScope));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoreDumbMode(...)");
        return (Boolean)object;
    }

    private final boolean isFatJar(LibraryInfo libraryInfo) {
        return libraryInfo.getLibraryRoots().size() > 1;
    }

    private final boolean isKotlinJavaRuntime(LibraryInfo libraryInfo) {
        return Intrinsics.areEqual((Object)libraryInfo.getLibrary().getName(), (Object)KOTLIN_JAVA_RUNTIME_NAME);
    }

    @Override
    public boolean isStdlib(@NotNull LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return (Boolean)this.stdlibCache.get(libraryInfo);
    }

    @Override
    public boolean isStdlibDependency(@NotNull LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return (Boolean)this.stdlibDependencyCache.get(libraryInfo);
    }

    @Override
    @Nullable
    public LibraryInfo findStdlibInModuleDependencies(@NotNull IdeaModuleInfo module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ProgressManager.checkCanceled();
        LibraryInfo stdlibDependency = this.moduleStdlibDependencyCache.get-ZbUFyrI(module2);
        return stdlibDependency;
    }

    public void dispose() {
    }

    private final boolean isStdlibWithFile(LibraryInfo $this$isStdlibWithFile, FqName fileName) {
        if (this.isFatJar($this$isStdlibWithFile) && !this.isKotlinJavaRuntime($this$isStdlibWithFile)) {
            return false;
        }
        return this.libraryScopeContainsIndexedFilesForName($this$isStdlibWithFile, fileName);
    }

    private static final Boolean libraryScopeContainsIndexedFilesForName$lambda$0(FqName $name, LibraryScope $libraryScope) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)((Object)$libraryScope), (String)"$libraryScope");
        return FileBasedIndex.getInstance().getContainingFilesIterator(KotlinStdlibIndex.Companion.getNAME(), (Object)$name, (GlobalSearchScope)$libraryScope).hasNext();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0014\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "checkKeyValidity", "", "key", "libraryInfosRemoved", "libraryInfos", "", "subscribe", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "kotlin.base.project-structure"})
    private static abstract class BaseStdLibCache
    extends SynchronizedFineGrainedEntityCache<LibraryInfo, Boolean>
    implements LibraryInfoListener {
        private BaseStdLibCache(Project project2) {
            super(project2, false, true);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection busConnection = this.getProject().getMessageBus().connect((Disposable)this);
            busConnection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            key.checkValidity();
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            FineGrainedEntityCache.invalidateKeys$default(this, libraryInfos, null, 2, null);
        }

        public /* synthetic */ BaseStdLibCache(Project project2, DefaultConstructorMarker $constructor_marker) {
            this(project2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$Companion;", "", "()V", "KOTLIN_JAVA_RUNTIME_NAME", "", "noStdlibDependency", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tj\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "directories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "fileSystems", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/collections/HashSet;", "contains", "", "file", "toString", "", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1620#2,3:292\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope\n*L\n82#1:292,3\n*E\n"})
    private static final class LibraryScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final Set<VirtualFile> directories;
        @NotNull
        private final HashSet<VirtualFileSystem> fileSystems;

        /*
         * WARNING - void declaration
         */
        public LibraryScope(@NotNull Project project2, @NotNull Set<? extends VirtualFile> directories) {
            void destination$iv;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(directories, (String)"directories");
            super(GlobalSearchScope.allScope((Project)project2));
            this.directories = directories;
            Iterable iterable = this.directories;
            Collection collection = new HashSet();
            LibraryScope libraryScope = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                VirtualFile virtualFile2 = (VirtualFile)item$iv;
                void var11_11 = destination$iv;
                boolean bl = false;
                var11_11.add(p0.getFileSystem());
            }
            libraryScope.fileSystems = (HashSet)destination$iv;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.fileSystems.contains(file2.getFileSystem()) && VfsUtilCore.isUnder((VirtualFile)file2, this.directories);
        }

        @NotNull
        public String toString() {
            return "All files under: " + this.directories;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\n0\u0004R\u00060\u0000R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n0\u0007R\u00060\u0000R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "libraryCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$LibraryCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "moduleCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache;", "dispose", "", "get", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "get-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "AbstractCache", "LibraryCache", "ModuleCache", "kotlin.base.project-structure"})
    private final class ModuleStdlibDependencyCache
    implements Disposable {
        @NotNull
        private final LibraryCache libraryCache = new LibraryCache();
        @NotNull
        private final ModuleCache moduleCache = new ModuleCache();

        public ModuleStdlibDependencyCache() {
            Disposer.register((Disposable)this, (Disposable)this.libraryCache);
            Disposer.register((Disposable)this, (Disposable)this.moduleCache);
        }

        @NotNull
        public final LibraryInfo get-ZbUFyrI(@NotNull IdeaModuleInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            IdeaModuleInfo ideaModuleInfo = key;
            return ideaModuleInfo instanceof LibraryInfo ? ((StdlibDependency)this.libraryCache.get(key)).unbox-impl() : ((ideaModuleInfo instanceof SdkInfo ? true : ideaModuleInfo instanceof NotUnderContentRootModuleInfo) ? noStdlibDependency : ((StdlibDependency)this.moduleCache.get(key)).unbox-impl());
        }

        public void dispose() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\bH\u0014J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u0004*\u0004\u0018\u00010\u0010H\u0004\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "checkValueValidity", "", "value", "checkValueValidity-d6v7aPo", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)V", "subscribe", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "findStdLib", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "toStdlibDependency", "toStdlibDependency-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "kotlin.base.project-structure"})
        @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,291:1\n1#2:292\n118#3:293\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache\n*L\n180#1:293\n*E\n"})
        private abstract class AbstractCache<Key extends IdeaModuleInfo>
        extends SynchronizedFineGrainedEntityCache<Key, StdlibDependency>
        implements LibraryInfoListener {
            public AbstractCache() {
                super(KotlinStdlibCacheImpl.this.project, false, true);
            }

            @Override
            protected void subscribe() {
                MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
                connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
                this.subscribe(connection);
            }

            protected void subscribe(@NotNull MessageBusConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            }

            @Nullable
            protected final LibraryInfo findStdLib(@NotNull Key $this$findStdLib) {
                LibraryInfo libraryInfo;
                block7: {
                    List<IdeaModuleInfo> list2;
                    Intrinsics.checkNotNullParameter($this$findStdLib, (String)"<this>");
                    if ($this$findStdLib instanceof LibraryInfo) {
                        if (KotlinStdlibCacheImpl.this.isStdlib((LibraryInfo)$this$findStdLib)) {
                            return (LibraryInfo)$this$findStdLib;
                        }
                        list2 = LibraryDependenciesCache.Companion.getInstance($this$findStdLib.getProject()).getLibraryDependencies((LibraryInfo)$this$findStdLib).getLibraries();
                    } else {
                        list2 = $this$findStdLib.dependencies();
                    }
                    List<IdeaModuleInfo> dependencies2 = list2;
                    Iterable iterable = dependencies2;
                    KotlinStdlibCacheImpl kotlinStdlibCacheImpl = KotlinStdlibCacheImpl.this;
                    for (IdeaModuleInfo it : iterable) {
                        LibraryInfo libraryInfo2;
                        LibraryInfo libraryInfo3;
                        boolean bl = false;
                        IdeaModuleInfo $this$safeAs$iv = it;
                        boolean $i$f$safeAs = false;
                        IdeaModuleInfo ideaModuleInfo = $this$safeAs$iv;
                        if (!(ideaModuleInfo instanceof LibraryInfo)) {
                            ideaModuleInfo = null;
                        }
                        if ((LibraryInfo)ideaModuleInfo != null) {
                            LibraryInfo libraryInfo4;
                            LibraryInfo p0 = libraryInfo4;
                            boolean bl2 = false;
                            libraryInfo3 = kotlinStdlibCacheImpl.isStdlib(p0) ? libraryInfo4 : null;
                        } else {
                            libraryInfo3 = null;
                        }
                        if ((libraryInfo2 = libraryInfo3) == null) continue;
                        libraryInfo = libraryInfo2;
                        break block7;
                    }
                    libraryInfo = null;
                }
                return libraryInfo;
            }

            @NotNull
            protected final LibraryInfo toStdlibDependency-ZbUFyrI(@Nullable LibraryInfo $this$toStdlibDependency_u2dZbUFyrI) {
                if ($this$toStdlibDependency_u2dZbUFyrI != null) {
                    return StdlibDependency.constructor-impl($this$toStdlibDependency_u2dZbUFyrI);
                }
                Boolean flag2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
                    final /* synthetic */ AbstractCache<Key> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Boolean invoke() {
                        return AbstractCache.access$getProject(this.this$0).isDisposed() ? null : (DumbService.Companion.isDumb(AbstractCache.access$getProject(this.this$0)) ? Boolean.valueOf(true) : Boolean.valueOf(false));
                    }
                }));
                Boolean bl = flag2;
                if (bl == null) {
                    throw new ProcessCanceledException();
                }
                if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                    IndexNotReadyException indexNotReadyException = IndexNotReadyException.create();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)indexNotReadyException), (String)"create(...)");
                    throw (Throwable)indexNotReadyException;
                }
                return noStdlibDependency;
            }

            protected void checkValueValidity-d6v7aPo(@NotNull LibraryInfo value2) {
                block0: {
                    LibraryInfo libraryInfo = value2;
                    if (libraryInfo == null) break block0;
                    libraryInfo.checkValidity();
                }
            }

            public static final /* synthetic */ Project access$getProject(AbstractCache $this) {
                return $this.getProject();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0012\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$LibraryCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "calculate", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "calculate-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "checkKeyValidity", "", "libraryInfosRemoved", "libraryInfos", "", "putExtraValues", "map", "", "kotlin.base.project-structure"})
        private final class LibraryCache
        extends AbstractCache<LibraryInfo> {
            @NotNull
            public LibraryInfo calculate-ZbUFyrI(@NotNull LibraryInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return this.toStdlibDependency-ZbUFyrI(this.findStdLib((IdeaModuleInfo)key));
            }

            public final void putExtraValues(@NotNull Map<LibraryInfo, StdlibDependency> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"map");
                this.putAll(map2);
            }

            @Override
            protected void checkKeyValidity(@NotNull LibraryInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                key.checkValidity();
            }

            @Override
            public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                FineGrainedEntityCache.invalidateEntries$default(this, (Function2)new Function2<LibraryInfo, StdlibDependency, Boolean>(libraryInfos){
                    final /* synthetic */ Collection<LibraryInfo> $libraryInfos;
                    {
                        this.$libraryInfos = $libraryInfos;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke-6iLzBBY(@NotNull LibraryInfo k, @NotNull LibraryInfo v) {
                        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                        return this.$libraryInfos.contains(k) || CollectionsKt.contains((Iterable)this.$libraryInfos, (Object)v);
                    }
                }, null, 2, null);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\"\u0010\u0015\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "calculate", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "calculate-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "checkKeyValidity", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "postProcessNewValue", "value", "postProcessNewValue-6iLzBBY", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)V", "subscribe", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "kotlin.base.project-structure"})
        @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 WorkspaceEntityChangeListener.kt\norg/jetbrains/kotlin/idea/base/util/caching/WorkspaceEntityChangeListenerKt\n*L\n1#1,291:1\n118#2:292\n118#2:293\n1#3:294\n1855#4,2:295\n111#5:297\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache\n*L\n230#1:292\n245#1:293\n261#1:295,2\n279#1:297\n*E\n"})
        private final class ModuleCache
        extends AbstractCache<IdeaModuleInfo>
        implements WorkspaceModelChangeListener {
            @Override
            protected void subscribe(@NotNull MessageBusConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)this);
            }

            @NotNull
            public LibraryInfo calculate-ZbUFyrI(@NotNull IdeaModuleInfo key) {
                TrackableModuleInfo trackableModuleInfo;
                block14: {
                    block13: {
                        LibraryInfo libraryInfo;
                        block12: {
                            ModuleSourceInfo moduleSourceInfo;
                            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                            IdeaModuleInfo $this$safeAs$iv = key;
                            boolean $i$f$safeAs = false;
                            IdeaModuleInfo ideaModuleInfo = $this$safeAs$iv;
                            if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                                ideaModuleInfo = null;
                            }
                            if ((trackableModuleInfo = (moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo)) == null || (trackableModuleInfo = trackableModuleInfo.getModule()) == null || (trackableModuleInfo = trackableModuleInfo.getModuleWithLibrariesScope()) == null) break block13;
                            TrackableModuleInfo trackableModuleInfo2 = trackableModuleInfo;
                            KotlinStdlibCacheImpl kotlinStdlibCacheImpl = KotlinStdlibCacheImpl.this;
                            TrackableModuleInfo scope2 = trackableModuleInfo2;
                            boolean bl = false;
                            Collection stdlibManifests = (Collection)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> ModuleCache.calculate_ZbUFyrI$lambda$1$lambda$0((GlobalSearchScope)scope2));
                            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
                            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                            ProjectFileIndex projectFileIndex2 = projectFileIndex;
                            LibraryInfoCache libraryInfoCache2 = LibraryInfoCache.Companion.getInstance(this.getProject());
                            for (VirtualFile manifest : stdlibManifests) {
                                List orderEntries2;
                                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex2.getOrderEntriesForFile(manifest), (String)"getOrderEntriesForFile(...)");
                                Iterator iterator2 = orderEntries2.iterator();
                                while (iterator2.hasNext()) {
                                    Object v6;
                                    block11: {
                                        LibraryEx library2;
                                        OrderEntry entry;
                                        OrderEntry $this$safeAs$iv2 = entry = (OrderEntry)iterator2.next();
                                        boolean $i$f$safeAs2 = false;
                                        OrderEntry orderEntry = $this$safeAs$iv2;
                                        if (!(orderEntry instanceof LibraryOrderEntry)) {
                                            orderEntry = null;
                                        }
                                        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                                        Library $this$safeAs$iv3 = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
                                        boolean $i$f$safeAs3 = false;
                                        Library library3 = $this$safeAs$iv3;
                                        if (!(library3 instanceof LibraryEx)) {
                                            library3 = null;
                                        }
                                        if ((LibraryEx)library3 == null) continue;
                                        List<LibraryInfo> libraryInfos = libraryInfoCache2.get((Library)library2);
                                        Iterable iterable = libraryInfos;
                                        for (Object t : iterable) {
                                            LibraryInfo p0 = (LibraryInfo)t;
                                            boolean bl2 = false;
                                            if (!kotlinStdlibCacheImpl.isStdlib(p0)) continue;
                                            v6 = t;
                                            break block11;
                                        }
                                        v6 = null;
                                    }
                                    if ((libraryInfo = (LibraryInfo)v6) == null) {
                                        continue;
                                    }
                                    break block12;
                                }
                            }
                            libraryInfo = null;
                        }
                        trackableModuleInfo = libraryInfo;
                        if (libraryInfo != null) break block14;
                    }
                    trackableModuleInfo = this.findStdLib(key);
                }
                TrackableModuleInfo stdLib = trackableModuleInfo;
                return this.toStdlibDependency-ZbUFyrI((LibraryInfo)stdLib);
            }

            public void postProcessNewValue-6iLzBBY(@NotNull IdeaModuleInfo key, @NotNull LibraryInfo value2) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                if (!(key instanceof ModuleSourceInfo)) {
                    return;
                }
                HashMap result2 = new HashMap();
                Iterable $this$forEach$iv = key.dependencies();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdeaModuleInfo it = (IdeaModuleInfo)element$iv;
                    boolean bl = false;
                    if (!(it instanceof LibraryInfo)) continue;
                    StdlibDependency stdlibDependency = StdlibDependency.box-impl(value2);
                    ((Map)result2).put(it, stdlibDependency);
                }
                ModuleStdlibDependencyCache.this.libraryCache.putExtraValues(result2);
            }

            @Override
            protected void checkKeyValidity(@NotNull IdeaModuleInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                key.checkValidity();
            }

            @Override
            public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                this.invalidateEntries((Function2)new Function2<IdeaModuleInfo, StdlibDependency, Boolean>(libraryInfos){
                    final /* synthetic */ Collection<LibraryInfo> $libraryInfos;
                    {
                        this.$libraryInfos = $libraryInfos;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke-6iLzBBY(@NotNull IdeaModuleInfo ideaModuleInfo, @NotNull LibraryInfo v) {
                        Intrinsics.checkNotNullParameter((Object)ideaModuleInfo, (String)"<anonymous parameter 0>");
                        return CollectionsKt.contains((Iterable)this.$libraryInfos, (Object)v);
                    }
                }, libraryInfosRemoved.2.INSTANCE);
            }

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VersionedStorageChange $this$getChanges$iv = event;
                boolean $i$f$getChanges = false;
                Collection collection = $this$getChanges$iv.getChanges(ModuleEntity.class);
                if (collection.isEmpty()) {
                    boolean bl = false;
                    return;
                }
                this.invalidate(true);
            }

            private static final Collection calculate_ZbUFyrI$lambda$1$lambda$0(GlobalSearchScope $scope) {
                Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
                return FileBasedIndex.getInstance().getContainingFiles(KotlinStdlibIndex.Companion.getNAME(), (Object)KotlinStdlibIndex.Companion.getKOTLIN_STDLIB_NAME(), $scope);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "calculate", "", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/Boolean;", "kotlin.base.project-structure"})
    private final class StdLibCache
    extends BaseStdLibCache {
        public StdLibCache() {
            super(KotlinStdlibCacheImpl.this.project, null);
        }

        @Override
        @NotNull
        public Boolean calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return KotlinStdlibCacheImpl.this.isStdlibWithFile(key, KotlinStdlibIndex.Companion.getKOTLIN_STDLIB_NAME());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0083@\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "constructor-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "getLibraryInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "equals", "", "other", "equals-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)I", "toString", "", "toString-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/String;", "kotlin.base.project-structure"})
    private static final class StdlibDependency {
        @Nullable
        private final LibraryInfo libraryInfo;

        @Nullable
        public final LibraryInfo getLibraryInfo() {
            return this.libraryInfo;
        }

        public static String toString-impl(LibraryInfo arg0) {
            return "StdlibDependency(libraryInfo=" + arg0 + ")";
        }

        public String toString() {
            return StdlibDependency.toString-impl(this.libraryInfo);
        }

        public static int hashCode-impl(LibraryInfo arg0) {
            LibraryInfo libraryInfo = arg0;
            return libraryInfo == null ? 0 : libraryInfo.hashCode();
        }

        public int hashCode() {
            return StdlibDependency.hashCode-impl(this.libraryInfo);
        }

        public static boolean equals-impl(LibraryInfo arg0, Object other2) {
            if (!(other2 instanceof StdlibDependency)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((StdlibDependency)other2).unbox-impl());
        }

        public boolean equals(Object other2) {
            return StdlibDependency.equals-impl(this.libraryInfo, other2);
        }

        private /* synthetic */ StdlibDependency(LibraryInfo libraryInfo) {
            this.libraryInfo = libraryInfo;
        }

        @NotNull
        public static LibraryInfo constructor-impl(@Nullable LibraryInfo libraryInfo) {
            return libraryInfo;
        }

        public static final /* synthetic */ StdlibDependency box-impl(LibraryInfo v) {
            return new StdlibDependency(v);
        }

        public final /* synthetic */ LibraryInfo unbox-impl() {
            return this.libraryInfo;
        }

        public static final boolean equals-impl0(LibraryInfo p1, LibraryInfo p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "calculate", "", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/Boolean;", "kotlin.base.project-structure"})
    private final class StdlibDependencyCache
    extends BaseStdLibCache {
        public StdlibDependencyCache() {
            super(KotlinStdlibCacheImpl.this.project, null);
        }

        @Override
        @NotNull
        public Boolean calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return KotlinStdlibCacheImpl.this.isStdlibWithFile(key, KotlinStdlibIndex.Companion.getSTANDARD_LIBRARY_DEPENDENCY_NAME());
        }
    }
}

