/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.searching.usages.dialogs;

import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.base.searching.usages.dialogs.Utils;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesSupport;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0007H\u0014J\b\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010$\u001a\u00020\u0013H\u0014R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/base/searching/usages/dialogs/KotlinFindFunctionUsagesDialog;", "Lcom/intellij/find/findUsages/FindMethodUsagesDialog;", "method", "Lorg/jetbrains/kotlin/psi/KtFunction;", "project", "Lcom/intellij/openapi/project/Project;", "findUsagesOptions", "Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinFunctionFindUsagesOptions;", "toShowInNewTab", "", "mustOpenInNewTab", "isSingleFile", "handler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/base/searching/usages/KotlinFunctionFindUsagesOptions;ZZZLcom/intellij/find/findUsages/FindUsagesHandler;)V", "expectedUsages", "Lcom/intellij/ui/StateRestoringCheckBox;", "overrideUsages", "addUsagesOptions", "", "optionsPanel", "Ljavax/swing/JPanel;", "calcFindUsagesOptions", "options", "Lcom/intellij/find/findUsages/JavaMethodFindUsagesOptions;", "canSearchForBaseMethod", "element", "Lcom/intellij/psi/PsiElement;", "canSearchForImplementingMethods", "canSearchForOverridingMethods", "configureLabelComponent", "coloredComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "getFindUsagesOptions", "isIncludeOverloadedMethodsAvailable", "noSpecificOptions", "update", "kotlin.searching.base"})
public final class KotlinFindFunctionUsagesDialog
extends FindMethodUsagesDialog {
    @Nullable
    private StateRestoringCheckBox expectedUsages;
    @Nullable
    private StateRestoringCheckBox overrideUsages;

    public KotlinFindFunctionUsagesDialog(@NotNull KtFunction method, @NotNull Project project2, @NotNull KotlinFunctionFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)findUsagesOptions, (String)"findUsagesOptions");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        super((PsiElement)method, project2, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    protected boolean noSpecificOptions(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return false;
    }

    protected boolean canSearchForOverridingMethods(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return false;
    }

    protected boolean canSearchForImplementingMethods(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return false;
    }

    protected boolean canSearchForBaseMethod(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtFunction && !((KtFunction)element3).hasModifier(KtTokens.PRIVATE_KEYWORD);
    }

    public boolean isIncludeOverloadedMethodsAvailable() {
        return true;
    }

    @NotNull
    protected KotlinFunctionFindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions = this.myFindUsagesOptions;
        Intrinsics.checkNotNull((Object)findUsagesOptions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.searching.usages.KotlinFunctionFindUsagesOptions");
        return (KotlinFunctionFindUsagesOptions)findUsagesOptions;
    }

    protected void addUsagesOptions(@NotNull JPanel optionsPanel) {
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter((Object)optionsPanel, (String)"optionsPanel");
        super.addUsagesOptions(optionsPanel);
        PsiElement psiElement2 = this.myUsagesHandler.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        KtNamedDeclaration method = (KtNamedDeclaration)psiElement2;
        if (Utils.isOpen(method)) {
            this.overrideUsages = this.addCheckboxToPanel(Utils.isAbstract(method) ? KotlinBundle.message((String)"find.declaration.implementing.methods.checkbox", (Object[])new Object[0]) : KotlinBundle.message((String)"find.declaration.overriding.methods.checkbox", (Object[])new Object[0]), this.getFindUsagesOptions().getSearchOverrides(), optionsPanel, true);
        }
        if (!Utils.renameCheckbox(optionsPanel, JavaBundle.message((String)"find.options.include.overloaded.methods.checkbox", (Object[])new Object[0]), KotlinBundle.message((String)"find.declaration.include.overloaded.methods.checkbox", (Object[])new Object[0]))) {
            this.addCheckboxToPanel(KotlinBundle.message((String)"find.declaration.include.overloaded.methods.checkbox", (Object[])new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        PsiElement psiElement3 = this.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPsiElement(...)");
        PsiElement element3 = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement3);
        if (element3 instanceof KtNamedDeclaration) {
            ktDeclaration = (KtDeclaration)((KtNamedDeclaration)element3);
        } else {
            Intrinsics.checkNotNull((Object)element3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.asJava.elements.KtLightMethod");
            ktDeclaration = (KtDeclaration)((KtLightMethod)element3).getKotlinOrigin();
        }
        KtDeclaration function2 = ktDeclaration;
        boolean isActual = function2 != null && PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)function2));
        KotlinFunctionFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundle.message((String)"find.usages.checkbox.name.expected.functions", (Object[])new Object[0]), options2.getSearchExpected(), optionsPanel, false);
        }
    }

    public void calcFindUsagesOptions(@NotNull JavaMethodFindUsagesOptions options2) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        super.calcFindUsagesOptions(options2);
        options2.isOverridingMethods = FindMethodUsagesDialog.isSelected((JCheckBox)((JCheckBox)this.overrideUsages));
        KotlinFunctionFindUsagesOptions kotlinOptions = (KotlinFunctionFindUsagesOptions)options2;
        if (this.expectedUsages != null) {
            StateRestoringCheckBox stateRestoringCheckBox = this.expectedUsages;
            Intrinsics.checkNotNull((Object)stateRestoringCheckBox);
            kotlinOptions.setSearchExpected(stateRestoringCheckBox.isSelected());
        }
    }

    protected void update() {
        super.update();
        if (!this.isOKActionEnabled() && FindMethodUsagesDialog.isSelected((JCheckBox)((JCheckBox)this.overrideUsages))) {
            this.setOKActionEnabled(true);
        }
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        Intrinsics.checkNotNullParameter((Object)coloredComponent, (String)"coloredComponent");
        PsiElement psiElement2 = this.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        coloredComponent.append(KotlinFindUsagesSupport.Companion.renderDeclaration((KtDeclaration)((KtFunction)psiElement2)));
    }
}

