/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.ImplicitPackagePrefixCache;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheServiceKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.NotNullableUserDataProperty;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 02\u00020\u0001:\u0003012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0017\u001a&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00070\u00070\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\tH\u0002J\u0015\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020\u0019J\u0016\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\tJ\u0014\u0010(\u001a\u00020\u000b*\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0002J/\u0010+\u001a\u00020\u0019\"\u0004\b\u0000\u0010,*\b\u0012\u0004\u0012\u0002H,0-2\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020\u00190/H\u0082\bR8\u0010\u0005\u001a,\u0012(\u0012&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00070\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cacheInstance", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/name/FqName;", "", "implicitPackagePrefixCache", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "pendingKtFileChanges", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "pendingVFileChanges", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "useStrongMapForCaching", "cache", "checkPendingChanges", "", "clear", "dispose", "getImplicitPackagePrefix", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "invalidateCacheForModuleSourceInfo", "moduleSourceInfo", "notifyPackageChange", "file", "notifyPackageChange$kotlin_base_analysis", "onTooComplexChange", "packageExists", "packageFqName", "moduleInfo", "containedInOrContains", "root", "", "processPending", "T", "", "body", "Lkotlin/Function1;", "Companion", "PackageCacheBulkFileListener", "PackageCacheModuleRootListener", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,440:1\n307#1:442\n319#1:443\n307#1:444\n319#1:445\n1#2:441\n1#2:448\n1#2:451\n1#2:454\n72#3,2:446\n72#3,2:449\n72#3,2:452\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService\n*L\n260#1:442\n260#1:443\n289#1:444\n289#1:445\n330#1:448\n333#1:451\n338#1:454\n330#1:446,2\n333#1:449,2\n338#1:452,2\n*E\n"})
public final class PerModulePackageCacheService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>>> cacheInstance;
    @NotNull
    private final ImplicitPackagePrefixCache implicitPackagePrefixCache;
    private final boolean useStrongMapForCaching;
    @NotNull
    private final Set<VFileEvent> pendingVFileChanges;
    @NotNull
    private final Set<KtFile> pendingKtFileChanges;
    @NotNull
    private final GlobalSearchScope projectScope;
    public static final int FULL_DROP_THRESHOLD = 1000;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final NotNullableUserDataProperty<? super Project, Boolean> DEBUG_LOG_ENABLE_PerModulePackageCache$delegate;

    public PerModulePackageCacheService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.cacheInstance = new AtomicReference();
        this.implicitPackagePrefixCache = new ImplicitPackagePrefixCache(this.project);
        this.useStrongMapForCaching = Registry.is((String)"kotlin.cache.packages.strong.map", (boolean)false);
        this.pendingVFileChanges = new LinkedHashSet();
        this.pendingKtFileChanges = new LinkedHashSet();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        this.projectScope = globalSearchScope;
    }

    public final void onTooComplexChange() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            this.pendingVFileChanges.clear();
            this.pendingKtFileChanges.clear();
            this.cacheInstance.set(null);
            this.implicitPackagePrefixCache.clear$kotlin_base_analysis();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache() {
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap;
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap2 = this.cacheInstance.get();
        if (concurrentMap2 != null) {
            ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> it = concurrentMap2;
            boolean bl = false;
            return it;
        }
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap3 = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"createConcurrentWeakMap(...)");
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> map2 = concurrentMap3;
        if (this.cacheInstance.compareAndSet(null, map2)) {
            concurrentMap = map2;
        } else {
            ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap4 = this.cacheInstance.get();
            Intrinsics.checkNotNull(concurrentMap4);
            concurrentMap = concurrentMap4;
        }
        return concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$kotlin_base_analysis(@NotNull VFileEvent file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            ((Collection)this.pendingVFileChanges).add(file2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$kotlin_base_analysis(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            ((Collection)this.pendingKtFileChanges).add(file2);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void invalidateCacheForModuleSourceInfo(ModuleSourceInfo moduleSourceInfo) {
        PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, (Function0)new Function0<String>(moduleSourceInfo){
            final /* synthetic */ ModuleSourceInfo $moduleSourceInfo;
            {
                this.$moduleSourceInfo = $moduleSourceInfo;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Invalidated cache for " + this.$moduleSourceInfo;
            }
        }, 2, null);
        ConcurrentMap cache2 = this.cacheInstance.get();
        ConcurrentMap concurrentMap = cache2;
        if (concurrentMap == null || (concurrentMap = (ConcurrentMap)concurrentMap.get(moduleSourceInfo.getModule())) == null) {
            return;
        }
        ConcurrentMap perSourceInfoData = concurrentMap;
        ConcurrentMap concurrentMap2 = (ConcurrentMap)perSourceInfoData.get(moduleSourceInfo);
        if (concurrentMap2 == null) {
            return;
        }
        ConcurrentMap dataForSourceInfo = concurrentMap2;
        dataForSourceInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPendingChanges() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            if (this.pendingVFileChanges.size() + this.pendingKtFileChanges.size() >= 1000) {
                this.onTooComplexChange();
            } else {
                PerModulePackageCacheService perModulePackageCacheService2 = this;
                Collection $this$processPending$iv = this.pendingVFileChanges;
                boolean $i$f$processPending = false;
                Function1 function1 = (Function1)new Function1<VFileEvent, Boolean>(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                        super(1);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @NotNull
                    public final Boolean invoke(Object value2) {
                        block10: {
                            try {
                                VFileEvent event = (VFileEvent)value2;
                                boolean bl = false;
                                VirtualFile virtualFile2 = event.getFile();
                                if (virtualFile2 == null) break block10;
                                Object object = virtualFile2;
                                Intrinsics.checkNotNull((Object)object);
                                VirtualFile vfile = object;
                                if (vfile.isDirectory() || !vfile.isValid()) {
                                    Object object2 = object = (ConcurrentMap)PerModulePackageCacheService.access$getCacheInstance$p(this.this$0).get();
                                    if (object2 != null) {
                                        Intrinsics.checkNotNull((Object)object2);
                                        Object cache2 = object;
                                        boolean bl2 = false;
                                        for (Map.Entry<K, V> entry : ((Map)cache2).entrySet()) {
                                            boolean bl3;
                                            ConcurrentMap data;
                                            Module module2;
                                            block11: {
                                                String[] sourceRootUrls;
                                                module2 = (Module)entry.getKey();
                                                data = (ConcurrentMap)entry.getValue();
                                                Intrinsics.checkNotNull((Object)module2);
                                                Intrinsics.checkNotNullExpressionValue((Object)ProjectUtil.getRootManager((Module)module2).getSourceRootUrls(), (String)"getSourceRootUrls(...)");
                                                String[] $this$any$iv = sourceRootUrls;
                                                boolean $i$f$any = false;
                                                int n = $this$any$iv.length;
                                                for (int j = 0; j < n; ++j) {
                                                    String element$iv;
                                                    String url = element$iv = $this$any$iv[j];
                                                    boolean bl4 = false;
                                                    Intrinsics.checkNotNull((Object)url);
                                                    if (!PerModulePackageCacheService.access$containedInOrContains(this.this$0, vfile, url)) continue;
                                                    bl3 = true;
                                                    break block11;
                                                }
                                                bl3 = false;
                                            }
                                            if (!bl3) continue;
                                            PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(module2){
                                                final /* synthetic */ Module $module;
                                                {
                                                    this.$module = $module;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final String invoke() {
                                                    return "Invalidated cache for " + this.$module;
                                                }
                                            }, 2, null);
                                            data.clear();
                                        }
                                    }
                                } else {
                                    IdeaModuleInfo infoByVirtualFile = ModuleInfoProviderUtils.firstOrNull(ModuleInfoProvider.Companion.getInstance(PerModulePackageCacheService.access$getProject$p(this.this$0)), vfile);
                                    if (infoByVirtualFile == null || !(infoByVirtualFile instanceof ModuleSourceInfo)) {
                                        PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(vfile, infoByVirtualFile){
                                            final /* synthetic */ VirtualFile $vfile;
                                            final /* synthetic */ IdeaModuleInfo $infoByVirtualFile;
                                            {
                                                this.$vfile = $vfile;
                                                this.$infoByVirtualFile = $infoByVirtualFile;
                                                super(0);
                                            }

                                            @NotNull
                                            public final String invoke() {
                                                return "Skip " + this.$vfile + " as it has mismatched ModuleInfo=" + this.$infoByVirtualFile;
                                            }
                                        }, 2, null);
                                    }
                                    ModuleSourceInfo moduleSourceInfo = infoByVirtualFile instanceof ModuleSourceInfo ? (ModuleSourceInfo)infoByVirtualFile : null;
                                    if (moduleSourceInfo != null) {
                                        ModuleSourceInfo it = moduleSourceInfo;
                                        boolean bl5 = false;
                                        PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                    }
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$kotlin_base_analysis(event);
                            }
                            catch (ProcessCanceledException pce) {
                                throw pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                };
                $this$processPending$iv.removeIf(new Predicate(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                        this.function = function2;
                    }

                    public final /* synthetic */ boolean test(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                });
                PerModulePackageCacheService this_$iv = this;
                $this$processPending$iv = this.pendingKtFileChanges;
                $i$f$processPending = false;
                function1 = (Function1)new Function1<KtFile, Boolean>(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                        super(1);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @NotNull
                    public final Boolean invoke(Object value2) {
                        block6: {
                            try {
                                KtFile file2 = (KtFile)value2;
                                boolean bl = false;
                                if (file2.getVirtualFile() != null && !PerModulePackageCacheService.access$getProjectScope$p(this.this$0).contains(file2.getVirtualFile())) {
                                    PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file2, this.this$0){
                                        final /* synthetic */ KtFile $file;
                                        final /* synthetic */ PerModulePackageCacheService this$0;
                                        {
                                            this.$file = $file;
                                            this.this$0 = $receiver;
                                            super(0);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        @NotNull
                                        public final String invoke() {
                                            Boolean bl;
                                            KtFile ktFile2 = this.$file;
                                            VirtualFile virtualFile2 = this.$file.getVirtualFile();
                                            if (virtualFile2 != null) {
                                                void it;
                                                VirtualFile virtualFile3 = virtualFile2;
                                                PerModulePackageCacheService perModulePackageCacheService = this.this$0;
                                                VirtualFile virtualFile4 = virtualFile3;
                                                KtFile ktFile3 = ktFile2;
                                                boolean bl2 = false;
                                                bl = !PerModulePackageCacheService.access$getProjectScope$p(perModulePackageCacheService).contains((VirtualFile)it);
                                                ktFile2 = ktFile3;
                                            } else {
                                                bl = null;
                                            }
                                            return "Skip " + ktFile2 + " without vFile, or not in scope: " + bl;
                                        }
                                    }, 2, null);
                                    break block6;
                                }
                                IdeaModuleInfo nullableModuleInfo = ModuleInfoProviderUtils.getModuleInfoOrNull((PsiElement)file2);
                                ModuleSourceInfo moduleSourceInfo = nullableModuleInfo instanceof ModuleSourceInfo ? (ModuleSourceInfo)nullableModuleInfo : null;
                                if (moduleSourceInfo != null) {
                                    ModuleSourceInfo it = moduleSourceInfo;
                                    boolean bl2 = false;
                                    PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                }
                                if (nullableModuleInfo == null || !(nullableModuleInfo instanceof ModuleSourceInfo)) {
                                    PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file2, nullableModuleInfo){
                                        final /* synthetic */ KtFile $file;
                                        final /* synthetic */ IdeaModuleInfo $nullableModuleInfo;
                                        {
                                            this.$file = $file;
                                            this.$nullableModuleInfo = $nullableModuleInfo;
                                            super(0);
                                        }

                                        @NotNull
                                        public final String invoke() {
                                            return "Skip " + this.$file + " as it has mismatched ModuleInfo=" + this.$nullableModuleInfo;
                                        }
                                    }, 2, null);
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$kotlin_base_analysis(file2);
                            }
                            catch (ProcessCanceledException pce) {
                                throw pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                };
                $this$processPending$iv.removeIf(new /* invalid duplicate definition of identical inner class */);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void processPending(Collection<T> $this$processPending, Function1<? super T, Unit> body2) {
        boolean $i$f$processPending = false;
        Function1 function1 = new Function1<T, Boolean>(body2){
            final /* synthetic */ Function1<T, Unit> $body;
            {
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Boolean invoke(T value2) {
                try {
                    this.$body.invoke(value2);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception exc) {
                    PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                }
                return true;
            }
        };
        $this$processPending.removeIf(new /* invalid duplicate definition of identical inner class */);
    }

    private final boolean containedInOrContains(VirtualFile $this$containedInOrContains, String root) {
        return VfsUtilCore.isEqualOrAncestor((String)$this$containedInOrContains.getUrl(), (String)root) || $this$containedInOrContains.isDirectory() && VfsUtilCore.isEqualOrAncestor((String)root, (String)$this$containedInOrContains.getUrl());
    }

    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        boolean bl;
        boolean bl2;
        ConcurrentMap perSourceInfoCache;
        ConcurrentMap default$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Module module2 = moduleInfo.getModule();
        this.checkPendingChanges();
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> $this$getOrPut$iv = this.cache();
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(module2);
        if (object2 == null) {
            boolean bl3 = false;
            object = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNull((Object)object);
            default$iv = object;
            boolean bl4 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(module2, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        ConcurrentMap $this$getOrPut$iv2 = perSourceInfoCache = (ConcurrentMap)object2;
        boolean $i$f$getOrPut2 = false;
        Object object3 = $this$getOrPut$iv2.get(moduleInfo);
        if (object3 == null) {
            boolean bl5 = false;
            default$iv = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNull((Object)default$iv);
            ConcurrentMap default$iv2 = default$iv;
            bl2 = false;
            object3 = $this$getOrPut$iv2.putIfAbsent(moduleInfo, default$iv2);
            if (object3 == null) {
                object3 = default$iv2;
            }
        }
        ConcurrentMap cacheForCurrentModuleInfo = (ConcurrentMap)object3;
        try {
            $this$getOrPut$iv2 = cacheForCurrentModuleInfo;
            $i$f$getOrPut2 = false;
            Object object4 = $this$getOrPut$iv2.get(packageFqName);
            if (object4 == null) {
                boolean bl6 = false;
                boolean packageExists2 = KotlinPackageIndexUtils.INSTANCE.packageExists(packageFqName, moduleInfo.getContentScope());
                PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, (Function0)new Function0<String>(packageFqName, moduleInfo, packageExists2){
                    final /* synthetic */ FqName $packageFqName;
                    final /* synthetic */ ModuleSourceInfo $moduleInfo;
                    final /* synthetic */ boolean $packageExists;
                    {
                        this.$packageFqName = $packageFqName;
                        this.$moduleInfo = $moduleInfo;
                        this.$packageExists = $packageExists;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Computed cache value for " + this.$packageFqName + " in " + this.$moduleInfo + " is " + this.$packageExists;
                    }
                }, 2, null);
                Boolean default$iv3 = packageExists2;
                bl2 = false;
                object4 = $this$getOrPut$iv2.putIfAbsent(packageFqName, default$iv3);
                if (object4 == null) {
                    object4 = default$iv3;
                }
            }
            bl = (Boolean)object4;
        }
        catch (IndexNotReadyException e) {
            object = DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> PerModulePackageCacheService.packageExists$lambda$14(packageFqName, moduleInfo));
            Intrinsics.checkNotNull((Object)object);
            bl = (Boolean)object;
        }
        return bl;
    }

    @NotNull
    public final FqName getImplicitPackagePrefix(@NotNull VirtualFile sourceRoot) {
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        this.checkPendingChanges();
        return this.implicitPackagePrefixCache.getPrefix(sourceRoot);
    }

    public void dispose() {
        this.clear();
    }

    private static final Boolean packageExists$lambda$14(FqName $packageFqName, ModuleSourceInfo $moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)$packageFqName, (String)"$packageFqName");
        Intrinsics.checkNotNullParameter((Object)$moduleInfo, (String)"$moduleInfo");
        return KotlinPackageIndexUtils.INSTANCE.packageExists($packageFqName, $moduleInfo.getContentScope());
    }

    public static final /* synthetic */ boolean access$containedInOrContains(PerModulePackageCacheService $this, VirtualFile $receiver, String root) {
        return $this.containedInOrContains($receiver, root);
    }

    public static final /* synthetic */ Project access$getProject$p(PerModulePackageCacheService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$invalidateCacheForModuleSourceInfo(PerModulePackageCacheService $this, ModuleSourceInfo moduleSourceInfo) {
        $this.invalidateCacheForModuleSourceInfo(moduleSourceInfo);
    }

    public static final /* synthetic */ AtomicReference access$getCacheInstance$p(PerModulePackageCacheService $this) {
        return $this.cacheInstance;
    }

    public static final /* synthetic */ ImplicitPackagePrefixCache access$getImplicitPackagePrefixCache$p(PerModulePackageCacheService $this) {
        return $this.implicitPackagePrefixCache;
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectScope$p(PerModulePackageCacheService $this) {
        return $this.projectScope;
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"debug.PerModulePackageCache");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEBUG_LOG_ENABLE_PerModulePackageCache$delegate = new NotNullableUserDataProperty(key, (Object)false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "()V", "FULL_DROP_THRESHOLD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "", "DEBUG_LOG_ENABLE_PerModulePackageCache", "Lcom/intellij/openapi/project/Project;", "getDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;)Z", "setDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;Z)V", "DEBUG_LOG_ENABLE_PerModulePackageCache$delegate", "Lorg/jetbrains/kotlin/psi/NotNullableUserDataProperty;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "project", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,440:1\n31#2,2:441\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion\n*L\n363#1:441,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final PerModulePackageCacheService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<PerModulePackageCacheService> serviceClass$iv = PerModulePackageCacheService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PerModulePackageCacheService)object;
        }

        public final boolean getDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"<this>");
            return (Boolean)DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.getValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0]);
        }

        public final void setDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"<this>");
            DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.setValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0], (Object)bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "DEBUG_LOG_ENABLE_PerModulePackageCache", "getDEBUG_LOG_ENABLE_PerModulePackageCache(Lcom/intellij/openapi/project/Project;)Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "isRelevant", "", "event", "onEvents", "isAfter", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,440:1\n1313#2,2:441\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener\n*L\n418#1:441,2\n*E\n"})
    public static final class PackageCacheBulkFileListener
    implements BulkFileListener {
        @NotNull
        private final Project project;

        public PackageCacheBulkFileListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, false);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, true);
        }

        private final boolean isRelevant(VFileEvent event) {
            boolean bl;
            VFileEvent vFileEvent = event;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                bl = false;
            } else if (vFileEvent instanceof VFileCreateEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileMoveEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileContentChangeEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileCopyEvent) {
                bl = true;
            } else {
                LOG.warn("Unknown vfs event: " + event.getClass());
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final void onEvents(List<? extends VFileEvent> events, boolean isAfter) {
            PerModulePackageCacheService service2 = Companion.getInstance(this.project);
            FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.project).getFileManager();
            Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"getFileManager(...)");
            FileManager fileManager2 = fileManager;
            if (events.size() >= 1000) {
                service2.onTooComplexChange();
            } else {
                void $this$forEach$iv;
                Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull VFileEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return PackageCacheBulkFileListener.access$isRelevant((PackageCacheBulkFileListener)this.receiver, p0);
                    }
                })), (Function1)onEvents.2.INSTANCE), (Function1)onEvents.3.INSTANCE), (Function1)((Function1)new Function1<VFileEvent, Boolean>(isAfter, fileManager2){
                    final /* synthetic */ boolean $isAfter;
                    final /* synthetic */ FileManager $fileManager;
                    {
                        this.$isAfter = $isAfter;
                        this.$fileManager = $fileManager;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VFileEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it instanceof VFileContentChangeEvent ? this.$isAfter && this.$fileManager.findCachedViewProvider(((VFileContentChangeEvent)it).getFile()) == null : true;
                    }
                })), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){
                    final /* synthetic */ PackageCacheBulkFileListener this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull VFileEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object origin = it.getRequestor();
                        return origin instanceof Project ? Intrinsics.areEqual((Object)origin, (Object)PackageCacheBulkFileListener.access$getProject$p(this.this$0)) : (origin instanceof PsiManager ? Intrinsics.areEqual((Object)((PsiManager)origin).getProject(), (Object)PackageCacheBulkFileListener.access$getProject$p(this.this$0)) : true);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    service2.notifyPackageChange$kotlin_base_analysis(event);
                }
            }
        }

        public static final /* synthetic */ boolean access$isRelevant(PackageCacheBulkFileListener $this, VFileEvent event) {
            return $this.isRelevant(event);
        }

        public static final /* synthetic */ Project access$getProject$p(PackageCacheBulkFileListener $this) {
            return $this.project;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheModuleRootListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rootsChanged", "", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "kotlin.base.analysis"})
    public static final class PackageCacheModuleRootListener
    implements ModuleRootListener {
        @NotNull
        private final Project project;

        public PackageCacheModuleRootListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.getInstance(this.project).onTooComplexChange();
        }
    }
}

