/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.trackers;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinModuleOutOfCodeBlockModificationTracker;
import org.jetbrains.kotlin.idea.caches.trackers.PureKotlinCodeBlockModificationListener;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "kotlinModificationCount", "", "kotlinOutOfCodeBlockTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getKotlinOutOfCodeBlockTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "kotlinOutOfCodeBlockTrackerImpl", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "modificationTrackerImpl", "Lcom/intellij/psi/util/PsiModificationTracker;", "dispose", "", "incModificationCount", "treeChanged", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "Companion", "kotlin.base.analysis"})
public final class KotlinCodeBlockModificationListener
implements PsiTreeChangePreprocessor,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiModificationTracker modificationTrackerImpl;
    private volatile long kotlinModificationCount;
    @NotNull
    private final SimpleModificationTracker kotlinOutOfCodeBlockTrackerImpl;
    @NotNull
    private final ModificationTracker kotlinOutOfCodeBlockTracker;

    public KotlinCodeBlockModificationListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"getInstance(...)");
        this.modificationTrackerImpl = psiModificationTracker;
        this.kotlinOutOfCodeBlockTrackerImpl = new SimpleModificationTracker();
        this.kotlinOutOfCodeBlockTracker = (ModificationTracker)this.kotlinOutOfCodeBlockTrackerImpl;
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)this);
        KotlinModuleOutOfCodeBlockModificationTracker.Updater perModuleOutOfCodeBlockTrackerUpdater = KotlinModuleOutOfCodeBlockModificationTracker.Companion.getUpdaterInstance$kotlin_base_analysis(project2);
        PureKotlinCodeBlockModificationListener.Companion.getInstance(project2);
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)psiManager, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiManagerImpl");
        ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)this);
        Topic topic = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> KotlinCodeBlockModificationListener._init_$lambda$0(this, perModuleOutOfCodeBlockTrackerUpdater));
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.incModificationCount();
            }

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.incModificationCount();
            }
        });
    }

    @NotNull
    public final ModificationTracker getKotlinOutOfCodeBlockTracker() {
        return this.kotlinOutOfCodeBlockTracker;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        boolean outOfCodeBlock;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event)) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                boolean bl;
                if (event.getPropertyName() == "propUnloadedPsi" || event.getPropertyName() == "roots") {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = outOfCodeBlock = event.getParent() instanceof PsiDirectory;
            }
        }
        if (outOfCodeBlock) {
            this.incModificationCount();
        }
    }

    public final void incModificationCount() {
        this.kotlinOutOfCodeBlockTrackerImpl.incModificationCount();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(KotlinCodeBlockModificationListener this$0, KotlinModuleOutOfCodeBlockModificationTracker.Updater $perModuleOutOfCodeBlockTrackerUpdater) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$perModuleOutOfCodeBlockTrackerUpdater, (String)"$perModuleOutOfCodeBlockTrackerUpdater");
        long kotlinTrackerInternalIDECount = this$0.modificationTrackerImpl.forLanguage((Language)KotlinLanguage.INSTANCE).getModificationCount();
        if (this$0.kotlinModificationCount == kotlinTrackerInternalIDECount) {
            this$0.incModificationCount();
        } else {
            this$0.kotlinModificationCount = kotlinTrackerInternalIDECount;
        }
        KotlinModuleOutOfCodeBlockModificationTracker.Updater.onPsiModificationTrackerUpdate$kotlin_base_analysis$default($perModuleOutOfCodeBlockTrackerUpdater, 0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nKotlinCodeBlockModificationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeBlockModificationListener.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,104:1\n31#2,2:105\n*S KotlinDebug\n*F\n+ 1 KotlinCodeBlockModificationListener.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion\n*L\n63#1:105,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinCodeBlockModificationListener getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KotlinCodeBlockModificationListener> serviceClass$iv = KotlinCodeBlockModificationListener.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinCodeBlockModificationListener)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

