/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001c\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005*\u00020\u0003H\u0007\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\b*\u00020\u000bH\u0007\u001a\f\u0010\f\u001a\u00020\b*\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"getRangeBinaryExpressionType", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/RangeKtExpressionType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getRangeLeftAndRightSigns", "Lkotlin/Pair;", "", "hasIllegalLiteralPrefixOrSuffix", "", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "illegalLiteralPrefixOrSuffix", "Lcom/intellij/psi/PsiElement;", "isFollowedByNewLine", "Lcom/intellij/lang/ASTNode;", "kotlin.code-insight.impl-base"})
public final class InlayHintUtilsKt {
    @ApiStatus.Internal
    public static final boolean isFollowedByNewLine(@NotNull ASTNode $this$isFollowedByNewLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isFollowedByNewLine, (String)"<this>");
        for (ASTNode sibling : PsiUtilsKt.siblings$default((ASTNode)$this$isFollowedByNewLine, (boolean)false, (int)1, null)) {
            if (!Intrinsics.areEqual((Object)sibling.getElementType(), (Object)TokenType.WHITE_SPACE) && !(sibling.getPsi() instanceof PsiComment) || !Intrinsics.areEqual((Object)sibling.getElementType(), (Object)TokenType.WHITE_SPACE) || !sibling.textContains('\n')) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public static final RangeKtExpressionType getRangeBinaryExpressionType(@NotNull KtExpression expression2) {
        RangeKtExpressionType rangeKtExpressionType;
        String dotQualifiedName;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtBinaryExpression ktBinaryExpression = expression2 instanceof KtBinaryExpression ? (KtBinaryExpression)expression2 : null;
        Object operationReference = ktBinaryExpression != null ? ktBinaryExpression.getOperationReference() : null;
        KtOperationReferenceExpression ktOperationReferenceExpression = operationReference;
        String binaryExprName = ktOperationReferenceExpression != null && (ktOperationReferenceExpression = ktOperationReferenceExpression.getReferencedNameAsName()) != null ? ktOperationReferenceExpression.asString() : null;
        KtDotQualifiedExpression ktDotQualifiedExpression = expression2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)expression2 : null;
        String string = dotQualifiedName = ktDotQualifiedExpression != null && (ktDotQualifiedExpression = KotlinPsiUtilsKt.getCallExpression((KtQualifiedExpression)ktDotQualifiedExpression)) != null && (ktDotQualifiedExpression = ktDotQualifiedExpression.getCalleeExpression()) != null ? ktDotQualifiedExpression.getText() : null;
        String string2 = binaryExprName;
        if (string2 == null) {
            string2 = dotQualifiedName;
        }
        String name2 = string2;
        if (Intrinsics.areEqual((Object)binaryExprName, (Object)"..") || Intrinsics.areEqual((Object)dotQualifiedName, (Object)"rangeTo")) {
            rangeKtExpressionType = RangeKtExpressionType.RANGE_TO;
        } else if (Intrinsics.areEqual((Object)binaryExprName, (Object)"..<") || Intrinsics.areEqual((Object)dotQualifiedName, (Object)"rangeUntil")) {
            rangeKtExpressionType = RangeKtExpressionType.RANGE_UNTIL;
        } else if (Intrinsics.areEqual((Object)name2, (Object)"downTo")) {
            KtOperationReferenceExpression ktOperationReferenceExpression2 = operationReference;
            if (!(ktOperationReferenceExpression2 != null ? !InlayHintUtilsKt.hasIllegalLiteralPrefixOrSuffix(ktOperationReferenceExpression2) : false)) {
                return null;
            }
            rangeKtExpressionType = RangeKtExpressionType.DOWN_TO;
        } else if (Intrinsics.areEqual((Object)name2, (Object)"until")) {
            KtOperationReferenceExpression ktOperationReferenceExpression3 = operationReference;
            if (!(ktOperationReferenceExpression3 != null ? !InlayHintUtilsKt.hasIllegalLiteralPrefixOrSuffix(ktOperationReferenceExpression3) : false)) {
                return null;
            }
            rangeKtExpressionType = RangeKtExpressionType.UNTIL;
        } else {
            rangeKtExpressionType = null;
        }
        return rangeKtExpressionType;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Pair<String, String> getRangeLeftAndRightSigns(@NotNull KtExpression $this$getRangeLeftAndRightSigns) {
        Intrinsics.checkNotNullParameter((Object)$this$getRangeLeftAndRightSigns, (String)"<this>");
        RangeKtExpressionType rangeKtExpressionType = InlayHintUtilsKt.getRangeBinaryExpressionType($this$getRangeLeftAndRightSigns);
        if (rangeKtExpressionType == null) {
            return null;
        }
        RangeKtExpressionType type2 = rangeKtExpressionType;
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> TuplesKt.to((Object)KotlinBundle.message((String)"hints.ranges.lessOrEqual", (Object[])new Object[0]), (Object)KotlinBundle.message((String)"hints.ranges.lessOrEqual", (Object[])new Object[0]));
            case 2 -> TuplesKt.to((Object)KotlinBundle.message((String)"hints.ranges.lessOrEqual", (Object[])new Object[0]), null);
            case 3 -> TuplesKt.to((Object)KotlinBundle.message((String)"hints.ranges.greaterOrEqual", (Object[])new Object[0]), (Object)KotlinBundle.message((String)"hints.ranges.greaterOrEqual", (Object[])new Object[0]));
            case 4 -> TuplesKt.to((Object)KotlinBundle.message((String)"hints.ranges.lessOrEqual", (Object[])new Object[0]), (Object)KotlinBundle.message((String)"hints.ranges.less", (Object[])new Object[0]));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasIllegalLiteralPrefixOrSuffix(KtOperationReferenceExpression $this$hasIllegalLiteralPrefixOrSuffix) {
        boolean bl;
        PsiElement prevLeaf2 = PsiTreeUtil.prevLeaf((PsiElement)((PsiElement)$this$hasIllegalLiteralPrefixOrSuffix));
        PsiElement nextLeaf2 = PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)$this$hasIllegalLiteralPrefixOrSuffix));
        PsiElement psiElement2 = prevLeaf2;
        if (psiElement2 != null) {
            if (InlayHintUtilsKt.illegalLiteralPrefixOrSuffix(psiElement2)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        PsiElement psiElement3 = nextLeaf2;
        if (psiElement3 == null) return false;
        if (!InlayHintUtilsKt.illegalLiteralPrefixOrSuffix(psiElement3)) return false;
        return true;
    }

    @ApiStatus.Internal
    public static final boolean illegalLiteralPrefixOrSuffix(@NotNull PsiElement $this$illegalLiteralPrefixOrSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$illegalLiteralPrefixOrSuffix, (String)"<this>");
        IElementType iElementType = $this$illegalLiteralPrefixOrSuffix.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RangeKtExpressionType.values().length];
            try {
                nArray[RangeKtExpressionType.RANGE_TO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.RANGE_UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.DOWN_TO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.UNTIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

