/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinInlayHintToggleActionKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayHintToggleAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "lastOptionName", "", "findElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "Holder", "kotlin.idea"})
public final class KotlinInlayHintToggleAction
implements IntentionAction,
LowPriorityAction {
    @IntentionName
    @NotNull
    private String lastOptionName = "";

    @NotNull
    public String getText() {
        return this.lastOptionName;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"hints.types", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.lastOptionName = "";
        for (PsiElement element3 = this.findElement(editor2, file2); element3 != null; element3 = element3.getParent()) {
            for (HintType hintType : Holder.INSTANCE.getHintTypes()) {
                Pair pair;
                if (!hintType.isApplicable(element3) || (pair = KotlinInlayHintToggleActionKt.findSetting$default(hintType, project2, null, 4, null)) == null) continue;
                Pair it = pair;
                boolean bl = false;
                boolean enabled2 = ((KotlinAbstractHintsProvider.HintsSettings)it.getSecond()).isEnabled(hintType);
                this.lastOptionName = enabled2 ? hintType.getHideDescription() : hintType.getShowDescription();
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        for (PsiElement element3 = this.findElement(editor2, file2); element3 != null; element3 = element3.getParent()) {
            for (HintType hintType : Holder.INSTANCE.getHintTypes()) {
                if (!KotlinInlayHintToggleActionKt.toggleHintSetting$default(hintType, project2, element3, null, 8, null)) continue;
                return;
            }
        }
    }

    private final PsiElement findElement(Editor editor2, PsiFile file2) {
        KtFile ktFile2 = file2 instanceof KtFile ? (KtFile)file2 : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        int offset2 = editor2.getCaretModel().getOffset();
        return ktFile3.findElementAt(offset2 - 1);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayHintToggleAction$Holder;", "", "()V", "hintTypes", "", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "getHintTypes", "()[Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "[Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "kotlin.idea"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final HintType[] hintTypes;

        private Holder() {
        }

        @NotNull
        public final HintType[] getHintTypes() {
            return hintTypes;
        }

        static {
            HintType[] hintTypeArray = new HintType[]{HintType.RANGES, HintType.PROPERTY_HINT, HintType.LOCAL_VARIABLE_HINT, HintType.FUNCTION_HINT, HintType.PARAMETER_TYPE_HINT, HintType.PARAMETER_HINT, HintType.LAMBDA_RETURN_EXPRESSION, HintType.LAMBDA_IMPLICIT_PARAMETER_RECEIVER, HintType.SUSPENDING_CALL};
            hintTypes = hintTypeArray;
        }
    }
}

