/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries.AddKotlinLibraryQuickFix;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManagerKt;
import org.jetbrains.kotlin.idea.configuration.KotlinLibraryVersionProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H$J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0002H$J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider;", "Lcom/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider;", "Lcom/intellij/psi/PsiReference;", "libraryGroupId", "", "libraryArtifactId", "(Ljava/lang/String;Ljava/lang/String;)V", "getLibraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "kotlinVersion", "Lkotlin/KotlinVersion;", "getReferenceClass", "Ljava/lang/Class;", "hasLibrary", "", "module", "Lcom/intellij/openapi/module/Module;", "isLibraryReference", "ref", "registerFixes", "", "registrar", "Lcom/intellij/codeInsight/daemon/QuickFixActionRegistrar;", "getKotlinVersion", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nAddKotlinLibraryQuickFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddKotlinLibraryQuickFixProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n288#2,2:75\n*S KotlinDebug\n*F\n+ 1 AddKotlinLibraryQuickFixProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider\n*L\n52#1:75,2\n*E\n"})
public abstract class AddKotlinLibraryQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReference> {
    @NotNull
    private final String libraryGroupId;
    @NotNull
    private final String libraryArtifactId;

    public AddKotlinLibraryQuickFixProvider(@NotNull String libraryGroupId, @NotNull String libraryArtifactId) {
        Intrinsics.checkNotNullParameter((Object)libraryGroupId, (String)"libraryGroupId");
        Intrinsics.checkNotNullParameter((Object)libraryArtifactId, (String)"libraryArtifactId");
        this.libraryGroupId = libraryGroupId;
        this.libraryArtifactId = libraryArtifactId;
    }

    protected abstract boolean hasLibrary(@NotNull Module var1);

    protected abstract boolean isLibraryReference(@NotNull PsiReference var1);

    private final KotlinVersion getKotlinVersion(PsiReference $this$getKotlinVersion) {
        PsiElement psiElement2 = $this$getKotlinVersion.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        return LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(psiElement2).getLanguageVersion());
    }

    private final ExternalLibraryDescriptor getLibraryDescriptor(KotlinVersion kotlinVersion2) {
        KotlinLibraryVersionProvider kotlinLibraryVersionProvider = (KotlinLibraryVersionProvider)CollectionsKt.firstOrNull((List)KotlinLibraryVersionProvider.Companion.getEP_NAME().getExtensionList());
        if (kotlinLibraryVersionProvider == null) {
            return null;
        }
        KotlinLibraryVersionProvider versionProvider = kotlinLibraryVersionProvider;
        return versionProvider.getVersion(this.libraryGroupId, this.libraryArtifactId, kotlinVersion2);
    }

    public void registerFixes(@NotNull PsiReference ref, @NotNull QuickFixActionRegistrar registrar2) {
        Object v3;
        Module module2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            if (!this.isLibraryReference(ref)) {
                return;
            }
            PsiElement psiElement2 = ref.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
            Module module3 = GenericPsiUtils.getModule(psiElement2);
            if (module3 == null) {
                return;
            }
            module2 = module3;
            List list2 = ref.getElement().getProject().getExtensionArea().getExtensionPoint(KotlinBuildSystemDependencyManager.Companion.getEP_NAME()).getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
            List extensionList = list2;
            Iterable $this$firstOrNull$iv = extensionList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinBuildSystemDependencyManager it = (KotlinBuildSystemDependencyManager)element$iv;
                boolean bl = false;
                if (!it.isApplicable(module2)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        KotlinBuildSystemDependencyManager kotlinBuildSystemDependencyManager = v3;
        if (kotlinBuildSystemDependencyManager == null) {
            return;
        }
        KotlinBuildSystemDependencyManager dependencyManager = kotlinBuildSystemDependencyManager;
        if (KotlinBuildSystemDependencyManagerKt.isProjectSyncPendingOrInProgress(dependencyManager)) {
            return;
        }
        if (this.hasLibrary(module2)) {
            return;
        }
        ExternalLibraryDescriptor externalLibraryDescriptor = this.getLibraryDescriptor(this.getKotlinVersion(ref));
        if (externalLibraryDescriptor == null) {
            return;
        }
        ExternalLibraryDescriptor libraryVersionToUse = externalLibraryDescriptor;
        DependencyScope scope2 = ProjectFileIndex.getInstance((Project)module2.getProject()).isInTestSourceContent(ref.getElement().getContainingFile().getVirtualFile()) ? DependencyScope.TEST : DependencyScope.COMPILE;
        registrar2.register((IntentionAction)new AddKotlinLibraryQuickFix(dependencyManager, KotlinBuildSystemDependencyManagerKt.withScope(libraryVersionToUse, scope2), KotlinBundle.message((String)"add.kotlin.coroutines", (Object[])new Object[0])));
    }

    @NotNull
    public Class<PsiReference> getReferenceClass() {
        return PsiReference.class;
    }
}

