/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaRenderer;
import org.jetbrains.kotlin.analysis.api.types.KaErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertToBlockBodyContext;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertToBlockBodyUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.GeneralPsiUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u0003\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ3\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\rR\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J$\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\rH\u0002J<\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u00020\r*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010 \u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyUtils;", "", "()V", "convert", "", "element", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "context", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyContext;", "declaration", "convertExpressionToBlockBodyData", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyUtils$ConvertExpressionToBlockBodyData;", "withReformat", "", "createContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "shortenReferences", "Lorg/jetbrains/kotlin/idea/base/codeInsight/ShortenReferencesFacility;", "reformat", "isErrorReturnTypeAllowed", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;Lorg/jetbrains/kotlin/idea/base/codeInsight/ShortenReferencesFacility;ZZ)Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyContext;", "generateBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "body", "prevComments", "", "Lcom/intellij/psi/PsiElement;", "nextComments", "returnsValue", "isConvertibleByPsi", "comments", "next", "setTypeReferenceIfNeeded", "ConvertExpressionToBlockBodyData", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nConvertToBlockBodyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToBlockBodyUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,190:1\n800#2,11:191\n1855#2,2:202\n1855#2,2:204\n1855#2,2:207\n748#2,10:209\n1855#2,2:219\n1855#2,2:221\n1#3:206\n1247#4,2:223\n*S KotlinDebug\n*F\n+ 1 ConvertToBlockBodyUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyUtils\n*L\n72#1:191,11\n72#1:202,2\n73#1:204,2\n171#1:207,2\n181#1:209,10\n182#1:219,2\n185#1:221,2\n140#1:223,2\n*E\n"})
public final class ConvertToBlockBodyUtils {
    @NotNull
    public static final ConvertToBlockBodyUtils INSTANCE = new ConvertToBlockBodyUtils();

    private ConvertToBlockBodyUtils() {
    }

    public final boolean isConvertibleByPsi(@NotNull KtDeclarationWithBody element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return (element3 instanceof KtNamedFunction || element3 instanceof KtPropertyAccessor) && !element3.hasBlockBody() && element3.hasBody();
    }

    @Nullable
    public final ConvertToBlockBodyContext createContext(@NotNull KaSession $context_receiver_0, @NotNull KtDeclarationWithBody declaration2, @NotNull ShortenReferencesFacility shortenReferences2, boolean reformat, boolean isErrorReturnTypeAllowed) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)shortenReferences2, (String)"shortenReferences");
        if (!this.isConvertibleByPsi(declaration2)) {
            return null;
        }
        KtExpression ktExpression = declaration2.getBodyExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression body2 = ktExpression;
        KaType returnType2 = $context_receiver_0.approximateToSuperPublicDenotableOrSelf($context_receiver_0.getReturnType((KtDeclaration)declaration2), true);
        if (!isErrorReturnTypeAllowed && returnType2 instanceof KaErrorType && declaration2 instanceof KtNamedFunction && !declaration2.hasDeclaredReturnType()) {
            return null;
        }
        KaType kaType = $context_receiver_0.getExpressionType(body2);
        if (kaType == null) {
            return null;
        }
        KaType bodyType = kaType;
        return new ConvertToBlockBodyContext($context_receiver_0.isUnit(returnType2), $context_receiver_0.isNothing(returnType2) && !$context_receiver_0.isMarkedNullable(returnType2), KaRenderer.render$default($context_receiver_0, returnType2, null, Variance.OUT_VARIANCE, 1, null), $context_receiver_0.isUnit(bodyType), $context_receiver_0.isNothing(bodyType) && !$context_receiver_0.isMarkedNullable(bodyType), reformat, shortenReferences2);
    }

    public static /* synthetic */ ConvertToBlockBodyContext createContext$default(ConvertToBlockBodyUtils convertToBlockBodyUtils, KaSession kaSession, KtDeclarationWithBody ktDeclarationWithBody, ShortenReferencesFacility shortenReferencesFacility, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return convertToBlockBodyUtils.createContext(kaSession, ktDeclarationWithBody, shortenReferencesFacility, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void convert(@NotNull KtDeclarationWithBody element3, @NotNull ConvertToBlockBodyContext context2) {
        Iterable $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtExpression ktExpression = element3.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression body2 = ktExpression;
        this.setTypeReferenceIfNeeded(element3, context2);
        List<PsiElement> prevComments2 = this.comments(body2, false);
        List<PsiElement> nextComments2 = this.comments(body2, true);
        boolean returnsValue = this.returnsValue(element3, context2);
        KtExpression newBody = this.generateBody(body2, prevComments2, nextComments2, context2, returnsValue);
        PsiElement psiElement2 = element3.getEqualsToken();
        if (psiElement2 != null) {
            psiElement2.delete();
        }
        Iterable $this$filterIsInstance$iv = prevComments2;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiComment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiComment it = (PsiComment)element$iv;
            boolean bl = false;
            it.delete();
        }
        $this$forEach$iv = nextComments2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
        PsiElement replaced2 = body2.replace((PsiElement)newBody);
        if (context2.getReformat()) {
            PsiFile psiFile2 = element3.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            Intrinsics.checkNotNull((Object)replaced2);
            GeneralPsiUtilsKt.reformat(psiFile2, PsiUtilsKt.getStartOffset((PsiElement)replaced2), PsiUtilsKt.getEndOffset((PsiElement)replaced2));
        }
    }

    @NotNull
    public final KtDeclarationWithBody convert(@NotNull KtDeclarationWithBody declaration2, @NotNull ConvertExpressionToBlockBodyData convertExpressionToBlockBodyData, boolean withReformat) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)convertExpressionToBlockBodyData, (String)"convertExpressionToBlockBodyData");
        ConvertToBlockBodyContext convertToBlockBodyContext = this.createContext(declaration2, convertExpressionToBlockBodyData, withReformat);
        if (convertToBlockBodyContext == null) {
            return declaration2;
        }
        ConvertToBlockBodyContext context2 = convertToBlockBodyContext;
        this.convert(declaration2, context2);
        return declaration2;
    }

    public static /* synthetic */ KtDeclarationWithBody convert$default(ConvertToBlockBodyUtils convertToBlockBodyUtils, KtDeclarationWithBody ktDeclarationWithBody, ConvertExpressionToBlockBodyData convertExpressionToBlockBodyData, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return convertToBlockBodyUtils.convert(ktDeclarationWithBody, convertExpressionToBlockBodyData, bl);
    }

    private final ConvertToBlockBodyContext createContext(KtDeclarationWithBody declaration2, ConvertExpressionToBlockBodyData convertExpressionToBlockBodyData, boolean reformat) {
        if (!this.isConvertibleByPsi(declaration2)) {
            return null;
        }
        return new ConvertToBlockBodyContext(convertExpressionToBlockBodyData.getReturnTypeIsUnit(), convertExpressionToBlockBodyData.getReturnTypeIsNothing() && !convertExpressionToBlockBodyData.getReturnTypeIsMarkedNullable(), convertExpressionToBlockBodyData.getReturnTypeString(), convertExpressionToBlockBodyData.getReturnTypeIsUnit(), convertExpressionToBlockBodyData.getReturnTypeIsNothing() && !convertExpressionToBlockBodyData.getReturnTypeIsMarkedNullable(), reformat, ShortenReferencesFacility.Companion.getInstance());
    }

    static /* synthetic */ ConvertToBlockBodyContext createContext$default(ConvertToBlockBodyUtils convertToBlockBodyUtils, KtDeclarationWithBody ktDeclarationWithBody, ConvertExpressionToBlockBodyData convertExpressionToBlockBodyData, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return convertToBlockBodyUtils.createContext(ktDeclarationWithBody, convertExpressionToBlockBodyData, bl);
    }

    private final void setTypeReferenceIfNeeded(KtDeclarationWithBody $this$setTypeReferenceIfNeeded, ConvertToBlockBodyContext context2) {
        PsiElement parent2;
        KtDeclarationWithBody ktDeclarationWithBody = $this$setTypeReferenceIfNeeded;
        if (ktDeclarationWithBody instanceof KtNamedFunction) {
            if (!$this$setTypeReferenceIfNeeded.hasDeclaredReturnType() && !context2.getReturnTypeIsUnit()) {
                ConvertToBlockBodyUtils.setTypeReferenceIfNeeded$setTypeReference((KtCallableDeclaration)$this$setTypeReferenceIfNeeded, context2);
            }
        } else if (ktDeclarationWithBody instanceof KtPropertyAccessor && (parent2 = ((KtPropertyAccessor)$this$setTypeReferenceIfNeeded).getParent()) instanceof KtProperty && ((KtProperty)parent2).getTypeReference() == null) {
            ConvertToBlockBodyUtils.setTypeReferenceIfNeeded$setTypeReference((KtCallableDeclaration)parent2, context2);
        }
    }

    private final List<PsiElement> comments(KtExpression $this$comments, boolean next2) {
        Sequence sequence2;
        Sequence it = sequence2 = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)$this$comments), (boolean)next2, (boolean)false), (Function1)comments.1.INSTANCE);
        boolean bl = false;
        Object object = ConvertToBlockBodyUtils.comments$hasComment((Sequence<? extends PsiElement>)it) ? sequence2 : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        return SequencesKt.toList((Sequence)object);
    }

    private final boolean returnsValue(KtDeclarationWithBody $this$returnsValue, ConvertToBlockBodyContext context2) {
        boolean bl;
        KtDeclarationWithBody ktDeclarationWithBody = $this$returnsValue;
        if (ktDeclarationWithBody instanceof KtNamedFunction) {
            bl = !context2.getReturnTypeIsUnit() && !context2.getReturnTypeIsNothing();
        } else if (ktDeclarationWithBody instanceof KtPropertyAccessor) {
            bl = ((KtPropertyAccessor)$this$returnsValue).isGetter();
        } else {
            throw new RuntimeException("Unknown declaration type: " + $this$returnsValue);
        }
        return bl;
    }

    private final KtExpression generateBody(KtExpression body2, List<? extends PsiElement> prevComments2, List<? extends PsiElement> nextComments2, ConvertToBlockBodyContext context2, boolean returnsValue) {
        PsiElement it;
        Iterable $this$forEach$iv;
        Iterable $this$dropWhile$iv;
        KtBlockExpression ktBlockExpression;
        Object annotatedExpr;
        boolean needReturn;
        Project project2 = body2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        if (context2.getBodyTypeIsUnit() && body2 instanceof KtNameReferenceExpression) {
            return (KtExpression)factory2.createEmptyBody();
        }
        boolean bl = needReturn = returnsValue && !context2.getBodyTypeIsUnit() && !context2.getBodyTypeIsNothing();
        if (needReturn) {
            annotatedExpr = body2 instanceof KtAnnotatedExpression ? (KtAnnotatedExpression)body2 : null;
            KtAnnotatedExpression ktAnnotatedExpression = annotatedExpr;
            if (ktAnnotatedExpression == null || (ktAnnotatedExpression = ktAnnotatedExpression.getBaseExpression()) == null) {
                ktAnnotatedExpression = body2;
            }
            KtAnnotatedExpression ktAnnotatedExpression2 = ktAnnotatedExpression;
            Intrinsics.checkNotNull((Object)ktAnnotatedExpression2);
            KtAnnotatedExpression returnedExpr = ktAnnotatedExpression2;
            Object[] objectArray = new Object[]{returnedExpr};
            KtBlockExpression block2 = KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)factory2, (KtExpression)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"return $0", (Object[])objectArray, (boolean)false, (int)4, null), null, null, (int)6, null);
            KtExpression statement2 = block2.getFirstStatement();
            Object object = annotatedExpr;
            if (object != null && (object = object.getAnnotationEntries()) != null) {
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KtAnnotationEntry it2 = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    block2.addBefore((PsiElement)it2, (PsiElement)statement2);
                    block2.addBefore(factory2.createNewLine(), (PsiElement)statement2);
                }
            }
            ktBlockExpression = block2;
        } else {
            ktBlockExpression = KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)factory2, (KtExpression)body2, null, null, (int)6, null);
        }
        KtBlockExpression newBody = ktBlockExpression;
        annotatedExpr = prevComments2;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it3 = (PsiElement)item$iv;
            boolean bl3 = false;
            if (it3 instanceof PsiWhiteSpace) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $this$dropWhile$iv = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiElement)element$iv;
            boolean bl4 = false;
            newBody.addAfter(it, newBody.getLBrace());
        }
        $this$forEach$iv = CollectionsKt.reversed((Iterable)nextComments2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PsiElement)element$iv;
            boolean bl5 = false;
            newBody.addAfter(it, (PsiElement)newBody.getFirstStatement());
        }
        return (KtExpression)newBody;
    }

    private static final void setTypeReferenceIfNeeded$setTypeReference(KtCallableDeclaration $this$setTypeReferenceIfNeeded_u24setTypeReference, ConvertToBlockBodyContext $context) {
        Project project2 = $this$setTypeReferenceIfNeeded_u24setTypeReference.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtTypeReference addedTypeReference = $this$setTypeReferenceIfNeeded_u24setTypeReference.setTypeReference(new KtPsiFactory(project2, false, 2, null).createType($context.getReturnTypeString()));
        if (addedTypeReference != null) {
            $context.getShortenReferences().shorten((KtElement)addedTypeReference);
        }
    }

    private static final boolean comments$hasComment(Sequence<? extends PsiElement> $this$comments_u24hasComment) {
        boolean bl;
        block1: {
            Sequence<? extends PsiElement> $this$any$iv = $this$comments_u24hasComment;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiComment)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyUtils$ConvertExpressionToBlockBodyData;", "", "returnTypeIsUnit", "", "returnTypeIsNothing", "returnTypeIsMarkedNullable", "returnTypeString", "", "(ZZZLjava/lang/String;)V", "getReturnTypeIsMarkedNullable", "()Z", "getReturnTypeIsNothing", "getReturnTypeIsUnit", "getReturnTypeString", "()Ljava/lang/String;", "kotlin.code-insight.utils"})
    public static final class ConvertExpressionToBlockBodyData {
        private final boolean returnTypeIsUnit;
        private final boolean returnTypeIsNothing;
        private final boolean returnTypeIsMarkedNullable;
        @NotNull
        private final String returnTypeString;

        public ConvertExpressionToBlockBodyData(boolean returnTypeIsUnit, boolean returnTypeIsNothing, boolean returnTypeIsMarkedNullable, @NotNull String returnTypeString) {
            Intrinsics.checkNotNullParameter((Object)returnTypeString, (String)"returnTypeString");
            this.returnTypeIsUnit = returnTypeIsUnit;
            this.returnTypeIsNothing = returnTypeIsNothing;
            this.returnTypeIsMarkedNullable = returnTypeIsMarkedNullable;
            this.returnTypeString = returnTypeString;
        }

        public final boolean getReturnTypeIsUnit() {
            return this.returnTypeIsUnit;
        }

        public final boolean getReturnTypeIsNothing() {
            return this.returnTypeIsNothing;
        }

        public final boolean getReturnTypeIsMarkedNullable() {
            return this.returnTypeIsMarkedNullable;
        }

        @NotNull
        public final String getReturnTypeString() {
            return this.returnTypeString;
        }
    }
}

