/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.KotlinCompletionCharFilterKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "()V", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "isWithinStringLiteral", "", "Companion", "kotlin.completion.impl.shared"})
public final class KotlinCompletionCharFilter
extends CharFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<String> JUST_TYPING_PREFIX = new Key("KotlinCompletionCharFilter.JUST_TYPING_PREFIX");

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        CharFilter.Result result2;
        char c2;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        if (!(lookup.getPsiFile() instanceof KtFile)) {
            return null;
        }
        if (!lookup.isCompletion()) {
            return null;
        }
        CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
        if (completionProcess == null) {
            return null;
        }
        boolean isAutopopup = completionProcess.isAutopopupCompletion();
        if (Character.isJavaIdentifierPart(c) || c == '@') {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        LookupElement currentItem = lookup.getCurrentItem();
        if (isAutopopup && !lookup.isSelectionTouched()) {
            LookupElement lookupElement2 = currentItem;
            boolean bl = lookupElement2 != null ? KotlinCompletionCharFilterKt.getSuppressItemSelectionByCharsOnTyping(lookupElement2) : false;
            if (bl) {
                return CharFilter.Result.HIDE_LOOKUP;
            }
        }
        if (c == ':') {
            LookupElement lookupElement3 = currentItem;
            return (lookupElement3 != null ? KotlinCompletionCharFilterKt.getHideLookupOnColon(lookupElement3) : false) ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.ADD_TO_PREFIX;
        }
        if (!lookup.isSelectionTouched()) {
            LookupElement lookupElement4 = currentItem;
            if (lookupElement4 != null) {
                CompletionUtilsNoResolveKt.putUserDataDeep(lookupElement4, JUST_TYPING_PREFIX, lookup.itemPattern(currentItem));
            }
        }
        if ((c2 = c) == '.') {
            int caret;
            if (prefixLength == 0 && isAutopopup && !lookup.isSelectionTouched() && (caret = lookup.getEditor().getCaretModel().getOffset()) > 0 && lookup.getEditor().getDocument().getCharsSequence().charAt(caret - 1) == '.') {
                return CharFilter.Result.HIDE_LOOKUP;
            }
            result2 = this.isWithinStringLiteral(lookup) ? CharFilter.Result.ADD_TO_PREFIX : CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        } else if (c2 == '{') {
            LookupElement lookupElement5 = currentItem;
            result2 = (lookupElement5 != null ? KotlinCompletionCharFilterKt.getAcceptOpeningBrace(lookupElement5) : false) ? CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP : CharFilter.Result.HIDE_LOOKUP;
        } else {
            result2 = ((((c2 == ',' ? true : c2 == ' ') ? true : c2 == '(') ? true : c2 == '=') ? true : c2 == '!') ? CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP : CharFilter.Result.HIDE_LOOKUP;
        }
        return result2;
    }

    private final boolean isWithinStringLiteral(Lookup lookup) {
        PsiElement psiElement2 = lookup.getPsiElement();
        return (psiElement2 != null ? psiElement2.getParent() : null) instanceof KtStringTemplateExpression;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinCompletionCharFilter$Companion;", "", "()V", "JUST_TYPING_PREFIX", "Lcom/intellij/openapi/util/Key;", "", "getJUST_TYPING_PREFIX", "()Lcom/intellij/openapi/util/Key;", "kotlin.completion.impl.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<String> getJUST_TYPING_PREFIX() {
            return JUST_TYPING_PREFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

