/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinPluginKindSwitcherController;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinPluginKindSwitcherControllerKt;
import org.jetbrains.kotlin.idea.preferences.KotlinPreferencesBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController;", "", "()V", "checkBox", "Lcom/intellij/ui/components/JBCheckBox;", "chosenKind", "Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginMode;", "currentPluginPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "initialValue", "pluginKindWillBeSwitchedAfterRestart", "", "getPluginKindWillBeSwitchedAfterRestart", "()Z", "pluginTypeChooserPanel", "productName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getProductName", "()Ljava/lang/String;", "applyChanges", "", "cancelSwitching", "createComponent", "Ljavax/swing/JComponent;", "isModified", "reset", "suggestRestart", "updateCheckBoxToChosenKind", "updatePanels", "Companion", "kotlin.preferences"})
public final class KotlinPluginKindSwitcherController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPluginMode initialValue;
    @NotNull
    private KotlinPluginMode chosenKind;
    private JBCheckBox checkBox;
    private Panel pluginTypeChooserPanel;
    private Panel currentPluginPanel;

    public KotlinPluginKindSwitcherController() {
        this.chosenKind = this.initialValue = KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions();
    }

    private final boolean getPluginKindWillBeSwitchedAfterRestart() {
        return KotlinPluginModeProvider.Companion.getCurrentPluginMode() != this.chosenKind;
    }

    private final String getProductName() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        return string;
    }

    public final boolean isModified() {
        return KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions() != this.chosenKind;
    }

    public final void applyChanges() {
        KotlinPluginKindSwitcherControllerKt.access$setUseK2Plugin(this.chosenKind == KotlinPluginMode.K2);
        this.updatePanels();
        if (this.getPluginKindWillBeSwitchedAfterRestart()) {
            this.suggestRestart();
        }
    }

    public final void reset() {
        if (!this.isModified()) {
            return;
        }
        this.chosenKind = KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions();
        this.updateCheckBoxToChosenKind();
        this.updatePanels();
    }

    @NotNull
    public final JComponent createComponent() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ KotlinPluginKindSwitcherController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                KotlinPluginKindSwitcherController.access$setCurrentPluginPanel$p(this.this$0, $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        KotlinPluginMode currentPluginMode = KotlinPluginModeProvider.Companion.getCurrentPluginMode();
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(currentPluginMode){
                            final /* synthetic */ KotlinPluginMode $currentPluginMode;
                            {
                                this.$currentPluginMode = $currentPluginMode;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Object[] objectArray = new Object[]{this.$currentPluginMode.getPluginModeDescription()};
                                String text2 = KotlinPreferencesBundle.message("label.your.current.plugin", objectArray);
                                Row.text$default((Row)$this$row, (String)text2, (int)0, null, (int)6, null);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(currentPluginMode){
                            final /* synthetic */ KotlinPluginMode $currentPluginMode;
                            {
                                this.$currentPluginMode = $currentPluginMode;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Object[] objectArray = new Object[]{this.$currentPluginMode.getOther().getPluginModeDescription()};
                                String text2 = KotlinPreferencesBundle.message("label.plugin.will.be.switched.after.ide.restart", objectArray);
                                Row.text$default((Row)$this$row, (String)text2, (int)0, null, (int)6, null);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Object[] objectArray = new Object[]{KotlinPluginKindSwitcherController.access$getProductName(this.this$0)};
                                String string = IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                $this$row.link(string, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                    final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        KotlinPluginKindSwitcherController.access$suggestRestart(this.this$0);
                                    }
                                });
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.link(KotlinPreferencesBundle.message("link.label.cancel.switching", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                    final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        KotlinPluginKindSwitcherController.access$cancelSwitching(this.this$0);
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                }));
                KotlinPluginKindSwitcherController.access$setPluginTypeChooserPanel$p(this.this$0, $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell cell = $this$row.checkBox(KotlinPreferencesBundle.message("checkbox.enable.k2.based.kotlin.plugin", new Object[0]));
                                KotlinPluginKindSwitcherController kotlinPluginKindSwitcherController = this.this$0;
                                Cell it = cell;
                                boolean bl = false;
                                KotlinPluginKindSwitcherController.access$setCheckBox$p(kotlinPluginKindSwitcherController, (JBCheckBox)it.getComponent());
                                cell.onChanged((Function1)new Function1<JBCheckBox, Unit>(this.this$0){
                                    final /* synthetic */ KotlinPluginKindSwitcherController this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull JBCheckBox it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        KotlinPluginKindSwitcherController.access$setChosenKind$p(this.this$0, KotlinPluginMode.Companion.of(it.isSelected()));
                                    }
                                }).gap(RightGap.SMALL);
                                Icon icon2 = AllIcons.General.Alpha;
                                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Alpha");
                                $this$row.icon(icon2).align((Align)AlignY.BOTTOM.INSTANCE);
                                KotlinPluginKindSwitcherController.access$updateCheckBoxToChosenKind(this.this$0);
                                Row.comment$default((Row)$this$row, (String)KotlinPreferencesBundle.message("kotlin.plugin.type.restart.required.comment", new Object[0]), (int)0, null, (int)6, null);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$panel, null, (Function1)createComponent.2.INSTANCE, (int)1, null);
                    }
                }));
                KotlinPluginKindSwitcherController.access$updatePanels(this.this$0);
            }
        }));
    }

    private final void cancelSwitching() {
        this.chosenKind = KotlinPluginModeProvider.Companion.getCurrentPluginMode();
        this.updateCheckBoxToChosenKind();
        this.updatePanels();
    }

    private final void updatePanels() {
        Panel panel2 = this.currentPluginPanel;
        if (panel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentPluginPanel");
            panel2 = null;
        }
        panel2.visible(this.getPluginKindWillBeSwitchedAfterRestart());
        Panel panel3 = this.pluginTypeChooserPanel;
        if (panel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginTypeChooserPanel");
            panel3 = null;
        }
        panel3.visible(!this.getPluginKindWillBeSwitchedAfterRestart());
    }

    private final void updateCheckBoxToChosenKind() {
        JBCheckBox jBCheckBox = this.checkBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(this.chosenKind == KotlinPluginMode.K2);
    }

    private final void suggestRestart() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx application2 = (ApplicationEx)application;
        Object[] objectArray = new Object[]{this.getProductName()};
        String string = IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray);
        objectArray = new Object[]{application2.isRestartCapable() ? 0 : 1};
        String string2 = IdeBundle.message((String)"button.now", (Object[])objectArray);
        objectArray = new Object[]{application2.isRestartCapable() ? 0 : 1};
        int result2 = Messages.showOkCancelDialog((String)string, (String)IdeBundle.message((String)"dialog.title.restart.required", (Object[])new Object[0]), (String)string2, (String)IdeBundle.message((String)"button.later", (Object[])objectArray), (Icon)Messages.getQuestionIcon());
        if (result2 == 0) {
            application2.restart(true);
        }
    }

    public static final /* synthetic */ void access$setCurrentPluginPanel$p(KotlinPluginKindSwitcherController $this, Panel panel2) {
        $this.currentPluginPanel = panel2;
    }

    public static final /* synthetic */ String access$getProductName(KotlinPluginKindSwitcherController $this) {
        return $this.getProductName();
    }

    public static final /* synthetic */ void access$suggestRestart(KotlinPluginKindSwitcherController $this) {
        $this.suggestRestart();
    }

    public static final /* synthetic */ void access$cancelSwitching(KotlinPluginKindSwitcherController $this) {
        $this.cancelSwitching();
    }

    public static final /* synthetic */ void access$setPluginTypeChooserPanel$p(KotlinPluginKindSwitcherController $this, Panel panel2) {
        $this.pluginTypeChooserPanel = panel2;
    }

    public static final /* synthetic */ void access$setChosenKind$p(KotlinPluginKindSwitcherController $this, KotlinPluginMode kotlinPluginMode) {
        $this.chosenKind = kotlinPluginMode;
    }

    public static final /* synthetic */ void access$updateCheckBoxToChosenKind(KotlinPluginKindSwitcherController $this) {
        $this.updateCheckBoxToChosenKind();
    }

    public static final /* synthetic */ void access$setCheckBox$p(KotlinPluginKindSwitcherController $this, JBCheckBox jBCheckBox) {
        $this.checkBox = jBCheckBox;
    }

    public static final /* synthetic */ void access$updatePanels(KotlinPluginKindSwitcherController $this) {
        $this.updatePanels();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController$Companion;", "", "()V", "createIfPluginSwitchIsPossible", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController;", "kotlin.preferences"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KotlinPluginKindSwitcherController createIfPluginSwitchIsPossible() {
            return VMOptions.canWriteOptions() ? new KotlinPluginKindSwitcherController() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

