/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotificationState;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "notificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;)V", "getNotificationState", "()Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "equals", "", "other", "", "hashCode", "", "Companion", "kotlin.project-configuration"})
public final class ConfigureKotlinNotification
extends Notification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigureKotlinNotificationState notificationState;

    public ConfigureKotlinNotification(@NotNull Project project2, @NotNull List<? extends Module> excludeModules, @NotNull ConfigureKotlinNotificationState notificationState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
        Intrinsics.checkNotNullParameter((Object)notificationState, (String)"notificationState");
        super("Configure Kotlin in Project", KotlinProjectConfigurationBundle.message("configure.kotlin", new Object[0]), notificationState.getNotificationString(), NotificationType.WARNING);
        this.notificationState = notificationState;
        this.setListener((arg_0, arg_1) -> ConfigureKotlinNotification._init_$lambda$0(project2, excludeModules, arg_0, arg_1));
        this.setSuggestionType(true);
    }

    @NotNull
    public final ConfigureKotlinNotificationState getNotificationState() {
        return this.notificationState;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof ConfigureKotlinNotification)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getContent(), (Object)((ConfigureKotlinNotification)((Object)other2)).getContent());
    }

    public int hashCode() {
        return this.getContent().hashCode();
    }

    private static final void _init_$lambda$0(Project $project, List $excludeModules, Notification notification2, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$excludeModules, (String)"$excludeModules");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String string = event.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(string);
            if (kotlinProjectConfigurator == null) {
                throw new AssertionError((Object)("Missed action: " + event.getDescription()));
            }
            KotlinProjectConfigurator configurator2 = kotlinProjectConfigurator;
            notification2.expire();
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logClickConfigureKtNotification($project);
            configurator2.configure($project, $excludeModules);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion;", "", "()V", "getLink", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "isOnlyOneModule", "", "getNotificationState", "Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotificationState;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nConfigureKotlinNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinNotification.kt\norg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n1#3:100\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinNotification.kt\norg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion\n*L\n82#1:96\n82#1:97,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ConfigureKotlinNotificationState getNotificationState(@NotNull Project project2, @NotNull Collection<? extends Module> excludeModules) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            boolean isOnlyOneModule;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(excludeModules, (String)"excludeModules");
            Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> pair = ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project2, excludeModules);
            Collection configurableModules = (Collection)pair.component1();
            Collection ableToRunConfigurators = (Collection)pair.component2();
            if (ableToRunConfigurators.isEmpty() || configurableModules.isEmpty()) {
                return null;
            }
            boolean bl = isOnlyOneModule = configurableModules.size() == 1;
            if (isOnlyOneModule) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)((ModuleSourceRootGroup)CollectionsKt.first((Iterable)configurableModules)).getBaseModule().getName(), (String)"getName(...)");
                string = KotlinProjectConfigurationBundle.message("configure.0.module", objectArray);
            } else {
                string = KotlinProjectConfigurationBundle.message("configure.modules", new Object[0]);
            }
            String modulesString = string;
            String links2 = CollectionsKt.joinToString$default((Iterable)ableToRunConfigurators, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinProjectConfigurator, CharSequence>(isOnlyOneModule){
                final /* synthetic */ boolean $isOnlyOneModule;
                {
                    this.$isOnlyOneModule = $isOnlyOneModule;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull KotlinProjectConfigurator configurator2) {
                    Intrinsics.checkNotNullParameter((Object)configurator2, (String)"configurator");
                    return org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification$Companion.access$getLink(ConfigureKotlinNotification.Companion, configurator2, this.$isOnlyOneModule);
                }
            }), (int)30, null);
            String string2 = project2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            Object object = new Object[3];
            object[0] = modulesString;
            Intrinsics.checkNotNullExpressionValue((Object)project2.getName(), (String)"getName(...)");
            object[2] = links2;
            String string3 = KotlinProjectConfigurationBundle.message("configure.0.in.1.project.br.2", object);
            object = configurableModules;
            String string4 = string3;
            String string5 = string2;
            boolean $i$f$map = false;
            void var11_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModuleSourceRootGroup moduleSourceRootGroup = (ModuleSourceRootGroup)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string6 = it.getBaseModule().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                collection.add(string6);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            String string7 = string4;
            String string8 = string5;
            return new ConfigureKotlinNotificationState(string8, string7, collection2);
        }

        private final String getLink(KotlinProjectConfigurator configurator2, boolean isOnlyOneModule) {
            Object[] objectArray = new Object[2];
            objectArray[0] = configurator2.getPresentableText();
            Integer n = 1;
            int n2 = ((Number)n).intValue();
            int n3 = 1;
            Object[] objectArray2 = objectArray;
            String string = "as.kotlin.1.module";
            String string2 = configurator2.getName();
            boolean bl = false;
            boolean bl2 = isOnlyOneModule;
            Integer n4 = bl2 ? n : null;
            objectArray2[n3] = n4 != null ? n4 : 2;
            return "<a href=\"" + string2 + "\">" + KotlinProjectConfigurationBundle.message(string, objectArray) + "</a>";
        }

        public static final /* synthetic */ String access$getLink(Companion $this, KotlinProjectConfigurator configurator2, boolean isOnlyOneModule) {
            return $this.getLink(configurator2, isOnlyOneModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

