/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.annotations.KotlinScript;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmDependency;
import kotlin.script.templates.ScriptTemplateDefinition;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionLoadingKt;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001aP\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u001aP\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u001a \u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"adjustClasspath", "", "Ljava/nio/file/Path;", "source", "loadDefinitionsFromTemplates", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "templateClassNames", "", "templateClasspath", "Ljava/io/File;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "additionalResolverClasspath", "defaultCompilerOptions", "", "loadDefinitionsFromTemplatesByPaths", "moveJarFromWslToHost", "targetFolderPathResolver", "Lkotlin/Lazy;", "shouldBeMovedToHost", "", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nscriptDefinitionLoading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scriptDefinitionLoading.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionLoadingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1549#2:152\n1620#2,3:153\n1549#2:156\n1620#2,3:157\n1603#2,9:160\n1855#2:169\n1549#2:170\n1620#2,3:171\n1856#2:179\n1612#2:180\n1549#2:181\n1620#2,3:182\n1549#2:185\n1620#2,3:186\n20#3,2:174\n20#3,2:176\n1#4:178\n*S KotlinDebug\n*F\n+ 1 scriptDefinitionLoading.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionLoadingKt\n*L\n42#1:152\n42#1:153,3\n44#1:156\n44#1:157,3\n71#1:160,9\n71#1:169\n77#1:170\n77#1:171,3\n71#1:179\n71#1:180\n114#1:181\n114#1:182,3\n125#1:185\n125#1:186,3\n83#1:174,2\n87#1:176,2\n71#1:178\n*E\n"})
public final class ScriptDefinitionLoadingKt {
    @NotNull
    public static final List<ScriptDefinition> loadDefinitionsFromTemplates(@NotNull List<String> templateClassNames, @NotNull List<? extends File> templateClasspath2, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<? extends File> additionalResolverClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
        Collection<Path> collection;
        File p0;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(templateClassNames, (String)"templateClassNames");
        Intrinsics.checkNotNullParameter(templateClasspath2, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(additionalResolverClasspath, (String)"additionalResolverClasspath");
        Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
        Iterable iterable = templateClasspath2;
        List<String> list2 = templateClassNames;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file2 = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.toPath());
        }
        $this$map$iv = additionalResolverClasspath;
        ScriptingHostConfiguration scriptingHostConfiguration = baseHostConfiguration;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toPath());
        }
        collection = (List)destination$iv$iv;
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(list2, (List<? extends Path>)collection2, scriptingHostConfiguration, (List<? extends Path>)collection, defaultCompilerOptions);
    }

    public static /* synthetic */ List loadDefinitionsFromTemplates$default(List list2, List list3, ScriptingHostConfiguration scriptingHostConfiguration, List list4, Iterable iterable, int n, Object object) {
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplates(list2, list3, scriptingHostConfiguration, list4, iterable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ScriptDefinition> loadDefinitionsFromTemplatesByPaths(@NotNull List<String> templateClassNames, @NotNull List<? extends Path> templateClasspath2, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<? extends Path> additionalResolverClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(templateClassNames, (String)"templateClassNames");
        Intrinsics.checkNotNullParameter(templateClasspath2, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(additionalResolverClasspath, (String)"additionalResolverClasspath");
        Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
        List<Path> classpath = ScriptDefinitionLoadingKt.adjustClasspath(CollectionsKt.plus((Collection)templateClasspath2, (Iterable)additionalResolverClasspath));
        ScriptUtilsKt.scriptingInfoLog("Loading script definitions: classes = " + templateClassNames + ", classpath = " + classpath);
        ClassLoader baseLoader = ScriptDefinitionContributor.class.getClassLoader();
        ClassLoader loader = classpath.isEmpty() ? baseLoader : (ClassLoader)UrlClassLoader.build().files(classpath).parent(baseLoader).get();
        Iterable $this$mapNotNull$iv = templateClassNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ScriptDefinition it$iv$iv;
            ScriptDefinition scriptDefinition;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String templateClassName = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                ScriptDefinition scriptDefinition2;
                Object v1;
                boolean $i$f$firstIsInstanceOrNull;
                Iterable $this$firstIsInstanceOrNull$iv;
                ScriptingHostConfiguration hostConfiguration2;
                List templateClasspathAsFiles;
                KClass template2;
                block16: {
                    void $this$mapTo$iv$iv2;
                    Class<?> clazz = loader.loadClass(templateClassName);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
                    template2 = JvmClassMappingKt.getKotlinClass(clazz);
                    Iterable $this$map$iv2 = templateClasspath2;
                    boolean $i$f$map22 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        Path path2 = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(new File(it.toString()));
                    }
                    templateClasspathAsFiles = (List)destination$iv$iv2;
                    ScriptingHostConfiguration[] $i$f$map22 = new ScriptingHostConfiguration[]{baseHostConfiguration};
                    hostConfiguration2 = new ScriptingHostConfiguration($i$f$map22, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>((List<? extends File>)templateClasspathAsFiles){
                        final /* synthetic */ List<File> $templateClasspathAsFiles;
                        {
                            this.$templateClasspathAsFiles = $templateClasspathAsFiles;
                            super(1);
                        }

                        public final void invoke(@NotNull ScriptingHostConfiguration.Builder $this$$receiver) {
                            Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                            JvmDependency[] jvmDependencyArray = new JvmDependency[]{new JvmDependency(this.$templateClasspathAsFiles)};
                            $this$$receiver.invoke(HostConfigurationKt.getConfigurationDependencies($this$$receiver), (T[])jvmDependencyArray);
                        }
                    }));
                    $this$firstIsInstanceOrNull$iv = template2.getAnnotations();
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof ScriptTemplateDefinition)) continue;
                        v1 = element$iv;
                        break block16;
                    }
                    v1 = null;
                }
                if (v1 != null) {
                    scriptDefinition2 = new ScriptDefinition.FromLegacyTemplate(hostConfiguration2, template2, templateClasspathAsFiles, defaultCompilerOptions);
                } else {
                    Object v3;
                    block17: {
                        $this$firstIsInstanceOrNull$iv = template2.getAnnotations();
                        $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KotlinScript)) continue;
                            v3 = element$iv;
                            break block17;
                        }
                        v3 = null;
                    }
                    if (v3 != null) {
                        scriptDefinition2 = new ScriptDefinition.FromTemplate(hostConfiguration2, template2, Reflection.getOrCreateKotlinClass(ScriptDefinition.class), defaultCompilerOptions);
                    } else {
                        ScriptUtilsKt.scriptingWarnLog("Cannot find a valid script definition annotation on the class " + template2);
                        scriptDefinition2 = null;
                    }
                }
                scriptDefinition = scriptDefinition2;
            }
            catch (ClassNotFoundException e) {
                ScriptUtilsKt.scriptingWarnLog("Cannot load script definition class " + templateClassName, e);
                scriptDefinition = null;
            }
            catch (Throwable e) {
                Unit unit;
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                String message2 = "Cannot load script definition class " + templateClassName;
                if (PluginManager.getPluginByClassNameAsNoAccessToClass((String)templateClassName) != null) {
                    PluginId it;
                    boolean bl4 = false;
                    ScriptUtilsKt.scriptingErrorLog(message2, (Throwable)new PluginException(message2, e, it));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    ScriptUtilsKt.scriptingErrorLog(message2, e);
                }
                scriptDefinition = null;
            }
            if (scriptDefinition == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List definitions2 = (List)destination$iv$iv;
        $this$mapNotNull$iv = definitions2;
        List<String> list2 = templateClassNames;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ScriptDefinition)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        ScriptUtilsKt.scriptingInfoLog("Loaded definitions: classes = " + list2 + ", definitions = " + (List)destination$iv$iv);
        return definitions2;
    }

    public static /* synthetic */ List loadDefinitionsFromTemplatesByPaths$default(List list2, List list3, ScriptingHostConfiguration scriptingHostConfiguration, List list4, Iterable iterable, int n, Object object) {
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(list2, list3, scriptingHostConfiguration, list4, iterable);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> adjustClasspath(List<? extends Path> source) {
        void $this$mapTo$iv$iv;
        Lazy cacheFolder2 = LazyKt.lazy((Function0)adjustClasspath.cacheFolder.1.INSTANCE);
        Iterable $this$map$iv = source;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ScriptDefinitionLoadingKt.shouldBeMovedToHost((Path)it) ? ScriptDefinitionLoadingKt.moveJarFromWslToHost((Path)it, (Lazy<? extends Path>)cacheFolder2) : it);
        }
        return (List)destination$iv$iv;
    }

    private static final Path moveJarFromWslToHost(Path source, Lazy<? extends Path> targetFolderPathResolver) {
        Path path2 = (Path)targetFolderPathResolver.getValue();
        if (path2 == null) {
            return source;
        }
        Path targetFolderPath = path2;
        String string = PathUtil.getFileName((String)NioPathUtil.toCanonicalPath((Path)source));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileNameWithExtension = string;
        Path relocatedJar = targetFolderPath.resolve(fileNameWithExtension);
        Intrinsics.checkNotNull((Object)relocatedJar);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(relocatedJar, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return relocatedJar;
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(source, relocatedJar, copyOptionArray);
        }
        catch (Throwable t) {
            ScriptUtilsKt.getLogger().warn("Unable to copy a DSL-related jar from " + source + " to " + relocatedJar + ": " + ExceptionUtil.getMessage((Throwable)t));
            return source;
        }
        return relocatedJar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeMovedToHost(Path $this$shouldBeMovedToHost) {
        if (!WslPath.Companion.isWslUncPath(((Object)$this$shouldBeMovedToHost).toString())) return false;
        String string = PathUtil.getFileName((String)NioPathUtil.toCanonicalPath((Path)$this$shouldBeMovedToHost));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

