/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashSetQueue;
import java.util.Queue;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.BackgroundExecutor;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.DefaultBackgroundExecutor;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 -2\u00020\u0001:\u0005-./01B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u001e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0016J\b\u0010)\u001a\u00020#H\u0002J\b\u0010*\u001a\u00020#H\u0002J\b\u0010+\u001a\u00020#H\u0002J\u0006\u0010,\u001a\u00020#R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/BackgroundExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;)V", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentProgressDone", "", "currentProgressSize", "inTransaction", "", "longRunningAlarm", "Lcom/intellij/util/Alarm;", "longRunningAlarmRequested", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "queue", "Ljava/util/Queue;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$LoadTask;", "rootsManager", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "getRootsManager", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "silentWorker", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$SilentWorker;", "underProgressWorker", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$UnderProgressWorker;", "work", "", "endBatch", "", "ensureInTransaction", "ensureScheduled", "key", "actions", "Lkotlin/Function0;", "requireSilentWorker", "requireUnderProgressWorker", "restartProgressBar", "updateProgress", "Companion", "LoadTask", "SilentWorker", "UnderProgressWorker", "Worker", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nDefaultBackgroundExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBackgroundExecutor.kt\norg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class DefaultBackgroundExecutor
implements BackgroundExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CompositeScriptConfigurationManager manager;
    @NotNull
    private final Object work;
    @NotNull
    private final Queue<LoadTask> queue;
    private int currentProgressSize;
    private int currentProgressDone;
    @Nullable
    private SilentWorker silentWorker;
    @Nullable
    private UnderProgressWorker underProgressWorker;
    @NotNull
    private final Alarm longRunningAlarm;
    private boolean longRunningAlarmRequested;
    private boolean inTransaction;
    @Nullable
    private VirtualFile currentFile;
    public static final int PROGRESS_INDICATOR_DELAY = 1000;
    public static final int PROGRESS_INDICATOR_MIN_QUEUE = 3;

    public DefaultBackgroundExecutor(@NotNull Project project2, @NotNull CompositeScriptConfigurationManager manager) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.project = project2;
        this.manager = manager;
        this.work = new Object();
        this.queue = (Queue)new HashSetQueue();
        this.longRunningAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CompositeScriptConfigurationManager getManager() {
        return this.manager;
    }

    private final ScriptClassRootsUpdater getRootsManager() {
        return this.manager.getUpdater();
    }

    @Override
    public synchronized void ensureScheduled(@NotNull VirtualFile key, @NotNull Function0<Unit> actions) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        LoadTask task2 = new LoadTask(key, actions);
        if (this.queue.add(task2)) {
            ScriptUtilsKt.scriptingDebugLog(task2.getKey(), (Function0<String>)((Function0)ensureScheduled.1.INSTANCE));
            if (this.queue.size() > 3) {
                this.requireUnderProgressWorker();
            } else {
                this.requireSilentWorker();
                if (!this.longRunningAlarmRequested) {
                    this.longRunningAlarmRequested = true;
                    this.longRunningAlarm.addRequest(() -> DefaultBackgroundExecutor.ensureScheduled$lambda$0(this), 1000);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void requireSilentWorker() {
        if (this.silentWorker == null && this.underProgressWorker == null) {
            void it;
            SilentWorker silentWorker;
            SilentWorker silentWorker2 = silentWorker = new SilentWorker();
            DefaultBackgroundExecutor defaultBackgroundExecutor = this;
            boolean bl = false;
            it.start();
            defaultBackgroundExecutor.silentWorker = silentWorker;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void requireUnderProgressWorker() {
        if (this.queue.isEmpty() && this.silentWorker == null) {
            return;
        }
        SilentWorker silentWorker = this.silentWorker;
        if (silentWorker != null) {
            silentWorker.stopGracefully();
        }
        if (this.underProgressWorker == null) {
            void it;
            UnderProgressWorker underProgressWorker;
            UnderProgressWorker underProgressWorker2 = underProgressWorker = new UnderProgressWorker();
            DefaultBackgroundExecutor defaultBackgroundExecutor = this;
            boolean bl = false;
            it.start();
            defaultBackgroundExecutor.underProgressWorker = underProgressWorker;
            this.restartProgressBar();
            this.updateProgress();
        }
    }

    private final synchronized void restartProgressBar() {
        this.currentProgressSize = this.queue.size();
        this.currentProgressDone = 0;
    }

    public final synchronized void updateProgress() {
        block4: {
            UnderProgressWorker underProgressWorker = this.underProgressWorker;
            if (underProgressWorker == null || (underProgressWorker = underProgressWorker.getProgressIndicator()) == null) break block4;
            UnderProgressWorker it = underProgressWorker;
            boolean bl = false;
            Object object = this.currentFile;
            if (object == null || (object = object.getPath()) == null) {
                object = "";
            }
            it.setText2((String)object);
            if (this.queue.size() == 0) {
                it.setIndeterminate(true);
            } else {
                it.setIndeterminate(false);
                if (this.currentProgressDone > this.currentProgressSize) {
                    this.restartProgressBar();
                }
                it.setFraction((double)this.currentProgressDone / (double)this.currentProgressSize);
            }
        }
    }

    private final synchronized void ensureInTransaction() {
        if (this.inTransaction) {
            return;
        }
        this.inTransaction = true;
    }

    private final synchronized void endBatch() {
        if (!this.inTransaction) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.getRootsManager().commit();
        this.inTransaction = false;
    }

    private static final void ensureScheduled$lambda$0(DefaultBackgroundExecutor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.longRunningAlarmRequested = false;
        this$0.requireUnderProgressWorker();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Companion;", "", "()V", "PROGRESS_INDICATOR_DELAY", "", "PROGRESS_INDICATOR_MIN_QUEUE", "kotlin.base.scripting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$LoadTask;", "", "key", "Lcom/intellij/openapi/vfs/VirtualFile;", "actions", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function0;)V", "getActions", "()Lkotlin/jvm/functions/Function0;", "getKey", "()Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "hashCode", "", "kotlin.base.scripting"})
    public static final class LoadTask {
        @NotNull
        private final VirtualFile key;
        @NotNull
        private final Function0<Unit> actions;

        public LoadTask(@NotNull VirtualFile key, @NotNull Function0<Unit> actions) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(actions, (String)"actions");
            this.key = key;
            this.actions = actions;
        }

        @NotNull
        public final VirtualFile getKey() {
            return this.key;
        }

        @NotNull
        public final Function0<Unit> getActions() {
            return this.actions;
        }

        public boolean equals(@Nullable Object other2) {
            return this == other2 || other2 instanceof LoadTask && Intrinsics.areEqual((Object)this.key, (Object)((LoadTask)other2).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$SilentWorker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "close", "", "start", "kotlin.base.scripting"})
    private final class SilentWorker
    extends Worker {
        @Override
        public void start() {
            super.start();
            SwingUtilities.invokeLater(() -> SilentWorker.start$lambda$1(DefaultBackgroundExecutor.this, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() {
            DefaultBackgroundExecutor defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
            DefaultBackgroundExecutor defaultBackgroundExecutor2 = DefaultBackgroundExecutor.this;
            DefaultBackgroundExecutor defaultBackgroundExecutor3 = defaultBackgroundExecutor;
            synchronized (defaultBackgroundExecutor3) {
                boolean bl = false;
                defaultBackgroundExecutor2.silentWorker = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        private static final void start$lambda$1$lambda$0(SilentWorker this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.run();
        }

        private static final void start$lambda$1(DefaultBackgroundExecutor this$0, SilentWorker this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            BackgroundTaskUtil.executeOnPooledThread((Disposable)KotlinPluginDisposable.Companion.getInstance(this$0.getProject()), () -> SilentWorker.start$lambda$1$lambda$0(this$1));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$UnderProgressWorker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "checkCancelled", "", "close", "", "start", "kotlin.base.scripting"})
    private final class UnderProgressWorker
    extends Worker {
        @Nullable
        private ProgressIndicator progressIndicator;

        @Nullable
        public final ProgressIndicator getProgressIndicator() {
            return this.progressIndicator;
        }

        public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
        }

        @Override
        public void start() {
            super.start();
            Project project2 = DefaultBackgroundExecutor.this.getProject();
            String string = KotlinBaseScriptingBundle.message("text.kotlin.loading.script.configuration", new Object[0]);
            new Task.Backgroundable(this, DefaultBackgroundExecutor.this, project2, string){
                final /* synthetic */ UnderProgressWorker this$0;
                final /* synthetic */ DefaultBackgroundExecutor this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super($super_call_param$1, $super_call_param$2, true);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    this.this$0.setProgressIndicator(indicator);
                    this.this$1.updateProgress();
                    this.this$0.run();
                }
            }.queue();
        }

        @Override
        protected boolean checkCancelled() {
            ProgressIndicator progressIndicator = this.progressIndicator;
            return progressIndicator != null ? progressIndicator.isCanceled() : false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void close() {
            DefaultBackgroundExecutor defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
            DefaultBackgroundExecutor defaultBackgroundExecutor2 = DefaultBackgroundExecutor.this;
            DefaultBackgroundExecutor defaultBackgroundExecutor3 = defaultBackgroundExecutor;
            synchronized (defaultBackgroundExecutor3) {
                boolean bl = false;
                defaultBackgroundExecutor2.underProgressWorker = null;
                this.progressIndicator = null;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\b\u001a\u00020\u0007H\u0004J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor$Worker;", "", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/DefaultBackgroundExecutor;)V", "shouldStop", "", "checkCancelled", "close", "", "run", "start", "stopGracefully", "kotlin.base.scripting"})
    private abstract class Worker {
        private boolean shouldStop;

        public void start() {
            DefaultBackgroundExecutor.this.ensureInTransaction();
        }

        public final void stopGracefully() {
            this.shouldStop = true;
        }

        protected boolean checkCancelled() {
            return false;
        }

        protected abstract void close();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected final void run() {
            DefaultBackgroundExecutor defaultBackgroundExecutor;
            try {
                while (true) {
                    Object object = DefaultBackgroundExecutor.this.work;
                    defaultBackgroundExecutor = DefaultBackgroundExecutor.this;
                    Object object2 = object;
                    // MONITORENTER : object2
                    boolean bl = false;
                    DefaultBackgroundExecutor defaultBackgroundExecutor2 = defaultBackgroundExecutor;
                    // MONITORENTER : defaultBackgroundExecutor2
                    boolean bl2 = false;
                    if (this.shouldStop) {
                        // MONITOREXIT : defaultBackgroundExecutor2
                        // MONITOREXIT : object2
                        this.close();
                        return;
                    }
                    if (!this.checkCancelled()) break block19;
                    break;
                }
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
            {
                Object object;
                LoadTask loadTask;
                block19: {
                    defaultBackgroundExecutor.queue.clear();
                    defaultBackgroundExecutor.endBatch();
                    // MONITOREXIT : defaultBackgroundExecutor2
                    // MONITOREXIT : object2
                    this.close();
                    return;
                }
                if (defaultBackgroundExecutor.queue.isEmpty()) {
                    defaultBackgroundExecutor.endBatch();
                    // MONITOREXIT : defaultBackgroundExecutor2
                    // MONITOREXIT : object2
                    this.close();
                    return;
                }
                LoadTask loadTask2 = loadTask = (LoadTask)defaultBackgroundExecutor.queue.poll();
                if (loadTask2 != null) {
                    LoadTask loadTask3;
                    Intrinsics.checkNotNull((Object)loadTask2);
                    LoadTask it = loadTask3 = loadTask;
                    boolean bl = false;
                    defaultBackgroundExecutor.currentFile = it.getKey();
                    int n = defaultBackgroundExecutor.currentProgressDone;
                    defaultBackgroundExecutor.currentProgressDone = n + 1;
                    defaultBackgroundExecutor.updateProgress();
                    object = loadTask3;
                } else {
                    object = null;
                }
                Object object3 = object;
                // MONITOREXIT : defaultBackgroundExecutor2
                Function0<Unit> next2 = object3;
                Function0<Unit> function0 = next2;
                if (function0 != null && (function0 = function0.getActions()) != null) {
                    function0.invoke();
                }
                object3 = defaultBackgroundExecutor.work;
                // MONITORENTER : object3
                boolean bl = false;
                defaultBackgroundExecutor.currentFile = null;
                loadTask = Unit.INSTANCE;
                // MONITOREXIT : object3
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT : object2
                continue;
            }
        }
    }
}

