/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.util.PropertiesCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.ScriptResidenceExceptionProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptResolveScopeProvider;
import org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptSearchScope;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u00020\r*\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\u0011\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000bH\u0002J\u001c\u0010\u0019\u001a\u00020\u0018*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptResolveScopeProvider;", "Lcom/intellij/psi/ResolveScopeProvider;", "()V", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "calculateScopeForStandaloneScript", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptSearchScope;", "Lorg/jetbrains/kotlin/psi/KtFile;", "debugLog", "", "message", "Lkotlin/Function0;", "", "getScopeAccordingToLanguageFeature", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScopeForNonStandaloneScript", "getScopeForStandaloneScript", "getScopeForStandaloneScriptUnderSourceRoot", "isStandaloneScript", "", "isStandaloneScriptByDesign", "definition", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nKotlinScriptResolveScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScriptResolveScopeProvider.kt\norg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptResolveScopeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class KotlinScriptResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!FileUtils.isKotlinFileType(file2)) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition((PsiFile)ktFile3);
        if (scriptDefinition == null) {
            return null;
        }
        ScriptDefinition scriptDefinition2 = scriptDefinition;
        if (Intrinsics.areEqual(scriptDefinition2.getBaseClassType().getFromClass(), (Object)Reflection.getOrCreateKotlinClass(Object.class))) {
            return null;
        }
        boolean featureEnabled = ScriptResidenceExceptionProviderKt.isEnabled(LanguageFeature.SkipStandaloneScriptsInSourceRoots, GenericPsiUtils.getModule((PsiElement)ktFile3), project2);
        boolean backwardCompatibilityIsOn = ScriptResidenceExceptionProviderKt.compilerAllowsAnyScriptsInSourceRoots(project2);
        this.debugLog(ktFile3, (Function0<String>)((Function0)new Function0<String>(featureEnabled, backwardCompatibilityIsOn){
            final /* synthetic */ boolean $featureEnabled;
            final /* synthetic */ boolean $backwardCompatibilityIsOn;
            {
                this.$featureEnabled = $featureEnabled;
                this.$backwardCompatibilityIsOn = $backwardCompatibilityIsOn;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "language-feature: " + this.$featureEnabled + ", backward-compatibility-flag: " + this.$backwardCompatibilityIsOn;
            }
        }));
        if (featureEnabled && !backwardCompatibilityIsOn) {
            return this.getScopeAccordingToLanguageFeature(ktFile3, file2, project2, scriptDefinition2);
        }
        if (!this.isStandaloneScript(ktFile3)) {
            this.debugLog(ktFile3, (Function0<String>)((Function0)getResolveScope.2.INSTANCE));
            return null;
        }
        ScriptUtilsKt.scriptingDebugLog(ktFile3, (Function0<String>)((Function0)getResolveScope.3.INSTANCE));
        return (GlobalSearchScope)this.calculateScopeForStandaloneScript(ktFile3, file2, project2);
    }

    private final boolean isStandaloneScript(KtFile $this$isStandaloneScript) {
        return ModuleInfoProviderUtils.getModuleInfoOrNull((PsiElement)$this$isStandaloneScript) instanceof ScriptModuleInfo;
    }

    private final GlobalSearchScope getScopeAccordingToLanguageFeature(KtFile $this$getScopeAccordingToLanguageFeature, VirtualFile file2, Project project2, ScriptDefinition scriptDefinition) {
        boolean bl = ScriptResidenceExceptionProviderKt.isEnabled(LanguageFeature.SkipStandaloneScriptsInSourceRoots, GenericPsiUtils.getModule((PsiElement)$this$getScopeAccordingToLanguageFeature), project2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "SkipStandaloneScriptsInSourceRoots is off";
            throw new AssertionError((Object)string);
        }
        return this.isStandaloneScriptByDesign($this$getScopeAccordingToLanguageFeature, project2, scriptDefinition) ? (GlobalSearchScope)this.getScopeForStandaloneScript($this$getScopeAccordingToLanguageFeature, file2, project2) : (GlobalSearchScope)this.getScopeForNonStandaloneScript($this$getScopeAccordingToLanguageFeature, file2, project2);
    }

    private final KotlinScriptSearchScope getScopeForNonStandaloneScript(KtFile $this$getScopeForNonStandaloneScript, VirtualFile file2, Project project2) {
        KotlinScriptSearchScope kotlinScriptSearchScope;
        boolean underSourceRoot = ProjectStructureUtils.isUnderKotlinSourceRootTypes((PsiElement)$this$getScopeForNonStandaloneScript);
        this.debugLog($this$getScopeForNonStandaloneScript, (Function0<String>)((Function0)new Function0<String>(underSourceRoot){
            final /* synthetic */ boolean $underSourceRoot;
            {
                this.$underSourceRoot = $underSourceRoot;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "under-source-root: " + this.$underSourceRoot;
            }
        }));
        if (underSourceRoot) {
            this.debugLog($this$getScopeForNonStandaloneScript, (Function0<String>)((Function0)getScopeForNonStandaloneScript.2.INSTANCE));
            kotlinScriptSearchScope = null;
        } else {
            kotlinScriptSearchScope = this.calculateScopeForStandaloneScript($this$getScopeForNonStandaloneScript, file2, project2);
        }
        return kotlinScriptSearchScope;
    }

    private final KotlinScriptSearchScope getScopeForStandaloneScript(KtFile $this$getScopeForStandaloneScript, VirtualFile file2, Project project2) {
        boolean underSourceRoot = ProjectStructureUtils.isUnderKotlinSourceRootTypes((PsiElement)$this$getScopeForStandaloneScript);
        this.debugLog($this$getScopeForStandaloneScript, (Function0<String>)((Function0)new Function0<String>(underSourceRoot){
            final /* synthetic */ boolean $underSourceRoot;
            {
                this.$underSourceRoot = $underSourceRoot;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "under-source-root: " + this.$underSourceRoot;
            }
        }));
        return underSourceRoot ? this.getScopeForStandaloneScriptUnderSourceRoot($this$getScopeForStandaloneScript, file2, project2) : this.calculateScopeForStandaloneScript($this$getScopeForStandaloneScript, file2, project2);
    }

    private final KotlinScriptSearchScope getScopeForStandaloneScriptUnderSourceRoot(KtFile $this$getScopeForStandaloneScriptUnderSourceRoot, VirtualFile file2, Project project2) {
        KotlinScriptSearchScope kotlinScriptSearchScope;
        boolean hasNoExceptionToBeUnderSourceRoot = ScriptResidenceExceptionProviderKt.hasNoExceptionsToBeUnderSourceRoot(file2);
        this.debugLog($this$getScopeForStandaloneScriptUnderSourceRoot, (Function0<String>)((Function0)new Function0<String>(hasNoExceptionToBeUnderSourceRoot){
            final /* synthetic */ boolean $hasNoExceptionToBeUnderSourceRoot;
            {
                this.$hasNoExceptionToBeUnderSourceRoot = $hasNoExceptionToBeUnderSourceRoot;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "exception-to-be-under-source-root: " + !this.$hasNoExceptionToBeUnderSourceRoot;
            }
        }));
        if (hasNoExceptionToBeUnderSourceRoot) {
            kotlinScriptSearchScope = this.calculateScopeForStandaloneScript($this$getScopeForStandaloneScriptUnderSourceRoot, file2, project2);
        } else {
            this.debugLog($this$getScopeForStandaloneScriptUnderSourceRoot, (Function0<String>)((Function0)getScopeForStandaloneScriptUnderSourceRoot.2.INSTANCE));
            kotlinScriptSearchScope = null;
        }
        return kotlinScriptSearchScope;
    }

    private final boolean isStandaloneScriptByDesign(KtFile $this$isStandaloneScriptByDesign, Project project2, ScriptDefinition definition2) {
        Object object = ScriptDependenciesProvider.Companion.getInstance(project2);
        if (object == null || (object = ((ScriptDependenciesProvider)object).getScriptConfiguration($this$isStandaloneScriptByDesign)) == null || (object = ((ScriptCompilationConfigurationWrapper)object).getConfiguration()) == null) {
            object = definition2.getCompilationConfiguration();
        }
        Object configuration2 = object;
        boolean isStandalone = Intrinsics.areEqual((Object)((PropertiesCollection)configuration2).get(ScriptCompilationKt.isStandalone(ScriptCompilationConfiguration.Companion)), (Object)true);
        this.debugLog($this$isStandaloneScriptByDesign, (Function0<String>)((Function0)new Function0<String>(isStandalone){
            final /* synthetic */ boolean $isStandalone;
            {
                this.$isStandalone = $isStandalone;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "standalone-by-design: " + this.$isStandalone;
            }
        }));
        return isStandalone;
    }

    private final KotlinScriptSearchScope calculateScopeForStandaloneScript(KtFile $this$calculateScopeForStandaloneScript, VirtualFile file2, Project project2) {
        VirtualFile virtualFile2 = $this$calculateScopeForStandaloneScript.getVirtualFile();
        if (virtualFile2 == null) {
            VirtualFile virtualFile3 = $this$calculateScopeForStandaloneScript.getViewProvider().getVirtualFile();
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
        }
        VirtualFile vFile = virtualFile2;
        GlobalSearchScope dependenciesScope = ScriptDependencyAware.Companion.getInstance(project2).getScriptDependenciesClassFilesScope(vFile);
        this.debugLog($this$calculateScopeForStandaloneScript, (Function0<String>)((Function0)calculateScopeForStandaloneScript.1.INSTANCE));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)project2, (VirtualFile)file2).uniteWith(dependenciesScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"uniteWith(...)");
        return new KotlinScriptSearchScope(project2, globalSearchScope);
    }

    private final void debugLog(KtFile $this$debugLog, Function0<String> message2) {
        ScriptUtilsKt.scriptingDebugLog($this$debugLog, (Function0<String>)((Function0)new Function0<String>(message2){
            final /* synthetic */ Function0<String> $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "[resolve-scope] " + this.$message.invoke();
            }
        }));
    }
}

