/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.PositionManagerWithMultipleStackFrames;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposableUtils;
import org.jetbrains.kotlin.idea.debugger.CandidatesSet;
import org.jetbrains.kotlin.idea.debugger.InlineCallRequestorWrapper;
import org.jetbrains.kotlin.idea.debugger.IrLambdaDescriptor;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager$getAppropriateLiteralForCrossinlineLambda$;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.PrepareRequest;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinAllFilesScopeProvider;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextTuner;
import org.jetbrains.kotlin.idea.debugger.core.ComposeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculator;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0017J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$H\u0016J$\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00072\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0003J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020-0\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u001eH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0003J$\u0010:\u001a\b\u0012\u0004\u0012\u00020-0\u00072\f\u0010;\u001a\b\u0012\u0004\u0012\u00020$0\u00072\u0006\u0010<\u001a\u00020\u001eH\u0002J\"\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u001eH\u0002J\"\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010\u0011\u001a\u0002042\u0006\u0010A\u001a\u00020B2\u0006\u0010<\u001a\u00020\u001eH\u0002J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\"\u0010D\u001a\u0004\u0018\u00010B2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u001eH\u0002J\u0012\u0010E\u001a\u0004\u0018\u0001042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010F\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010G\u001a\u00020\u00102\u0006\u0010H\u001a\u00020B2\u0006\u00107\u001a\u00020\u001eH\u0002J\u0010\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020$H\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00072\u0006\u0010L\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010M\u001a\u00020\u0010*\u00020@2\u0006\u0010N\u001a\u00020$2\u0006\u0010O\u001a\u00020\u0010H\u0002J0\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007*\u00020\u001c2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00072\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020$H\u0002J\u001c\u0010U\u001a\u0004\u0018\u00010B*\b\u0012\u0004\u0012\u00020B0\u00072\u0006\u0010N\u001a\u00020$H\u0002J$\u0010V\u001a\u0004\u0018\u00010B*\b\u0012\u0004\u0012\u00020B0\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001eH\u0002J%\u0010W\u001a\u0004\u0018\u00010B*\b\u0012\u0004\u0012\u00020B0\u00072\u0006\u0010N\u001a\u00020$H\u0002R\u00020X\u00a2\u0006\u0002\u0010YJ\u0017\u0010Z\u001a\u0004\u0018\u00010$*\u00020[H\u0002R\u00020X\u00a2\u0006\u0002\u0010\\J \u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0^0\u0007*\u00020S2\u0006\u0010T\u001a\u00020$H\u0002J\u000e\u0010_\u001a\u0004\u0018\u00010[*\u00020BH\u0002J(\u0010`\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010^*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0^0\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010a\u001a\u00020b*\b\u0012\u0004\u0012\u0002090\u00072\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u001c\u0010c\u001a\u0004\u0018\u00010B*\b\u0012\u0004\u0012\u00020B0\u00072\u0006\u0010d\u001a\u00020\u001eH\u0002J\u0014\u0010e\u001a\u00020\u0010*\u00020B2\u0006\u00107\u001a\u00020\u001eH\u0002J\u0014\u0010f\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010g\u001a\u000204H\u0002J\u000e\u0010h\u001a\u0004\u0018\u00010>*\u00020BH\u0002JA\u0010i\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001Hk\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hk0\u00070j\"\b\b\u0000\u0010k*\u00020l*\b\u0012\u0004\u0012\u0002Hk0\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u00020X\u00a2\u0006\u0002\u0010mJ\u001c\u0010n\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010g\u001a\u0002042\u0006\u0010T\u001a\u00020$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerWithMultipleStackFrames;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "collectPrepareRequests", "Lorg/jetbrains/kotlin/idea/debugger/PrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "isInsideProjectWithCompose", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectPrepareRequestsWithProgress", "(Lcom/intellij/debugger/requests/ClassPrepareRequestor;Lcom/intellij/debugger/SourcePosition;ZLorg/jetbrains/kotlin/psi/KtFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "sourcePosition", "createPrepareRequests", "createSourcePosition", "location", "Lcom/sun/jdi/Location;", "sourceLineNumber", "", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "expression", "findTargetClasses", "Lcom/sun/jdi/ReferenceType;", "candidates", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getCallableReferenceIfInside", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "lineNumber", "getCandidates", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$ClassNameCandidateInfo;", "getClassesWithInlinedCode", "candidatesWithInline", "line", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "getFirstElementInsideLambdaOnLine", "Lcom/intellij/psi/PsiElement;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getKotlinClassPrepareRequests", "getLambdaOrFunOnLineIfInside", "getPsiFileByLocation", "getSourcePosition", "hasImplicitReturnOnLine", "function", "isNestedClassName", "name", "locationsOfLine", "type", "calculatedClassNameMatches", "currentLocationClassName", "isLambda", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getAppropriateLiteralBasedOnDeclaringClassName", "getAppropriateLiteralBasedOnLambdaName", "getAppropriateLiteralForCrossinlineLambda", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtFunction;", "getBytecodeMethodName", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "getInlineFunctionBorders", "Lkotlin/ranges/ClosedRange;", "getLambdaCallMethod", "getLeastEnclosingBorders", "getReferenceTypesCandidates", "Lorg/jetbrains/kotlin/idea/debugger/CandidatesSet;", "getSamLambdaWithIndex", "index", "hasExecutableCodeInsideOnLine", "hasFinallyBlockInParent", "psiFile", "lastStatementSkippingComments", "separateInlinedAndNonInlinedElements", "Lkotlin/Pair;", "T", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/util/List;Lcom/sun/jdi/Location;)Lkotlin/Pair;", "shouldBeTreatedAsReentrantSourcePosition", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n+ 2 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n+ 7 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 8 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 9 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 10 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 11 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 12 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 13 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,955:1\n32#2:956\n766#3:957\n857#3,2:958\n288#3,2:960\n288#3,2:963\n766#3:965\n857#3,2:966\n766#3:970\n857#3,2:971\n800#3,11:984\n288#3,2:1004\n2624#3,3:1007\n288#3,2:1020\n766#3:1022\n857#3,2:1023\n766#3:1030\n857#3,2:1031\n1747#3,3:1033\n766#3:1036\n857#3,2:1037\n1045#3:1039\n766#3:1040\n857#3,2:1041\n1360#3:1055\n1446#3,5:1056\n1549#3:1061\n1620#3,3:1062\n1549#3:1065\n1620#3,3:1066\n1360#3:1084\n1446#3,5:1085\n766#3:1090\n857#3,2:1091\n1603#3,9:1095\n1855#3:1104\n1856#3:1106\n1612#3:1107\n1360#3:1108\n1446#3,5:1109\n1620#3,3:1114\n1549#3:1117\n1620#3,3:1118\n1#4:962\n1#4:1081\n1#4:1105\n66#5,2:968\n223#5,2:1025\n66#5,2:1028\n436#5:1053\n129#6,11:973\n28#7,2:995\n28#7,2:1010\n28#7,2:1043\n36#8,7:997\n43#8:1006\n36#8,8:1012\n36#8,8:1045\n473#9:1027\n188#10:1054\n37#11,2:1069\n11383#12,9:1071\n13309#12:1080\n13310#12:1082\n11392#12:1083\n14#13:1093\n14#13:1094\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManager\n*L\n220#1:956\n221#1:957\n221#1:958,2\n225#1:960,2\n228#1:963,2\n237#1:965\n237#1:966,2\n262#1:970\n262#1:971,2\n311#1:984,11\n316#1:1004,2\n332#1:1007,3\n363#1:1020,2\n377#1:1022\n377#1:1023,2\n419#1:1030\n419#1:1031,2\n420#1:1033,3\n432#1:1036\n432#1:1037,2\n438#1:1039\n446#1:1040\n446#1:1041,2\n574#1:1055\n574#1:1056,5\n585#1:1061\n585#1:1062,3\n586#1:1065\n586#1:1066,3\n599#1:1084\n599#1:1085,5\n632#1:1090\n632#1:1091,2\n663#1:1095,9\n663#1:1104\n663#1:1106\n663#1:1107\n704#1:1108\n704#1:1109,5\n704#1:1114,3\n706#1:1117\n706#1:1118,3\n592#1:1081\n663#1:1105\n254#1:968,2\n391#1:1025,2\n407#1:1028,2\n492#1:1053\n311#1:973,11\n313#1:995,2\n335#1:1010,2\n479#1:1043,2\n313#1:997,7\n313#1:1006\n335#1:1012,8\n479#1:1045,8\n391#1:1027\n547#1:1054\n590#1:1069,2\n592#1:1071,9\n592#1:1080\n592#1:1082\n592#1:1083\n653#1:1093\n654#1:1094\n*E\n"})
public final class KotlinPositionManager
implements MultiRequestPositionManager,
PositionManagerWithMultipleStackFrames {
    @NotNull
    private final DebugProcess debugProcess;
    @NotNull
    private final List<GlobalSearchScope> sourceSearchScopes;

    public KotlinPositionManager(@NotNull DebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        Object[] objectArray = new GlobalSearchScope[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.debugProcess.getSearchScope(), (String)"getSearchScope(...)");
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        objectArray[1] = KotlinAllFilesScopeProvider.Companion.getInstance(project2).getAllKotlinFilesScope();
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return ProjectStructureUtils.getKOTLIN_FILE_TYPES();
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context2, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @Nullable
    public List<XStackFrame> createStackFrames(@NotNull StackFrameDescriptorImpl descriptor2) {
        List<XStackFrame> inlineStackTrace;
        List<XStackFrame> coroutineFrames;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Location location2 = descriptor2.getLocation();
        if (!(location2 != null ? DebuggerUtil.isInKotlinSources(location2) : false)) {
            return null;
        }
        StackFrameProxyImpl stackFrameProxyImpl = descriptor2.getFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getFrameProxy(...)");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
        if (stackFrameInterceptor != null) {
            DebugProcess debugProcess = descriptor2.getDebugProcess();
            Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
            v4 = stackFrameInterceptor.createStackFrames(frameProxy, (DebugProcessImpl)debugProcess);
        } else {
            v4 = coroutineFrames = null;
        }
        if (coroutineFrames != null) {
            return coroutineFrames;
        }
        if (Registry.get((String)"debugger.kotlin.inline.stack.trace.enabled").asBoolean() && !((Collection)(inlineStackTrace = InlineStackTraceCalculator.INSTANCE.calculateInlineStackTrace(descriptor2))).isEmpty()) {
            return inlineStackTrace;
        }
        List<LocalVariableProxyImpl> visibleVariables = InlineStackTraceCalculator.INSTANCE.calculateVisibleVariables(frameProxy);
        return CollectionsKt.listOf((Object)((Object)new KotlinStackFrame(descriptor2, visibleVariables)));
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        SourcePosition sourcePosition2;
        PsiFile psiFile2;
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String string = SafeUtilKt.safeSourceName(location2);
        if (string == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        String fileName = string;
        int lineNumber = SafeUtilKt.safeLineNumber(location2);
        if (lineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile3 = this.getAlternativeSource(location2);
        if (psiFile3 == null) {
            psiFile3 = this.getPsiFileByLocation(location2);
        }
        if ((psiFile2 = psiFile3) == null) {
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
            boolean isKotlinStrataAvailable = DebuggerUtil.containsKotlinStrata(referenceType);
            if (isKotlinStrataAvailable) {
                try {
                    String javaSourceFileName = location2.sourceName("Java");
                    JvmClassName jvmClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location2));
                    Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
                    JvmClassName javaClassName = jvmClassName;
                    Project project2 = this.debugProcess.getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    Intrinsics.checkNotNull((Object)javaSourceFileName);
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, javaClassName, javaSourceFileName, location2);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!(psiFile2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber(location2) - 1;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        Method method = SafeUtilKt.safeMethod(location2);
        boolean bl = method != null ? KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(method) : false;
        if (bl) {
            return null;
        }
        SourcePosition javaSourceFileName = PositionManagerImpl.adjustPositionForConditionalReturn((DebugProcess)this.debugProcess, (Location)location2, (PsiFile)psiFile2, (int)sourceLineNumber);
        if (javaSourceFileName != null) {
            SourcePosition it = javaSourceFileName;
            boolean bl2 = false;
            return it;
        }
        SourcePosition sourcePosition3 = this.createSourcePosition(location2, (KtFile)psiFile2, sourceLineNumber);
        if (sourcePosition3 == null) {
            sourcePosition3 = SourcePosition.createFromLine((PsiFile)psiFile2, (int)sourceLineNumber);
        }
        if (!((sourcePosition2 = sourcePosition3) instanceof KotlinReentrantSourcePosition) && this.shouldBeTreatedAsReentrantSourcePosition(location2, psiFile2, fileName)) {
            Intrinsics.checkNotNull((Object)sourcePosition2);
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        return sourcePosition2;
    }

    private final SourcePosition createSourcePosition(Location location2, KtFile file2, int sourceLineNumber) {
        SourcePosition sourcePosition2;
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunOnLineIfInside(location2, file2, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            PsiElement elementAt = this.getFirstElementInsideLambdaOnLine((PsiFile)file2, lambdaOrFunIfInside, sourceLineNumber);
            if (elementAt != null) {
                return SourcePosition.createFromElement((PsiElement)elementAt);
            }
            return SourcePosition.createFromLine((PsiFile)((PsiFile)file2), (int)sourceLineNumber);
        }
        KtCallableReferenceExpression callableReferenceIfInside = this.getCallableReferenceIfInside(location2, file2, sourceLineNumber);
        if (callableReferenceIfInside != null && (sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)callableReferenceIfInside))) != null) {
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, file2, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getFirstElementInsideLambdaOnLine(PsiFile file2, KtFunction lambda2, int line) {
        Object v3;
        PsiElement psiElement2;
        List elementsOnLine;
        block7: {
            Object v2;
            PsiElement it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block6: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine$default(file2, line, false, 2, null);
                if (textRange == null) {
                    return null;
                }
                TextRange lineRange = textRange;
                Object $this$findElementsOfTypeInRange$iv = file2;
                boolean $i$f$findElementsOfTypeInRange = false;
                Class[] classArray = new Class[]{PsiElement.class};
                $this$findElementsOfTypeInRange$iv = JvmDebuggerBasePsiUtils.findElementsOfTypeInRange($this$findElementsOfTypeInRange$iv, lineRange, classArray);
                boolean $i$f$filter = false;
                classArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiElement it2 = (PsiElement)element$iv$iv;
                    boolean bl = false;
                    if (!(lineRange.contains(PsiUtilsKt.getStartOffset((PsiElement)it2)) && SequencesKt.contains((Sequence)PsiUtilsKt.getParents((PsiElement)it2), (Object)lambda2))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                elementsOnLine = (List)destination$iv$iv;
                KtExpression ktExpression = lambda2.getBodyExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                TextRange bodyRange = ktExpression.getTextRange();
                $this$firstOrNull$iv = elementsOnLine;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!bodyRange.contains(PsiUtilsKt.getStartOffset((PsiElement)it))) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            psiElement2 = v2;
            if (psiElement2 != null) {
                PsiElement it3 = psiElement2;
                boolean bl = false;
                return it3;
            }
            $this$firstOrNull$iv = elementsOnLine;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtElement)) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        psiElement2 = v3;
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            return it;
        }
        return (PsiElement)CollectionsKt.firstOrNull((List)elementsOnLine);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile2, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod($this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile2)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile2) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement2;
        Integer n = PsiLinesUtilsKt.getLineStartOffset(psiFile2, KotlinPositionManagerKt.access$getZeroBasedLineNumber($this$hasFinallyBlockInParent));
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            psiElement2 = psiFile2.findElementAt(it);
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        if (psiElement3 != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement3;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        ClosedRange<Location> closedRange = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (closedRange == null) {
            return CollectionsKt.emptyList();
        }
        ClosedRange<Location> leastEnclosingBorders = closedRange;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!leastEnclosingBorders.contains((Comparable)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ClosedRange<Location> getLeastEnclosingBorders(List<? extends ClosedRange<Location>> $this$getLeastEnclosingBorders, Location location2) {
        ClosedRange<Location> result2 = null;
        for (ClosedRange<Location> closedRange : $this$getLeastEnclosingBorders) {
            if (!closedRange.contains((Comparable)location2) || result2 != null && ((Location)closedRange.getStart()).compareTo(result2.getStart()) <= 0) continue;
            result2 = closedRange;
        }
        return result2;
    }

    private final List<ClosedRange<Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionBorders), (Function1)getInlineFunctionBorders.1.INSTANCE), (Function1)((Function1)new Function1<ClosedRange<Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;
            {
                this.$sourceFileName = $sourceFileName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClosedRange<Location> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)it.getStart()), (Object)this.$sourceFileName);
            }
        })));
    }

    private final PsiFile getAlternativeSource(Location location2) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        String qName = location2.declaringType().name();
        String string = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.debugProcess.getProject());
        if (string == null) {
            return null;
        }
        String alternativeFileUrl = string;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile alternativePsiFile = virtualFile2;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextTuner.Companion.getInstance().tuneContextElement(elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    Intrinsics.checkNotNull((Object)methodName);
                    if (!JvmAbi.isGetterName((String)methodName)) break block7;
                    v1 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getValueParameters()) == null) {
                        v1 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v1 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    for (T var11_11 : var9_9) {
                        it = (KtParameter)var11_11;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                        v2 = it.getName();
                        Intrinsics.checkNotNull((Object)v2);
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v2), (Object)methodName)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var11_11;
                        break block6;
                    }
                    v4 = null;
                }
                v5 = v4;
                break block8;
            }
            v5 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final KtCallableReferenceExpression getCallableReferenceIfInside(Location location2, KtFile file2, int lineNumber) {
        void this_$iv$iv;
        Pair pair;
        Object lineElement$iv;
        List list2;
        String string = KotlinPositionManagerKt.getClassName(location2);
        if (string == null) {
            return null;
        }
        String currentLocationClassName = string;
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement2 = DebuggerUtil.findElementAtLine(file2, lineNumber);
        KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
        if (ktElement == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceTo$iv$iv$iv;
            lineElement$iv = ktElement;
            int start$iv = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement$iv));
            int end$iv = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement$iv));
            for (PsiElement nextSibling$iv = lineElement$iv.getNextSibling(); nextSibling$iv != null && lineNumber == PsiLinesUtilsKt.getLineNumber$default(nextSibling$iv, false, 1, null); nextSibling$iv = nextSibling$iv.getNextSibling()) {
                end$iv = PsiUtilsKt.getEndOffset((PsiElement)nextSibling$iv);
            }
            Class[] classArray = new Class[]{KtCallableReferenceExpression.class};
            Pair $this$filterIsInstance$iv$iv = (Pair)FindElementUtils.findElementsOfClassInRange((PsiFile)file2, start$iv, end$iv, classArray);
            boolean $i$f$filterIsInstance = false;
            pair = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof KtCallableReferenceExpression)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list2 = (List)destination$iv$iv$iv;
        }
        List allReferenceExpressions = list2;
        if (allReferenceExpressions.isEmpty()) {
            return null;
        }
        KtElement useSiteElement$iv = (KtElement)CollectionsKt.first((List)allReferenceExpressions);
        boolean $i$f$analyze = false;
        Project project2 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        lineElement$iv = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        try {
            Object v5;
            block12: {
                KaSession $this$getCallableReferenceIfInside_u24lambda_u2412 = analysisSession$iv$iv;
                boolean bl = false;
                pair = this.separateInlinedAndNonInlinedElements($this$getCallableReferenceIfInside_u24lambda_u2412, allReferenceExpressions, location2);
                KtCallableReferenceExpression inlinedReference = (KtCallableReferenceExpression)pair.component1();
                List notInlined = (List)pair.component2();
                KtCallableReferenceExpression ktCallableReferenceExpression = inlinedReference;
                if (ktCallableReferenceExpression != null) {
                    KtCallableReferenceExpression ktCallableReferenceExpression2 = ktCallableReferenceExpression;
                    return ktCallableReferenceExpression2;
                }
                Iterable $this$firstOrNull$iv = notInlined;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtCallableReferenceExpression it = (KtCallableReferenceExpression)element$iv;
                    boolean bl2 = false;
                    if (!this.calculatedClassNameMatches((PsiElement)it, currentLocationClassName, false)) continue;
                    v5 = element$iv;
                    break block12;
                }
                v5 = null;
            }
            KtCallableReferenceExpression ktCallableReferenceExpression = v5;
            return ktCallableReferenceExpression;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final KtFunction getLambdaOrFunOnLineIfInside(Location location2, KtFile file2, int lineNumber) {
        void this_$iv$iv;
        boolean bl;
        List<KtFunction> literalsOrFunctions;
        String currentLocationClassName;
        block12: {
            String string = KotlinPositionManagerKt.getClassName(location2);
            if (string == null) {
                return null;
            }
            currentLocationClassName = string;
            Integer start2 = KotlinPsiUtils.getStartLineOffset((PsiFile)file2, lineNumber);
            Integer end = KotlinPsiUtils.getEndLineOffset((PsiFile)file2, lineNumber);
            if (start2 == null || end == null) {
                return null;
            }
            literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLine(file2, lineNumber);
            Iterable $this$none$iv = literalsOrFunctions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtFunction it = (KtFunction)element$iv;
                    boolean bl2 = false;
                    if (!BreakpointTypeUtilsKt.isStartingOrEndingOnLine(it, lineNumber)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        KtElement useSiteElement$iv = (KtElement)CollectionsKt.first(literalsOrFunctions);
        boolean $i$f$analyze = false;
        Project project2 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        try {
            KaSession $this$getLambdaOrFunOnLineIfInside_u24lambda_u2414 = analysisSession$iv$iv;
            boolean bl3 = false;
            Pair<KtFunction, List<KtFunction>> pair = this.separateInlinedAndNonInlinedElements($this$getLambdaOrFunOnLineIfInside_u24lambda_u2414, literalsOrFunctions, location2);
            KtFunction innermostContainingLiteral = (KtFunction)pair.component1();
            List notInlinedLambdas = (List)pair.component2();
            KtFunction ktFunction = innermostContainingLiteral;
            if (ktFunction != null) {
                KtFunction ktFunction2 = ktFunction;
                return ktFunction2;
            }
            KtFunction ktFunction3 = this.getAppropriateLiteralBasedOnDeclaringClassName(notInlinedLambdas, currentLocationClassName);
            if (ktFunction3 == null && (ktFunction3 = this.getAppropriateLiteralForCrossinlineLambda($this$getLambdaOrFunOnLineIfInside_u24lambda_u2414, notInlinedLambdas, currentLocationClassName)) == null) {
                ktFunction3 = this.getAppropriateLiteralBasedOnLambdaName(notInlinedLambdas, location2, lineNumber);
            }
            KtFunction ktFunction4 = ktFunction3;
            return ktFunction4;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        }
    }

    private final <T extends KtExpression> Pair<T, List<T>> separateInlinedAndNonInlinedElements(KaSession $context_receiver_0, List<? extends T> $this$separateInlinedAndNonInlinedElements, Location location2) {
        List notInlined = new ArrayList();
        KtExpression innermostInlinedElement = null;
        for (KtExpression expression2 : $this$separateInlinedAndNonInlinedElements) {
            KaValueParameterSymbol inlineArgument = InlineUtilsKt.getInlineArgumentSymbol($context_receiver_0, expression2);
            if (inlineArgument != null && (!inlineArgument.isCrossinline() || DebuggerUtil.isInlinedArgument(expression2, location2))) {
                DebugProcess debugProcess = this.debugProcess;
                Intrinsics.checkNotNull((Object)debugProcess, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                if (!DebuggerUtil.isInsideInlineArgument(expression2, location2, (DebugProcessImpl)debugProcess)) continue;
                innermostInlinedElement = expression2;
                continue;
            }
            notInlined.add(expression2);
        }
        return TuplesKt.to(innermostInlinedElement, (Object)notInlined);
    }

    private final KtFunction getAppropriateLiteralBasedOnDeclaringClassName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnDeclaringClassName, String currentLocationClassName) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getAppropriateLiteralBasedOnDeclaringClassName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFunction it = (KtFunction)element$iv;
                boolean bl = false;
                PsiElement psiElement2 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
                if (!this.calculatedClassNameMatches(psiElement2, currentLocationClassName, true)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunction getAppropriateLiteralForCrossinlineLambda(KaSession $context_receiver_0, List<? extends KtFunction> $this$getAppropriateLiteralForCrossinlineLambda, String currentLocationClassName) {
        void $this$descendantsOfType_u24default$iv;
        String $this$filterTo$iv$iv;
        if ($this$getAppropriateLiteralForCrossinlineLambda.isEmpty()) {
            return null;
        }
        String crossinlineLambdaPrefix = "$$inlined$";
        if (!StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)crossinlineLambdaPrefix, (boolean)false, (int)2, null)) {
            return null;
        }
        if ($this$getAppropriateLiteralForCrossinlineLambda.size() == 1) {
            return (KtFunction)CollectionsKt.first($this$getAppropriateLiteralForCrossinlineLambda);
        }
        Iterable $this$filter$iv = $this$getAppropriateLiteralForCrossinlineLambda;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            String string;
            Object element$iv$iv = iterator2.next();
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl2 = false;
            KtCallExpression ktCallExpression = this.getLambdaCallMethod(it);
            if (ktCallExpression == null || (string = this.getBytecodeMethodName($context_receiver_0, ktCallExpression)) == null) {
                bl = false;
            } else {
                String name2 = string;
                bl = StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)(crossinlineLambdaPrefix + name2 + "$"), (boolean)false, (int)2, null);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fittingCallMethodName = (List)destination$iv$iv;
        if (fittingCallMethodName.isEmpty()) {
            return null;
        }
        if (fittingCallMethodName.size() == 1) {
            return (KtFunction)CollectionsKt.first((List)fittingCallMethodName);
        }
        KtCallExpression $i$f$filter22 = this.getLambdaCallMethod((KtFunction)CollectionsKt.first((List)fittingCallMethodName));
        if ($i$f$filter22 == null || ($this$filterTo$iv$iv = this.getBytecodeMethodName($context_receiver_0, $i$f$filter22)) == null) {
            return null;
        }
        String callMethodName = $this$filterTo$iv$iv;
        KtExpression ktExpression = KotlinPositionManagerKt.getContainingMethod$default((PsiElement)CollectionsKt.first((List)fittingCallMethodName), false, 1, null);
        if (ktExpression == null) {
            return null;
        }
        KtExpression containingMethod = ktExpression;
        destination$iv$iv = (PsiElement)containingMethod;
        boolean childrenFirst$iv = false;
        boolean $i$f$descendantsOfType = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)getAppropriateLiteralForCrossinlineLambda$$inlined$descendantsOfType$default$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List allLambdasInMethod2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)getAppropriateLiteralForCrossinlineLambda.allLambdasInMethod.1.INSTANCE), (Function1)((Function1)new Function1<KtFunction, Boolean>(this, $context_receiver_0, callMethodName){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ KaSession $$context_receiver_0;
            final /* synthetic */ String $callMethodName;
            {
                this.this$0 = $receiver;
                this.$$context_receiver_0 = $$context_receiver_0;
                this.$callMethodName = $callMethodName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KtCallExpression ktCallExpression = KotlinPositionManager.access$getLambdaCallMethod(this.this$0, it);
                return Intrinsics.areEqual(ktCallExpression != null ? KotlinPositionManager.access$getBytecodeMethodName(this.this$0, ktCallExpression, this.$$context_receiver_0) : null, (Object)this.$callMethodName);
            }
        })));
        List candidatesBySequenceNumber = new ArrayList();
        for (KtFunction call2 : fittingCallMethodName) {
            int indexInOuterMethod = allLambdasInMethod2.indexOf(call2);
            String candidateName = crossinlineLambdaPrefix + callMethodName + "$" + (indexInOuterMethod + 1);
            if (!StringsKt.contains$default((CharSequence)currentLocationClassName, (CharSequence)candidateName, (boolean)false, (int)2, null)) continue;
            candidatesBySequenceNumber.add(call2);
        }
        return (KtFunction)CollectionsKt.singleOrNull((List)candidatesBySequenceNumber);
    }

    private final KtCallExpression getLambdaCallMethod(KtFunction $this$getLambdaCallMethod) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$getLambdaCallMethod;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtCallExpression.class, (boolean)true);
    }

    private final String getBytecodeMethodName(KaSession $context_receiver_0, KtCallExpression $this$getBytecodeMethodName) {
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)$this$getBytecodeMethodName);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner resolvedCall2 = kaLifetimeOwner;
        Object s = KaPartiallyAppliedSymbolKt.getSymbol(resolvedCall2.getPartiallyAppliedSymbol());
        KaNamedFunctionSymbol kaNamedFunctionSymbol = s instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)s : null;
        if (kaNamedFunctionSymbol == null) {
            return null;
        }
        KaNamedFunctionSymbol symbol2 = kaNamedFunctionSymbol;
        return JvmNameUtilKt.getByteCodeMethodName(symbol2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean calculatedClassNameMatches(PsiElement $this$calculatedClassNameMatches, String currentLocationClassName, boolean isLambda) {
        boolean bl;
        block6: {
            void $this$any$iv;
            List list2;
            List $this$calculatedClassNameMatches_u24lambda_u2417 = new ClassNameProvider(ClassNameProvider.Configuration.Companion.getSTOP_AT_LAMBDA()).getCandidatesForElement($this$calculatedClassNameMatches);
            boolean bl2 = false;
            if (isLambda) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $this$calculatedClassNameMatches_u24lambda_u2417;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String p0 = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!this.isNestedClassName(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = $this$calculatedClassNameMatches_u24lambda_u2417;
            }
            Iterable iterable = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNestedClassName(String name2) {
        return StringsKt.contains$default((CharSequence)name2, (CharSequence)"$", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtFunction getAppropriateLiteralBasedOnLambdaName(List<? extends KtFunction> $this$getAppropriateLiteralBasedOnLambdaName, Location location, int lineNumber) {
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return null;
        }
        method = v0;
        v1 = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"name(...)");
        if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v1)) {
            return null;
        }
        v2 = location.declaringType().methods();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"methods(...)");
        var6_5 = v2;
        $i$f$filter = false;
        var8_9 = $this$filter$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Method)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$lambdas$1 = false;
            v3 = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"name(...)");
            if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(v3)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)it);
            if (KotlinPositionManagerKt.isGeneratedErasedLambdaMethod(it)) ** GOTO lbl-1000
            v4 = DebuggerUtilsEx.locationsOfLine((Method)it, (int)(lineNumber + 1));
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"locationsOfLine(...)");
            if (((Collection)v4).isEmpty() == false) {
                v5 = true;
            } else lbl-1000:
            // 3 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv /* !! */ ;
        $i$f$sortedBy = false;
        lambdas = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                Method it = (Method)a;
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                it = (Method)b2;
                Comparable comparable = new IrLambdaDescriptor(string);
                bl = false;
                String string2 = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)new IrLambdaDescriptor(string2));
            }
        });
        if (lambdas.isEmpty()) {
            return null;
        }
        $this$filter$iv = $this$getAppropriateLiteralBasedOnLambdaName;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFunction)element$iv$iv;
            $i$a$-filter-KotlinPositionManager$getAppropriateLiteralBasedOnLambdaName$suitableFunLiterals$1 = false;
            if (!this.hasExecutableCodeInsideOnLine(it, lineNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableFunLiterals = (List)destination$iv$iv;
        methodIdx = lambdas.indexOf(method);
        if (lambdas.size() == suitableFunLiterals.size()) {
            return (KtFunction)suitableFunLiterals.get(methodIdx);
        }
        return this.getSamLambdaWithIndex(suitableFunLiterals, methodIdx);
    }

    private final boolean hasExecutableCodeInsideOnLine(KtFunction $this$hasExecutableCodeInsideOnLine, int lineNumber) {
        VirtualFile file2 = $this$hasExecutableCodeInsideOnLine.getContainingFile().getVirtualFile();
        KtElement ktElement = (KtElement)$this$hasExecutableCodeInsideOnLine;
        Intrinsics.checkNotNull((Object)file2);
        Project project2 = $this$hasExecutableCodeInsideOnLine.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine(ktElement, file2, lineNumber, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(file2, lineNumber){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $lineNumber;
            {
                this.$file = $file;
                this.$lineNumber = $lineNumber;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                ApplicabilityResult applicabilityResult;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                if (psiElement2 instanceof KtNamedFunction) {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                } else if (psiElement2 instanceof KtElement) {
                    VirtualFile virtualFile2 = this.$file;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"$file");
                    LineBreakpointExpressionVisitor visitor2 = LineBreakpointExpressionVisitor.Companion.of(virtualFile2, this.$lineNumber);
                    applicabilityResult = visitor2 != null ? (ApplicabilityResult)((KtElement)element3).accept((KtVisitor)visitor2, null) : ApplicabilityResult.UNKNOWN;
                } else {
                    applicabilityResult = ApplicabilityResult.UNKNOWN;
                }
                return applicabilityResult;
            }
        })) || this.hasImplicitReturnOnLine($this$hasExecutableCodeInsideOnLine, lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean hasImplicitReturnOnLine(KtFunction function2, int lineNumber) {
        boolean bl;
        void this_$iv$iv;
        if (!(function2 instanceof KtFunctionLiteral) || PsiLinesUtilsKt.getLineNumber((PsiElement)function2, false) != lineNumber) {
            return false;
        }
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)function2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)function2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)function2);
        try {
            KaSession $this$hasImplicitReturnOnLine_u24lambda_u2422 = analysisSession$iv$iv;
            boolean bl2 = false;
            KaType functionalType = $this$hasImplicitReturnOnLine_u24lambda_u2422.getFunctionType(function2);
            KaType kaType = functionalType instanceof KaFunctionType ? (KaFunctionType)functionalType : null;
            bl = kaType != null && (kaType = kaType.getReturnType()) != null ? $this$hasImplicitReturnOnLine_u24lambda_u2422.isUnit(kaType) : false;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)function2);
        }
        boolean isUnitReturnType = bl;
        if (!isUnitReturnType) {
            return false;
        }
        return !(this.lastStatementSkippingComments(function2) instanceof KtReturnExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtElement lastStatementSkippingComments(KtFunction $this$lastStatementSkippingComments) {
        KtBlockExpression ktBlockExpression = $this$lastStatementSkippingComments.getBodyBlockExpression();
        Object object = ktBlockExpression;
        if (ktBlockExpression == null) return null;
        PsiElement $this$childrenOfType$iv = (PsiElement)object;
        boolean $i$f$childrenOfType = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, KtElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        object = list2;
        if (list2 == null) return null;
        KtElement ktElement = (KtElement)CollectionsKt.lastOrNull((List)object);
        return ktElement;
    }

    private final KtFunction getSamLambdaWithIndex(List<? extends KtFunction> $this$getSamLambdaWithIndex, int index) {
        int samLambdaCounter = 0;
        for (KtFunction ktFunction : $this$getSamLambdaWithIndex) {
            if (!KotlinPositionManagerKt.access$isSamLambda(ktFunction)) continue;
            if (samLambdaCounter == index) {
                return ktFunction;
            }
            ++samLambdaCounter;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        String string;
        String string2 = SafeUtilKt.safeSourceName(location2);
        if (string2 == null) {
            return null;
        }
        String sourceName2 = string2;
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(sourceName2)) {
            return null;
        }
        try {
            String string3;
            ReferenceType referenceType = location2.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
            if (DebuggerUtil.containsKotlinStrata(referenceType)) {
                String string4 = location2.sourcePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sourcePath(...)");
                string3 = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            } else {
                string3 = this.defaultInternalName(location2);
            }
            string = string3;
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location2);
        }
        String referenceInternalName = string;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)referenceInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName className = jvmClassName;
        Project project2 = this.debugProcess.getProject();
        Intrinsics.checkNotNull((Object)project2);
        List files2 = KotlinPositionManagerKt.access$findFileCandidatesWithBackgroundProcess(project2, className, sourceName2, this.sourceSearchScopes);
        return (PsiFile)DebuggerUtils.INSTANCE.chooseApplicableFile$kotlin_jvm_debugger_core(files2, location2);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        Intrinsics.checkNotNull((Object)referenceFqName);
        return JvmNameUtilsKt.fqnToInternalName(referenceFqName);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 instanceof KtFile) {
            List<ReferenceType> list2;
            List<ReferenceType> list3;
            Project project2 = ((KtFile)psiFile3).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            List list4 = (List)KotlinPluginDisposableUtils.syncNonBlockingReadAction(project2, (Function0)new Function0<List<? extends ClassNameProvider.ClassNameCandidateInfo>>(psiFile3, this, sourcePosition2){
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$psiFile = $psiFile;
                    this.this$0 = $receiver;
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @Nullable
                public final List<ClassNameProvider.ClassNameCandidateInfo> invoke() {
                    if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)this.$psiFile)) {
                        return null;
                    }
                    return KotlinPositionManager.access$getCandidates(this.this$0, this.$sourcePosition);
                }
            });
            if (list4 == null) {
                return CollectionsKt.emptyList();
            }
            List candidates2 = list4;
            CandidatesSet candidatesSet = this.getReferenceTypesCandidates(candidates2, sourcePosition2);
            List<ReferenceType> classes2 = candidatesSet.component1();
            List<ReferenceType> classesWithInlinedCode = candidatesSet.component2();
            Collection $this$ifNotEmpty$iv = classes2;
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                List $this$getAllClasses_u24lambda_u2423 = (List)$this$ifNotEmpty$iv;
                boolean bl = false;
                list3 = this.findTargetClasses($this$getAllClasses_u24lambda_u2423, sourcePosition2);
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<ReferenceType> referenceTypesInKtFile = list2;
            List<ReferenceType> composeClassesIfNeeded = ComposeUtilsKt.isInsideProjectWithCompose(sourcePosition2) ? ComposeUtilsKt.getComposableSingletonsClasses(this.debugProcess, (KtFile)psiFile3) : CollectionsKt.emptyList();
            return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)referenceTypesInKtFile, (Iterable)classesWithInlinedCode), (Iterable)composeClassesIfNeeded));
        }
        if (psiFile3 instanceof ClsFileImpl) {
            Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(psiFile3){
                final /* synthetic */ PsiFile $psiFile;
                {
                    this.$psiFile = $psiFile;
                    super(0);
                }

                @NotNull
                public final PsiFile invoke() {
                    return ((ClsFileImpl)this.$psiFile).getDecompiledPsiFile();
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            PsiFile decompiledPsiFile2 = (PsiFile)object;
            if (decompiledPsiFile2 instanceof KtClsFile && ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(sourcePosition2){
                final /* synthetic */ SourcePosition $sourcePosition;
                {
                    this.$sourcePosition = $sourcePosition;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return this.$sourcePosition.getLine();
                }
            }))).intValue() == -1) {
                String className = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile2));
                List list5 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"classesByName(...)");
                return list5;
            }
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
        throw (Throwable)noDataException;
    }

    @RequiresReadLock
    private final List<ClassNameProvider.ClassNameCandidateInfo> getCandidates(SourcePosition sourcePosition2) {
        return new ClassNameProvider(null, 1, null).getCandidatesInfo(sourcePosition2);
    }

    /*
     * WARNING - void declaration
     */
    private final CandidatesSet getReferenceTypesCandidates(List<ClassNameProvider.ClassNameCandidateInfo> $this$getReferenceTypesCandidates, SourcePosition sourcePosition2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getReferenceTypesCandidates;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ClassNameProvider.ClassNameCandidateInfo classNameCandidateInfo = (ClassNameProvider.ClassNameCandidateInfo)element$iv$iv;
            boolean bl = false;
            String className = classNameCandidateInfo.component1();
            List list2 = this.debugProcess.getVirtualMachineProxy().classesByName(className);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classesByName(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List classes2 = (List)destination$iv$iv;
        List candidatesWithInline = KotlinPositionManagerKt.access$filterHasInlineElements($this$getReferenceTypesCandidates);
        if (candidatesWithInline.isEmpty()) {
            return new CandidatesSet(classes2, CollectionsKt.emptyList());
        }
        int line = sourcePosition2.getLine() + 1;
        List<ReferenceType> classesWithInlinedCode = this.getClassesWithInlinedCode(candidatesWithInline, line);
        return new CandidatesSet(classes2, classesWithInlinedCode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReferenceType> getClassesWithInlinedCode(List<String> candidatesWithInline, int line) {
        void $this$mapNotNullTo$iv$iv;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = candidatesWithInline;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmNameUtilsKt.fqnToInternalName((String)it));
        }
        List candidatesWithInlineInternalNames = (List)destination$iv$iv;
        List list2 = this.debugProcess.getVirtualMachineProxy().allClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allClasses(...)");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            ReferenceType bl = (ReferenceType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)type2);
            collection.add(KotlinPositionManagerKt.access$hasInlinedLinesToAsync((ReferenceType)type2, line, candidatesWithInlineInternalNames).thenApply(arg_0 -> KotlinPositionManager.getClassesWithInlinedCode$lambda$27$lambda$26((Function1)new Function1<Boolean, ReferenceType>((ReferenceType)type2){
                final /* synthetic */ ReferenceType $type;
                {
                    this.$type = $type;
                    super(1);
                }

                @Nullable
                public final ReferenceType invoke(Boolean hasInlinedLines) {
                    ReferenceType referenceType;
                    ReferenceType it = referenceType = this.$type;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)hasInlinedLines);
                    return hasInlinedLines != false ? referenceType : null;
                }
            }, arg_0)));
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        CompletableFuture[] thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] futures2 = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(Arrays.copyOf(futures2, futures2.length)).join();
        CompletableFuture[] $this$mapNotNull$iv = futures2;
        boolean $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            ReferenceType it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            if ((ReferenceType)it.get() == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLockAbsence
    private final List<ReferenceType> findTargetClasses(List<? extends ReferenceType> candidates2, SourcePosition sourcePosition2) {
        try {
            List<? extends ReferenceType> list2;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Collection<ReferenceType> collection = candidates2;
            boolean $i$f$flatMap = false;
            void var6_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ReferenceType referenceType = (ReferenceType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.debugProcess, referenceType, sourcePosition2.getLine());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List matchingCandidates = (List)destination$iv$iv;
            collection = matchingCandidates;
            if (collection.isEmpty()) {
                boolean bl = false;
                list2 = candidates2;
            } else {
                list2 = collection;
            }
            return list2;
        }
        catch (IncompatibleThreadStateException e) {
            return CollectionsKt.emptyList();
        }
        catch (VMDisconnectedException e) {
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            void $this$filterTo$iv$iv;
            int line;
            List locations;
            Collection collection;
            if (DexDebugFacility.INSTANCE.isDex(this.debugProcess)) {
                List inlineLocations2;
                VirtualMachineProxy virtualMachineProxy = this.debugProcess.getVirtualMachineProxy();
                VirtualMachineProxyImpl virtualMachineProxyImpl = virtualMachineProxy instanceof VirtualMachineProxyImpl ? (VirtualMachineProxyImpl)virtualMachineProxy : null;
                if (!(virtualMachineProxyImpl != null ? virtualMachineProxyImpl.canGetSourceDebugExtension() : false) && !((Collection)(inlineLocations2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends Location>>(type2, position, this){
                    final /* synthetic */ ReferenceType $type;
                    final /* synthetic */ SourcePosition $position;
                    final /* synthetic */ KotlinPositionManager this$0;
                    {
                        this.$type = $type;
                        this.$position = $position;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final List<Location> invoke() {
                        GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getDebugProcess$p(this.this$0).getSearchScope();
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
                        return DebuggerUtils.INSTANCE.getLocationsOfInlinedLine(this.$type, this.$position, globalSearchScope);
                    }
                })))).isEmpty()) {
                    return inlineLocations2;
                }
            }
            if ((collection = (Collection)(locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (String)"Kotlin", null, (int)(line = position.getLine() + 1)))) == null || collection.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
                throw (Throwable)noDataException;
            }
            Intrinsics.checkNotNull((Object)locations);
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.sourceName("Kotlin"), (Object)position.getFile().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()", imports={}))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        DebugProcessImpl debugProcessImpl;
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiFile psiFile2 = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        PsiFile file2 = psiFile2;
        if (!(file2 instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        boolean isInsideProjectWithCompose = ComposeUtilsKt.isInsideProjectWithCompose(position);
        Object $this$asSafely$iv = requestor;
        boolean $i$f$asSafely = false;
        ClassPrepareRequestor classPrepareRequestor = $this$asSafely$iv;
        if (!(classPrepareRequestor instanceof Breakpoint)) {
            classPrepareRequestor = null;
        }
        Breakpoint breakpoint2 = (Breakpoint)classPrepareRequestor;
        XBreakpoint xBreakpoint = breakpoint2 != null ? breakpoint2.getXBreakpoint() : null;
        DebugProcess $this$asSafely$iv2 = this.debugProcess;
        boolean $i$f$asSafely22 = false;
        DebugProcess debugProcess = $this$asSafely$iv2;
        if (!(debugProcess instanceof DebugProcessImpl)) {
            debugProcess = null;
        }
        $this$asSafely$iv = (debugProcessImpl = (DebugProcessImpl)debugProcess) != null && (debugProcessImpl = debugProcessImpl.getXdebugProcess()) != null ? debugProcessImpl.getSession() : null;
        $i$f$asSafely = false;
        ClassPrepareRequestor classPrepareRequestor2 = $this$asSafely$iv;
        if (!(classPrepareRequestor2 instanceof XDebugSessionImpl)) {
            classPrepareRequestor2 = null;
        }
        XDebugSessionImpl xSession = (XDebugSessionImpl)classPrepareRequestor2;
        $this$asSafely$iv = (Iterable)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends PrepareRequest>>, Object>(xBreakpoint, xSession, this, requestor, position, isInsideProjectWithCompose, file2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ XBreakpoint<? extends JavaBreakpointProperties<? extends JavaBreakpointProperties<?>>> $xBreakpoint;
            final /* synthetic */ XDebugSessionImpl $xSession;
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ ClassPrepareRequestor $requestor;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ boolean $isInsideProjectWithCompose;
            final /* synthetic */ PsiFile $file;
            {
                this.$xBreakpoint = $xBreakpoint;
                this.$xSession = $xSession;
                this.this$0 = $receiver;
                this.$requestor = $requestor;
                this.$position = $position;
                this.$isInsideProjectWithCompose = $isInsideProjectWithCompose;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlockingCancellable = (CoroutineScope)this.L$0;
                        if (this.$xBreakpoint != null && this.$xSession != null) break;
                        this.label = 1;
                        v0 = KotlinPositionManager.access$collectPrepareRequestsWithProgress(this.this$0, this.$requestor, this.$position, this.$isInsideProjectWithCompose, (KtFile)this.$file, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        v1 = (List)v0;
                        ** GOTO lbl26
                    }
                }
                this.label = 2;
                v2 = KotlinPositionManagerKt.access$cancelIfExpired($this$runBlockingCancellable, (Function1)new Function1<Continuation<? super Boolean>, Object>(this.$xSession, this.$xBreakpoint, null){
                    int label;
                    final /* synthetic */ XDebugSessionImpl $xSession;
                    final /* synthetic */ XBreakpoint<? extends JavaBreakpointProperties<? extends JavaBreakpointProperties<?>>> $xBreakpoint;
                    {
                        this.$xSession = $xSession;
                        this.$xBreakpoint = $xBreakpoint;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<Boolean>(this.$xSession, this.$xBreakpoint){
                                    final /* synthetic */ XDebugSessionImpl $xSession;
                                    final /* synthetic */ XBreakpoint<? extends JavaBreakpointProperties<? extends JavaBreakpointProperties<?>>> $xBreakpoint;
                                    {
                                        this.$xSession = $xSession;
                                        this.$xBreakpoint = $xBreakpoint;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Boolean invoke() {
                                        return this.$xSession.isBreakpointActive(this.$xBreakpoint);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super Boolean> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Function1)new Function1<Continuation<? super List<? extends PrepareRequest>>, Object>(this.this$0, this.$requestor, this.$position, this.$isInsideProjectWithCompose, this.$file, null){
                    int label;
                    final /* synthetic */ KotlinPositionManager this$0;
                    final /* synthetic */ ClassPrepareRequestor $requestor;
                    final /* synthetic */ SourcePosition $position;
                    final /* synthetic */ boolean $isInsideProjectWithCompose;
                    final /* synthetic */ PsiFile $file;
                    {
                        this.this$0 = $receiver;
                        this.$requestor = $requestor;
                        this.$position = $position;
                        this.$isInsideProjectWithCompose = $isInsideProjectWithCompose;
                        this.$file = $file;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = KotlinPositionManager.access$collectPrepareRequestsWithProgress(this.this$0, this.$requestor, this.$position, this.$isInsideProjectWithCompose, (KtFile)this.$file, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@Nullable Continuation<? super List<PrepareRequest>> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)this);
                if (v2 == var3_2) {
                    return var3_2;
                }
                ** GOTO lbl25
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl25:
                        // 2 sources

                        v1 = (List)v2;
lbl26:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<PrepareRequest>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$mapNotNull = false;
        void $i$f$asSafely22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassPrepareRequest classPrepareRequest;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PrepareRequest request2 = (PrepareRequest)element$iv$iv;
            boolean bl2 = false;
            if (this.debugProcess.getRequestsManager().createClassPrepareRequest(request2.getRequestor(), request2.getPattern()) != null) {
                ClassPrepareRequest classPrepareRequest2;
                ClassPrepareRequest $this$createPrepareRequests_u24lambda_u2433_u24lambda_u2432 = classPrepareRequest2;
                boolean bl3 = false;
                VirtualMachineProxy virtualMachineProxy = this.debugProcess.getVirtualMachineProxy();
                if ((virtualMachineProxy instanceof VirtualMachineProxyImpl ? (VirtualMachineProxyImpl)virtualMachineProxy : null) != null) {
                    VirtualMachineProxyImpl vmProxy;
                    vmProxy = vmProxy;
                    if (request2.getFileName() != null && vmProxy.canUseSourceNameFilters()) {
                        $this$createPrepareRequests_u24lambda_u2433_u24lambda_u2432.addSourceNameFilter(request2.getFileName());
                    }
                }
                classPrepareRequest = classPrepareRequest2;
            } else {
                classPrepareRequest = null;
            }
            if (classPrepareRequest == null) continue;
            ClassPrepareRequest it$iv$iv = classPrepareRequest;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Object collectPrepareRequestsWithProgress(ClassPrepareRequestor requestor, SourcePosition position, boolean isInsideProjectWithCompose, KtFile file2, Continuation<? super List<PrepareRequest>> $completion) {
        return com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<List<? extends PrepareRequest>>(this, requestor, position, isInsideProjectWithCompose, file2){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ ClassPrepareRequestor $requestor;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ boolean $isInsideProjectWithCompose;
            final /* synthetic */ KtFile $file;
            {
                this.this$0 = $receiver;
                this.$requestor = $requestor;
                this.$position = $position;
                this.$isInsideProjectWithCompose = $isInsideProjectWithCompose;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final List<PrepareRequest> invoke() {
                return KotlinPositionManager.access$collectPrepareRequests(this.this$0, this.$requestor, this.$position, this.$isInsideProjectWithCompose, this.$file);
            }
        }), $completion);
    }

    private final List<PrepareRequest> collectPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position, boolean isInsideProjectWithCompose, KtFile file2) {
        List list2;
        List kotlinRequests = this.getKotlinClassPrepareRequests(requestor, position);
        if (isInsideProjectWithCompose) {
            String singletonRequestPattern = ComposeUtilsKt.getClassPrepareRequestPatternForComposableSingletons(file2);
            list2 = CollectionsKt.plus((Collection)kotlinRequests, (Object)new PrepareRequest(requestor, singletonRequestPattern, null, 4, null));
        } else {
            list2 = kotlinRequests;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final List<PrepareRequest> getKotlinClassPrepareRequests(ClassPrepareRequestor requestor, SourcePosition position) {
        void $this$mapTo$iv$iv;
        Collection collection;
        Object item$iv2;
        void $this$mapTo$iv;
        Iterator $this$flatMapTo$iv$iv;
        SourcePosition refinedPosition = requestor instanceof SourcePositionRefiner ? ((SourcePositionRefiner)requestor).refineSourcePosition(position) : position;
        List classRequests = new ArrayList();
        List<ClassNameProvider.ClassNameCandidateInfo> candidates2 = this.getCandidates(refinedPosition);
        Iterable $this$flatMap$iv = candidates2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ClassNameProvider.ClassNameCandidateInfo classNameCandidateInfo = (ClassNameProvider.ClassNameCandidateInfo)element$iv$iv;
            boolean bl = false;
            String name2 = classNameCandidateInfo.component1();
            Object[] objectArray = new String[]{name2, name2 + "$*"};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv) {
            void it;
            String $i$f$flatMapTo2 = (String)item$iv2;
            collection = classRequests;
            boolean bl = false;
            collection.add(new PrepareRequest(requestor, (String)it, null, 4, null));
        }
        Iterable $this$map$iv = KotlinPositionManagerKt.access$filterHasInlineElements(candidates2);
        boolean $i$f$map = false;
        item$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(JvmNameUtilsKt.fqnToInternalName((String)it));
        }
        List candidatesWithInline = (List)destination$iv$iv2;
        if (!((Collection)candidatesWithInline).isEmpty()) {
            int line = refinedPosition.getLine() + 1;
            PrepareRequest inlineCallRequest = new PrepareRequest(new InlineCallRequestorWrapper(requestor, line, candidatesWithInline), null, refinedPosition.getFile().getName());
            classRequests.add(inlineCallRequest);
        }
        return classRequests;
    }

    private static final ReferenceType getClassesWithInlinedCode$lambda$27$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReferenceType)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KtCallExpression access$getLambdaCallMethod(KotlinPositionManager $this, KtFunction $receiver) {
        return $this.getLambdaCallMethod($receiver);
    }

    public static final /* synthetic */ String access$getBytecodeMethodName(KotlinPositionManager $this, KtCallExpression $receiver, KaSession $context_receiver_0) {
        return $this.getBytecodeMethodName($context_receiver_0, $receiver);
    }

    public static final /* synthetic */ List access$getCandidates(KotlinPositionManager $this, SourcePosition sourcePosition2) {
        return $this.getCandidates(sourcePosition2);
    }

    public static final /* synthetic */ DebugProcess access$getDebugProcess$p(KotlinPositionManager $this) {
        return $this.debugProcess;
    }

    public static final /* synthetic */ Object access$collectPrepareRequestsWithProgress(KotlinPositionManager $this, ClassPrepareRequestor requestor, SourcePosition position, boolean isInsideProjectWithCompose, KtFile file2, Continuation $completion) {
        return $this.collectPrepareRequestsWithProgress(requestor, position, isInsideProjectWithCompose, file2, (Continuation<? super List<PrepareRequest>>)$completion);
    }

    public static final /* synthetic */ List access$collectPrepareRequests(KotlinPositionManager $this, ClassPrepareRequestor requestor, SourcePosition position, boolean isInsideProjectWithCompose, KtFile file2) {
        return $this.collectPrepareRequests(requestor, position, isInsideProjectWithCompose, file2);
    }
}

