/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.ExceptionDebugHelper;
import com.intellij.rt.debugger.coroutines.CoroutinesDebugHelper;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineFilter;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineStackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.SkipCoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineStackFrameLight;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImplCoroutineOwner;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfBaseContinuationImplLight;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineOwner;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010\u0014*\u00020\u0010H\u0002\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor;", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "()V", "callMethodFromHelper", "Lcom/sun/jdi/Value;", "helperClass", "Ljava/lang/Class;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "methodName", "", "args", "", "callerLocation", "Lcom/sun/jdi/Location;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "createStackFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "extractBaseContinuation", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "continuation", "Lcom/sun/jdi/ObjectReference;", "defaultExecutionContext", "extractContinuation", "frameProxy", "extractContinuationId", "extractCoroutineFilter", "getContinuationFilterFromHelper", "currentContinuation", "getCoroutinesRunningOnCurrentThreadFromHelper", "", "", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "showCoroutinePanel", "", "tryComputeContinuationFilter", "getStackFrameProxyImpl", "ContinuationObjectFilter", "CoroutineIdFilter", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,278:1\n1603#2,9:279\n1855#2:288\n1856#2:290\n1612#2:291\n1#3:289\n1#3:294\n118#4:292\n23#5:293\n23#5:295\n23#5:296\n23#5:297\n23#5:298\n23#5:299\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n*L\n66#1:279,9\n66#1:288\n66#1:290\n66#1:291\n66#1:289\n74#1:292\n99#1:293\n139#1:295\n160#1:296\n179#1:297\n181#1:298\n233#1:299\n*E\n"})
public final class CoroutineStackFrameInterceptor
implements StackFrameInterceptor {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess) {
        block10: {
            StackFrameProxyImpl resumeWithFrame;
            Object it;
            SuspendContextImpl suspendContextImpl;
            Object object;
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                    Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                    JavaDebugProcess javaDebugProcess = debugProcess.getXdebugProcess();
                    if (!((javaDebugProcess != null ? javaDebugProcess.getSession() : null) instanceof XDebugSessionImpl) || frame instanceof SkipCoroutineStackFrameProxyImpl) break block10;
                    JavaDebugProcess javaDebugProcess2 = debugProcess.getXdebugProcess();
                    Object object2 = javaDebugProcess2 != null ? javaDebugProcess2.getSession() : null;
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                    if (!AsyncStacksToggleAction.Companion.isAsyncStacksEnabled((XDebugSessionImpl)object2)) break block10;
                    Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frame);
                    if (location2 != null && SafeUtilKt.safeLineNumber(location2) < 0) {
                        Method method = SafeUtilKt.safeMethod(location2);
                        if (Intrinsics.areEqual((Object)(method != null ? method.name() : null), (Object)"main") || CoroutineUtilsKt.isInvokeSuspend(location2)) {
                            return CollectionsKt.emptyList();
                        }
                    }
                    if ((object = (suspendContextImpl = SuspendManagerUtil.getContextForEvaluation((SuspendManager)debugProcess.getSuspendManager()))) == null) break block11;
                    it = object;
                    boolean bl = false;
                    CoroutinePreflightFrame coroutinePreflightFrame = CoroutineFrameBuilder.Companion.coroutineExitFrame(frame, (SuspendContextImpl)it);
                    object = coroutinePreflightFrame;
                    if (coroutinePreflightFrame != null) break block12;
                }
                return null;
            }
            Object stackFrame = object;
            if (!((CoroutinePreflightFrame)((Object)stackFrame)).isFirstSuspendFrame()) {
                return CollectionsKt.emptyList();
            }
            if (Registry.is((String)"debugger.kotlin.auto.show.coroutines.view")) {
                this.showCoroutinePanel(debugProcess);
            }
            if (CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContextImpl, resumeWithFrame = (StackFrameProxyImpl)CollectionsKt.firstOrNull(((CoroutinePreflightFrame)((Object)stackFrame)).getThreadPreCoroutineFrames()))) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                CoroutineFrameBuilder.Companion.CoroutineFrameItemLists frameItemLists = CoroutineFrameBuilder.Companion.build((CoroutinePreflightFrame)((Object)stackFrame), suspendContextImpl, false);
                it = frameItemLists.getFrames();
                Collection collection = CollectionsKt.listOf((Object)stackFrame);
                boolean $i$f$mapNotNull = false;
                void var10_11 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    XStackFrame it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    CoroutineStackFrameItem it2 = (CoroutineStackFrameItem)((Object)element$iv$iv);
                    boolean bl2 = false;
                    if (it2.createFrame(debugProcess) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            }
            return CollectionsKt.listOf((Object)stackFrame);
        }
        return null;
    }

    private final void showCoroutinePanel(DebugProcessImpl debugProcess) {
        XDebugSession xDebugSession = debugProcess.getSession().getXDebugSession();
        RunnerLayoutUi $this$safeAs$iv = xDebugSession != null ? xDebugSession.getUI() : null;
        boolean $i$f$safeAs = false;
        RunnerLayoutUi runnerLayoutUi = $this$safeAs$iv;
        if (!(runnerLayoutUi instanceof RunnerLayoutUiImpl)) {
            runnerLayoutUi = null;
        }
        RunnerLayoutUiImpl runnerLayoutUiImpl = (RunnerLayoutUiImpl)runnerLayoutUi;
        if (runnerLayoutUiImpl == null) {
            return;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)ui);
        if (runnerContentUi == null) {
            return;
        }
        RunnerContentUi runnerContentUi2 = runnerContentUi;
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(runnerContentUi2){
            final /* synthetic */ RunnerContentUi $runnerContentUi;
            {
                this.$runnerContentUi = $runnerContentUi;
                super(0);
            }

            public final void invoke() {
                this.$runnerContentUi.findOrRestoreContentIfNeeded("XCoroutineThreadsContent");
            }
        }), (int)1, null);
    }

    @Override
    @Nullable
    public CoroutineFilter extractCoroutineFilter(@NotNull SuspendContextImpl suspendContext) {
        CoroutineFilter coroutineFilter;
        CoroutineFilter continuationFilter;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxyImpl(suspendContext);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        DefaultExecutionContext defaultExecutionContext = new DefaultExecutionContext(suspendContext, frameProxy);
        CoroutineFilter coroutineFilter2 = continuationFilter = this.tryComputeContinuationFilter(frameProxy, defaultExecutionContext);
        if (coroutineFilter2 != null) {
            return coroutineFilter2;
        }
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(defaultExecutionContext);
        if (debugProbesImpl != null && debugProbesImpl.isInstalled()) {
            Set<Long> currentCoroutines;
            Set<Long> set = this.getCoroutinesRunningOnCurrentThreadFromHelper(defaultExecutionContext, debugProbesImpl);
            if (set == null) {
                set = debugProbesImpl.getCoroutinesRunningOnCurrentThread(defaultExecutionContext);
            }
            coroutineFilter = !((Collection)(currentCoroutines = set)).isEmpty() ? new CoroutineIdFilter(currentCoroutines) : null;
        } else {
            CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("[coroutine filter]: kotlinx-coroutines debug agent was not enabled, DebugProbesImpl class is not found.");
            coroutineFilter = null;
        }
        return coroutineFilter;
    }

    private final CoroutineFilter tryComputeContinuationFilter(StackFrameProxyImpl frameProxy, DefaultExecutionContext defaultExecutionContext) {
        CoroutineFilter coroutineFilter;
        ObjectReference objectReference = this.extractContinuation(frameProxy);
        if (objectReference == null) {
            return null;
        }
        ObjectReference currentContinuation = objectReference;
        CoroutineFilter coroutineFilter2 = this.getContinuationFilterFromHelper(currentContinuation, defaultExecutionContext);
        if (coroutineFilter2 != null) {
            CoroutineFilter it = coroutineFilter2;
            boolean bl = false;
            return it;
        }
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(defaultExecutionContext);
        if (debugProbesImpl != null && debugProbesImpl.isInstalled() && (coroutineFilter = this.extractContinuationId(currentContinuation, defaultExecutionContext)) != null) {
            CoroutineFilter it = coroutineFilter;
            boolean bl = false;
            return it;
        }
        return this.extractBaseContinuation(currentContinuation, defaultExecutionContext);
    }

    private final CoroutineFilter extractBaseContinuation(ObjectReference continuation2, DefaultExecutionContext defaultExecutionContext) {
        CoroutineStackFrameLight baseContinuationImpl = new CoroutineStackFrameLight(defaultExecutionContext);
        ObjectReference loopContinuation = continuation2;
        while (true) {
            MirrorOfBaseContinuationImplLight continuationMirror;
            if ((continuationMirror = (MirrorOfBaseContinuationImplLight)baseContinuationImpl.mirror(loopContinuation, defaultExecutionContext)) == null) {
                CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                StackFrameProxyImpl stackFrameProxyImpl = defaultExecutionContext.getFrameProxy();
                logger.warn("[coroutine filter]: extracted completion field was not an instance of BaseContinuationImpl, " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
                return null;
            }
            ObjectReference nextContinuation = continuationMirror.getNextContinuation();
            if (nextContinuation == null) {
                return new ContinuationObjectFilter(continuationMirror.getThat());
            }
            loopContinuation = nextContinuation;
        }
    }

    private final CoroutineFilter extractContinuationId(ObjectReference continuation2, DefaultExecutionContext defaultExecutionContext) {
        CoroutineStackFrameLight baseContinuationImpl = new CoroutineStackFrameLight(defaultExecutionContext);
        ObjectReference loopContinuation = continuation2;
        while (true) {
            DebugProbesImplCoroutineOwner coroutineOwner;
            MirrorOfCoroutineOwner coroutineOwnerMirror;
            Object object;
            MirrorOfBaseContinuationImplLight continuationMirror;
            if ((continuationMirror = (MirrorOfBaseContinuationImplLight)baseContinuationImpl.mirror(loopContinuation, defaultExecutionContext)) == null) {
                CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                StackFrameProxyImpl stackFrameProxyImpl = defaultExecutionContext.getFrameProxy();
                logger.warn("[coroutine filter]: extracted completion field was not an instance of BaseContinuationImpl, " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
                return null;
            }
            if (continuationMirror.getCoroutineOwner() != null && (object = (coroutineOwnerMirror = (MirrorOfCoroutineOwner)(coroutineOwner = new DebugProbesImplCoroutineOwner(null, defaultExecutionContext)).mirror(continuationMirror.getCoroutineOwner(), defaultExecutionContext))) != null && (object = ((MirrorOfCoroutineOwner)object).getCoroutineInfo()) != null && (object = ((MirrorOfCoroutineInfo)object).getSequenceNumber()) != null) {
                long it = ((Number)object).longValue();
                boolean bl = false;
                return new CoroutineIdFilter(SetsKt.setOf((Object)it));
            }
            ObjectReference nextContinuation = continuationMirror.getNextContinuation();
            if (nextContinuation == null) {
                return new ContinuationObjectFilter(continuationMirror.getThat());
            }
            loopContinuation = nextContinuation;
        }
    }

    private final CoroutineFilter getContinuationFilterFromHelper(ObjectReference currentContinuation, DefaultExecutionContext context2) {
        ContinuationObjectFilter continuationObjectFilter;
        Value continuationIdValue = this.callMethodFromHelper(CoroutinesDebugHelper.class, context2, "tryGetContinuationId", CollectionsKt.listOf((Object)currentContinuation));
        LongValue longValue = continuationIdValue instanceof LongValue ? (LongValue)continuationIdValue : null;
        if (longValue != null) {
            long it = longValue.value();
            boolean bl = false;
            if (it != -1L) {
                return new CoroutineIdFilter(SetsKt.setOf((Object)it));
            }
        }
        CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        logger.warn("[coroutine filter]: Could not extract continuation ID, location = " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
        Value rootContinuation = this.callMethodFromHelper(CoroutinesDebugHelper.class, context2, "getRootContinuation", CollectionsKt.listOf((Object)currentContinuation));
        if (rootContinuation == null) {
            CoroutineStackFrameInterceptor $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(CoroutineStackFrameInterceptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("[coroutine filter]: Could not extract continuation instance");
        }
        Value value2 = rootContinuation;
        if (value2 != null) {
            Value it = value2;
            boolean bl = false;
            continuationObjectFilter = new ContinuationObjectFilter((ObjectReference)it);
        } else {
            continuationObjectFilter = null;
        }
        return continuationObjectFilter;
    }

    private final Set<Long> getCoroutinesRunningOnCurrentThreadFromHelper(DefaultExecutionContext context2, DebugProbesImpl debugProbesImpl) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            return null;
        }
        ThreadReferenceProxyImpl threadReferenceProxyImpl2 = threadReferenceProxyImpl;
        Object[] objectArray = new ObjectReference[]{debugProbesImpl.getObject(), threadReferenceProxyImpl2.getThreadReference()};
        List args = CollectionsKt.listOf((Object[])objectArray);
        Value result2 = this.callMethodFromHelper(CoroutinesDebugHelper.class, context2, "getCoroutinesRunningOnCurrentThread", args);
        if (result2 == null) {
            return null;
        }
        List<Value> list2 = ((ArrayReference)result2).getValues();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValues(...)");
        return SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)getCoroutinesRunningOnCurrentThreadFromHelper.1.INSTANCE));
    }

    private final Value callMethodFromHelper(Class<?> helperClass, DefaultExecutionContext context2, String methodName, List<? extends Value> args) {
        try {
            return DebuggerUtilsImpl.invokeHelperMethod((EvaluationContextImpl)context2.getEvaluationContext(), helperClass, (String)methodName, args);
        }
        catch (Exception e) {
            if (e instanceof EvaluateException && ((EvaluateException)e).getExceptionFromTargetVM() != null) {
                EvaluationContextImpl evaluationContextImpl = context2.getEvaluationContext();
                ObjectReference objectReference = ((EvaluateException)e).getExceptionFromTargetVM();
                Intrinsics.checkNotNull((Object)objectReference);
                String exceptionStack = DebuggerUtilsImpl.getExceptionText((EvaluationContextImpl)evaluationContextImpl, (ObjectReference)objectReference);
                if (exceptionStack != null) {
                    Value value2 = DebuggerUtilsImpl.invokeHelperMethod((EvaluationContextImpl)context2.getEvaluationContext(), ExceptionDebugHelper.class, (String)"getCurrentThreadStackDepth", (List)CollectionsKt.emptyList());
                    Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.IntegerValue");
                    int currentStackDepth = ((IntegerValue)value2).value();
                    List lines = StringsKt.lines((CharSequence)exceptionStack);
                    if (lines.size() > currentStackDepth) {
                        exceptionStack = CollectionsKt.joinToString$default((Iterable)lines.subList(0, lines.size() - currentStackDepth + 1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    }
                    String[] stringArray = new String[]{exceptionStack};
                    DebuggerUtilsImpl.logError((String)e.getMessage(), (Throwable)e, (String[])stringArray);
                    return null;
                }
            }
            DebuggerUtilsImpl.logError((Throwable)e);
            return null;
        }
    }

    private final ObjectReference extractContinuation(StackFrameProxyImpl frameProxy) {
        ObjectReference objectReference;
        Location location2 = frameProxy.location();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location(...)");
        SuspendExitMode suspendExitMode = CoroutineUtilsKt.getSuspendExitMode(location2);
        switch (WhenMappings.$EnumSwitchMapping$0[suspendExitMode.ordinal()]) {
            case 1: {
                ObjectReference objectReference2 = CoroutineUtilsKt.thisVariableValue(frameProxy);
                if (objectReference2 != null) {
                    ObjectReference it = objectReference2;
                    boolean bl = false;
                    return it;
                }
                List list2 = frameProxy.threadProxy().frames();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"frames(...)");
                StackFrameProxyImpl prevStackFrame = (StackFrameProxyImpl)CollectionsKt.getOrNull((List)list2, (int)(frameProxy.getFrameIndex() + 1));
                if (prevStackFrame == null) {
                    CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("[coroutine filtering]: Could not extract the previous stack frame for the frame " + frameProxy.getStackFrame() + ":\nthread = " + frameProxy.threadProxy().name() + " \nframes = " + frameProxy.threadProxy().frames());
                    return null;
                }
                objectReference = prevStackFrame.thisObject();
                break;
            }
            case 2: {
                objectReference = CoroutineUtilsKt.continuationVariableValue(frameProxy);
                if (objectReference != null) break;
                objectReference = CoroutineUtilsKt.completionVariableValue(frameProxy);
                break;
            }
            default: {
                objectReference = null;
            }
        }
        return objectReference;
    }

    @Override
    @Nullable
    public Location callerLocation(@NotNull SuspendContextImpl suspendContext) {
        Object stackTraceElement;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxyImpl(suspendContext);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ObjectReference objectReference = this.extractContinuation(frameProxy);
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuationObject = objectReference;
        DefaultExecutionContext executionContext2 = new DefaultExecutionContext(suspendContext, frameProxy);
        DebugMetadata debugMetadata = DebugMetadata.Companion.instance(executionContext2);
        if (debugMetadata == null) {
            return null;
        }
        DebugMetadata debugMetadata2 = debugMetadata;
        Value value2 = this.callMethodFromHelper(CoroutinesDebugHelper.class, executionContext2, "getCallerFrame", CollectionsKt.listOf((Object)continuationObject));
        if (value2 == null) {
            return null;
        }
        Value callerFrame = value2;
        Object object = debugMetadata2.getStackTraceElement((ObjectReference)callerFrame, executionContext2);
        if (object == null || (object = ((MirrorOfStackTraceElement)object).stackTraceElement()) == null) {
            return null;
        }
        Object it = stackTraceElement = object;
        boolean bl = false;
        return DebuggerUtilsEx.findOrCreateLocation((DebugProcessImpl)suspendContext.getDebugProcess(), (StackTraceElement)it);
    }

    private final StackFrameProxyImpl getStackFrameProxyImpl(SuspendContextImpl $this$getStackFrameProxyImpl) {
        JavaExecutionStack javaExecutionStack = $this$getStackFrameProxyImpl.getActiveExecutionStack();
        if (javaExecutionStack == null || (javaExecutionStack = javaExecutionStack.getThreadProxy()) == null || (javaExecutionStack = javaExecutionStack.frame(0)) == null) {
            javaExecutionStack = $this$getStackFrameProxyImpl.getFrameProxy();
        }
        return javaExecutionStack;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0016J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$ContinuationObjectFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "reference", "Lcom/sun/jdi/ObjectReference;", "(Lcom/sun/jdi/ObjectReference;)V", "getReference", "()Lcom/sun/jdi/ObjectReference;", "canRunTo", "", "nextCoroutineFilter", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
    private static final class ContinuationObjectFilter
    implements CoroutineFilter {
        @NotNull
        private final ObjectReference reference;

        public ContinuationObjectFilter(@NotNull ObjectReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            this.reference = reference2;
        }

        @NotNull
        public final ObjectReference getReference() {
            return this.reference;
        }

        @Override
        public boolean canRunTo(@NotNull CoroutineFilter nextCoroutineFilter) {
            Intrinsics.checkNotNullParameter((Object)nextCoroutineFilter, (String)"nextCoroutineFilter");
            return Intrinsics.areEqual((Object)this, (Object)nextCoroutineFilter);
        }

        @NotNull
        public final ObjectReference component1() {
            return this.reference;
        }

        @NotNull
        public final ContinuationObjectFilter copy(@NotNull ObjectReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            return new ContinuationObjectFilter(reference2);
        }

        public static /* synthetic */ ContinuationObjectFilter copy$default(ContinuationObjectFilter continuationObjectFilter, ObjectReference objectReference, int n, Object object) {
            if ((n & 1) != 0) {
                objectReference = continuationObjectFilter.reference;
            }
            return continuationObjectFilter.copy(objectReference);
        }

        @NotNull
        public String toString() {
            return "ContinuationObjectFilter(reference=" + this.reference + ")";
        }

        public int hashCode() {
            return ((Object)this.reference).hashCode();
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ContinuationObjectFilter)) {
                return false;
            }
            ContinuationObjectFilter continuationObjectFilter = (ContinuationObjectFilter)other2;
            return Intrinsics.areEqual((Object)this.reference, (Object)continuationObjectFilter.reference);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$CoroutineIdFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "coroutinesRunningOnCurrentThread", "", "", "(Ljava/util/Set;)V", "getCoroutinesRunningOnCurrentThread", "()Ljava/util/Set;", "canRunTo", "", "nextCoroutineFilter", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$CoroutineIdFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
    private static final class CoroutineIdFilter
    implements CoroutineFilter {
        @NotNull
        private final Set<Long> coroutinesRunningOnCurrentThread;

        public CoroutineIdFilter(@NotNull Set<Long> coroutinesRunningOnCurrentThread) {
            Intrinsics.checkNotNullParameter(coroutinesRunningOnCurrentThread, (String)"coroutinesRunningOnCurrentThread");
            this.coroutinesRunningOnCurrentThread = coroutinesRunningOnCurrentThread;
            if (!(!((Collection)this.coroutinesRunningOnCurrentThread).isEmpty())) {
                boolean bl = false;
                String string = "Coroutines set can not be empty";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Set<Long> getCoroutinesRunningOnCurrentThread() {
            return this.coroutinesRunningOnCurrentThread;
        }

        @Override
        public boolean canRunTo(@NotNull CoroutineFilter nextCoroutineFilter) {
            Intrinsics.checkNotNullParameter((Object)nextCoroutineFilter, (String)"nextCoroutineFilter");
            return nextCoroutineFilter instanceof CoroutineIdFilter && !((Collection)CollectionsKt.intersect((Iterable)this.coroutinesRunningOnCurrentThread, (Iterable)((CoroutineIdFilter)nextCoroutineFilter).coroutinesRunningOnCurrentThread)).isEmpty();
        }

        @NotNull
        public final Set<Long> component1() {
            return this.coroutinesRunningOnCurrentThread;
        }

        @NotNull
        public final CoroutineIdFilter copy(@NotNull Set<Long> coroutinesRunningOnCurrentThread) {
            Intrinsics.checkNotNullParameter(coroutinesRunningOnCurrentThread, (String)"coroutinesRunningOnCurrentThread");
            return new CoroutineIdFilter(coroutinesRunningOnCurrentThread);
        }

        public static /* synthetic */ CoroutineIdFilter copy$default(CoroutineIdFilter coroutineIdFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = coroutineIdFilter.coroutinesRunningOnCurrentThread;
            }
            return coroutineIdFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "CoroutineIdFilter(coroutinesRunningOnCurrentThread=" + this.coroutinesRunningOnCurrentThread + ")";
        }

        public int hashCode() {
            return ((Object)this.coroutinesRunningOnCurrentThread).hashCode();
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof CoroutineIdFilter)) {
                return false;
            }
            CoroutineIdFilter coroutineIdFilter = (CoroutineIdFilter)other2;
            return Intrinsics.areEqual(this.coroutinesRunningOnCurrentThread, coroutineIdFilter.coroutinesRunningOnCurrentThread);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendExitMode.values().length];
            try {
                nArray[SuspendExitMode.SUSPEND_LAMBDA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendExitMode.SUSPEND_METHOD_PARAMETER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

