/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentPatcher;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "expressionWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "addWrapper", "wrapper", "extractExpressionWithText", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "replaceExpression", "", "expression", "newExpressionText", "wrapFragmentExpressionIfNeeded", "stats", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "Companion", "kotlin.jvm-debugger.evaluation"})
final class KotlinCodeFragmentPatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final List<KotlinExpressionWrapper> expressionWrappers;
    @NotNull
    private static final Logger LOG;

    public KotlinCodeFragmentPatcher(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.expressionWrappers = new ArrayList();
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final KotlinCodeFragmentPatcher addWrapper(@NotNull KotlinExpressionWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.expressionWrappers.add(wrapper);
        return this;
    }

    public final void wrapFragmentExpressionIfNeeded(@NotNull CodeFragmentCompilationStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Pair<KtExpression, String> pair = this.extractExpressionWithText();
        if (pair == null) {
            return;
        }
        Pair<KtExpression, String> pair2 = pair;
        KtExpression expression2 = (KtExpression)pair2.component1();
        String expressionText2 = (String)pair2.component2();
        Object object = stats.startAndMeasureWrapAnalysisUnderReadAction-IoAF18A((Function0)new Function0<String>(expressionText2, this, expression2){
            final /* synthetic */ String $expressionText;
            final /* synthetic */ KotlinCodeFragmentPatcher this$0;
            final /* synthetic */ KtExpression $expression;
            {
                this.$expressionText = $expressionText;
                this.this$0 = $receiver;
                this.$expression = $expression;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String newExpressionText2 = this.$expressionText;
                for (KotlinExpressionWrapper wrapper : KotlinCodeFragmentPatcher.access$getExpressionWrappers$p(this.this$0)) {
                    if (!wrapper.isApplicable(this.$expression)) continue;
                    newExpressionText2 = wrapper.createWrappedExpressionText(newExpressionText2);
                }
                return newExpressionText2;
            }
        });
        ResultKt.throwOnFailure((Object)object);
        String newExpressionText2 = (String)object;
        if (!Intrinsics.areEqual((Object)newExpressionText2, (Object)expressionText2)) {
            this.replaceExpression(expression2, newExpressionText2);
        }
    }

    private final void replaceExpression(KtExpression expression2, String newExpressionText2) {
        KtExpression newExpression2 = (KtExpression)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtExpression>(expression2, newExpressionText2){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ String $newExpressionText;
            {
                this.$expression = $expression;
                this.$newExpressionText = $newExpressionText;
                super(0);
            }

            @NotNull
            public final KtExpression invoke() {
                Project project2 = this.$expression.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                return new KtPsiFactory(project2, false, 2, null).createExpression(this.$newExpressionText);
            }
        }));
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(expression2, newExpression2){
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KtExpression $newExpression;
            {
                this.$expression = $expression;
                this.$newExpression = $newExpression;
                super(0);
            }

            public final void invoke() {
                Project project2 = this.$expression.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                ApplicationUtilsKt.executeWriteCommand(project2, KotlinDebuggerEvaluationBundle.message("wrap.expression", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this.$expression, this.$newExpression){
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KtExpression $newExpression;
                    {
                        this.$expression = $expression;
                        this.$newExpression = $newExpression;
                        super(0);
                    }

                    public final void invoke() {
                        this.$expression.replace((PsiElement)this.$newExpression);
                    }
                }));
            }
        }), (int)1, null);
    }

    private final Pair<KtExpression, String> extractExpressionWithText() {
        return (Pair)ActionsKt.runReadAction((Function0)((Function0)new Function0<Pair<? extends KtExpression, ? extends String>>(this){
            final /* synthetic */ KotlinCodeFragmentPatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Pair<KtExpression, String> invoke() {
                KtExpression ktExpression;
                KtCodeFragment ktCodeFragment = this.this$0.getCodeFragment();
                if (ktCodeFragment instanceof KtExpressionCodeFragment) {
                    ktExpression = ((KtExpressionCodeFragment)this.this$0.getCodeFragment()).getContentElement();
                } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
                    List list2 = ((KtBlockCodeFragment)this.this$0.getCodeFragment()).getContentElement().getStatements();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                    ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list2);
                } else {
                    KotlinCodeFragmentPatcher.access$getLOG$cp().error("Invalid code fragment type: " + this.this$0.getClass());
                    ktExpression = null;
                }
                KtExpression expression2 = ktExpression;
                return expression2 == null ? null : new Pair((Object)expression2, (Object)expression2.getText());
            }
        }));
    }

    public static final /* synthetic */ List access$getExpressionWrappers$p(KotlinCodeFragmentPatcher $this) {
        return $this.expressionWrappers;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(KotlinCodeFragmentPatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentPatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

