/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.extensions.KotlinJvmDebuggerFacade;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleCoroutineDebugProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "enhanceTaskProcessing", "", "project", "Lcom/intellij/openapi/project/Project;", "taskNames", "", "", "initScriptConsumer", "Lcom/intellij/util/Consumer;", "parameters", "", "setupCoroutineAgentForJvmForkedTestTasks", "shouldCheckGradleVersion", "", "Companion", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleCoroutineDebugProjectResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleCoroutineDebugProjectResolver.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleCoroutineDebugProjectResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class KotlinGradleCoroutineDebugProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String MIN_SUPPORTED_GRADLE_VERSION = "4.6";

    public void enhanceTaskProcessing(@Nullable Project project2, @NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters2) {
        Intrinsics.checkNotNullParameter(taskNames, (String)"taskNames");
        Intrinsics.checkNotNullParameter(initScriptConsumer, (String)"initScriptConsumer");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        try {
            GradleVersion gradleVersion2;
            KotlinJvmDebuggerFacade kotlinJvmDebuggerFacade = KotlinJvmDebuggerFacade.Companion.getInstance();
            boolean allowCoroutineAgent = kotlinJvmDebuggerFacade != null ? kotlinJvmDebuggerFacade.isCoroutineAgentAllowedInDebug() : false;
            String string = parameters2.get("GRADLE_VERSION");
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = GradleVersion.version((String)it);
            } else {
                v2 = gradleVersion2 = null;
            }
            if (allowCoroutineAgent && (gradleVersion2 == null || gradleVersion2.compareTo(GradleVersion.version((String)MIN_SUPPORTED_GRADLE_VERSION)) >= 0)) {
                this.setupCoroutineAgentForJvmForkedTestTasks(initScriptConsumer, gradleVersion2 == null);
            }
        }
        catch (Exception e) {
            log.error("Gradle: not possible to attach a coroutine debugger agent.", (Throwable)e);
        }
    }

    private final void setupCoroutineAgentForJvmForkedTestTasks(Consumer<String> initScriptConsumer, boolean shouldCheckGradleVersion) {
        String gradleVersionCheck = shouldCheckGradleVersion ? "if (org.gradle.util.GradleVersion.current() < org.gradle.util.GradleVersion.version(\"4.6\")) return" : "";
        String script = StringsKt.trimIndent((String)("\n            gradle.taskGraph.whenReady { TaskExecutionGraph taskGraph ->\n                " + gradleVersionCheck + "\n                def debugAllIsEnabled = Boolean.valueOf(System.properties[\"idea.gradle.debug.all\"])\n                def jvmTasks = taskGraph.allTasks.findAll { task -> task instanceof Test || task instanceof JavaExec }\n                def matchedTasks = debugAllIsEnabled ? jvmTasks : GradleTasksUtil.filterStartTasks(jvmTasks, gradle, rootProject)\n\n                matchedTasks.each { Task task ->                    \n                    for (arg in task.getJvmArgs()) {\n                        if (arg == \"-Dkotlinx.coroutines.debug=off\") {\n                            return\n                        }\n                    }\n\n                    FileCollection taskClasspath = task.classpath\n                    task.jvmArgumentProviders.add(new CommandLineArgumentProvider() {\n                        private static def VERSION_PATTERN = java.util.regex.Pattern.compile(/(\\d+)\\.(\\d+)(\\.(\\d+))?.*/)\n                    \n                        @Override\n                        Iterable<String> asArguments() {\n                            List<String> emptyList = Collections.emptyList()\n                            if (System.getProperty(\"idea.debugger.dispatch.port\") == null) return emptyList\n                            def kotlinxCoroutinesCoreJar = taskClasspath.find { it.name.startsWith(\"kotlinx-coroutines-core\") && !it.name.contains(\"sources\") }\n                            if (kotlinxCoroutinesCoreJar == null) return emptyList\n                            def results = (kotlinxCoroutinesCoreJar.getName() =~ /kotlinx-coroutines-core(\\-jvm)?-(\\d[\\w\\.\\-]+)\\.jar$/).findAll()\n                            if (results.isEmpty()) return emptyList\n                            String version = results.first()[2]\n                            def matcher = VERSION_PATTERN.matcher(version)\n                            try {\n                                if (!matcher.matches()) return emptyList\n                                int major = Integer.parseInt(matcher.group(1)) \n                                int minor = Integer.parseInt(matcher.group(2))\n                                int patch = Integer.parseInt(matcher.group(4) ?: \"0\")\n                                if (major < 1 || (major == 1 && (minor < 5 || (minor == 5 && patch < 1)))) return emptyList\n                            } catch (NumberFormatException ignored) {\n                                return emptyList\n                            }\n                            return [\"-javaagent:${kotlinxCoroutinesCoreJar?.absolutePath}\", \"-ea\"]\n                        }\n                    })\n                }\n            }\n            "));
        initScriptConsumer.consume((Object)script);
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleCoroutineDebugProjectResolver$Companion;", "", "()V", "MIN_SUPPORTED_GRADLE_VERSION", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

