/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinCommonLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.base.platforms.KotlinNativeLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmJsLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinWasmWasiLibraryKind;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J8\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "looksAsNonJvmLibrary", "", "Lcom/intellij/openapi/roots/libraries/Library;", "Companion", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleLibraryDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n766#2:350\n857#2,2:351\n1747#2,2:353\n1749#2:356\n1747#2,3:357\n1#3:355\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleLibraryDataService\n*L\n171#1:350\n171#1:351,2\n173#1:353,2\n173#1:356\n189#1:357,3\n*E\n"})
public final class KotlinGradleLibraryDataService
extends AbstractProjectDataService<LibraryData, Void> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<PersistentLibraryKind<?>> NON_JVM_LIBRARY_KINDS;
    @NotNull
    private static final List<String> NON_JVM_SUFFIXES;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LIBRARY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void postProcess(@NotNull Collection<? extends DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        boolean bl;
        block10: {
            void $this$any$iv;
            Object it;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            if (toImport.isEmpty()) {
                return;
            }
            DataNode dataNode = ((DataNode)CollectionsKt.first((Iterable)toImport)).getParent();
            Intrinsics.checkNotNull((Object)dataNode);
            DataNode projectDataNode = dataNode;
            Collection collection = projectDataNode.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
            Iterable $this$filter$iv = collection;
            boolean bl2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (DataNode)element$iv$iv;
                boolean bl22 = false;
                if (!(it.getData() instanceof ModuleData)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDataNodes = (List)destination$iv$iv;
            $this$filter$iv = moduleDataNodes;
            boolean bl3 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Object v3;
                    DataNode node2 = (DataNode)element$iv;
                    boolean bl32 = false;
                    if (KotlinGradleSourceSetDataServiceKt.detectPlatformKindByPlugin((DataNode<ModuleData>)node2) != null) {
                        it = element$iv$iv;
                        boolean bl4 = false;
                        v3 = !JvmIdePlatformUtil.isJvm((IdePlatformKind)it) ? element$iv$iv : null;
                    } else {
                        v3 = null;
                    }
                    if (!(v3 != null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean anyNonJvmModules = bl;
        for (DataNode<LibraryData> dataNode : toImport) {
            Library ideLibrary;
            if (modelsProvider.findIdeLibrary((LibraryData)dataNode.getData()) == null) continue;
            Library.ModifiableModel modifiableModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
            Intrinsics.checkNotNull((Object)modifiableModel, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
            LibraryEx.ModifiableModelEx modifiableModel2 = (LibraryEx.ModifiableModelEx)modifiableModel;
            if (anyNonJvmModules || this.looksAsNonJvmLibrary(ideLibrary)) {
                if (KotlinLibraryKindKt.detectLibraryKind(ideLibrary, project2) != null) {
                    PersistentLibraryKind<?> it;
                    boolean bl5 = false;
                    modifiableModel2.setKind(it);
                }
                continue;
            }
            if (!(ideLibrary instanceof LibraryEx) || !CollectionsKt.contains((Iterable)NON_JVM_LIBRARY_KINDS, (Object)((LibraryEx)ideLibrary).getKind())) continue;
            modifiableModel2.forgetKind();
        }
    }

    private final boolean looksAsNonJvmLibrary(Library $this$looksAsNonJvmLibrary) {
        String string = $this$looksAsNonJvmLibrary.getName();
        if (string != null) {
            boolean bl;
            String name2;
            block5: {
                name2 = string;
                boolean bl2 = false;
                Iterable $this$any$iv = NON_JVM_SUFFIXES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl || StringsKt.startsWith$default((String)name2, (String)"Kotlin/Native", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        VirtualFile[] virtualFileArray = $this$looksAsNonJvmLibrary.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        return Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getExtension() : null), (Object)"klib");
    }

    static {
        Logger logger = Logger.getInstance(KotlinGradleLibraryDataService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new PersistentLibraryKind[]{KotlinJavaScriptLibraryKind.INSTANCE, KotlinWasmJsLibraryKind.INSTANCE, KotlinWasmWasiLibraryKind.INSTANCE, KotlinNativeLibraryKind.INSTANCE, KotlinCommonLibraryKind.INSTANCE};
        NON_JVM_LIBRARY_KINDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"-common", "-js", "-wasm", "-native", "-kjsm", "-metadata"};
        NON_JVM_SUFFIXES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleLibraryDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NON_JVM_LIBRARY_KINDS", "", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getNON_JVM_LIBRARY_KINDS", "()Ljava/util/List;", "NON_JVM_SUFFIXES", "", "getNON_JVM_SUFFIXES", "kotlin.gradle.gradle-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<PersistentLibraryKind<?>> getNON_JVM_LIBRARY_KINDS() {
            return NON_JVM_LIBRARY_KINDS;
        }

        @NotNull
        public final List<String> getNON_JVM_SUFFIXES() {
            return NON_JVM_SUFFIXES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

